/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.google.common.collect.Lists;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.time.DateFormatUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.util.Assert;

public class StringUtil {
    public static String convertPointToSpace(String str) {
        String space = "";
        if (StringUtils.isEmpty((String)str)) {
            return space;
        }
        String[] path = str.split("\\.");
        for (int i = 0; i < path.length - 1; ++i) {
            space = space + "&nbsp;&emsp;";
        }
        return space;
    }

    public static String InputStreamToString(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        String str = result.toString(StandardCharsets.UTF_8.name());
        result.close();
        return str;
    }

    public static String join(String[] arr) {
        return StringUtil.join(arr, ",");
    }

    public static String join(String[] arr, String split) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]);
            sb.append(split);
        }
        return sb.substring(0, sb.length() - split.length());
    }

    public static String join(Collection<String> strs) {
        return StringUtil.join(strs, ",");
    }

    public static String join(Collection<String> strs, String split) {
        if (strs == null || strs.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = strs.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(split);
        }
        return sb.substring(0, sb.length() - split.length());
    }

    public static String convertToChineseNumeral(double amount) {
        char[] hunit = new char[]{'\u62fe', '\u4f70', '\u4edf'};
        char[] vunit = new char[]{'\u4e07', '\u4ebf'};
        char[] digit = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        long midVal = (long)(amount * 100.0);
        String valStr = String.valueOf(midVal);
        String head = valStr.substring(0, valStr.length() - 2);
        String rail = valStr.substring(valStr.length() - 2);
        String prefix = "";
        String suffix = "";
        suffix = rail.equals("00") ? "\u6574" : digit[rail.charAt(0) - 48] + "\u89d2" + digit[rail.charAt(1) - 48] + "\u5206";
        char[] chDig = head.toCharArray();
        int zero = 48;
        int zeroSerNum = 0;
        for (int i = 0; i < chDig.length; ++i) {
            int idx = (chDig.length - i - 1) % 4;
            int vidx = (chDig.length - i - 1) / 4;
            if (chDig[i] == '0') {
                zeroSerNum = (byte)(zeroSerNum + 1);
                if (zero == 48) {
                    zero = digit[0];
                    continue;
                }
                if (idx != 0 || vidx <= 0 || zeroSerNum >= 4) continue;
                prefix = prefix + vunit[vidx - 1];
                zero = 48;
                continue;
            }
            zeroSerNum = 0;
            if (zero != 48) {
                prefix = prefix + (char)zero;
                zero = 48;
            }
            prefix = prefix + digit[chDig[i] - 48];
            if (idx > 0) {
                prefix = prefix + hunit[idx - 1];
            }
            if (idx != 0 || vidx <= 0) continue;
            prefix = prefix + vunit[vidx - 1];
        }
        if (prefix.length() > 0) {
            prefix = prefix + '\u5706';
        }
        return prefix + suffix;
    }

    public static String stripHtml(String content) {
        content = content.replaceAll("<p .*?>", "\r\n");
        content = content.replaceAll("<br\\s*/?>", "\r\n");
        content = content.replaceAll("\\<.*?>", "");
        content = content.replaceAll(" ", "");
        return content;
    }

    public static String convertCharEntityToHtml(String content) {
        content = content.replace("&apos;", "'").replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
        int start = 0;
        int end = 0;
        StringBuilder buffer = new StringBuilder();
        while (start > -1) {
            int length;
            char s;
            int system = 10;
            if (start == 0) {
                int t = content.indexOf("&#");
                if (start != t) {
                    start = t;
                }
                if (start > 0) {
                    buffer.append(content.substring(0, start));
                }
            }
            end = content.indexOf(";", start + 2);
            String charStr = "";
            if (end != -1 && ((s = (charStr = content.substring(start + 2, end)).charAt(0)) == 'x' || s == 'X')) {
                system = 16;
                charStr = charStr.substring(1);
            }
            try {
                char letter = (char)Integer.parseInt(charStr, system);
                buffer.append(new Character(letter).toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            start = content.indexOf("&#", end);
            if (start - end > 1) {
                buffer.append(content.substring(end + 1, start));
            }
            if (start != -1 || end + 1 == (length = content.length())) continue;
            buffer.append(content.substring(end + 1, length));
        }
        return buffer.toString();
    }

    public static String convertHtmlToCharEntity(String content) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append(c);
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append("&#x");
                        sb.append(Integer.toString(c, 16));
                        sb.append(';');
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String format(String message, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            message = message.replace("${" + i + "}", args[i].toString());
        }
        return message;
    }

    public static String format(String message, Map<String, Object> params) {
        String result = message;
        if (params == null || params.isEmpty()) {
            return result;
        }
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value == null) continue;
            result = result.replace("${" + key + "}", value.toString());
        }
        return result;
    }

    public static StringBuilder format(CharSequence msgWithFormat, boolean autoQuote, Object ... args) {
        int argsLen = args.length;
        boolean markFound = false;
        StringBuilder sb = new StringBuilder(msgWithFormat);
        if (argsLen > 0) {
            for (int i = 0; i < argsLen; ++i) {
                String flag = "%" + (i + 1);
                int idx = sb.indexOf(flag);
                while (idx >= 0) {
                    markFound = true;
                    sb.replace(idx, idx + 2, StringUtil.toString(args[i], autoQuote));
                    idx = sb.indexOf(flag);
                }
            }
            if (args[argsLen - 1] instanceof Throwable) {
                StringWriter sw = new StringWriter();
                ((Throwable)args[argsLen - 1]).printStackTrace(new PrintWriter(sw));
                sb.append("\n").append(sw.toString());
            } else if (argsLen == 1 && !markFound) {
                sb.append(args[argsLen - 1].toString());
            }
        }
        return sb;
    }

    public static boolean isExist(String content, String beginStr, String endStr) {
        boolean isExist = true;
        String lowContent = content.toLowerCase();
        String lowBeginStr = beginStr.toLowerCase();
        String lowEndStr = endStr.toLowerCase();
        int beginIndex = lowContent.indexOf(lowBeginStr);
        int endIndex = lowContent.indexOf(lowEndStr);
        return beginIndex != -1 && endIndex != -1 && beginIndex < endIndex;
    }

    public static String trimPrefix(String content, String prefix) {
        String resultStr = content;
        while (resultStr.startsWith(prefix)) {
            resultStr = resultStr.substring(prefix.length());
        }
        return resultStr;
    }

    public static String trimSuffix(String content, String suffix) {
        String resultStr = content;
        while (resultStr.endsWith(suffix)) {
            resultStr = resultStr.substring(0, resultStr.length() - suffix.length());
        }
        return resultStr;
    }

    public static String trim(String content, String trimStr) {
        return StringUtil.trimSuffix(StringUtil.trimPrefix(content, trimStr), trimStr);
    }

    public static String upperFirst(String str) {
        return StringUtil.toFirst(str, true);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isNotEmpty(Optional<String> str) {
        return str.filter(s -> !StringUtil.isEmpty(s)).isPresent();
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        if (str.trim().equals("")) {
            return true;
        }
        return "null".equals(str);
    }

    public static boolean isEmpty(Long value) {
        if (value == null) {
            return true;
        }
        return value == 0L;
    }

    public static boolean isZeroEmpty(String tmp) {
        boolean isEmpty = StringUtil.isEmpty(tmp);
        if (isEmpty) {
            return true;
        }
        return "0".equals(tmp);
    }

    public static boolean isNotZeroEmpty(String tmp) {
        return !StringUtil.isZeroEmpty(tmp);
    }

    public static String lowerFirst(String str) {
        return StringUtil.toFirst(str, false);
    }

    public static String toFirst(String str, boolean isUpper) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        char first = str.charAt(0);
        String firstChar = new String(new char[]{first});
        firstChar = isUpper ? firstChar.toUpperCase() : firstChar.toLowerCase();
        return firstChar + str.substring(1);
    }

    public static String replaceVariable(String content, String replace) {
        return StringUtil.replaceVariable(content, replace, "\\{(.*?)\\}");
    }

    public static String replaceVariable(String content, String replace, String regular) {
        Pattern regex = Pattern.compile(regular);
        String result = content;
        Matcher regexMatcher = regex.matcher(result);
        while (regexMatcher.find()) {
            String toReplace = regexMatcher.group(0);
            result = result.replace(toReplace, replace);
            regexMatcher = regex.matcher(result);
        }
        return result;
    }

    public static String replaceVariableMap(String content, Map<String, Object> map) throws Exception {
        return StringUtil.replaceVariableMap(content, map, "\\{(.*?)\\}");
    }

    public static String replaceVariableMap(String template, Map<String, Object> map, String regular) throws Exception {
        Pattern regex = Pattern.compile(regular);
        Matcher regexMatcher = regex.matcher(template);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            String toReplace = regexMatcher.group(0);
            String value = (String)map.get(key);
            if (value != null) {
                template = template.replace(toReplace, value);
                continue;
            }
            throw new Exception("\u6ca1\u6709\u627e\u5230[" + key + "]\u5bf9\u5e94\u7684\u53d8\u91cf\u503c\uff0c\u8bf7\u68c0\u67e5\u8868\u53d8\u91cf\u914d\u7f6e!");
        }
        return template;
    }

    public static String removeSpecial(String str) throws PatternSyntaxException {
        return StringUtil.removeByRegEx(str, "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\"]");
    }

    public static String removeByRegEx(String str, String regEx) throws PatternSyntaxException {
        Pattern p = Pattern.compile("[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\"]");
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static byte[] stringToBytes(String str) {
        byte[] digest = new byte[str.length() / 2];
        for (int i = 0; i < digest.length; ++i) {
            String byteString = str.substring(2 * i, 2 * i + 2);
            int byteValue = Integer.parseInt(byteString, 16);
            digest[i] = (byte)byteValue;
        }
        return digest;
    }

    public static String bytesToString(byte[] b) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String plainText = Integer.toHexString(0xFF & b[i]);
            if (plainText.length() < 2) {
                plainText = "0" + plainText;
            }
            hexString.append(plainText);
        }
        return hexString.toString();
    }

    public static String toString(Object obj, boolean autoQuote) {
        StringBuilder sb = new StringBuilder();
        if (obj == null) {
            sb.append("NULL");
        } else if (obj instanceof Object[]) {
            for (int i = 0; i < ((Object[])obj).length; ++i) {
                sb.append(((Object[])obj)[i]).append(", ");
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
        } else {
            sb.append(obj.toString());
        }
        if (!(!autoQuote || sb.length() <= 0 || sb.charAt(0) == '[' && sb.charAt(sb.length() - 1) == ']' || sb.charAt(0) == '{' && sb.charAt(sb.length() - 1) == '}')) {
            sb.insert(0, "[").append("]");
        }
        return sb.toString();
    }

    public static String encodingString(String str, String from, String to) {
        String result = str;
        try {
            result = new String(str.getBytes(from), to);
        }
        catch (Exception e) {
            result = str;
        }
        return result;
    }

    public static String substringAfterLast(String str, String separator) {
        return StringUtils.substringAfterLast((String)str, (String)separator);
    }

    public static String substringBeforeLast(String str, String separator) {
        return StringUtils.substringBeforeLast((String)str, (String)separator);
    }

    public static String trimSufffix(String toTrim, String trimStr) {
        while (toTrim.endsWith(trimStr)) {
            toTrim = toTrim.substring(0, toTrim.length() - trimStr.length());
        }
        return toTrim;
    }

    public static String convertDbFieldToField(String dbField) {
        return StringUtil.convertDbFieldToField(dbField, "_", true);
    }

    public static String convertDbFieldToField(String dbField, String symbol, boolean isIgnoreFirst) {
        String result = "";
        if (dbField.startsWith(symbol)) {
            dbField = dbField.substring(1);
        }
        if (dbField.endsWith(symbol)) {
            dbField = dbField.substring(0, dbField.length() - 1);
        }
        String[] arr = dbField.split(symbol);
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i];
            if (isIgnoreFirst && i != 0) {
                char oldChar = str.charAt(0);
                char newChar = (oldChar + "").toUpperCase().charAt(0);
                str = newChar + str.substring(1);
            }
            result = result + str;
        }
        return result;
    }

    public static Object parserObject(Object obj, String type) {
        if (obj == null) {
            return null;
        }
        Object val = obj;
        try {
            String str = obj.toString();
            if (type.equalsIgnoreCase("string")) {
                val = str;
            } else if (type.equalsIgnoreCase("int")) {
                val = Integer.parseInt(str);
            } else if (type.equalsIgnoreCase("float")) {
                val = Float.valueOf(Float.parseFloat(str));
            } else if (type.equalsIgnoreCase("double")) {
                val = Double.parseDouble(str);
            } else if (type.equalsIgnoreCase("byte")) {
                val = Byte.parseByte(str);
            } else if (type.equalsIgnoreCase("short")) {
                val = Short.parseShort(str);
            } else if (type.equalsIgnoreCase("long")) {
                val = Long.parseLong(str);
            } else if (type.equalsIgnoreCase("boolean")) {
                if (StringUtils.isNumeric((String)str)) {
                    val = Integer.parseInt(str) == 1;
                }
                val = Boolean.parseBoolean(str);
            } else {
                val = type.equalsIgnoreCase("date") ? DateFormatUtil.parse(str) : str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static Object parserObject(String objStr, Class<?> type) {
        if (StringUtil.isEmpty(objStr)) {
            return null;
        }
        try {
            switch (type.getSimpleName()) {
                case "String": 
                case "Boolean": 
                case "Byte": 
                case "Short": 
                case "Integer": 
                case "Long": 
                case "Float": 
                case "Double": {
                    return type.getConstructor(String.class).newInstance(objStr);
                }
                case "boolean": 
                case "byte": 
                case "short": 
                case "int": 
                case "long": 
                case "float": 
                case "double": {
                    return StringUtil.parserObject((Object)objStr, type.getSimpleName());
                }
                case "Date": {
                    return DateUtils.parseDate((String)objStr, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "HH:mm:ss"});
                }
                case "LocalDate": {
                    return DateFormatUtil.dateParse(objStr, "yyyy-MM-dd");
                }
                case "LocalDateTime": {
                    return DateFormatUtil.parseDateTime(objStr);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] getStringAryByStr(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        String[] aryId = str.split(",");
        String[] lAryId = new String[aryId.length];
        for (int i = 0; i < aryId.length; ++i) {
            lAryId[i] = aryId[i];
        }
        return lAryId;
    }

    public static Long[] getLongAryByStr(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] aryId = str.split(",");
        Long[] lAryId = new Long[aryId.length];
        for (int i = 0; i < aryId.length; ++i) {
            lAryId[i] = Long.parseLong(aryId[i]);
        }
        return lAryId;
    }

    public static Object getMapValue(String param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String str = "";
        String key = "";
        Object value = "";
        char[] charList = param.toCharArray();
        boolean valueBegin = false;
        for (int i = 0; i < charList.length; ++i) {
            char c = charList[i];
            if (c == '{') {
                if (!valueBegin) continue;
                value = StringUtil.getMapValue(param.substring(i, param.length()));
                i = param.indexOf(125, i) + 1;
                map.put(key, value);
                continue;
            }
            if (c == '=') {
                valueBegin = true;
                key = str;
                str = "";
                continue;
            }
            if (c == ',') {
                valueBegin = false;
                value = str;
                str = "";
                map.put(key, value);
                continue;
            }
            if (c == '}') {
                if (!"".equals(str)) {
                    value = str;
                }
                map.put(key, value);
                return map;
            }
            if (c == ' ') continue;
            str = str + c;
        }
        return map;
    }

    public static Map<String, String> getMapStringByMapList(Map<String, Set<String>> listMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : listMap.keySet()) {
            String valueString;
            Set<String> list = listMap.get(key);
            if (list == null || !StringUtil.isNotEmpty(valueString = StringUtil.convertListToSingleQuotesString(list))) continue;
            map.put(key, valueString);
        }
        return map;
    }

    public static String convertListToSingleQuotesString(Set<String> set) {
        if (set == null) {
            return "";
        }
        String ids = "";
        for (String value : set) {
            ids = ids + "'" + value + "',";
        }
        ids = ids.equals("") ? "" : ids.substring(0, ids.length() - 1);
        return ids;
    }

    public static String idsInSql(String[] str, String whereId) {
        Set set = Arrays.stream(str).collect(Collectors.toSet());
        List list = Lists.partition(new ArrayList(set), (int)1000);
        StringBuffer sbf = new StringBuffer();
        sbf.append("(");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sbf.append(" or ").append(whereId).append(" in (");
            } else {
                sbf.append(whereId).append(" in (");
            }
            String idsSql = StringUtil.convertListToSingleQuotesString(new HashSet<String>((Collection)list.get(i)));
            sbf.append(idsSql);
            sbf.append(")");
        }
        sbf.append(")");
        return sbf.toString();
    }

    public static boolean equals(String st1, String st2) {
        if (BeanUtils.isEmpty(st1) && BeanUtils.isEmpty(st2)) {
            return true;
        }
        if (BeanUtils.isNotEmpty(st1) && BeanUtils.isNotEmpty(st1)) {
            return st1.equals(st2);
        }
        return false;
    }

    public static boolean LargeThen(String st1, String st2) {
        if (BeanUtils.isNotEmpty(st1) && BeanUtils.isNotEmpty(st1)) {
            return st1.compareTo(st2) > 0;
        }
        return false;
    }

    public static boolean littleThen(String st1, String st2) {
        if (BeanUtils.isNotEmpty(st1) && BeanUtils.isNotEmpty(st1)) {
            return st1.compareTo(st2) < 0;
        }
        return false;
    }

    public static boolean contains(String st1, String st2) {
        if (BeanUtils.isNotEmpty(st1) && BeanUtils.isNotEmpty(st1)) {
            return st1.contains(st2);
        }
        return false;
    }

    public static boolean isStringBelongTo(String target, String boundary) {
        if (BeanUtils.isEmpty(target) || BeanUtils.isEmpty(boundary)) {
            return false;
        }
        String[] boundaryArr = boundary.split(",");
        if (boundaryArr.length <= 0) {
            return false;
        }
        List<String> list = Arrays.asList(boundaryArr);
        return list.contains(target);
    }

    public static String wordMask(String word, int startLength, int endLength, String pad) {
        Assert.isTrue((startLength >= 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u4f4d\u7f6e\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        Assert.isTrue((endLength >= 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u4f4d\u7f6e\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        Assert.isTrue((startLength <= endLength ? 1 : 0) != 0, (String)"\u5f00\u59cb\u4f4d\u7f6e\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u4f4d\u7f6e");
        if (StringUtil.isEmpty(word)) {
            return word;
        }
        if (endLength > word.length()) {
            endLength = word.length();
        }
        if (startLength > endLength) {
            return word;
        }
        if (startLength > 0) {
            --startLength;
        }
        String startStr = word.substring(0, startLength);
        String endStr = word.substring(endLength, word.length());
        return startStr + StringUtils.leftPad((String)"", (int)(endLength - startLength), (String)pad) + endStr;
    }

    public static boolean isMobile(String mobile) {
        mobile = String.valueOf(mobile).trim();
        Pattern regex = Pattern.compile("^((1[3-9]{1}))\\d{9}$");
        Matcher matcher = regex.matcher(mobile);
        boolean isMatched = matcher.matches();
        return isMatched;
    }

    public static boolean isEmail(String email) {
        email = String.valueOf(email).trim();
        Pattern regex = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
        Matcher matcher = regex.matcher(email);
        boolean isMatched = matcher.matches();
        return isMatched;
    }

    public static boolean isRegex(String string, String regexStr) {
        string = String.valueOf(string).trim();
        Pattern regex = Pattern.compile(regexStr);
        Matcher matcher = regex.matcher(string);
        return matcher.matches();
    }

    public static String format(double value) {
        String dstr = String.valueOf(value);
        String[] earr = dstr.split("E");
        if (earr.length == 2) {
            int e = Integer.valueOf(earr[1]);
            String[] dotArr = earr[0].split("[.]");
            int precision = dotArr[1].length() - e;
            dstr = new BigDecimal(value).setScale(precision, RoundingMode.HALF_EVEN).toPlainString();
        } else if (value % 1.0 == 0.0) {
            dstr = String.valueOf(Double.valueOf(value).intValue());
        }
        return dstr;
    }

    public static boolean hasEmoji(String content) {
        Pattern pattern = Pattern.compile("(?:[\ud83c\udf00-\ud83d\uddff]|[\ud83e\udd00-\ud83e\uddff]|[\ud83d\ude00-\ud83d\ude4f]|[\ud83d\ude80-\ud83d\udeff]|[\u2600-\u26ff]\ufe0f?|[\u2700-\u27bf]\ufe0f?|\u24c2\ufe0f?|[\ud83c\udde6-\ud83c\uddff]{1,2}|[\ud83c\udd70\ud83c\udd71\ud83c\udd7e\ud83c\udd7f\ud83c\udd8e\ud83c\udd91-\ud83c\udd9a]\ufe0f?|[#*0-9]\ufe0f?\u20e3|[\u2194-\u2199\u21a9-\u21aa]\ufe0f?|[\u2b05-\u2b07\u2b1b\u2b1c\u2b50\u2b55]\ufe0f?|[\u2934\u2935]\ufe0f?|[\u3030\u303d]\ufe0f?|[\u3297\u3299]\ufe0f?|[\ud83c\ude01\ud83c\ude02\ud83c\ude1a\ud83c\ude2f\ud83c\ude32-\ud83c\ude3a\ud83c\ude50\ud83c\ude51]\ufe0f?|[\u203c\u2049]\ufe0f?|[\u25aa\u25ab\u25b6\u25c0\u25fb-\u25fe]\ufe0f?|[\u00a9\u00ae]\ufe0f?|[\u2122\u2139]\ufe0f?|\ud83c\udc04\ufe0f?|\ud83c\udccf\ufe0f?|[\u231a\u231b\u2328\u23cf\u23e9-\u23f3\u23f8-\u23fa]\ufe0f?)");
        Matcher matcher = pattern.matcher(content);
        return matcher.find();
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.wordMask("123456789", 0, 1, "*"));
        System.out.println(StringUtil.wordMask("123456789", 9, 15, "*"));
        System.out.println(StringUtil.wordMask("123456789", 0, 2, "*"));
        System.out.println(StringUtil.wordMask("123456789", 1, 2, "*"));
    }

    public static String getStrByRule(String titleRule, Map<String, Object> map) {
        return StringUtil.getStrByRule(titleRule, map, "\\{(.*?)\\}");
    }

    public static String getStrByRule(String titleRule, Map<String, Object> map, String regexRule) {
        if (StringUtils.isEmpty((String)titleRule)) {
            return "";
        }
        Pattern regex = Pattern.compile(regexRule, 98);
        Matcher matcher = regex.matcher(titleRule);
        while (matcher.find()) {
            String tag = matcher.group(0);
            String rule = matcher.group(1);
            String[] aryRule = rule.split(":");
            String name = "";
            name = aryRule.length == 1 ? rule : aryRule[1];
            if (map.containsKey(name)) {
                Object obj = map.get(name);
                if (obj != null) {
                    try {
                        if (obj instanceof Double) {
                            titleRule = titleRule.replace(tag, BigDecimal.valueOf((Double)obj).toPlainString());
                            continue;
                        }
                        titleRule = titleRule.replace(tag, obj.toString());
                    }
                    catch (Exception e) {
                        titleRule = titleRule.replace(tag, "");
                    }
                    continue;
                }
                titleRule = titleRule.replace(tag, "");
                continue;
            }
            String defaultValue = "";
            try {
                if (aryRule.length > 1) {
                    GroovyScriptEngine scriptEngine = AppUtil.getBean(GroovyScriptEngine.class);
                    String script = rule.replace(aryRule[0] + ":", "");
                    defaultValue = scriptEngine.executeString(script, map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            titleRule = titleRule.replace(tag, defaultValue);
        }
        return titleRule;
    }

    public static String underlineToHump(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            if (result.length() == 0) {
                result.append(camel.toLowerCase());
                continue;
            }
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String getByDefault(String str, String defaultValue) {
        if (StringUtil.isEmpty(str)) {
            return defaultValue;
        }
        return str;
    }

    public static String nCopies(String str, int n) {
        return Collections.nCopies(n, str).stream().collect(Collectors.joining());
    }

    public static String substring(String str, int length) {
        if (BeanUtils.isEmpty(str)) {
            return str;
        }
        if (str.length() >= length) {
            return str.substring(0, length);
        }
        return str;
    }
}

