/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component
public class TransactionThreadLocal {
    private static ThreadLocal<Connection> currentConnections = new ThreadLocal();
    private static ThreadLocal<List<Map<Connection, DataSource>>> connectionAndDSList = new ThreadLocal();

    private void cleanAll() {
        connectionAndDSList.remove();
        currentConnections.remove();
    }

    public void cleanCurrentConnection() {
        currentConnections.remove();
    }

    public void setCurrentConnections(Connection connection) {
        currentConnections.set(connection);
    }

    public Connection getCurrentConnection() {
        Connection connection = currentConnections.get();
        return connection;
    }

    public void commit() throws SQLException {
        List<Map<Connection, DataSource>> list = connectionAndDSList.get();
        if (list == null) {
            return;
        }
        list.stream().forEach(tmMap -> tmMap.forEach((connection, dataSource) -> {
            try {
                if (!connection.isClosed()) {
                    connection.commit();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
                }
            }
        }));
        this.cleanAll();
    }

    public void rollback() throws SQLException {
        List<Map<Connection, DataSource>> list = connectionAndDSList.get();
        if (list == null) {
            return;
        }
        list.stream().forEach(tmMap -> tmMap.forEach((connection, dataSource) -> {
            try {
                if (!connection.isClosed()) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
                }
            }
        }));
        this.cleanAll();
    }

    public void close() throws SQLException {
        List<Map<Connection, DataSource>> list = connectionAndDSList.get();
        if (list == null) {
            return;
        }
        list.stream().forEach(tmMap -> tmMap.forEach((connection, dataSource) -> {
            try {
                if (connection != null && !connection.isClosed()) {
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }));
        this.cleanAll();
    }

    public void addConnectionAndDS(Map<Connection, DataSource> map) {
        List<Map<Connection, DataSource>> list = connectionAndDSList.get();
        if (list == null) {
            list = new ArrayList<Map<Connection, DataSource>>();
        }
        if (list.contains(map)) {
            return;
        }
        list.add(map);
        connectionAndDSList.set(list);
    }
}

