/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.aop;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.FieldAuth;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.query.PageList;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FieldAuthAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    FormFeignService formFeignService;
    @Resource
    PortalFeignService portalFeignService;
    private final String FieldAuthPonit = "execution(* *..*Controller.*(..)) && @annotation(com.hotent.base.annotation.FieldAuth)";

    @AfterReturning(value="execution(* *..*Controller.*(..)) && @annotation(com.hotent.base.annotation.FieldAuth)", returning="keys")
    public Object doAfterReturningAdvice1(JoinPoint joinPoint, Object keys) throws Exception {
        MethodInvocationProceedingJoinPoint methodPoint = (MethodInvocationProceedingJoinPoint)joinPoint;
        Field proxy = methodPoint.getClass().getDeclaredField("methodInvocation");
        proxy.setAccessible(true);
        ReflectiveMethodInvocation j = (ReflectiveMethodInvocation)proxy.get(methodPoint);
        Method method = j.getMethod();
        String className = method.getAnnotation(FieldAuth.class).value();
        this.logger.info("\u7b2c\u4e00\u4e2a\u540e\u7f6e\u8fd4\u56de\u901a\u77e5\u7684\u8fd4\u56de\u503c\uff1a" + keys);
        Class<?> cls = Class.forName(className);
        String simpleName = cls.getSimpleName();
        ObjectNode node = this.formFeignService.getByClassName(simpleName);
        if (BeanUtils.isEmpty(node)) {
            return keys;
        }
        ObjectNode rightJson = this.portalFeignService.calcAllPermssion(node.get("fieldList").asText());
        Map map = JsonUtil.toMap(JsonUtil.toJson(rightJson));
        if (keys instanceof PageList) {
            PageList pageList = (PageList)keys;
            if (pageList.getRows().size() > 0) {
                List rows = pageList.getRows();
                ArrayList<ObjectNode> result = new ArrayList<ObjectNode>();
                for (Object object : rows) {
                    ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode(object);
                    Set entrySet = map.entrySet();
                    for (Map.Entry entry : entrySet) {
                        String converKey;
                        String key = entry.getKey();
                        boolean flag = (Boolean)entry.getValue();
                        if (flag || !objectNode.has(converKey = this.converKey(key))) continue;
                        objectNode.put(converKey, "\u65e0\u6743\u9650");
                    }
                    result.add(objectNode);
                }
                pageList.setRows(result);
            }
            return pageList;
        }
        return keys;
    }

    private String converKey(String key) {
        if (key.indexOf("_") == -1) {
            return key;
        }
        String[] split = key.split("_");
        if (split.length == 1) {
            return split[0].toLowerCase();
        }
        StringBuffer sb = new StringBuffer(split[0].toLowerCase());
        for (int i = 1; i < split.length; ++i) {
            String first = StringUtil.toFirst(split[i], true);
            sb.append(first);
        }
        return sb.toString();
    }
}

