/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.aop;

import com.hotent.base.annotation.Lock;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.service.RedisLock;
import com.hotent.base.util.ReflectUtil;
import com.hotent.base.util.StringUtil;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;

@Aspect
@Component
@Order(value=1000)
public class LockAspect {
    private Logger logger = LoggerFactory.getLogger(LockAspect.class);
    @Autowired
    RedisLock redisLock;
    @Autowired
    private SaaSConfig saaSConfig;
    @Resource
    BaseContext baseContext;
    private final String lockNameSpace = "eipLock:";

    @Around(value="@annotation(com.hotent.base.annotation.Lock)")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] args = joinPoint.getArgs();
        Model model = null;
        for (Object obj : args) {
            if (obj == null || !(obj instanceof Model)) continue;
            model = (Model)obj;
        }
        Lock lock = (Lock)AnnotationUtils.findAnnotation((Method)method, Lock.class);
        String key = String.valueOf(ReflectUtil.generateKey(lock.key(), method, args, joinPoint.getTarget()));
        if (StringUtil.isEmpty(key)) {
            return joinPoint.proceed();
        }
        String tenantId = this.baseContext.getCurrentTenantId();
        key = this.saaSConfig.isEnable() && StringUtil.isNotEmpty(tenantId) && !lock.ignoreTenant() ? "eipLock:" + tenantId + ":" + key : "eipLock:" + key;
        try {
            return this.redisLock.executeWithLock(key, joinPoint, lock.tryTime(), lock.lockFailMsg());
        }
        catch (BaseException e) {
            if (lock.isModel() && model != null) {
                model.addAttribute("msg", (Object)e.getMessage());
                return lock.failModel();
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }
}

