/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.aop;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.LogType;
import com.hotent.base.aop.AopCacheHelper;
import com.hotent.base.conf.SysLogConfig;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.WebUtil;
import com.hotent.base.util.time.DateUtil;
import io.jsonwebtoken.Claims;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(value={"syslog.enabled"}, matchIfMissing=true, havingValue="true")
public class SysLogsAspect {
    private Logger logger = LoggerFactory.getLogger(SysLogsAspect.class);
    @Resource
    JmsProducer jmsProducer;
    @Resource
    AopCacheHelper aopCacheHelper;
    @Autowired
    JwtTokenHandler jwtTokenHandler;
    @Value(value="${openApi.prefix:openApi}")
    private String openApiPrefix;
    private final String systemCode = "sysCode";
    @Value(value="${jwt.header:Authorization}")
    private String jwtHeader;
    @Resource
    private SysLogConfig sysLogConfig;
    private static final List<String> START_WITH_FOR_QUERY_LOG = Arrays.asList("get", "list", "query");
    private static String moduleType = "base";

    @Value(value="${spring.application.name:base}")
    public void setModuleType(String param) {
        moduleType = param;
    }

    /*
     * WARNING - void declaration
     */
    @Around(value="execution(* *..*Controller.*(..)) && @annotation(io.swagger.annotations.ApiOperation)")
    public Object sysLogs(ProceedingJoinPoint joinPoint) throws Throwable {
        ApiOperation apiOperation;
        String opeName;
        LocalDateTime startTime = LocalDateTime.now();
        Class<?> targetClass = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Method[] methods = targetClass.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        if (StringUtil.isEmpty(opeName = (apiOperation = method.getAnnotation(ApiOperation.class)).value())) {
            opeName = apiOperation.notes();
        }
        ThreadMsgUtil.addMapMsg("sysLogOpeName", opeName);
        Object proceed = null;
        HttpServletRequest request = HttpUtil.getRequest();
        proceed = joinPoint.proceed();
        if (BeanUtils.isEmpty(request)) {
            return proceed;
        }
        Object[] args = joinPoint.getArgs();
        String reqUrl = request.getRequestURI();
        try {
            void var15_23;
            Map<String, String> cacheSettings = this.aopCacheHelper.getSysLogsSettingStatusMap();
            if (BeanUtils.isEmpty(cacheSettings) || !cacheSettings.containsKey(moduleType) || !"1".equals(cacheSettings.get(moduleType))) {
                this.logger.error("\u672a\u83b7\u53d6\u5230\u65e5\u5fd7\u914d\u7f6e\u4e2d\u5173\u4e8e\u6a21\u5757\uff1a{}\u7684\u65e5\u5fd7\u914d\u7f6e\uff0c\u8df3\u8fc7\u8be5\u6a21\u5757\u7684\u65e5\u5fd7\u8bb0\u5f55\u3002", (Object)moduleType);
                return proceed;
            }
            if (!this.sysLogConfig.isQuery()) {
                for (String string : START_WITH_FOR_QUERY_LOG) {
                    if (!methodName.toLowerCase().startsWith(string)) continue;
                    this.logger.info("\u8df3\u8fc7\u67e5\u8be2\u7c7b\u578b\u7684\u65e5\u5fd7\u8bb0\u5f55\uff1a{}", (Object)reqUrl);
                    return proceed;
                }
            }
            StringBuffer sb = new StringBuffer();
            if (BeanUtils.isNotEmpty(args)) {
                for (Object object : args) {
                    if (object instanceof ServletRequest || object instanceof ServletResponse) continue;
                    try {
                        String json = JsonUtil.toJson(object);
                        sb.append(json);
                    }
                    catch (Exception e) {
                        sb.append(object.toString());
                    }
                }
            }
            String string = "\u7cfb\u7edf[\u65e0\u7528\u6237\u767b\u5f55\u7cfb\u7edf]";
            if (StringUtil.isNotEmpty(AuthenticationUtil.getCurrentUserFullname())) {
                String string2 = String.format("%s[%s]", AuthenticationUtil.getCurrentUserFullname(), AuthenticationUtil.getCurrentUsername());
            }
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            objectNode.put("id", UniqueIdUtil.getSuid());
            objectNode.put("opeName", opeName);
            objectNode.put("moduleType", moduleType);
            objectNode.put("reqUrl", reqUrl);
            objectNode.put("opeContent", sb.toString());
            objectNode.put("type", "sysLog");
            objectNode.putPOJO("executionTime", (Object)DateUtil.getCurrentDate());
            String tenantId = HttpUtil.getTenantId();
            if (BeanUtils.isEmpty(tenantId)) {
                tenantId = "-1";
            }
            if (reqUrl.contains(this.openApiPrefix)) {
                String requestHeader = request.getHeader(this.jwtHeader);
                String authToken = requestHeader.substring(7);
                Claims claims = this.jwtTokenHandler.parseToken(authToken);
                String systemCode = (String)claims.get((Object)this.systemCode);
                objectNode.put("systemType", systemCode);
            }
            objectNode.put("tenantId", tenantId);
            LogType type = method.getAnnotation(LogType.class);
            String logType = "\u64cd\u4f5c\u65e5\u5fd7";
            if (type != null) {
                logType = type.value();
            }
            objectNode.put("logType", logType);
            objectNode.put("executor", (String)var15_23);
            objectNode.put("ip", WebUtil.getIpAddr(request));
            objectNode.put("elapsedTime", Double.valueOf(DateUtil.getTime(startTime, LocalDateTime.now())) / 1000.0);
            this.jmsProducer.sendToQueue(JsonUtil.toJson(objectNode), "sysLogQueue");
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\u3002" + ExceptionUtil.getExceptionMessage(e));
        }
        return proceed;
    }
}

