/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.cache.setting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.hotent.base.cache.setting.FirstCacheSetting;
import com.hotent.base.cache.setting.SecondaryCacheSetting;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class CacheSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SPLIT = "-";
    private String internalKey;
    private String depict;
    boolean useSecondCache = true;
    private FirstCacheSetting firstCacheSetting;
    private SecondaryCacheSetting secondaryCacheSetting;
    private Boolean onlyUseRedis = false;

    public static CacheSetting buildDefault(String depict) {
        CacheSetting cacheSetting = new CacheSetting();
        cacheSetting.setDepict(depict);
        cacheSetting.setUseSecondCache(false);
        cacheSetting.withDefaultFirstSetting().withDefaultSecondaryCacheSetting();
        cacheSetting.internalKey();
        return cacheSetting;
    }

    private CacheSetting withDefaultFirstSetting() {
        FirstCacheSetting fcs = new FirstCacheSetting();
        fcs.setExpireTime(7);
        fcs.setTimeUnit(TimeUnit.HOURS);
        this.setFirstCacheSetting(fcs);
        return this;
    }

    private CacheSetting withDefaultSecondaryCacheSetting() {
        SecondaryCacheSetting scs = new SecondaryCacheSetting();
        scs.setExpiration(24);
        scs.setTimeUnit(TimeUnit.HOURS);
        scs.setPreloadTime(5);
        this.setSecondaryCacheSetting(scs);
        return this;
    }

    private CacheSetting() {
    }

    public CacheSetting(FirstCacheSetting firstCacheSetting, SecondaryCacheSetting secondaryCacheSetting, String depict, Boolean onlyUseRedis) {
        this.firstCacheSetting = firstCacheSetting;
        this.secondaryCacheSetting = secondaryCacheSetting;
        this.depict = depict;
        this.onlyUseRedis = onlyUseRedis;
        this.internalKey();
    }

    @JsonIgnore
    private void internalKey() {
        this.internalKey = "default";
    }

    public FirstCacheSetting getFirstCacheSetting() {
        return this.firstCacheSetting;
    }

    public SecondaryCacheSetting getSecondaryCacheSetting() {
        return this.secondaryCacheSetting;
    }

    public String getInternalKey() {
        return this.internalKey;
    }

    public void internalKey(String internalKey) {
        this.internalKey = internalKey;
    }

    public boolean isUseSecondCache() {
        return this.useSecondCache;
    }

    public void setUseSecondCache(boolean useSecondCache) {
        this.useSecondCache = useSecondCache;
    }

    public void setFirstCacheSetting(FirstCacheSetting firstCacheSetting) {
        this.firstCacheSetting = firstCacheSetting;
    }

    public void setSecondaryCacheSetting(SecondaryCacheSetting secondaryCacheSetting) {
        this.secondaryCacheSetting = secondaryCacheSetting;
    }

    public void setInternalKey(String internalKey) {
        this.internalKey = internalKey;
    }

    public String getDepict() {
        return this.depict;
    }

    public void setDepict(String depict) {
        this.depict = depict;
    }

    public Boolean getOnlyUseRedis() {
        return this.onlyUseRedis;
    }

    public void setOnlyUseRedis(Boolean onlyUseRedis) {
        this.onlyUseRedis = onlyUseRedis;
    }
}

