/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.conf;

import com.hotent.base.conf.EipYmlConfig;
import com.hotent.base.conf.JwtConfig;
import com.hotent.base.conf.WebSecurityEmptyExtend;
import com.hotent.base.conf.WebSecurityExtend;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.filter.JwtAuthorizationTokenFilter;
import com.hotent.base.jwt.JwtAuthenticationEntryPoint;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.security.CustomAccessDeniedHandler;
import com.hotent.base.security.CustomPwdEncoder;
import com.hotent.base.security.HtDecisionManager;
import com.hotent.base.security.HtFilterSecurityInterceptor;
import com.hotent.base.util.StringUtil;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@EnableWebSecurity
@Configuration
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Resource
    UserDetailsService userDetailsService;
    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    JwtConfig jwtConfig;
    @Value(value="${feign.encry.key:feignCallEncry}")
    private String encryKey;
    @Value(value="${hotent.security.ignore.httpUrls:''}")
    String permitAll;
    @Value(value="${hotent.security.deny.httpUrls:''}")
    String denyAll;
    @Value(value="${hotent.security.pswd.encoder:}")
    String passwordEncoder;
    @Value(value="${cors.enable:true}")
    Boolean corsEnable;
    @Resource
    JwtAuthenticationEntryPoint jwtAuthenticationEntryPoint;
    @Resource
    HtFilterSecurityInterceptor htFilterSecurityInterceptor;
    @Resource
    CustomAccessDeniedHandler customAccessDeniedHandler;
    @Resource
    EipYmlConfig eipYmlConfig;
    @Value(value="${webjar.context:mvue,front,mobile}")
    private List<String> resourceContext;
    @Autowired
    PortalFeignService portalFeignService;
    @Value(value="${openApi.prefix:'openApi'}")
    String openApiPre;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.getCustomPasswordEncoder());
    }

    public PasswordEncoder getCustomPasswordEncoder() {
        CustomPwdEncoder encoder = (CustomPwdEncoder)this.defaultPasswordEncoderBean();
        if (StringUtil.isNotEmpty(this.passwordEncoder)) {
            try {
                logger.info("Use config password encoder : " + this.passwordEncoder);
                PasswordEncoder delegate = (PasswordEncoder)Class.forName(this.passwordEncoder).newInstance();
                encoder.setDelegateEncoder(delegate);
            }
            catch (Exception e) {
                logger.error("Create custom password encoder config class[" + this.passwordEncoder + "] failed.");
            }
        }
        return encoder;
    }

    @Bean
    public WebSecurityExtend emptyExtend() {
        return new WebSecurityEmptyExtend();
    }

    @Bean
    public PasswordEncoder defaultPasswordEncoderBean() {
        return new CustomPwdEncoder();
    }

    @Bean
    public AccessDecisionManager accessDecisionManager() {
        return new HtDecisionManager();
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        Object[] permitAlls = new String[]{};
        String[] denyAlls = new String[]{};
        if (StringUtil.isNotEmpty(this.permitAll)) {
            permitAlls = this.permitAll.split(",");
        }
        for (String rc : this.resourceContext) {
            permitAlls = (String[])ArrayUtils.add((Object[])permitAlls, (Object)String.format("/%s/**", rc));
        }
        if (StringUtil.isNotEmpty(this.denyAll)) {
            denyAlls = this.denyAll.split(",");
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)httpSecurity.csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.jwtAuthenticationEntryPoint).and()).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.customAccessDeniedHandler).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers((String[])permitAlls)).permitAll().antMatchers(denyAlls)).denyAll().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().antMatchers(new String[]{"/auth/**"})).permitAll().antMatchers(new String[]{"/index"})).permitAll().antMatchers(new String[]{"/demo/**"})).permitAll().antMatchers(new String[]{"/images/**"})).permitAll().antMatchers(new String[]{"/listFiles"})).permitAll().antMatchers(new String[]{"/fileUpload"})).permitAll().antMatchers(new String[]{"/deleteFile"})).permitAll().antMatchers(new String[]{"/ueditor/**", "/apiManager/getToken"})).permitAll().anyRequest()).authenticated().accessDecisionManager(this.accessDecisionManager());
        JwtAuthorizationTokenFilter authenticationTokenFilter = new JwtAuthorizationTokenFilter(this.userDetailsService(), this.jwtTokenHandler, this.jwtConfig.getHeader(), this.portalFeignService, this.openApiPre);
        authenticationTokenFilter.setEncryKey(this.encryKey);
        authenticationTokenFilter.setEipYmlConfig(this.eipYmlConfig);
        httpSecurity.addFilterBefore((Filter)authenticationTokenFilter, UsernamePasswordAuthenticationFilter.class);
        httpSecurity.addFilterBefore((Filter)this.htFilterSecurityInterceptor, FilterSecurityInterceptor.class);
        httpSecurity.addFilterBefore((Filter)this.corsFilter(), ChannelProcessingFilter.class);
        httpSecurity.headers().frameOptions().sameOrigin().cacheControl();
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.POST, new String[]{"/auth", "/error", "/sys/sysLogs/v1/loginLogs", "/sys/sysLogs/v1/saveLogs", "/api/user/v1/user/loadUserByUsername", "/actuator/cert", "/form/formServiceController/v1/getFormAndBoExportXml", "/api/twoVerify/v1/twoStepVerify", "/api/twoVerify/v1/twoStepVerifyAndBind", "/i18n/custom/i18nMessageType/v1/all", "/**/bpmRuntimeStartUp"})).antMatchers(HttpMethod.GET, new String[]{"/sso/**", "/sys/sysLogsSettings/v1/getSysLogsSettingStatusMap", "/sys/sysRoleAuth/v1/getMethodRoleAuth", "/system/file/v1/getLogoFile", "/system/file/v1/getImage", "/flow/def/v1/bpmnXml", "/file/onlinePreviewController/v1/getFileByPathAndId**", "/file/onlinePreviewController/v1/getFileById**", "/portal/main/v1/appProperties", "/uc/tenantManage/v1/getTenantByCode", "/sys/sysProperties/v1/getDecryptBySysSetting", "/portal/shorturlManage/v1/getLongUrlByShortUrl", "/system/file/v1/downloadFile", "/portal/sysExternalUnite/v1/getQrCodeInfo", "/portal/sysExternalUnite/v1/getDingtalkIdFromScanCode", "/portal/sysExternalUnite/v1/getWxWorkIdFromScanCode", "/base/tools/v1/getPublicKey", "/portalBizSystem/v1/checkSysCodeAndUri", "/instance/client/v1/get", "/i18n/custom/i18nMessage/v1/getLangPackage", "/task/check", "/base/tools/v1/getPinyin"})).and().ignoring().antMatchers(HttpMethod.GET, new String[]{"/", "/error", "/*.html", "/favicon.ico", "/**/*.html", "/getPreviewFile/*_*_*", "/**/*.css", "/**/*.js", "/**/*.css", "/**/*.woff2", "/**/*.woff", "/**/*.ttf", "/**/image"})).and().ignoring().antMatchers(new String[]{"/v2/api-docs", "/swagger-resources/configuration/ui", "/swagger-resources", "/swagger-resources/configuration/security", "/swagger-ui.html", "/proxy.stream", "/hystrix.stream", "/druid/**", "/hystrix/**", "/actuator/**", "/static/**", "/public/**", "/pdfjs/**", "/css/**", "/service/**"})).and().ignoring().antMatchers(this.eipYmlConfig.getAnonymousUrl().toArray(new String[this.eipYmlConfig.getAnonymousUrl().size()]));
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        if (this.corsEnable.booleanValue()) {
            CorsConfiguration corsConfiguration = new CorsConfiguration();
            corsConfiguration.addAllowedOrigin("*");
            corsConfiguration.addAllowedHeader("*");
            corsConfiguration.addAllowedMethod("*");
            source.registerCorsConfiguration("/**", corsConfiguration);
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public HtFilterSecurityInterceptor htFilterSecurityInterceptor(AccessDecisionManager accessDecisionManager) throws Exception {
        HtFilterSecurityInterceptor htFilterSecurityInterceptor = new HtFilterSecurityInterceptor();
        htFilterSecurityInterceptor.setAccessDecisionManager(accessDecisionManager);
        return htFilterSecurityInterceptor;
    }
}

