/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.controller;

import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.model.CommonResult;
import com.hotent.base.service.ExceptionLogService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BasicErrorController
implements ErrorController {
    private static final String ERROR_PATH = "/error";
    @Resource
    ExceptionLogService exceptionLogService;
    Logger logger = LoggerFactory.getLogger(BasicErrorController.class);

    @RequestMapping(value={"/error"})
    public CommonResult<String> handleError(HttpServletRequest request) throws Throwable {
        this.logException(request);
        Object rootException = request.getAttribute("javax.servlet.error.exception");
        if (BeanUtils.isNotEmpty(rootException) && rootException instanceof Exception) {
            Exception exception = (Exception)rootException;
            this.logger.error("\u9519\u8bef\u539f\u56e0: {}", (Object)exception.getMessage(), (Object)exception);
            throw ExceptionUtil.getRootCauseOrSelf((Throwable)rootException);
        }
        return this.resultByCode(request);
    }

    private void logException(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        String errorMessage = (String)request.getAttribute("javax.servlet.error.message");
        String requestUri = (String)request.getAttribute("javax.servlet.error.request_uri");
        this.logger.error("\u8bf7\u6c42\u9519\u8bef\u5730\u5740\uff1a{}", (Object)requestUri);
        this.logger.error("\u8bf7\u6c42\u9519\u8bef\u72b6\u6001\uff1a{}", (Object)statusCode);
        this.logger.error("\u8bf7\u6c42\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)errorMessage);
        this.exceptionLogService.save(errorMessage);
    }

    private CommonResult<String> resultByCode(HttpServletRequest request) {
        ResponseErrorEnums[] values;
        Integer code = (Integer)request.getAttribute("javax.servlet.error.status_code");
        for (ResponseErrorEnums value : values = ResponseErrorEnums.values()) {
            if (value.getHttpCode() != code.intValue()) continue;
            return new CommonResult<String>(value);
        }
        return new CommonResult<String>(ResponseErrorEnums.SYSTEM_ERROR);
    }
}

