/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.dto.PortalDataSensitive;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.interceptor.ResultSetFilter;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BaseContextThreadUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.base.util.DesensitizeUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.api.util.IPermissionCalc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FormDataResultSetFilter
implements ResultSetFilter,
ContextThread {
    Logger logger = LoggerFactory.getLogger(FormDataResultSetFilter.class);
    ThreadLocal<Map<String, PortalDataSensitive>> portalDataSensitiveLocal = new ThreadLocal();
    ThreadLocal<Map<String, JsonNode>> desensiRuleLocal = new ThreadLocal();

    @Override
    public void handle(Object obj) {
        Map currentProfiles = null;
        Map<String, PortalDataSensitive> portalDataSensitive = this.portalDataSensitiveLocal.get();
        Map<String, JsonNode> desensiRuleMap = this.desensiRuleLocal.get();
        if (BeanUtils.isNotEmpty(portalDataSensitive) || BeanUtils.isNotEmpty(desensiRuleMap)) {
            IPermissionCalc permissionCalc = AppUtil.getBean(IPermissionCalc.class);
            currentProfiles = permissionCalc.getCurrentProfiles();
        }
        if (obj instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)obj;
            for (HashMap hashMap : arrayList) {
                if (!(hashMap instanceof HashMap)) continue;
                HashMap row = hashMap;
                for (Map.Entry<String, Object> entry : row.entrySet()) {
                    if (BeanUtils.isNotEmpty(portalDataSensitive)) {
                        this.handleField(entry, currentProfiles);
                    }
                    if (!BeanUtils.isNotEmpty(desensiRuleMap)) continue;
                    this.handleFormField(entry, currentProfiles);
                }
            }
        }
        if (BeanUtils.isNotEmpty(portalDataSensitive)) {
            this.portalDataSensitiveLocal.remove();
        }
        if (BeanUtils.isNotEmpty(desensiRuleMap)) {
            this.desensiRuleLocal.remove();
        }
    }

    @Override
    public boolean support(String id, String sql, List<String> tableNames) {
        ArrayList<String> mappedStatementIds = new ArrayList<String>();
        mappedStatementIds.add("com.hotent.base.dao.CommonDao.queryByCustomSql");
        mappedStatementIds.add("com.hotent.base.dao.CommonDao.query");
        if (mappedStatementIds.contains(id) && tableNames != null) {
            PortalFeignService portalFeignService = AppUtil.getBean(PortalFeignService.class);
            Map desensitizationMap = null;
            try {
                Object desensitization = BaseContextThreadUtil.getCommuVar("desensitizationMap", "");
                if (BeanUtils.isNotEmpty(desensitization)) {
                    desensitizationMap = (Map)desensitization;
                }
            }
            catch (Exception desensitization) {
                // empty catch block
            }
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = tableNames.get(i);
                if (StringUtil.isNotEmpty(tableName)) {
                    CommonResult<PortalDataSensitive> portalDataSensitive = null;
                    try {
                        portalDataSensitive = portalFeignService.getPortalDataSensitive("local", tableName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (BeanUtils.isNotEmpty(portalDataSensitive) && portalDataSensitive.getState().booleanValue() && BeanUtils.isNotEmpty(portalDataSensitive.getValue())) {
                        this.add2Local(tableName, portalDataSensitive.getValue());
                    }
                }
                if (!BeanUtils.isNotEmpty(desensitizationMap) || !desensitizationMap.containsKey(tableName)) continue;
                Map desensiRuleMap = (Map)desensitizationMap.get(tableName);
                for (String field : desensiRuleMap.keySet()) {
                    this.addDesensi2Local(field, (JsonNode)desensiRuleMap.get(field));
                }
            }
            return this.isNotEmpty();
        }
        return false;
    }

    private boolean isNotEmpty() {
        Map<String, PortalDataSensitive> map = this.portalDataSensitiveLocal.get();
        Map<String, JsonNode> ruleMap = this.desensiRuleLocal.get();
        return BeanUtils.isNotEmpty(map) || BeanUtils.isNotEmpty(ruleMap);
    }

    private void add2Local(String tableName, PortalDataSensitive portalDataSensitive) {
        Map<String, PortalDataSensitive> map = this.portalDataSensitiveLocal.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, PortalDataSensitive>();
        }
        map.put(tableName, portalDataSensitive);
        this.portalDataSensitiveLocal.set(map);
    }

    private void addDesensi2Local(String tableName, JsonNode desensiSet) {
        Map<String, JsonNode> map = this.desensiRuleLocal.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, JsonNode>();
        }
        map.put(tableName, desensiSet);
        this.desensiRuleLocal.set(map);
    }

    private void handleField(Map.Entry<String, Object> entry, Map<String, Set<String>> currentProfiles) {
        try {
            Map<String, PortalDataSensitive> map = this.portalDataSensitiveLocal.get();
            Set<String> keySet = map.keySet();
            for (String tableName : keySet) {
                PortalDataSensitive portalDataSensitive = map.get(tableName);
                ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode(portalDataSensitive.getDesensitizationRules());
                GroovyScriptEngine groovyScriptEngine = AppUtil.getBean(GroovyScriptEngine.class);
                for (JsonNode jsonNode : arrayNode) {
                    Object value;
                    boolean hasRight;
                    if (!entry.getKey().equalsIgnoreCase(jsonNode.get("fieldName").asText()) || (hasRight = this.hasRight(jsonNode.get("rights").asText(), currentProfiles))) continue;
                    String groovyScript = JsonUtil.getString(jsonNode, "groovyScript");
                    String calType = JsonUtil.getString(jsonNode, "calType");
                    String formula = JsonUtil.getString(jsonNode, "formula");
                    Object workMask = value = entry.getValue();
                    if (StringUtil.isNotEmpty(groovyScript) && "2".equals(calType)) {
                        HashMap<String, Object> vars = new HashMap<String, Object>();
                        vars.put(entry.getKey(), entry.getValue());
                        workMask = groovyScriptEngine.executeObject(groovyScript, vars);
                    } else if (StringUtil.isNotEmpty(formula) && "3".equals(calType)) {
                        HashMap<String, Object> vars = new HashMap<String, Object>();
                        vars.put("DesensitizeUtil", DesensitizeUtil.class);
                        vars.put("target", entry.getValue());
                        workMask = groovyScriptEngine.executeScript(formula, vars);
                    } else {
                        int maxLength = 0;
                        if (BeanUtils.isNotEmpty(value)) {
                            int endPosition;
                            if (!(value instanceof String)) {
                                value = String.valueOf(value);
                            }
                            String valueStr = value.toString();
                            maxLength = valueStr.length();
                            JsonNode rules = JsonUtil.toJsonNode(jsonNode.get("rules").asText());
                            int startPosition = JsonUtil.getInt((JsonNode)((ObjectNode)rules), "startPosition", 0);
                            if (startPosition > maxLength) {
                                startPosition = maxLength;
                            }
                            if ((endPosition = JsonUtil.getInt((JsonNode)((ObjectNode)rules), "endPosition", maxLength)) > maxLength) {
                                endPosition = maxLength;
                            }
                            String pad = JsonUtil.getString(rules, "pad", "*");
                            workMask = StringUtil.wordMask(valueStr, startPosition, endPosition, pad);
                        }
                    }
                    entry.setValue(workMask);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(ResponseErrorEnums.DESENSITIZATION.getMessage(), (Throwable)e);
            throw new BaseException(ResponseErrorEnums.DESENSITIZATION);
        }
    }

    private void handleFormField(Map.Entry<String, Object> entry, Map<String, Set<String>> currentProfiles) {
        try {
            Map<String, JsonNode> map = this.desensiRuleLocal.get();
            Set<String> keySet = map.keySet();
            GroovyScriptEngine groovyScriptEngine = AppUtil.getBean(GroovyScriptEngine.class);
            for (String fieldName : keySet) {
                Object value;
                JsonNode desensiRuleNode;
                boolean hasRight;
                if (!entry.getKey().equalsIgnoreCase(fieldName) || (hasRight = this.hasRight((desensiRuleNode = map.get(fieldName)).get("rights").asText(), currentProfiles))) continue;
                String groovyScript = desensiRuleNode.has("groovyScript") ? desensiRuleNode.get("groovyScript").asText() : "";
                String calType = desensiRuleNode.get("type").asText();
                String formula = JsonUtil.getString(desensiRuleNode, "formula");
                Object workMask = value = entry.getValue();
                if (StringUtil.isNotEmpty(groovyScript) && "2".equals(calType)) {
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put(entry.getKey(), entry.getValue());
                    workMask = groovyScriptEngine.executeObject(groovyScript, vars);
                } else if (StringUtil.isNotEmpty(formula) && "3".equals(calType)) {
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("DesensitizeUtil", DesensitizeUtil.class);
                    vars.put("target", entry.getValue());
                    workMask = groovyScriptEngine.executeScript(formula, vars);
                } else if (BeanUtils.isNotEmpty(value)) {
                    int endPosition;
                    if (!(value instanceof String)) {
                        value = String.valueOf(value);
                    }
                    String valueStr = value.toString();
                    int maxLength = valueStr.length();
                    int startPosition = JsonUtil.getInt((JsonNode)((ObjectNode)desensiRuleNode), "startPosition", 0);
                    if (startPosition > maxLength) {
                        startPosition = maxLength;
                    }
                    if ((endPosition = JsonUtil.getInt((JsonNode)((ObjectNode)desensiRuleNode), "endPosition", maxLength)) > maxLength) {
                        endPosition = maxLength;
                    }
                    String pad = JsonUtil.getString(desensiRuleNode, "pad", "*");
                    workMask = StringUtil.wordMask(valueStr, startPosition, endPosition, pad);
                }
                entry.setValue(workMask);
            }
        }
        catch (Exception e) {
            this.logger.error(ResponseErrorEnums.DESENSITIZATION.getMessage(), (Throwable)e);
            throw new BaseException(ResponseErrorEnums.DESENSITIZATION);
        }
    }

    private boolean hasRight(String rights, Map<String, Set<String>> currentProfiles) throws IOException {
        IPermissionCalc permissionCalc = AppUtil.getBean(IPermissionCalc.class);
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode(rights);
        if (arrayNode.isEmpty()) {
            return false;
        }
        return permissionCalc.hasRight(JsonUtil.toJsonString(arrayNode.get(0)), currentProfiles);
    }

    @Override
    public void cleanAll() {
        this.portalDataSensitiveLocal.remove();
        this.desensiRuleLocal.remove();
    }
}

