/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.filter;

import com.hotent.base.conf.EipYmlConfig;
import com.hotent.base.conf.JwtConfig;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.SecurityUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadLocalCleanUtil;
import io.jsonwebtoken.Claims;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtAuthorizationTokenFilter
extends OncePerRequestFilter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String encryKey;
    private UserDetailsService userDetailsService;
    private JwtTokenHandler jwtTokenHandler;
    private String tokenHeader;
    private PortalFeignService portalFeignService;
    private final String systemCodeKey = "sysCode";
    private final String tenantId = "tenantId";
    private final String PARAMETER_TOKEN = "token";
    private String OpenApiPre;
    private EipYmlConfig eipYmlConfig;

    public EipYmlConfig getEipYmlConfig() {
        return this.eipYmlConfig;
    }

    public void setEipYmlConfig(EipYmlConfig eipYmlConfig) {
        this.eipYmlConfig = eipYmlConfig;
    }

    public void setEncryKey(String encryKey) {
        this.encryKey = encryKey;
    }

    public JwtAuthorizationTokenFilter(UserDetailsService userDetailsService, JwtTokenHandler jwtTokenHandler, String tokenHeader, PortalFeignService portalFeignService, String OpenApiPre) {
        this.userDetailsService = userDetailsService;
        this.jwtTokenHandler = jwtTokenHandler;
        this.tokenHeader = tokenHeader;
        this.portalFeignService = portalFeignService;
        this.OpenApiPre = OpenApiPre;
    }

    private Claims getClaims(String token) {
        try {
            return this.jwtTokenHandler.parseToken(token);
        }
        catch (Exception e) {
            Claims claims = this.jwtTokenHandler.parseFeignToken(token);
            claims.put((Object)"isFromFeign", (Object)true);
            return claims;
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        ThreadLocalCleanUtil.cleanAll(false);
        String requestHeader = request.getHeader(this.tokenHeader);
        boolean isFromFeign = false;
        if (StringUtil.isEmpty(requestHeader)) {
            requestHeader = request.getHeader("Proxy-Authorization");
            isFromFeign = true;
        }
        String username = null;
        String authToken = null;
        Claims claims = null;
        String requestURI = request.getRequestURI();
        request.setAttribute("htRequestStartTime", (Object)LocalDateTime.now());
        String sysCode = "";
        if (requestHeader != null && requestHeader.startsWith("Bearer ")) {
            authToken = requestHeader.substring(7);
            try {
                claims = this.getClaims(authToken);
                sysCode = (String)claims.get((Object)this.systemCodeKey);
                if (!isFromFeign && claims.containsKey((Object)"isFromFeign")) {
                    isFromFeign = (Boolean)claims.get((Object)"isFromFeign");
                }
                if (StringUtil.isNotEmpty(sysCode) && !isFromFeign) {
                    isFromFeign = StringUtil.isNotEmpty(request.getHeader("Proxy-Authorization"));
                }
                if (StringUtil.isNotEmpty(sysCode) && requestURI.contains(this.OpenApiPre)) {
                    CommonResult result = this.portalFeignService.checkSysCodeAndUri(sysCode, null, requestURI, (String)claims.get((Object)"tenantId"));
                    if (!result.getState().booleanValue()) {
                        this.send401Error(response, result.getMessage());
                        return;
                    }
                } else if (StringUtil.isNotEmpty(sysCode) && !requestURI.contains(this.OpenApiPre) && !isFromFeign) {
                    this.send401Error(response, "\u5f53\u524d\u8def\u5f84\uff0c\u60a8\u65e0\u8bbf\u95ee\u6743\u9650");
                    return;
                }
                username = claims.getSubject();
            }
            catch (Exception e) {
                this.logger.warn("the token valid exception", (Throwable)e);
                this.send401Error(response, e.getMessage());
                return;
            }
        }
        if (requestHeader != null && requestHeader.startsWith("Basic ") && this.jwtTokenHandler.enableBasic().booleanValue()) {
            String basicToken = requestHeader.substring(6);
            String userPwd = Base64.getFromBase64(basicToken);
            String[] arys = userPwd.split(":");
            if (arys.length == 2) {
                try {
                    String pwd = "";
                    try {
                        pwd = EncryptUtil.decrypt(arys[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ("admin".equals(arys[0]) && pwd.equals(this.encryKey)) {
                        SecurityUtil.login(request, arys[0], "", true);
                    }
                    SecurityUtil.login(request, arys[0], arys[1], false);
                }
                catch (Exception e) {
                    this.logger.error("\u7528\u6237\u8ba4\u8bc1\u9519\u8bef", (Throwable)e);
                    this.send401Error(response, e.getMessage());
                    return;
                }
            }
        } else if (this.allowRequest(request)) {
            authToken = request.getParameter("token");
            username = this.getUserNameFormToken(authToken);
        } else {
            this.logger.warn("couldn't find bearer string, will ignore the header");
        }
        this.logger.debug("checking authentication for user '{}'", (Object)username);
        if (username != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            this.logger.debug("security context was null, so authorizating user");
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
            if (claims != null && claims.containsKey((Object)"isFromFeign") || this.jwtTokenHandler.validateToken(authToken, userDetails).booleanValue()) {
                if (StringUtil.isEmpty(sysCode)) {
                    try {
                        this.handleSingleLogin(request, username, authToken, userDetails);
                    }
                    catch (Exception e) {
                        this.logger.warn("the token valid exception", (Throwable)e);
                        if (e instanceof BaseException) {
                            this.send401Error(response, (BaseException)e);
                        } else {
                            this.send401Error(response, e.getMessage());
                        }
                        return;
                    }
                }
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                AuthenticationUtil.setAuthentication((Authentication)authentication);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getUserNameFormToken(String token) {
        String username = null;
        if (StringUtil.isNotEmpty(token)) {
            Claims claims = this.getClaims(token);
            username = claims.getSubject();
        }
        return username;
    }

    private boolean allowRequest(HttpServletRequest request) {
        List<String> allowUrlsFromTokenParameter = this.eipYmlConfig.getAllowUrlsFromTokenParameter();
        for (String url : allowUrlsFromTokenParameter) {
            AntPathRequestMatcher matcher;
            if (StringUtil.isEmpty(url) || !(matcher = new AntPathRequestMatcher(url)).matches(request)) continue;
            return true;
        }
        return false;
    }

    private void send401Error(HttpServletResponse response, String message) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html; charset=utf-8");
        CommonResult result = new CommonResult(false, message);
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        PrintWriter writer = response.getWriter();
        writer.print(JsonUtil.toJson(result));
        writer.flush();
    }

    private void send401Error(HttpServletResponse response, BaseException e) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html; charset=utf-8");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        PrintWriter writer = response.getWriter();
        CommonResult result = new CommonResult(false, e.getMessage());
        if (e.getResponseErrorEnums() != null) {
            result = CommonResult.result(e.getResponseErrorEnums());
        }
        writer.print(JsonUtil.toJson(result));
        writer.flush();
    }

    private void handleSingleLogin(HttpServletRequest request, String username, String token, UserDetails userDetails) throws Exception {
        LocalDate expireDate;
        JwtConfig jwtConfig = AppUtil.getBean(JwtConfig.class);
        String header = request.getHeader("Proxy-Authorization");
        if (jwtConfig.isSingle() && StringUtil.isEmpty(header)) {
            boolean isMobile = HttpUtil.isMobile(request);
            String userAgent = isMobile ? "mobile" : "pc";
            String tenantId = HttpUtil.getTenantId();
            String oldToken = this.jwtTokenHandler.getTokenFromCache(userAgent, tenantId, username, jwtConfig.getExpiration());
            if (jwtConfig.isStricty()) {
                if (StringUtil.isEmpty(token) || !token.equals(oldToken)) {
                    throw new BaseException(ResponseErrorEnums.TOKEN_INVALID);
                }
            } else if (StringUtil.isNotEmpty(oldToken) && this.jwtTokenHandler.validateToken(oldToken, userDetails).booleanValue() && !oldToken.equals(token)) {
                throw new BaseException(ResponseErrorEnums.KICK_OFF_BY_ANOTHER);
            }
        }
        if ((expireDate = JsonUtil.getLocalDate(JsonUtil.toJsonNode(userDetails), "expireDate")) != null && LocalDate.now().isAfter(expireDate)) {
            String msg = String.format("\u3010%s\u3011\u5df2\u8fc7\u7528\u6237\u6709\u6548\u65e5\u671f", username);
            this.logger.error(msg);
            throw new BaseException(ResponseErrorEnums.USER_EXPIRED);
        }
    }
}

