/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.groovy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.groovy.GroovyBinding;
import com.hotent.base.model.ExtendClassCheckEvent;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExtendClassLoader;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class GroovyScriptEngine
implements BeanPostProcessor {
    private Log logger = LogFactory.getLog(this.getClass());
    private static ConcurrentHashMap<String, Class<Script>> zlassMaps = new ConcurrentHashMap();
    private GroovyBinding binding = new GroovyBinding();
    private final String CommonScript = "scriptImpl";
    private List<String> bindingInterface;

    public List<String> getBindingInterface() {
        return this.bindingInterface;
    }

    public void setBindingInterface(List<String> bindingInterface) {
        this.bindingInterface = bindingInterface;
    }

    public void execute(String script) {
        this.executeObject(script, null);
    }

    public void execute(String script, Map<String, Object> vars) {
        this.executeObject(script, vars);
    }

    public boolean executeBoolean(String script, Map<String, Object> vars) {
        return (Boolean)this.executeObject(script, vars);
    }

    public String executeString(String script, Map<String, Object> vars) {
        return BeanUtils.ObjectToString(this.executeObject(script, vars));
    }

    public int executeInt(String script, Map<String, Object> vars) {
        return (Integer)this.executeObject(script, vars);
    }

    public float executeFloat(String script, Map<String, Object> vars) {
        return ((Float)this.executeObject(script, vars)).floatValue();
    }

    public Object executeObject(String script, Map<String, Object> vars) {
        ObjectNode scriptNode;
        DatabaseContext databaseContext = AppUtil.getBean(DatabaseContext.class);
        this.checkScriptIsUseExtendClass(script);
        if (this.isCommonScript(script) && BeanUtils.isNotEmpty(scriptNode = AppUtil.getBean(BpmRuntimeFeignService.class).getByScript(script)) && StringUtil.isNotEmpty(JsonUtil.getString((JsonNode)scriptNode, "dsName"))) {
            return databaseContext.switchDS(JsonUtil.getString((JsonNode)scriptNode, "dsName"), () -> this.executeScript(script, vars), e -> {
                throw new BaseException(e.getMessage());
            });
        }
        return this.executeScript(script, vars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(String script, Map<String, Object> vars) {
        try {
            script = script.replace("&apos;", "'").replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&nuot;", "\n").replace("&amp;", "&");
            String key = this.fingerKey(script);
            Class scriptShell = zlassMaps.get(key);
            if (scriptShell == null) {
                String string = key.intern();
                synchronized (string) {
                    scriptShell = zlassMaps.get(key);
                    if (scriptShell == null) {
                        try (GroovyClassLoader classLoader = new GroovyClassLoader();){
                            scriptShell = classLoader.parseClass(script);
                            zlassMaps.put(key, scriptShell);
                        }
                    }
                }
            }
            this.setParameters(vars);
            Script scriptObj = InvokerHelper.createScript(scriptShell, (Binding)this.binding);
            Object rtn = scriptObj.run();
            return rtn;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u6267\u884c\u811a\u672c" + script + "\u62a5\u9519,\u8bf7\u68c0\u67e5\u811a\u672c");
        }
    }

    private void checkScriptIsUseExtendClass(String script) {
        if (BeanUtils.isEmpty(script) || !script.contains(".")) {
            return;
        }
        Map<String, String> cacheClassMd5Map = ExtendClassLoader.getClassMd5Map();
        if (BeanUtils.isNotEmpty(cacheClassMd5Map)) {
            HashSet<String> usedExtendClass = new HashSet<String>();
            for (Map.Entry<String, String> next : cacheClassMd5Map.entrySet()) {
                char charAt;
                String[] split = script.split(next.getKey() + "\\.");
                if (script.startsWith(next.getKey() + ".")) {
                    usedExtendClass.add(next.getKey());
                    continue;
                }
                if (split.length <= 1 || Character.isDigit(charAt = split[0].charAt(split[0].length() - 1)) || Character.isLetter(charAt)) continue;
                usedExtendClass.add(next.getKey());
            }
            if (BeanUtils.isNotEmpty(usedExtendClass)) {
                ExtendClassCheckEvent event = new ExtendClassCheckEvent(usedExtendClass);
                AppUtil.publishEvent(event);
            }
        }
    }

    private String fingerKey(String scriptText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(scriptText.getBytes(StandardCharsets.UTF_8));
            char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
            StringBuilder ret = new StringBuilder(bytes.length * 2);
            for (byte aByte : bytes) {
                ret.append(HEX_DIGITS[aByte >> 4 & 0xF]);
                ret.append(HEX_DIGITS[aByte & 0xF]);
            }
            return ret.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isCommonScript(String script) {
        return script.contains("scriptImpl");
    }

    private void setParameters(Map<String, Object> vars) {
        if (vars == null) {
            return;
        }
        Set<Map.Entry<String, Object>> set = vars.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            this.binding.setVariable(entry.getKey(), entry.getValue());
        }
    }

    private void setParameters(GroovyShell shell, Map<String, Object> vars) {
        if (vars == null) {
            return;
        }
        Set<Map.Entry<String, Object>> set = vars.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            shell.setVariable(entry.getKey(), entry.getValue());
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ArrayList list = new ArrayList();
        for (String string : this.bindingInterface) {
            try {
                Class<?> clazz = Class.forName(string);
                list.add(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                this.logger.debug((Object)e.getException());
            }
        }
        for (Class clazz : list) {
            boolean isImpl = BeanUtils.isInherit(bean.getClass(), clazz);
            if (!isImpl) continue;
            this.binding.setProperty(beanName, bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

