/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.interceptor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hotent.base.annotation.NewVersion;
import com.hotent.base.controller.BaseController;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice(basePackages={"com.hotent"})
public class ResponseAdvice
implements ResponseBodyAdvice {
    @Autowired
    private ServletRequest servletRequest;
    private static final Logger logger = LoggerFactory.getLogger(ResponseAdvice.class);
    private static final Map<String, String> map = new ConcurrentHashMap<String, String>();
    private static final String key = "newVersion";

    public boolean supports(MethodParameter methodParameter, Class clazz) {
        return true;
    }

    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class clazz, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        Class controllerClass;
        String originURI = (String)this.servletRequest.getAttribute("originURI");
        if (BeanUtils.isEmpty(originURI)) {
            return o;
        }
        this.servletRequest.removeAttribute("originURI");
        if (map.get(key) != null && !map.get(key).equals("true")) {
            return o;
        }
        if (map.get(key) == null && BaseController.class.isAssignableFrom(controllerClass = methodParameter.getDeclaringClass()) && BaseController.class.isAnnotationPresent(NewVersion.class)) {
            NewVersion version = BaseController.class.getAnnotation(NewVersion.class);
            String value = version.open();
            map.put(key, value);
        }
        if (o instanceof CommonResult) {
            CommonResult result = (CommonResult)o;
            if (result.getMessage() == null || result.getMessage().equals("")) {
                result.setMessage(ResponseErrorEnums.SUCCESS_OPTION.getMessage());
            }
            return o;
        }
        if (o instanceof String) {
            ObjectMapper om = new ObjectMapper();
            try {
                return om.writeValueAsString(CommonResult.ok().message(String.valueOf(o)).value(String.valueOf(o)));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                logger.error("\u589e\u5f3a\u8fd4\u56de\u7c7b\u578b\u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            }
        }
        if (BeanUtils.isEmpty(o)) {
            return CommonResult.ok().value(String.valueOf(""));
        }
        return CommonResult.ok().value(o);
    }
}

