/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.manager.impl;

import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.context.BaseContext;
import com.hotent.base.jwt.JwtAuthenticationRequest;
import com.hotent.base.manager.CaptchaManager;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.StringUtil;
import com.wf.captcha.SpecCaptcha;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiter;
import es.moki.ratelimitj.inmemory.request.InMemorySlidingWindowRequestRateLimiter;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CaptchaManagerImpl
implements CaptchaManager {
    private static final int DEFAULT_LEN = 4;
    private static final int DEFAULT_WIDTH = 130;
    private static final int DEFAULT_HEIGHT = 48;
    @Resource
    BaseContext baseContext;
    @Value(value="${captcha.isEnabled:0}")
    private Integer captchaEnabled;
    private RequestRateLimiter limiter;

    @Value(value="${captcha.maxFailedCount:5}")
    void setLimiter(Integer maxFailedCount) {
        if (maxFailedCount < 0) {
            maxFailedCount = 0;
        }
        Set<RequestLimitRule> rules = Collections.singleton(RequestLimitRule.of((Duration)Duration.ofDays(7L), (long)maxFailedCount.intValue()));
        this.limiter = new InMemorySlidingWindowRequestRateLimiter(rules);
    }

    @CachePut(value={"eip:catpcha:code"}, key="#key", ignoreException=false, firstCache=@FirstCache(expireTime=30), secondaryCache=@SecondaryCache(expireTime=30, timeUnit=TimeUnit.MINUTES))
    public String saveCaptchaCode(String key, String code) {
        return code;
    }

    @Cacheable(value={"eip:catpcha:code"}, key="#key")
    protected String getCaptchaCode(String key) {
        return null;
    }

    @CacheEvict(value={"eip:catpcha:code"}, key="#key")
    public void delCaptchaCode(String key) {
    }

    @Override
    public Map<String, String> generateImage() {
        SpecCaptcha captcha = new SpecCaptcha(130, 48, 4);
        String verCode = captcha.text().toLowerCase();
        String key = UUID.randomUUID().toString();
        CaptchaManagerImpl bean = (CaptchaManagerImpl)AppUtil.getBean(this.getClass());
        bean.saveCaptchaCode(key, verCode);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("key", key);
        map.put("image", captcha.toBase64());
        return map;
    }

    @Override
    public boolean addFailedCount(String reqAccount) {
        if (this.captchaEnabled == null || this.captchaEnabled.equals(0)) {
            return false;
        }
        if (this.captchaEnabled.equals(2)) {
            return true;
        }
        return this.limiter.overLimitWhenIncremented(reqAccount);
    }

    @Override
    public boolean verifyCode(JwtAuthenticationRequest authenticationRequest) {
        String reqAccount = authenticationRequest.getUsername();
        if (this.captchaEnabled == null || this.captchaEnabled.equals(0)) {
            this.limiter.resetLimit(reqAccount);
            return true;
        }
        if (this.captchaEnabled.equals(1) && !this.limiter.overLimitWhenIncremented(reqAccount)) {
            this.limiter.overLimitWhenIncremented(reqAccount, -1);
            return true;
        }
        return this.fourceVerifyCode(authenticationRequest);
    }

    @Override
    public boolean fourceVerifyCode(JwtAuthenticationRequest authenticationRequest) {
        String reqAccount = authenticationRequest.getUsername();
        String key = authenticationRequest.getVerificationKey();
        String code = authenticationRequest.getVerificationCode();
        if (StringUtil.isEmpty(code)) {
            return false;
        }
        CaptchaManagerImpl bean = (CaptchaManagerImpl)AppUtil.getBean(this.getClass());
        String currentTenantId = this.baseContext.getCurrentTenantId();
        this.baseContext.setTempTenantId("-1");
        String redisCode = bean.getCaptchaCode(key);
        bean.delCaptchaCode(key);
        this.baseContext.setTempTenantId(currentTenantId);
        boolean result = code.trim().equalsIgnoreCase(redisCode);
        if (result) {
            this.limiter.resetLimit(reqAccount);
        }
        return result;
    }

    @Override
    public void resetLimit(String reqAccount) {
        if (this.captchaEnabled.equals(1) && !this.limiter.overLimitWhenIncremented(reqAccount)) {
            this.limiter.resetLimit(reqAccount);
        }
    }
}

