/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.service.impl;

import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.service.RedisLock;
import com.hotent.base.util.ResubmitLock;
import java.util.function.Supplier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Service;

@Service
public class MemoryLockImpl
implements RedisLock {
    private static final int DELAY_SECONDS = 0;
    private static final Object PRESENT = new Object();

    @Override
    public Object commitRedisLock(String key, ProceedingJoinPoint joinPoint) throws Throwable {
        boolean lock = false;
        try {
            lock = ResubmitLock.getInstance().lock(key, PRESENT);
            if (lock) {
                Object object = joinPoint.proceed();
                return object;
            }
            throw new BaseException(ResponseErrorEnums.REPEATABLE_COMMIT);
        }
        finally {
            ResubmitLock.getInstance().unLock(lock, key, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean methodRedisLock(String key, Supplier<Boolean> supplier) {
        int maxCountSloop = 10;
        for (int i = 0; i < maxCountSloop; ++i) {
            boolean lock = false;
            try {
                lock = ResubmitLock.getInstance().lock(key, PRESENT);
                if (!lock) continue;
                Boolean bl = supplier.get();
                return bl;
            }
            finally {
                ResubmitLock.getInstance().unLock(lock, key, 0);
            }
        }
        return false;
    }

    @Override
    public Object executeWithLock(String key, ProceedingJoinPoint joinPoint, long tryTime, String lockFailMsg) throws Throwable {
        boolean lock = false;
        try {
            lock = ResubmitLock.getInstance().lock(key, PRESENT);
            if (lock) {
                Object object = joinPoint.proceed();
                return object;
            }
            throw new BaseException(lockFailMsg);
        }
        finally {
            ResubmitLock.getInstance().unLock(lock, key, 0);
        }
    }
}

