/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.sqlbuilder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.query.QueryOP;
import com.hotent.base.sqlbuilder.AbstractSqlBuilder;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;

public class PgSqlSqlBuilder
extends AbstractSqlBuilder {
    @Override
    public String analyzeResultField() {
        StringBuffer sql = new StringBuffer();
        ArrayNode resultField = this.sqlBuilderModel.getResultField();
        if (resultField == null || resultField.size() == 0) {
            sql.append("* ");
        } else {
            for (int i = 0; i < resultField.size(); ++i) {
                JsonNode jo = resultField.get(i);
                String field = jo.get("field").asText();
                String aggFuncOp = jo.get("AggFuncOp").asText();
                sql.append(aggFuncOp);
                sql.append("(" + field + ") ");
                String regex = ".*[A-Z]+.*";
                boolean result = field.matches(regex);
                if (result) {
                    field = "\"" + field + "\"";
                }
                if (!StringUtil.isEmpty(field)) {
                    sql.append(" as " + field + " ");
                }
                if (i >= resultField.size() - 1) continue;
                sql.append(",");
            }
        }
        return sql.toString();
    }

    @Override
    public String analyzeConditionField() {
        boolean isOr = false;
        StringBuffer sql = new StringBuffer();
        ArrayNode conditionField = this.sqlBuilderModel.getConditionField();
        if (conditionField == null) {
            return sql.toString();
        }
        for (int i = 0; i < conditionField.size(); ++i) {
            ObjectNode jo = (ObjectNode)conditionField.get(i);
            Object value = jo.get("value");
            if (value == null) continue;
            value = value.asText();
            if (JsonUtil.getString((JsonNode)jo, "isScript").equals("1")) {
                sql.append(value);
                continue;
            }
            String field = jo.get("field").asText();
            String dbType = jo.get("dbType").asText();
            QueryOP op = QueryOP.getByVal(jo.get("op").asText());
            if (QueryOP.IS_NULL.equals((Object)op)) {
                sql.append(" and " + field + " is null ");
                continue;
            }
            if (QueryOP.NOTNULL.equals((Object)op)) {
                sql.append(" and " + field + " is not null ");
                continue;
            }
            if (QueryOP.IN.equals((Object)op)) {
                String v = "";
                String[] vals = value.toString().split(",");
                for (int j = 0; j < vals.length; ++j) {
                    v = v + "'" + vals[j] + "'";
                    if (j == vals.length - 1) continue;
                    v = v + ",";
                }
                sql.append(" and " + field + " " + op.op() + "(" + v + ") ");
                continue;
            }
            if (dbType.equals("varchar") || dbType.equals("clob")) {
                String relation;
                if (QueryOP.EQUAL.equals((Object)op) || QueryOP.NOT_EQUAL.equals((Object)op)) {
                    relation = "and";
                    if (isOr && jo.has("relation")) {
                        relation = jo.get("relation").asText().equals("null") ? "and" : jo.get("relation").asText();
                    } else {
                        isOr = true;
                    }
                    sql.append(" " + relation + " " + field + op.op() + "'" + value.toString() + "' ");
                    continue;
                }
                if (QueryOP.LIKE.equals((Object)op)) {
                    relation = "and";
                    if (isOr && jo.has("relation")) {
                        relation = jo.get("relation").asText().equals("null") ? "and" : jo.get("relation").asText();
                    } else {
                        isOr = true;
                    }
                    sql.append(" " + relation + " " + field + " like '%" + value.toString() + "%' ");
                    continue;
                }
                if (QueryOP.RIGHT_LIKE.equals((Object)op)) {
                    sql.append(" and " + field + " like '" + value.toString() + "%' ");
                    continue;
                }
                if (QueryOP.LEFT_LIKE.equals((Object)op)) {
                    sql.append(" and " + field + " like '%" + value.toString() + "' ");
                    continue;
                }
                if (!QueryOP.EQUAL_IGNORE_CASE.equals((Object)op)) continue;
                sql.append(" and upper(" + field + ") " + op.op() + "'" + value.toString().toUpperCase() + "' ");
                continue;
            }
            if (dbType.equals("int") || dbType.equals("number")) {
                if (QueryOP.BETWEEN.equals((Object)op)) {
                    ObjectNode value1 = (ObjectNode)value;
                    String start = JsonUtil.getString((JsonNode)value1, "start", "");
                    String end = JsonUtil.getString((JsonNode)value1, "end", "");
                    if (StringUtil.isNotEmpty(start)) {
                        sql.append(" and " + field + " >='" + start + "' ");
                    }
                    if (!StringUtil.isNotEmpty(end)) continue;
                    sql.append(" and " + field + " <='" + end + "' ");
                    continue;
                }
                sql.append(" and " + field + op.op() + "'" + value.toString() + "' ");
                continue;
            }
            if (!dbType.equals("date")) continue;
            String format = "";
            if (jo.has("format")) {
                format = jo.get("format").asText();
            }
            this.handleDbTypeEqualDate(sql, field, op, value, format);
        }
        return sql.toString();
    }

    @Override
    public String analyzeSortField() {
        StringBuffer sql = new StringBuffer();
        ArrayNode sortField = this.sqlBuilderModel.getSortField();
        if (sortField == null || sortField.size() == 0) {
            return "";
        }
        sql.append("ORDER BY  ");
        for (int i = 0; i < sortField.size(); ++i) {
            JsonNode jo = sortField.get(i);
            String field = jo.get("field").asText();
            String sortType = jo.get("sortType").asText();
            sql.append(field + " " + sortType);
            if (i >= sortField.size() - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    @Override
    public void handleDbTypeEqualDate(StringBuffer sql, String field, QueryOP op, Object value, String format) {
        if (op == QueryOP.BETWEEN) {
            ObjectNode value1 = (ObjectNode)value;
            String start = JsonUtil.getString((JsonNode)value1, "start", "");
            String end = JsonUtil.getString((JsonNode)value1, "end", "");
            if (StringUtil.isNotEmpty(start)) {
                sql.append(" and " + field + " >= '" + start + "'");
            }
            if (StringUtil.isNotEmpty(end)) {
                sql.append(" and " + field + " <= '" + end + "'");
            }
        } else {
            sql.append(" and " + field + " " + op.op() + " '" + value.toString() + "'");
        }
    }

    @Override
    public String getSql() {
        StringBuffer sql = new StringBuffer("select ");
        sql.append(this.analyzeResultField());
        sql.append("from " + this.sqlBuilderModel.getFromName() + " ");
        sql.append(" where 1=1 ");
        sql.append(this.analyzeConditionField());
        sql.append(this.analyzeSortField());
        return sql.toString();
    }
}

