/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.sqlbuilder.service.impl;

import com.hotent.base.sqlbuilder.AbstractSqlBuilder;
import com.hotent.base.sqlbuilder.ISqlBuilder;
import com.hotent.base.sqlbuilder.KingbaseesSqlBuilder;
import com.hotent.base.sqlbuilder.MySqlSqlBuilder;
import com.hotent.base.sqlbuilder.OracleSqlBuilder;
import com.hotent.base.sqlbuilder.PgSqlSqlBuilder;
import com.hotent.base.sqlbuilder.SqlBuilderModel;
import com.hotent.base.sqlbuilder.SqlServerSqlBuilder;
import com.hotent.base.sqlbuilder.service.ISqlBuilderService;
import org.springframework.stereotype.Service;

@Service(value="sqlBuilderService")
public class SqlBuilderService
implements ISqlBuilderService {
    @Override
    public String getSql(SqlBuilderModel model) {
        ISqlBuilder builder = this.getSqlBuilder(model);
        if (builder != null) {
            return builder.getSql();
        }
        return "";
    }

    @Override
    public ISqlBuilder getSqlBuilder(SqlBuilderModel model) {
        AbstractSqlBuilder builder;
        String dbType;
        switch (dbType = model.getDbType()) {
            case "mysql": {
                builder = new MySqlSqlBuilder();
                break;
            }
            case "oracle": {
                builder = new OracleSqlBuilder();
                break;
            }
            case "postgresql": {
                builder = new PgSqlSqlBuilder();
                break;
            }
            case "kingbasees": {
                builder = new KingbaseesSqlBuilder();
                break;
            }
            default: {
                builder = new SqlServerSqlBuilder();
            }
        }
        builder.setModel(model);
        return builder;
    }
}

