/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.thread;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.task.DelegatingSecurityContextAsyncTaskExecutor;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@EnableAsync
public class AsyncConfiguration {
    public static final String THREAD_NAME = "asyncExecutor";
    @Value(value="${system.thread.core-pool-size:8}")
    private int corePoolSize;
    @Value(value="${system.thread.max-pool-size:8}")
    private int maxPoolSize;
    @Value(value="${system.thread.keep-alive-seconds:60}")
    private int keepAliveSeconds;
    @Value(value="${system.thread.queue-capacity:100}")
    private int queueCapacity;

    @Bean(name={"asyncExecutor"})
    public Executor asyncExecutor(DispatcherServlet dispatcherServlet) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize);
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setKeepAliveSeconds(this.keepAliveSeconds);
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setThreadNamePrefix("AsyncThread-");
        executor.initialize();
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
        dispatcherServlet.setThreadContextInheritable(true);
        return new DelegatingSecurityContextAsyncTaskExecutor((AsyncTaskExecutor)executor);
    }
}

