/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.transaction;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.TransactionThreadLocal;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.apache.ibatis.transaction.Transaction;
import org.springframework.context.ApplicationContext;

class SpringManagedTransactionProxy
implements InvocationHandler {
    private static final String GET_CONNECTION = "getConnection";
    Transaction transaction;

    public SpringManagedTransactionProxy(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals(GET_CONNECTION)) {
            Connection connection = null;
            TransactionThreadLocal transactionThreadLocal = this.getTransactionThreadLocal();
            if (transactionThreadLocal != null) {
                connection = transactionThreadLocal.getCurrentConnection();
            }
            if (connection != null) {
                return connection;
            }
        }
        Object invoke = method.invoke((Object)this.transaction, args);
        return invoke;
    }

    private TransactionThreadLocal getTransactionThreadLocal() {
        ApplicationContext applicaitonContext = AppUtil.getApplicaitonContext();
        if (applicaitonContext != null && applicaitonContext.containsBean("transactionThreadLocal")) {
            return (TransactionThreadLocal)applicaitonContext.getBean(TransactionThreadLocal.class);
        }
        return null;
    }
}

