/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.hotent.base.model.TokenModel;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CustomUtil;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTokenUtil {
    protected static Logger log = LoggerFactory.getLogger(ApiTokenUtil.class);
    private static ConcurrentHashMap<String, TokenModel> modelList = new ConcurrentHashMap();

    public static synchronized String getToken(JsonNode jsonNode, Integer tokenExpire, String sysCode) throws IOException {
        TokenModel model = ApiTokenUtil.getModel(modelList, tokenExpire, sysCode);
        if (!model.isInit()) {
            String token = ApiTokenUtil.requestToken(jsonNode);
            ApiTokenUtil.putModel(token, tokenExpire, sysCode, modelList);
            return token;
        }
        if (model.isExpire(model.getLastUpdTime(), model.getExprieIn())) {
            String token = ApiTokenUtil.requestToken(jsonNode);
            ApiTokenUtil.putModel(token, tokenExpire, sysCode, modelList);
            return token;
        }
        return model.getToken();
    }

    public static String requestToken(JsonNode jsonNode) throws IOException {
        if (jsonNode.get("inputs") == null || jsonNode.get("url") == null) {
            return "";
        }
        Map<String, Object> conditionMap = ApiTokenUtil.buildInputs(jsonNode, "inputs", "key", "type", "value", null);
        String url = jsonNode.get("url").asText();
        String requestType = jsonNode.get("requestType") == null ? "GET" : jsonNode.get("requestType").asText();
        String header = jsonNode.get("header") == null ? "" : jsonNode.get("header").asText();
        String paramKey = jsonNode.get("paramKey") == null ? "" : jsonNode.get("paramKey").asText();
        String response = "";
        if ("GET".equalsIgnoreCase(requestType)) {
            url = ApiTokenUtil.handleGet(url, conditionMap);
            response = FluentUtil.get(url, header);
        } else if ("POST".equalsIgnoreCase(requestType)) {
            response = FluentUtil.post(url, header, conditionMap);
        }
        if (StringUtil.isEmpty(response)) {
            return "";
        }
        JsonNode result = JsonUtil.toJsonNode(response);
        if (paramKey.contains(".")) {
            String[] data;
            for (String item : data = paramKey.split("\\.")) {
                result = result.get(item);
            }
        } else {
            result = result.get(paramKey);
        }
        return result == null ? "" : result.asText();
    }

    public static Map<String, Object> buildInputs(JsonNode jsonNode, String key, String fieldKey, String typeKey, String valueKey, Map<String, Object> params) throws IOException {
        JsonNode tempArrayNode;
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        if (jsonNode.get(key) == null) {
            return conditionMap;
        }
        JsonNode inputNode = jsonNode.get(key);
        ArrayNode inputs = inputNode instanceof ArrayNode ? (ArrayNode)jsonNode.get(key) : (inputNode instanceof TextNode ? ((tempArrayNode = JsonUtil.toJsonNode(inputNode.asText())) instanceof ArrayNode ? (ArrayNode)tempArrayNode : JsonUtil.getMapper().createArrayNode()) : JsonUtil.objectToArray(inputNode));
        for (int i = 0; i < inputs.size(); ++i) {
            String field;
            ObjectNode inputParam = (ObjectNode)JsonUtil.toJsonNode(inputs.get(i));
            if (inputParam == null || inputParam.get(fieldKey) == null || StringUtil.isEmpty(field = inputParam.get(fieldKey).asText())) continue;
            String defaultType = JsonUtil.getString((JsonNode)inputParam, typeKey, "2");
            String defaultValue = JsonUtil.getString((JsonNode)inputParam, valueKey);
            String condition = JsonUtil.getString((JsonNode)inputParam, "condition");
            Object value = null;
            value = CustomUtil.buildValue(field, defaultType, defaultValue, params);
            if (BeanUtils.isEmpty(value) || value instanceof String && (StringUtil.isEmpty(value.toString()) || value.toString().equals("|"))) continue;
            if (condition.equals(QueryOP.BETWEEN.toString())) {
                value = CustomUtil.handleDateBetweenValue(value);
            }
            conditionMap.put(field, value.toString());
        }
        return conditionMap;
    }

    public static boolean clearToken() {
        String tenantId = TenantUtil.getCurrentTenantId();
        if (StringUtil.isEmpty(tenantId)) {
            tenantId = "-1";
        }
        try {
            modelList.put(tenantId, new TokenModel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
            return false;
        }
        return true;
    }

    private static void putModel(String token, int tokenExpire, String sysCode, ConcurrentHashMap<String, TokenModel> modelList) {
        String tenantId = TenantUtil.getCurrentTenantId();
        if (StringUtil.isEmpty(tenantId)) {
            tenantId = "-1";
        }
        TokenModel model = new TokenModel();
        if (StringUtil.isNotEmpty(token)) {
            model.setCorpToken(token, tokenExpire);
        } else {
            model.setInit(false);
        }
        String key = sysCode + tenantId;
        modelList.put(key, model);
    }

    private static TokenModel getModel(ConcurrentHashMap<String, TokenModel> modelList, int tokenExpire, String sysCode) {
        String key;
        String tenantId = TenantUtil.getCurrentTenantId();
        if (StringUtil.isEmpty(tenantId)) {
            tenantId = "-1";
        }
        return modelList.containsKey(key = sysCode + tenantId) ? modelList.get(key) : new TokenModel(tokenExpire);
    }

    public static String handleGet(String url, Map<String, Object> params) {
        Iterator<Map.Entry<String, Object>> entries = params.entrySet().iterator();
        StringBuilder urlBuilder = new StringBuilder(url);
        while (entries.hasNext()) {
            Map.Entry<String, Object> entry = entries.next();
            String key = entry.getKey();
            String value = entry.getValue().toString();
            String map = key + "=" + value;
            if (urlBuilder.toString().contains("?")) {
                urlBuilder.append("&").append(map);
                continue;
            }
            urlBuilder.append("?").append(map);
        }
        url = urlBuilder.toString();
        return url;
    }
}

