/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.hotent.base.model.Tree;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.time.TimeUtil;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ReflectionUtils;

public class BeanUtils {
    private static Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    public static ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    private static BeanUtilsBean beanUtilsBean = new BeanUtilsBean(convertUtilsBean, new PropertyUtilsBean());

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            if (((String)o).trim().length() == 0) {
                return true;
            }
        } else if (o instanceof Collection) {
            if (((Collection)o).size() == 0) {
                return true;
            }
        } else if (o instanceof byte[]) {
            if (((byte[])o).length == 0) {
                return true;
            }
        } else {
            if (o.getClass().isArray()) {
                if (o instanceof byte[]) {
                    return ((byte[])o).length == 0;
                }
                if (o instanceof int[]) {
                    return ((int[])o).length == 0;
                }
                if (o instanceof short[]) {
                    return ((short[])o).length == 0;
                }
                if (o instanceof long[]) {
                    return ((long[])o).length == 0;
                }
                if (o instanceof double[]) {
                    return ((double[])o).length == 0;
                }
                if (o instanceof float[]) {
                    return ((float[])o).length == 0;
                }
                if (o instanceof boolean[]) {
                    return ((boolean[])o).length == 0;
                }
                if (o instanceof char[]) {
                    return ((char[])o).length == 0;
                }
                return ((Object[])o).length == 0;
            }
            if (o instanceof Map) {
                if (((Map)o).size() == 0) {
                    return true;
                }
            } else {
                if (o instanceof ArrayNode) {
                    ArrayNode an = (ArrayNode)o;
                    return an.isEmpty(null);
                }
                if (o instanceof Serializable) {
                    return ((Serializable)o).toString().trim().length() == 0;
                }
            }
        }
        return false;
    }

    public static boolean isNotEmpty(Object o) {
        return !BeanUtils.isEmpty(o);
    }

    public static boolean isNumber(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            try {
                Double.parseDouble((String)o);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean validClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isInherit(Class cls, Class parentClass) {
        return parentClass.isAssignableFrom(cls);
    }

    public static List<String> scanPackages(String basePackages) throws IllegalArgumentException {
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)rl);
        ArrayList<String> result = new ArrayList<String>();
        String[] arrayPackages = basePackages.split(",");
        try {
            for (int j = 0; j < arrayPackages.length; ++j) {
                String packageToScan = arrayPackages[j];
                String packagePart = packageToScan.replace('.', '/');
                String classPattern = "classpath*:/" + packagePart + "/**/*.class";
                Resource[] resources = rl.getResources(classPattern);
                for (int i = 0; i < resources.length; ++i) {
                    Resource resource = resources[i];
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    String className = metadataReader.getClassMetadata().getClassName();
                    result.add(className);
                }
            }
        }
        catch (Exception e) {
            new IllegalArgumentException("scan pakcage class error,pakcages:" + basePackages);
        }
        return result;
    }

    public static Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = BeanUtils.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static Object convertByActType(String typeName, String value) {
        Object o = null;
        o = typeName.equals("int") ? Integer.valueOf(Integer.parseInt(value)) : (typeName.equals("short") ? Short.valueOf(Short.parseShort(value)) : (typeName.equals("long") ? Long.valueOf(Long.parseLong(value)) : (typeName.equals("float") ? Float.valueOf(Float.parseFloat(value)) : (typeName.equals("double") ? Double.valueOf(Double.parseDouble(value)) : (typeName.equals("boolean") ? Boolean.valueOf(Boolean.parseBoolean(value)) : (typeName.equals("java.lang.String") ? value : value))))));
        return o;
    }

    public static Class<?> getParameterTypes(String type) {
        Class claz = null;
        try {
            claz = type.equalsIgnoreCase("string") ? String.class : (type.equalsIgnoreCase("int") ? Integer.class : (type.equalsIgnoreCase("float") ? Float.class : (type.equalsIgnoreCase("double") ? Double.class : (type.equalsIgnoreCase("byte") ? Byte.class : (type.equalsIgnoreCase("short") ? Short.class : (type.equalsIgnoreCase("long") ? Long.class : (type.equalsIgnoreCase("boolean") ? Boolean.class : (type.equalsIgnoreCase("date") ? Date.class : String.class))))))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return claz;
    }

    public static Field getField(Class<?> thisClass, String fieldName) throws NoSuchFieldException {
        if (fieldName == null) {
            throw new NoSuchFieldException("Error field !");
        }
        Field field = thisClass.getDeclaredField(fieldName);
        return field;
    }

    public static void mergeObject(Object srcObj, Object desObj) {
        if (srcObj == null || desObj == null) {
            return;
        }
        Field[] fs1 = srcObj.getClass().getDeclaredFields();
        Field[] fs2 = desObj.getClass().getDeclaredFields();
        for (int i = 0; i < fs1.length; ++i) {
            try {
                fs1[i].setAccessible(true);
                Object value = fs1[i].get(srcObj);
                fs1[i].setAccessible(false);
                if (null == value) continue;
                fs2[i].setAccessible(true);
                fs2[i].set(desObj, value);
                fs2[i].setAccessible(false);
                continue;
            }
            catch (Exception e) {
                logger.error("mergeObject" + e.getMessage());
            }
        }
    }

    public static void removeDuplicate(List list) {
        HashSet h = new HashSet(list);
        list.clear();
        list.addAll(h);
    }

    public static <T> List<T> listToTree(List<T> list) {
        LinkedHashMap<String, Tree> tempMap = new LinkedHashMap<String, Tree>();
        if (BeanUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        if (!(list.get(0) instanceof Tree)) {
            throw new RuntimeException("\u6811\u5f62\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\u3002\u6570\u636e\u5fc5\u987b\u5b9e\u73b0Tree\u63a5\u53e3\uff01");
        }
        ArrayList<Tree> returnList = new ArrayList<Tree>();
        for (Tree tree : list) {
            tree.setIsParent("false");
            tempMap.put(tree.getId(), tree);
        }
        for (Tree obj : list) {
            String parentId;
            if (BeanUtils.isNotEmpty(obj.getChildren()) && obj.getChildren().size() <= 0) {
                obj.setChildren(null);
            }
            if (tempMap.containsKey(parentId = obj.getParentId()) && !obj.getId().equals(parentId)) {
                if (((Tree)tempMap.get(parentId)).getChildren() == null) {
                    ((Tree)tempMap.get(parentId)).setChildren(new ArrayList<Tree>());
                }
                ((Tree)tempMap.get(parentId)).getChildren().add(obj);
                ((Tree)tempMap.get(parentId)).setIsParent("true");
                continue;
            }
            returnList.add(obj);
        }
        return returnList;
    }

    public static <T> List<T> treeToList(List<T> list) {
        if (BeanUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        if (!(list.get(0) instanceof Tree)) {
            throw new RuntimeException("\u6811\u5f62\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\u3002\u6570\u636e\u5fc5\u987b\u5b9e\u73b0Tree\u63a5\u53e3\uff01");
        }
        ArrayList<Tree> returnList = new ArrayList<Tree>();
        for (Tree tree : list) {
            BeanUtils.recursionTreeChildren(tree, returnList);
            tree.setChildren(null);
            returnList.add(tree);
        }
        return returnList;
    }

    private static <T> void recursionTreeChildren(Tree tree, List<T> result) {
        if (BeanUtils.isEmpty(tree) || BeanUtils.isEmpty(tree.getChildren())) {
            return;
        }
        for (Tree child : tree.getChildren()) {
            if (BeanUtils.isNotEmpty(child.getChildren())) {
                BeanUtils.recursionTreeChildren(child, result);
                child.setChildren(null);
            }
            result.add(child);
        }
    }

    public static <T> void listByPid(List<T> list, String pid, List<T> result) {
        for (Tree t : list) {
            if (!BeanUtils.isNotEmpty(t) || !pid.equals(t.getParentId())) continue;
            BeanUtils.listByPid(list, t.getId(), result);
            result.add(t);
        }
    }

    public static void copyNotNullProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            logger.error("No destination bean specified");
            return;
        }
        if (orig == null) {
            logger.error("No origin bean specified");
            return;
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!beanUtilsBean.getPropertyUtils().isReadable(orig, name) || !beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                Object value = ((DynaBean)orig).get(name);
                beanUtilsBean.copyProperty(dest, name, value);
            }
        } else if (orig instanceof Map) {
            for (Map.Entry entry : ((Map)orig).entrySet()) {
                String name = (String)entry.getKey();
                if (!beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                beanUtilsBean.copyProperty(dest, name, entry.getValue());
            }
        } else {
            PropertyDescriptor[] origDescriptors = beanUtilsBean.getPropertyUtils().getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !beanUtilsBean.getPropertyUtils().isReadable(orig, name) || !beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                try {
                    Object value = beanUtilsBean.getPropertyUtils().getSimpleProperty(orig, name);
                    if (value == null) continue;
                    beanUtilsBean.copyProperty(dest, name, value);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Object cloneBean(Object bean) throws Exception {
        return beanUtilsBean.cloneBean(bean);
    }

    public static void setProperty(Object bean, String name, Object value) {
        try {
            beanUtilsBean.setProperty(bean, name, value);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }

    private static void handleReflectionException(Exception e) {
        ReflectionUtils.handleReflectionException((Exception)e);
    }

    public static boolean isEquals(Object newVal, Object oldVal) {
        if (newVal == oldVal || BeanUtils.isEmpty(newVal) && BeanUtils.isEmpty(oldVal)) {
            return true;
        }
        if (BeanUtils.isEmpty(newVal) && BeanUtils.isNotEmpty(oldVal) || BeanUtils.isNotEmpty(newVal) && BeanUtils.isEmpty(oldVal)) {
            return false;
        }
        return BeanUtils.ObjectToString(newVal).equals(BeanUtils.ObjectToString(oldVal));
    }

    public static String ObjectToString(Object val) {
        if (BeanUtils.isEmpty(val)) {
            return "";
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (BeanUtils.isNumber(val)) {
            DecimalFormat decimalFormat = new DecimalFormat("###################.###########");
            return decimalFormat.format(val);
        }
        if (val instanceof LocalDateTime) {
            return TimeUtil.getDateTimeString((LocalDateTime)val);
        }
        if (val instanceof LocalDate) {
            LocalDate date = (LocalDate)val;
            return TimeUtil.getDateString(date.atTime(0, 0, 0));
        }
        if (val instanceof Timestamp) {
            Timestamp time = (Timestamp)val;
            return TimeUtil.getDateTimeString(time.toLocalDateTime());
        }
        if (val instanceof TextNode) {
            return ((TextNode)val).asText();
        }
        try {
            return JsonUtil.toJson(val);
        }
        catch (IOException e) {
            e.printStackTrace();
            return val.toString();
        }
    }

    public static <T> void compareListChange(List<T> list, Map<String, T> map, Function<T, String> keySupplier, Consumer<T> createConsumer, BiConsumer<T, T> updateConsumer, Consumer<T> deleteConsumer) {
        for (T t : list) {
            if (!map.containsKey(keySupplier.apply(t))) {
                createConsumer.accept(t);
                continue;
            }
            T old = map.get(keySupplier.apply(t));
            updateConsumer.accept(old, t);
            map.remove(keySupplier.apply(t));
        }
        map.forEach((key, value) -> deleteConsumer.accept(value));
    }

    static {
        convertUtilsBean.register((Converter)new DateConverter(), Date.class);
        convertUtilsBean.register((Converter)new LongConverter(null), Long.class);
    }
}

