/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class Dom4jUtil {
    private static final Log logger = LogFactory.getLog(Dom4jUtil.class);

    public static Document loadXml(String s) {
        Document document;
        block5: {
            document = null;
            try {
                document = DocumentHelper.parseText((String)s);
            }
            catch (Exception ex) {
                try {
                    while (s.contains("<![CDATA[<![CDATA[")) {
                        s = s.replaceAll("\\<\\!\\[CDATA\\[\\<\\!\\[CDATA\\[", "\\<\\!\\[CDATA\\[");
                        s = s.replaceAll("\\]\\]\\>\\]\\]\\>", "\\]\\]\\>");
                    }
                    document = DocumentHelper.parseText((String)s);
                }
                catch (Exception ex2) {
                    throw new RuntimeException(ex2.getMessage(), ex2.getCause());
                }
                if (document != null) break block5;
                throw new RuntimeException(ex.getMessage(), ex.getCause());
            }
        }
        return document;
    }

    public static Document load(String filename, String encode) {
        Document document = null;
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEncoding(encode);
            document = saxReader.read(new File(filename));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static Document loadXml(String xml, String encode) throws UnsupportedEncodingException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(encode));
        return Dom4jUtil.loadXml(inputStream, encode);
    }

    public static Document loadXml(InputStream is) {
        return Dom4jUtil.loadXml(is, "utf-8");
    }

    public static Document loadXml(InputStream is, String charset) {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding(charset);
            document = reader.read(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return document;
    }

    public static void write(Document document, String fileName) throws IOException {
        String xml = document.asXML();
        FileUtil.writeFile(fileName, xml);
    }

    public static void write(String str, String fileName) throws IOException, DocumentException {
        Document document = DocumentHelper.parseText((String)str);
        Dom4jUtil.write(document, fileName);
    }

    public Document load(URL url) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(url);
        return document;
    }

    public static Document load(String filename) {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            document = reader.read(new File(filename));
            document.normalize();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return document;
    }

    public static Document loadByClassPath(String filePath) throws IOException, DocumentException {
        return Dom4jUtil.loadByClassPath(filePath, "utf-8", null);
    }

    public static Document loadByClassPath(String filePath, String charset) throws IOException, DocumentException {
        return Dom4jUtil.loadByClassPath(filePath, charset, null);
    }

    /*
     * Exception decompiling
     */
    public static Document loadByClassPath(String filePath, String charset, ClassLoader classLoader) throws IOException, DocumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String transFormXsl(String xml, String xsl, Map<String, String> map) throws Exception {
        StringReader xmlReader = new StringReader(xml);
        StringReader xslReader = new StringReader(xsl);
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(xslReader));
        if (map != null) {
            for (Map.Entry<String, String> obj : map.entrySet()) {
                transformer.setParameter(obj.getKey(), obj.getValue());
            }
        }
        StreamSource xmlSource = new StreamSource(xmlReader);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(xmlSource, result);
        return writer.toString();
    }

    public static String transXmlByXslt(String xml, String xslPath, Map<String, String> map) throws Exception {
        Document document = Dom4jUtil.loadXml(xml);
        document.setXMLEncoding("UTF-8");
        Document result = Dom4jUtil.styleDocument(document, xslPath, map);
        return Dom4jUtil.docToString(result);
    }

    public static String transXmlByXslt(String xml, InputStream styleStream, Map<String, String> map) throws Exception {
        Document document = Dom4jUtil.loadXml(xml);
        document.setXMLEncoding("UTF-8");
        Document result = Dom4jUtil.styleDocument(document, styleStream, map);
        return Dom4jUtil.docToString(result);
    }

    public static String transFileXmlByXslt(String xmlPath, String xslPath, Map<String, String> map) throws Exception {
        Document document = Dom4jUtil.load(xmlPath);
        Objects.requireNonNull(document);
        document.setXMLEncoding("UTF-8");
        Document result = Dom4jUtil.styleDocument(document, xslPath, map);
        return Dom4jUtil.docToString(result);
    }

    public static String docToString(Document document) {
        String s = "";
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputFormat format = new OutputFormat("  ", true, "UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(document);
            s = out.toString("UTF-8");
        }
        catch (Exception ex) {
            logger.error((Object)("docToString error:" + ex.getMessage()));
        }
        return s;
    }

    public static String docToPrettyString(Document document) {
        String s = "";
        try {
            StringWriter writer = new StringWriter();
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setSuppressDeclaration(true);
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            xmlWriter.write(document);
            s = ((Object)writer).toString();
        }
        catch (Exception ex) {
            logger.error((Object)("docToString error:" + ex.getMessage()));
        }
        return s;
    }

    public static Document styleDocument(Document document, String stylesheet, Map<String, String> map) throws Exception {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(stylesheet));
        if (map != null) {
            for (Map.Entry<String, String> obj : map.entrySet()) {
                transformer.setParameter(obj.getKey(), obj.getValue());
            }
        }
        DocumentSource source = new DocumentSource(document);
        DocumentResult result = new DocumentResult();
        transformer.transform((Source)source, (Result)result);
        Document transformedDoc = result.getDocument();
        return transformedDoc;
    }

    public static Document styleDocument(Document document, InputStream stylesheetStream, Map<String, String> map) throws Exception {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(stylesheetStream));
        if (map != null) {
            for (Map.Entry<String, String> obj : map.entrySet()) {
                transformer.setParameter(obj.getKey(), obj.getValue());
            }
        }
        DocumentSource source = new DocumentSource(document);
        DocumentResult result = new DocumentResult();
        transformer.transform((Source)source, (Result)result);
        Document transformedDoc = result.getDocument();
        return transformedDoc;
    }

    public static boolean validateXMLSchema(String xml, File ... xsdFiles) {
        return Dom4jUtil.validateXMLSchema(new ByteArrayInputStream(xml.getBytes()), xsdFiles);
    }

    public static boolean validateXMLSchema(InputStream xmlIs, File ... xsdFiles) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ArrayList<StreamSource> sourceList = new ArrayList<StreamSource>();
            for (File file : xsdFiles) {
                sourceList.add(new StreamSource(file));
            }
            Source[] sources = sourceList.toArray(new Source[0]);
            Schema schema = factory.newSchema(sources);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xmlIs));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getString(Element element, String attrName) {
        return Dom4jUtil.getString(element, attrName, false);
    }

    public static String getString(Element element, String attrName, Boolean fuzzy) {
        if (element == null) {
            return null;
        }
        String val = element.attributeValue(attrName);
        if (StringUtils.isEmpty((String)val)) {
            return null;
        }
        if (fuzzy.booleanValue()) {
            val = "%" + val + "%";
        }
        return val;
    }
}

