/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.mybatis.spring.SqlSessionTemplate;

public class FieldConvertUtil {
    private static Map<String, Map<String, String>> entityFieldMap = new HashMap<String, Map<String, String>>();

    public static Map<String, String> getTableFieldMapping(Class clazz) {
        if (entityFieldMap.containsKey(clazz.getName())) {
            return entityFieldMap.get(clazz.getName());
        }
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Class superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            allFields.addAll(Arrays.asList(superclass.getDeclaredFields()));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty(allFields)) {
            allFields.forEach(f -> {
                TableField tableField = f.getAnnotation(TableField.class);
                if (tableField != null) {
                    if (tableField.exist()) {
                        map.put(f.getName(), tableField.value());
                    }
                } else {
                    TableId tableId = f.getAnnotation(TableId.class);
                    if (tableId != null) {
                        map.put(f.getName(), tableId.value());
                    }
                }
            });
        }
        map.putAll(FieldConvertUtil.getTableFieldByResultMap(clazz));
        entityFieldMap.put(clazz.getName(), map);
        return map;
    }

    private static Map<String, String> getTableFieldByResultMap(Class clazz) {
        SqlSessionTemplate sqlSessionTemplate = AppUtil.getBean(SqlSessionTemplate.class);
        Configuration configuration = sqlSessionTemplate.getConfiguration();
        Collection resultMapNames = configuration.getResultMapNames();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : resultMapNames) {
            ResultMap resultMap;
            Class type;
            if (name.indexOf(".") == -1 || !(type = (resultMap = configuration.getResultMap(name)).getType()).equals(clazz)) continue;
            for (ResultMapping resultMappirng : resultMap.getPropertyResultMappings()) {
                map.put(resultMappirng.getProperty(), resultMappirng.getColumn());
            }
        }
        return map;
    }

    public static String property2Field(String property, Class clazz) {
        Map<String, String> tableFieldMapping = FieldConvertUtil.getTableFieldMapping(clazz);
        if (BeanUtils.isNotEmpty(tableFieldMapping) && tableFieldMapping.containsKey(property)) {
            return tableFieldMapping.get(property);
        }
        return property;
    }

    public static String field2Property(String field, Class clazz) {
        Map<String, String> tableFieldMapping = FieldConvertUtil.getTableFieldMapping(clazz);
        if (BeanUtils.isNotEmpty(tableFieldMapping)) {
            for (Map.Entry<String, String> next : tableFieldMapping.entrySet()) {
                if (!field.equalsIgnoreCase(next.getValue())) continue;
                return next.getKey();
            }
        }
        return field;
    }
}

