/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.FilterJsonStruct;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.SqlDateFormatUtil;
import com.hotent.base.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class FilterJsonStructUtil {
    public static String CONDITION_AND = " and ";

    public static String getSql(String filterJson, String dbType) throws JsonParseException, JsonMappingException, IOException {
        if (StringUtil.isEmpty(filterJson)) {
            return "";
        }
        ArrayList<Map<String, Object>> operatorList = new ArrayList<Map<String, Object>>();
        List<FilterJsonStruct> filters = JsonUtil.toBean(filterJson, new TypeReference<List<FilterJsonStruct>>(){});
        FilterJsonStructUtil.getFilterResult(filters, operatorList, dbType);
        return FilterJsonStructUtil.executeOperator(operatorList);
    }

    private static void getFilterResult(List<FilterJsonStruct> filters, List<Map<String, Object>> operatorList, String dbType) {
        for (FilterJsonStruct filter : filters) {
            if (filter.getBranch().booleanValue()) {
                ArrayList<Map<String, Object>> branchResultList = new ArrayList<Map<String, Object>>();
                FilterJsonStructUtil.getFilterResult(filter.getSub(), branchResultList, dbType);
                String branchResult = FilterJsonStructUtil.executeOperator(branchResultList);
                Map<String, Object> resultMap = FilterJsonStructUtil.getResultMap(filter.getCompType(), branchResult);
                operatorList.add(resultMap);
                continue;
            }
            FilterJsonStructUtil.getNormalFilterResult(filter, operatorList, dbType);
        }
    }

    private static String executeOperator(List<Map<String, Object>> operatorList) {
        if (operatorList.size() == 0) {
            return "";
        }
        String returnVal = (String)operatorList.get(0).get("result");
        if (operatorList.size() == 1) {
            return returnVal;
        }
        int size = operatorList.size();
        for (int k = 1; k < size; ++k) {
            Map<String, Object> resultMap = operatorList.get(k);
            String operator = resultMap.get("operator").toString();
            if ("".equals(operator)) {
                operator = operatorList.get(k - 1).get("operator").toString();
            }
            if ("or".equals(operator)) {
                returnVal = "(" + returnVal + ") OR (" + resultMap.get("result") + ")";
                continue;
            }
            if (!"and".equals(operator)) continue;
            returnVal = "(" + returnVal + ") AND (" + resultMap.get("result") + ")";
        }
        if (StringUtils.isNotEmpty((String)returnVal)) {
            returnVal = "(" + returnVal + ")";
        }
        return returnVal;
    }

    private static Map<String, Object> getResultMap(String operator, String result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("operator", operator);
        resultMap.put("result", result);
        return resultMap;
    }

    private static void getNormalFilterResult(FilterJsonStruct filter, List<Map<String, Object>> operatorList, String dbType) {
        String flowvarKey = filter.getFlowvarKey();
        String judgeVal1 = FilterJsonStructUtil.getJudgeVal(filter, true);
        String judgeVal2 = FilterJsonStructUtil.getJudgeVal(filter, false);
        int optType = filter.getOptType();
        String script = "";
        switch (optType) {
            case 1: {
                if (StringUtils.isNotEmpty((String)judgeVal1) || "11".equals(filter.getJudgeCon1()) || "12".equals(filter.getJudgeCon1())) {
                    script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, judgeVal1, filter.getOptType(), dbType);
                }
                if (!StringUtils.isNotEmpty((String)judgeVal2)) break;
                String moreScript = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon2(), flowvarKey, judgeVal2, filter.getOptType(), dbType);
                if (StringUtils.isNotEmpty((String)script)) {
                    script = script + CONDITION_AND;
                }
                script = script + moreScript;
                break;
            }
            case 2: {
                if (!StringUtils.isNotEmpty((String)judgeVal1) && !"11".equals(filter.getJudgeCon1()) && !"12".equals(filter.getJudgeCon1())) break;
                script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, judgeVal1, filter.getOptType(), dbType);
                break;
            }
            case 3: {
                if (StringUtils.isNotEmpty((String)judgeVal1) || "11".equals(filter.getJudgeCon1()) || "12".equals(filter.getJudgeCon1())) {
                    String val1 = SqlDateFormatUtil.convertDateFormat(filter.getDatefmt(), judgeVal1, dbType);
                    script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, val1, filter.getOptType(), dbType);
                }
                if (!StringUtils.isNotEmpty((String)judgeVal2)) break;
                String val2 = SqlDateFormatUtil.convertDateFormat(filter.getDatefmt(), judgeVal1, dbType);
                String moreScript = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon2(), flowvarKey, val2, filter.getOptType(), dbType);
                if (StringUtils.isNotEmpty((String)script)) {
                    script = script + CONDITION_AND;
                }
                script = script + moreScript;
                break;
            }
            case 4: {
                String[] vals;
                for (String val : vals = judgeVal1.split("&&")) {
                    if (StringUtils.isNotEmpty((String)script)) {
                        script = script + CONDITION_AND;
                    }
                    script = script + FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, val, filter.getOptType(), dbType);
                }
                break;
            }
            case 5: {
                String judgeCon = filter.getJudgeCon1();
                String[] ids = judgeVal1.split("&&");
                if (ids.length == 2) {
                    script = FilterJsonStructUtil.getCompareScript(judgeCon, filter.getFlowvarKey(), ids[0], filter.getOptType(), dbType);
                    break;
                }
                if (!"3".equalsIgnoreCase(judgeCon) && !"4".equalsIgnoreCase(judgeCon)) break;
                script = FilterJsonStructUtil.getCompareScript(judgeCon, filter.getFlowvarKey(), judgeVal1, filter.getOptType(), dbType);
            }
        }
        if (StringUtil.isEmpty(script)) {
            return;
        }
        Map<String, Object> resultMap = FilterJsonStructUtil.getResultMap(filter.getCompType(), script);
        operatorList.add(resultMap);
    }

    private static String getJudgeVal(FilterJsonStruct filter, boolean isJudgeVal1) {
        String val = isJudgeVal1 ? filter.getJudgeVal1() : filter.getJudgeVal2();
        int ruleType = filter.getRuleType();
        if (ruleType == 1) {
            return val;
        }
        GroovyScriptEngine groovyScriptEngine = AppUtil.getBean(GroovyScriptEngine.class);
        String object = groovyScriptEngine.executeString(val, null);
        return object.toString();
    }

    private static String getCompareScript(String judgeCon, String fieldName, String judgeVal, int type, String dbType) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> varMap = new HashMap<String, String>();
        if (!AuthenticationUtil.getUserThreadLocal().has("id")) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            try {
                JsonNode principal = JsonUtil.toJsonNode(authentication.getPrincipal());
                varMap.put("'[curUserId]'", principal.get("id").asText());
                varMap.put("'[curUserAccount]'", principal.get("account").asText());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        } else {
            varMap.put("'[curUserId]'", AuthenticationUtil.getCurrentUserId());
            varMap.put("'[curUserAccount]'", AuthenticationUtil.getCurrentUsername());
        }
        switch (type) {
            case 1: 
            case 3: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append("=").append(judgeVal);
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append("!=").append(judgeVal);
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append(fieldName).append(">").append(judgeVal);
                    break;
                }
                if ("4".equals(judgeCon)) {
                    sb.append(fieldName).append(">=").append(judgeVal);
                    break;
                }
                if ("5".equals(judgeCon)) {
                    sb.append(fieldName).append("<").append(judgeVal);
                    break;
                }
                if ("6".equals(judgeCon)) {
                    sb.append(fieldName).append("<=").append(judgeVal);
                    break;
                }
                if ("7".equals(judgeCon)) {
                    sb.append(fieldName).append(" = :").append("").append(judgeVal).append("");
                    break;
                }
                if ("8".equals(judgeCon)) {
                    sb.append(fieldName).append(" != :").append("").append(judgeVal).append("");
                    break;
                }
                if ("9".equals(judgeCon)) {
                    if (judgeVal == null) {
                        sb.append(fieldName).append(" != ").append(judgeVal).append("");
                        break;
                    }
                    sb.append(" (").append(fieldName).append(" != ").append(judgeVal).append(" or ").append(fieldName).append(" IS NULL ").append(") ");
                    break;
                }
                if ("11".equals(judgeCon)) {
                    sb.append(fieldName).append(" IS NULL");
                    break;
                }
                if (!"12".equals(judgeCon)) break;
                sb.append(fieldName).append(" IS NOT NULL");
                break;
            }
            case 2: 
            case 4: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append("=").append("'").append(judgeVal).append("'");
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append("!=").append("'").append(judgeVal).append("'");
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append("UPPER(").append(fieldName).append(")=").append(" UPPER('").append(judgeVal).append("')");
                    break;
                }
                if ("4".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '%").append(judgeVal).append("%'");
                    break;
                }
                if ("5".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '").append(judgeVal).append("%'");
                    break;
                }
                if ("6".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '%").append(judgeVal).append("'");
                    break;
                }
                if ("7".equals(judgeCon)) {
                    sb.append(fieldName).append(" = '").append(varMap.get(judgeVal)).append("'");
                    break;
                }
                if ("8".equals(judgeCon)) {
                    sb.append(fieldName).append(" != '").append(varMap.get(judgeVal)).append("'");
                    break;
                }
                if ("9".equals(judgeCon)) {
                    sb.append(fieldName).append(" != '").append(judgeVal).append("'");
                    break;
                }
                if ("10".equals(judgeCon)) {
                    sb.append("UPPER(").append(fieldName).append(") != ").append("UPPER('").append(judgeVal).append("')");
                    if (judgeVal == null) break;
                    sb.append(" or ").append(fieldName).append(" is null ");
                    break;
                }
                if ("11".equals(judgeCon)) {
                    sb.append(fieldName).append(" IS NULL OR ").append(fieldName).append(" = ''");
                    break;
                }
                if (!"12".equals(judgeCon)) break;
                sb.append(fieldName).append(" IS NOT NULL AND ").append(fieldName).append(" != ''");
                break;
            }
            case 5: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append(" in (").append("").append(judgeVal).append(")");
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append(" not in (").append("").append(judgeVal).append(")");
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append(fieldName).append(" = :").append("").append(judgeVal).append("");
                    break;
                }
                if (!"4".equals(judgeCon)) break;
                sb.append(fieldName).append(" != :").append("").append(judgeVal).append("");
                break;
            }
        }
        return sb.toString();
    }
}

