/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SQLUtil {
    public static String getDbTypeByUrl(String url) {
        return JdbcUtils.getDbType((String)url).getDb();
    }

    public static String getDbType() {
        return SQLUtil.getDbTypeObj().getDb();
    }

    public static DbType getDbTypeObj() {
        DatabaseContext databaseContext = AppUtil.getBean(DatabaseContext.class);
        return databaseContext.getDbTypeObj();
    }

    public static boolean containsSqlInjection(String sql) {
        if (StringUtil.isEmpty(sql)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\b(insert|drop|grant|alter|delete|update|truncate|show)\\b");
        Matcher matcher = pattern.matcher(sql.toLowerCase());
        return matcher.find();
    }

    public static boolean containsSqlUnion(String sql) {
        if (StringUtil.isEmpty(sql)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\b(union)\\b");
        Matcher matcher = pattern.matcher(sql.toLowerCase());
        return matcher.find();
    }

    public static String ClobToString(Clob clob) throws SQLException, IOException {
        String ret = "";
        Reader read = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(read);
        String s = br.readLine();
        StringBuffer sb = new StringBuffer();
        while (s != null) {
            sb.append(s);
            s = br.readLine();
        }
        ret = sb.toString();
        if (br != null) {
            br.close();
        }
        if (read != null) {
            read.close();
        }
        return ret;
    }

    public static void StringToTimestamp(QueryFilter queryFilter) {
        List<QueryField> querys = queryFilter.getQuerys();
        for (QueryField query : querys) {
            if (!query.getOperation().equals((Object)QueryOP.BETWEEN) || !List.class.isInstance(query.getValue())) continue;
            ArrayList<Timestamp> objects = new ArrayList<Timestamp>();
            for (String v : (List)query.getValue()) {
                objects.add(Timestamp.valueOf(v));
            }
            query.setValue(objects);
        }
    }

    public static String escapeDataBaseByEqual(String str) {
        if (str == null) {
            return null;
        }
        str = StringUtils.replace((String)str, (String)"'", (String)"''").replaceAll("\\\\", "\\\\\\\\");
        return str;
    }
}

