/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.ReflectUtil;
import com.hotent.base.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    private static XmlMapper xmlMapper = new XmlMapper();

    public static String getXML(Element element) {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource();
            source.setNode(element);
            StreamResult result = new StreamResult();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            result.setOutputStream(baos);
            transformer.transform(source, result);
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Element getChildNodeByName(Element ruleNode, String name) {
        NodeList nodeList = ruleNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element node = XmlUtil.getElement(nodeList.item(i));
            if (node == null || node.getTagName() == null || !node.getTagName().equalsIgnoreCase(name)) continue;
            return node;
        }
        return null;
    }

    private static Element getElement(Object object) {
        if (object != null && object instanceof Element) {
            Element node = (Element)object;
            return node;
        }
        return null;
    }

    public static Document getDocument(String xmlFilePath) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(xmlFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static NodeList selectNodes(String express, Object source) {
        NodeList result = null;
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            result = (NodeList)xpath.evaluate(express, source, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Element selectFirstElement(String express, Object source) {
        NodeList list = XmlUtil.selectNodes(express, source);
        for (int i = 0; i < list.getLength(); ++i) {
            Node obj = list.item(i);
            if (!(obj instanceof Element)) continue;
            return (Element)obj;
        }
        return null;
    }

    public static void checkXmlFormat(org.dom4j.Element root, String firstName, String nextName) throws Exception {
        String msg = "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9";
        if (!root.getName().equals(firstName)) {
            throw new Exception(msg);
        }
        List itemLists = root.elements();
        for (org.dom4j.Element elm : itemLists) {
            if (elm.getName().equals(nextName)) continue;
            throw new Exception(msg);
        }
    }

    public static String toJson(String xml) {
        StringWriter w = new StringWriter();
        try (JsonParser jp = xmlMapper.getFactory().createParser(xml);
             JsonGenerator jg = JsonUtil.getMapper().getFactory().createGenerator((Writer)w);){
            while (jp.nextToken() != null) {
                jg.copyCurrentEvent(jp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return w.toString();
    }

    public static <T> T transformToObject(Node node, Class<T> clazz) throws Exception {
        PipedOutputStream output = new PipedOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(output);
        PipedInputStream input = new PipedInputStream(output);
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(node), new StreamResult(writer));
        Object object = JAXBUtil.unmarshall(input, clazz);
        return (T)object;
    }

    public static <T> T mapToXMLBean(Map<String, Object> data, Class<T> beanClass) throws Exception {
        T object = beanClass.newInstance();
        List<Field> fields = ReflectUtil.getAllField(beanClass);
        return (T)XmlUtil.setDataToObject(data, object, fields);
    }

    private static Object setDataToObject(Map<String, Object> data, Object object, List<Field> fields) throws Exception {
        for (Field field : fields) {
            Object propValue;
            XmlElementWrapper wapper;
            Map fromMap = data;
            String propName = field.getName();
            XmlElement element = field.getAnnotation(XmlElement.class);
            if (element != null && !"##default".equals(element.name())) {
                propName = element.name();
            }
            if ((wapper = field.getAnnotation(XmlElementWrapper.class)) != null) {
                fromMap = (Map)data.get(wapper.name());
            }
            if ((propValue = fromMap.get(propName)) == null) continue;
            Class<List> fieldClazz = field.getType();
            if (ReflectUtil.isBasicType(fieldClazz)) {
                ReflectUtil.setFieldValue(object, field, StringUtil.parserObject(propValue.toString(), fieldClazz));
                continue;
            }
            if (fieldClazz.isAssignableFrom(List.class)) {
                Class<?> propClazz = ReflectUtil.getGenericType(field.getGenericType(), 0);
                ArrayList listObjs = new ArrayList();
                if (List.class.isInstance(propValue)) {
                    List list = (List)propValue;
                    for (Map propMap : list) {
                        listObjs.add(XmlUtil.mapToXMLBean(propMap, propClazz));
                    }
                } else if (Map.class.isInstance(propValue)) {
                    listObjs.add(XmlUtil.mapToXMLBean((Map)propValue, propClazz));
                }
                ReflectUtil.setFieldValue(object, field, listObjs);
                continue;
            }
            if (!Map.class.isInstance(propValue)) continue;
            ReflectUtil.setFieldValue(object, field, XmlUtil.mapToXMLBean((Map)propValue, fieldClazz));
        }
        return object;
    }

    public static void transformToMap(Map<String, Object> result, Node n) {
        if (n.hasChildNodes()) {
            String nodeName;
            Node child;
            int i;
            NodeList nl = n.getChildNodes();
            HashMap<String, Integer> nodeNum = new HashMap<String, Integer>();
            for (i = 0; i < nl.getLength(); ++i) {
                child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                nodeNum.put(nodeName, nodeNum.containsKey(nodeName = child.getLocalName()) ? (Integer)nodeNum.get(nodeName) + 1 : 1);
            }
            for (i = 0; i < nl.getLength(); ++i) {
                child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                nodeName = child.getLocalName();
                if ((Integer)nodeNum.get(nodeName) > 1) {
                    ArrayList<HashMap<String, Object>> arrayNode = (ArrayList<HashMap<String, Object>>)result.get(nodeName);
                    if (arrayNode == null) {
                        arrayNode = new ArrayList<HashMap<String, Object>>();
                        result.put(nodeName, arrayNode);
                    }
                    HashMap<String, Object> childNodeMap = new HashMap<String, Object>();
                    XmlUtil.transformToMap(childNodeMap, child);
                    arrayNode.add(childNodeMap);
                    continue;
                }
                if (child.getChildNodes().getLength() == 1 && child.getFirstChild().getNodeType() == 3) {
                    Node text = child.getFirstChild();
                    result.put(child.getLocalName(), text.getNodeValue());
                    continue;
                }
                HashMap<String, Object> childNodeMap = new HashMap<String, Object>();
                XmlUtil.transformToMap(childNodeMap, child);
                result.put(child.getLocalName(), childNodeMap);
            }
        }
    }
}

