/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bo.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.instance.BoDataRecordHandler;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.dao.BoAttributeDao;
import com.hotent.bo.persistence.dao.BoEntDao;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import com.hotent.bo.persistence.manager.BoDefManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="boAttributeManager")
public class BoAttributeManagerImpl
extends BaseManagerImpl<BoAttributeDao, BoAttribute>
implements BoAttributeManager {
    @Resource
    BoEntDao boEntDao;
    @Resource
    BoDefManager boDefManager;
    @Resource
    BoDataRecordHandler boDataRecordHandler;

    @Override
    public List<BoAttribute> getByEntId(String entId) {
        BoEnt ent = (BoEnt)((Object)this.boEntDao.selectById((Serializable)((Object)entId)));
        List<BoAttribute> list = ((BoAttributeDao)this.baseMapper).getByEntId(entId);
        for (BoAttribute attribute : list) {
            attribute.setBoEnt(ent);
        }
        return list;
    }

    @Override
    public List<BoAttribute> getByBoEnt(BoEnt boEnt) {
        List<BoAttribute> list = ((BoAttributeDao)this.baseMapper).getByEntId(boEnt.getId());
        for (BoAttribute attribute : list) {
            attribute.setBoEnt(boEnt);
        }
        return list;
    }

    @Override
    public List<BoAttribute> getByEntName(String name) {
        return this.getByEntId(((BoEnt)((Object)this.boEntDao.selectOne((Wrapper)Wrappers.lambdaQuery().eq(BoEnt::getName, (Object)name)))).getId());
    }

    @Override
    public void removeByEntId(String entId) {
        ((BoAttributeDao)this.baseMapper).removeByEntId(entId);
    }

    @Override
    public void updateAttrStatus(String json, String alias) throws IOException {
        JsonNode nodes = JsonUtil.toJsonNode((String)json);
        if (BeanUtils.isNotEmpty((Object)nodes)) {
            ArrayList<BoAttribute> boAttributes = new ArrayList<BoAttribute>();
            for (JsonNode node : nodes) {
                BoAttribute boAttribute = (BoAttribute)((Object)JsonUtil.toBean((JsonNode)node, BoAttribute.class));
                if (!StringUtil.isNotEmpty((String)boAttribute.getId())) continue;
                boAttribute.setStatus("hide");
                boAttributes.add(boAttribute);
            }
            if (BeanUtils.isNotEmpty(boAttributes)) {
                this.boDefManager.delBodefFromCache(alias);
                this.updateBatchById(boAttributes);
            }
            this.saveRecordLog(boAttributes, alias, "\u903b\u8f91\u5220\u9664");
        }
    }

    @Override
    public void saveRecordLog(List<BoAttribute> attributes, String alias, String action) {
        StringBuilder content = new StringBuilder();
        for (BoAttribute attribute : attributes) {
            content.append(String.format("%s\u5b57\u6bb5\u3010%s\u3011;", action, attribute.getDesc()));
        }
        this.boDataRecordHandler.saveShowRecord(alias, content.toString(), action);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteAttr(String id, String alias) {
        BoAttribute boAttribute = (BoAttribute)this.get((Serializable)((Object)id));
        this.remove((Serializable)((Object)id));
        this.saveRecordLog(Collections.singletonList(boAttribute), alias, "\u5220\u9664");
    }

    @Override
    public void recovery(String json, String alias) throws Exception {
        BoAttribute boAttribute = (BoAttribute)((Object)JsonUtil.toBean((String)json, BoAttribute.class));
        if (StringUtil.isNotEmpty((String)boAttribute.getId())) {
            this.boDefManager.delBodefFromCache(alias);
            boAttribute.setStatus("show");
            ((BoAttributeDao)this.baseMapper).updateById((Object)boAttribute);
            this.saveRecordLog(Collections.singletonList(boAttribute), alias, "\u6062\u590d");
        }
    }

    @Override
    public void deleteByDefId(String defId) {
        ((BoAttributeDao)this.baseMapper).deleteByDefId(defId);
    }

    public void create(BoAttribute attr) {
        this.validateAttrDataType(attr);
        super.create((Model)attr);
    }

    public void update(BoAttribute attr) {
        this.validateAttrDataType(attr);
        super.update((Model)attr);
    }

    private void validateAttrDataType(BoAttribute attr) {
        if (!BoAttribute.ATTR_TYPE_LIST.contains(attr.getDataType())) {
            throw new BaseException(String.format("\u5b9e\u4f53\u3010%s\u3011\u4e0b\u7684\u5b57\u6bb5\u3010%s\u3011\u6570\u636e\u7c7b\u578b\u4e3a\u3010%s\u3011\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u53ea\u80fd\u662f\u3010%s\u3011\u5176\u4e2d\u4e00\u79cd", attr.getBoEnt().getDesc(), attr.getDesc(), attr.getDataType(), StringUtil.join(BoAttribute.ATTR_TYPE_LIST)));
        }
    }

    @Override
    public List<Map<String, String>> getBoDatabaseAttr(List<String> entNameList, List<String> attrNameList) {
        return ((BoAttributeDao)this.baseMapper).getBoDatabaseAttr(entNameList, attrNameList);
    }
}

