/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bo.persistence.manager.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.model.BoStdAttr;
import com.hotent.bo.persistence.dao.BoStdAttrDao;
import com.hotent.bo.persistence.manager.BoStdAttrManager;
import com.hotent.bo.util.BoUtil;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BoStdAttrManagerImpl
extends BaseManagerImpl<BoStdAttrDao, BoStdAttr>
implements BoStdAttrManager {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveAttributes(List<BoStdAttr> attributes, String userId) {
        this.validateAttributes(attributes);
        attributes.forEach(attribute -> attribute.setUserId(userId));
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoStdAttr::getUserId, (Object)userId);
        this.remove((Wrapper)wrapper);
        this.saveBatch(attributes);
    }

    @Override
    public List<BoStdAttr> getAttributes(String currentUserId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoStdAttr::getUserId, (Object)currentUserId);
        return this.list((Wrapper)wrapper);
    }

    private void validateAttributes(List<BoStdAttr> attributes) {
        attributes.forEach(attribute -> {
            Assert.notBlank((CharSequence)attribute.getName(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)attribute.getComment(), (String)"\u5b57\u6bb5\u6ce8\u91ca\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            BoStdAttrManagerImpl.validateAttr(attribute);
        });
    }

    public static void validateAttr(BoStdAttr attr) {
        if (BeanUtils.isEmpty((Object)attr.getDataType())) {
            throw new BaseException("");
        }
        if (!BoUtil.ATTR_TYPE_LIST.contains(attr.getDataType())) {
            throw new BaseException(String.format("\u5b57\u6bb5\u3010%s\u3011\u6570\u636e\u7c7b\u578b\u4e3a\u3010%s\u3011\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u53ea\u80fd\u662f\u3010%s\u3011\u5176\u4e2d\u4e00\u79cd", attr.getComment(), attr.getDataType(), StringUtil.join(BoUtil.ATTR_TYPE_LIST)));
        }
    }
}

