/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bo.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bo.exception.BoBaseException;
import com.hotent.bo.instance.BoDataHandler;
import com.hotent.bo.instance.BoInstanceFactory;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoBpmShipGroup;
import com.hotent.bo.model.BoCopyVo;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoDefXml;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.model.BoEntRel;
import com.hotent.bo.model.BoResult;
import com.hotent.bo.persistence.dao.BoDefDao;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.bo.persistence.manager.BoEntRelManager;
import com.hotent.bo.util.BoUtil;
import com.hotent.bo.vo.RemoveBoDefVO;
import com.hotent.table.model.Column;
import com.hotent.table.operator.ITableOperator;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

@Service(value="boDefManager")
public class BoDefManagerImpl
extends BaseManagerImpl<BoDefDao, BoDef>
implements BoDefManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoEntRelManager bOEntRelManager;
    @Resource
    ITableOperator tableOperator;
    @Resource
    BpmModelFeignService bpmModelFeignService;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    BoInstanceFactory boInstanceFactory;
    @Resource
    CommonManager commonManager;
    @Resource
    DatabaseContext databaseContext;

    @Override
    @Transactional
    public void removeByIds(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        ArrayList<String> aliasList = new ArrayList();
        List list = this.list((Wrapper)new QueryWrapper().select(new String[]{"alias_"}).in((Object)"id_", idList));
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)list)) {
            aliasList = list.stream().map(BoDef::getAlias).collect(Collectors.toList());
        }
        ((BoDefDao)this.baseMapper).deleteBatchIds(idList);
        for (String defId : idList) {
            this.boAttributeManager.deleteByDefId(defId);
            this.boEntManager.remove(defId);
            this.boEntManager.deleteByDefId(defId);
            this.bOEntRelManager.removeByDefId(defId);
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty(aliasList)) {
            this.delBodefCacheByIds(aliasList);
        }
    }

    @Override
    public RemoveBoDefVO checkRelation(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        ArrayList<String> idCanRemove = new ArrayList<String>();
        HashMap<String, List<BoDef>> refMap = new HashMap<String, List<BoDef>>();
        for (String defId : idList) {
            List existBoDefs;
            boolean isExistRef = false;
            List<String> refDefIds = this.boEntManager.getExtLocalEnts(defId);
            if (CollUtil.isNotEmpty(refDefIds) && CollUtil.isNotEmpty((Collection)(existBoDefs = this.list((Wrapper)Wrappers.lambdaQuery().in(BoDef::getId, refDefIds))))) {
                isExistRef = true;
                refMap.put(defId, existBoDefs);
            }
            if (isExistRef) continue;
            idCanRemove.add(defId);
        }
        int countFailed = refMap.size();
        RemoveBoDefVO removeBoDefVO = new RemoveBoDefVO();
        removeBoDefVO.setCountFailed(countFailed);
        removeBoDefVO.setCountSuccess(idList.size() - countFailed);
        removeBoDefVO.setRefMap(refMap);
        removeBoDefVO.setIdCanRemove(idCanRemove);
        return removeBoDefVO;
    }

    @Override
    @Transactional
    public void update(BoDef entity) {
        this.delBodefCache(entity.getAlias());
        BoEnt mainEnt = entity.getBoEnt();
        ArrayList<BoEnt> boEnts = new ArrayList<BoEnt>();
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)mainEnt)) && !mainEnt.isCreatedTable() && entity.isSupportDb()) {
            if (!mainEnt.isExternal()) {
                boEnts.add(mainEnt);
            }
            List<BoEnt> childEntList = mainEnt.getChildEntList();
            for (BoEnt boEnt2 : childEntList) {
                if (!boEnt2.isExternal() && !boEnt2.isCreatedTable()) {
                    boEnts.add(boEnt2);
                    List<BoEnt> sunEntList = boEnt2.getChildEntList();
                    if (com.hotent.base.util.BeanUtils.isNotEmpty(sunEntList)) {
                        for (BoEnt sunEnt : sunEntList) {
                            if (sunEnt.isExternal() || sunEnt.isCreatedTable()) continue;
                            boEnts.add(sunEnt);
                        }
                    }
                }
                this.boEntManager.delBoEntsByEntId(boEnt2.getId());
            }
        } else if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)mainEnt)) && entity.isSupportDb()) {
            List<BoEnt> childEntList = mainEnt.getChildEntList();
            for (BoEnt boEnt3 : childEntList) {
                List<BoEnt> sunEntList;
                if (!boEnt3.isExternal() && !boEnt3.isCreatedTable()) {
                    boEnts.add(boEnt3);
                }
                if (com.hotent.base.util.BeanUtils.isNotEmpty(sunEntList = boEnt3.getChildEntList())) {
                    for (BoEnt sunEnt : sunEntList) {
                        if (sunEnt.isExternal() || sunEnt.isCreatedTable()) continue;
                        boEnts.add(sunEnt);
                    }
                }
                this.boEntManager.delBoEntsByEntId(boEnt3.getId());
            }
        }
        boEnts.stream().forEach(boEnt -> boEnt.setIsCreatedTable(true));
        this.boEntManager.updateBatchById(boEnts);
        this.createTables(boEnts);
        super.updateById((Object)entity);
    }

    private void createTables(List<BoEnt> boEnts) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)AppUtil.getBean(TransactionManager.class);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)def);
        HashSet<String> createTables = new HashSet<String>();
        String createTable = "";
        try {
            if (com.hotent.base.util.BeanUtils.isNotEmpty(boEnts)) {
                for (int i = 0; i < boEnts.size(); ++i) {
                    BoEnt boEnt = boEnts.get(i);
                    if (boEnt.isExternal()) continue;
                    createTable = boEnt.getTableName();
                    this.boEntManager.createTable(boEnt);
                    createTables.add(createTable);
                }
            }
            transactionManager.commit(status);
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u8868\u5931\u8d25", (Throwable)e);
            PlatformTransactionManager transactionManagerCatch = (PlatformTransactionManager)AppUtil.getBean(TransactionManager.class);
            DefaultTransactionDefinition defCatch = new DefaultTransactionDefinition();
            defCatch.setPropagationBehavior(3);
            TransactionStatus statusCatch = transactionManagerCatch.getTransaction((TransactionDefinition)def);
            for (String tableName : createTables) {
                try {
                    this.tableOperator.dropTable(tableName);
                }
                catch (SQLException e1) {
                    throw new BaseException("\u521b\u5efa\u8868\u5931\u8d25,\u8868" + createTable + "\u5df2\u5b58\u5728");
                }
            }
            transactionManagerCatch.commit(statusCatch);
            transactionManager.rollback(status);
            throw new BaseException("\u521b\u5efa\u8868\u5931\u8d25,\u8868" + createTable + "\u5df2\u5b58\u5728");
        }
    }

    private void importTables(List<BoEnt> boEnts) {
        LinkedHashSet<String> createdTables = Optional.ofNullable(ThreadMsgUtil.getMapMsg2((String)"createTables")).orElse(new LinkedHashSet());
        try {
            if (com.hotent.base.util.BeanUtils.isNotEmpty(boEnts)) {
                for (BoEnt boEnt : boEnts) {
                    if (boEnt.isExternal()) continue;
                    createdTables.add(boEnt.getTableName());
                    this.boEntManager.createTable(boEnt);
                    ThreadMsgUtil.addMapMsg2((String)"createTables", createdTables);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    @Override
    public BoDef getByDefId(String defId) {
        BoDef boDef = (BoDef)((BoDefDao)this.baseMapper).selectById((Serializable)((Object)defId));
        return this.getByBoDef(boDef, defId);
    }

    @Override
    public BoDef getByBoDef(BoDef boDef, String defId) {
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)boDef)) {
            boDef = ((BoDefDao)this.baseMapper).getByAlias(defId);
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)boDef)) {
            boDef = this.getbuildBoFormCache(boDef);
        }
        return boDef;
    }

    @Override
    public BoDef getByAlias(String alias) {
        BoDef boDef = this.getByAliasFormCache(alias);
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)boDef)) {
            boDef = this.getbuildBoFormCache(boDef);
        }
        return boDef;
    }

    @Override
    public BoDef getPureByAlias(String alias) {
        BoDef boDef = this.getByAliasFormCache(alias);
        return boDef;
    }

    @Override
    @Cacheable(value={"eip:form:simpleBoDefAlias"}, key="#alias")
    public BoDef getByAliasFormCache(String alias) {
        return ((BoDefDao)this.baseMapper).getByAlias(alias);
    }

    @Override
    @CacheEvict(value={"eip:form:simpleBoDefAlias"}, key="#alias")
    public void delSimpleBoDefFromCache(String alias) {
    }

    private BoDef getbuildBoFormCache(BoDef boDef) {
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)boDef)) {
            return null;
        }
        return this.getBodefFormCache(boDef);
    }

    @Override
    @Cacheable(value={"eip:form:boDefAlias"}, key="#boDef.alias")
    public BoDef getBodefFormCache(BoDef boDef) {
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)boDef)) {
            return null;
        }
        HashMap<String, List<BoEnt>> refMap = new HashMap<String, List<BoEnt>>();
        HashMap<String, BoEntRel> entMap = new HashMap<String, BoEntRel>();
        List<BoEntRel> list = this.bOEntRelManager.getByDefId(boDef.getId());
        for (BoEntRel ref : list) {
            entMap.put(ref.getId(), ref);
        }
        String mainEntRefId = this.getMainEntRefId(list);
        for (BoEntRel ref : list) {
            List<BoEnt> tempList;
            String refEntId;
            BoEnt ent = ref.getRefEnt();
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)((Object)ent)) && (StringUtil.isEmpty((String)(refEntId = ref.getRefEntId())) || com.hotent.base.util.BeanUtils.isEmpty((Object)((Object)(ent = this.boEntManager.getById(refEntId)))))) continue;
            ent.setType(ref.getType());
            if (com.hotent.base.util.BeanUtils.isEmpty(ent.getBoAttrList())) {
                List<BoAttribute> attrList = this.boAttributeManager.getByBoEnt(ent);
                ent.setBoAttrList(attrList);
            }
            ent.setRelation(ent.getType());
            if ("main".equals(ref.getType())) {
                ent.setShow("\u4e3b\u5b9e\u4f53");
                boDef.setBoEnt(ent);
                continue;
            }
            BoEntRel boEntRel = (BoEntRel)((Object)entMap.get(ref.getParentId()));
            if (mainEntRefId.equals(ref.getParentId())) {
                ent.setShow("\u5b50\u5b9e\u4f53");
            } else {
                ent.setShow("\u5b59\u5b9e\u4f53");
            }
            String parentId = boEntRel.getRefEntId();
            if (refMap.containsKey(parentId)) {
                tempList = (List)refMap.get(parentId);
                tempList.add(ent);
                continue;
            }
            tempList = new ArrayList();
            tempList.add(ent);
            refMap.put(parentId, tempList);
        }
        this.buildRefEnt(boDef.getBoEnt(), refMap);
        return boDef;
    }

    private String getMainEntRefId(List<BoEntRel> list) {
        for (BoEntRel boEntRel : list) {
            if (!"main".equals(boEntRel.getType())) continue;
            return boEntRel.getId();
        }
        return "";
    }

    private void buildRefEnt(BoEnt boEnt, Map<String, List<BoEnt>> refMap) {
        List<BoEnt> tempList = refMap.get(boEnt.getId());
        if (com.hotent.base.util.BeanUtils.isEmpty(tempList)) {
            return;
        }
        boEnt.setChildEntList(tempList);
        for (BoEnt childObj : tempList) {
            this.buildRefEnt(childObj, refMap);
        }
    }

    @Override
    public List<BoDef> parseXml(String xml) {
        try {
            BoDefXml def = (BoDefXml)JAXBUtil.unmarshall((String)xml, BoDefXml.class);
            List<BoDef> list = def.getDefList();
            return list;
        }
        catch (Exception e) {
            throw new BaseException("\u89e3\u6790xml\u6210\u4e1a\u52a1\u5bf9\u8c61\u5b9a\u4e49\u65f6\u51fa\u9519:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public String serialToXml(List<BoDef> boDef) {
        String xml = "";
        try {
            BoDefXml defXml = new BoDefXml();
            defXml.setDefList(boDef);
            xml = JAXBUtil.marshall((Object)defXml, BoDefXml.class);
        }
        catch (JAXBException e) {
            throw new BaseException("\u5e8f\u5217\u6362\u6210XML\u65f6\u51fa\u9519:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return xml;
    }

    @Override
    @Transactional
    public List<BoDef> importBoDef(List<BoDef> boDefs) {
        ArrayList<BoDef> rtnList = new ArrayList<BoDef>();
        this.checkBoEnt(boDefs);
        for (BoDef boDef : boDefs) {
            BoDef boBoDef = this.importDef(boDef);
            rtnList.add(boBoDef);
        }
        return rtnList;
    }

    private BoDef importDef(BoDef boDef) {
        String alias = boDef.getAlias();
        BoDef dbDef = this.getPureByAlias(alias);
        BoEnt boEnt = boDef.getBoEnt();
        boEnt.setIsCreatedTable(boDef.isDeployed());
        ArrayList<BoEnt> createTableByBoEntList = new ArrayList<BoEnt>();
        if (dbDef == null) {
            String defId = UniqueIdUtil.getSuid();
            boDef.setId(defId);
            boDef.setDeployed(true);
            ObjectNode sysType = this.portalFeignService.getSysTypeByType("DEF_TYPE", "default");
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)sysType)) {
                boDef.setCategoryId(sysType.get("id").asText());
                boDef.setCategoryName(sysType.get("name").asText());
            }
            boDef.setCreateBy(AuthenticationUtil.getCurrentUserId());
            boDef.setCreateTime(LocalDateTime.now());
            this.create((Model)boDef);
            this.importAddEnt(defId, boEnt, "0", createTableByBoEntList);
        } else {
            String defId = dbDef.getId();
            boDef.setId(defId);
            this.importEditEnt(defId, boEnt, "0", createTableByBoEntList);
        }
        String notNeedTransaction = ThreadMsgUtil.getMapMsg((String)"notNeedTransaction", (boolean)true);
        if (StringUtil.isNotEmpty((String)notNeedTransaction)) {
            this.importTables(createTableByBoEntList);
        } else {
            this.createTables(createTableByBoEntList);
        }
        this.delBodefCache(boDef.getAlias());
        return boDef;
    }

    private void importAddEnt(String defId, BoEnt ent, String parentId, List<BoEnt> creatTableByBoEnt) {
        if (ent.isExternal()) {
            ent.setIsCreatedTable(true);
        }
        ent.setId(null);
        ent.setStatus("enabled");
        this.boEntManager.create((Model)ent);
        List<BoAttribute> attrList = ent.getBoAttrList();
        this.saveAttr(ent.getId(), attrList, ent);
        creatTableByBoEnt.add(ent);
        ThreadMsgUtil.addMapMsg2((String)"entsAdded", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", ent.getComment() + "", ent.getName() + ""));
        String relId = UniqueIdUtil.getSuid();
        this.saveBoRel(relId, defId, parentId, ent.getId(), ent.getType());
        List<BoEnt> childEnts = ent.getChildEntList();
        if (com.hotent.base.util.BeanUtils.isEmpty(childEnts)) {
            return;
        }
        for (BoEnt childBaseEnt : childEnts) {
            childBaseEnt.setIsCreatedTable(ent.isCreatedTable());
            this.importEditEnt(defId, childBaseEnt, relId, creatTableByBoEnt);
        }
    }

    private void importEditEnt(String defId, final BoEnt ent, String parentId, List<BoEnt> creatTableByBoEnt) {
        if (ent.isExternal()) {
            ent.setIsCreatedTable(true);
        }
        String relId = UniqueIdUtil.getSuid();
        BoEnt dbEnt = this.boEntManager.getByName(ent.getName());
        if (dbEnt == null) {
            this.importAddEnt(defId, ent, parentId, creatTableByBoEnt);
        } else {
            if (!this.tableOperator.isTableExist(dbEnt.getTableName())) {
                this.createTables((List<BoEnt>)new ArrayList<BoEnt>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(ent);
                    }
                });
            }
            this.boEntManager.delBoEntsByEntId(dbEnt.getId());
            if (!ent.isExternal()) {
                this.importNewBoAttr(ent, dbEnt.getId());
            } else {
                dbEnt.setFk(ent.getFk());
                dbEnt.setDesc(ent.getDesc());
                this.boEntManager.update((Model)dbEnt);
            }
            BoEntRel entRel = this.bOEntRelManager.getByDefIdAndEntId(defId, dbEnt.getId());
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)((Object)entRel))) {
                this.saveBoRel(relId, defId, parentId, ent.getId(), ent.getType());
            } else {
                relId = entRel.getId();
            }
            ThreadMsgUtil.addMapMsg2((String)"entDefsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", dbEnt.getDesc() + "", dbEnt.getName() + ""));
            List<BoEnt> childEnts = ent.getChildEntList();
            if (com.hotent.base.util.BeanUtils.isEmpty(childEnts)) {
                return;
            }
            for (BoEnt childBaseEnt : childEnts) {
                childBaseEnt.setIsCreatedTable(ent.isCreatedTable());
                this.importEditEnt(defId, childBaseEnt, relId, creatTableByBoEnt);
            }
        }
    }

    private void importNewBoAttr(BoEnt ent, String entId) {
        List<BoAttribute> dbAttrList = this.boAttributeManager.getByEntId(entId);
        Map<String, List<BoAttribute>> mapBoAttr = ((List)Optional.ofNullable(dbAttrList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(BoAttribute::getName));
        List<BoAttribute> importAttrList = ent.getBoAttrList();
        ArrayList<BoAttribute> importNewAttrList = new ArrayList<BoAttribute>();
        for (BoAttribute boAttribute : importAttrList) {
            if (mapBoAttr.containsKey(boAttribute.getName())) continue;
            importNewAttrList.add(boAttribute);
        }
        this.saveAttr(entId, importNewAttrList, ent);
        for (BoAttribute boAttribute : importNewAttrList) {
            try {
                this.tableOperator.addColumn(ent.getTableName(), (Column)boAttribute);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BaseException("\u65b0\u589e\u6570\u636e\u5e93\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public Set<String> checkBoEnt(List<BoDef> boDefs) {
        HashSet<String> entNames = new HashSet<String>();
        for (BoDef boDef : boDefs) {
            HashSet<String> tempEntNames;
            BoEnt boEnt = boDef.getBoEnt();
            BoDef dbBoDef = this.getByAlias(boDef.getAlias());
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)dbBoDef)) {
                tempEntNames = new HashSet<String>();
                this.checkExistBoEnt(boEnt, tempEntNames);
                if (!com.hotent.base.util.BeanUtils.isNotEmpty(tempEntNames)) continue;
                throw new BaseException("\u5efa\u6a21\u5b9e\u4f53\u3010" + String.join((CharSequence)"\uff0c", tempEntNames) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728");
            }
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)dbBoDef.getBoEnt())) && !dbBoDef.getBoEnt().getName().equalsIgnoreCase(boEnt.getName())) {
                throw new BaseException("\u5efa\u6a21\u3010" + boDef.getDescription() + "" + boDef.getAlias() + "\u3011\u5df2\u5b58\u5728,\u4e3b\u5b9e\u4f53\u540d\u79f0\u4e0d\u4e00\u81f4");
            }
            tempEntNames = new HashSet();
            this.checkExistBoEnt(dbBoDef.getId(), boEnt, tempEntNames, "0");
            entNames.addAll(tempEntNames);
        }
        return entNames;
    }

    @Override
    public void checkExistBoEnt(BoEnt ent, Set<String> entNames) {
        List<BoEnt> childEntList;
        BoEnt oldBoEnt;
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)ent)) && StringUtil.isNotEmpty((String)ent.getName()) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)(oldBoEnt = this.boEntManager.getByName(ent.getName()))))) {
            entNames.add(String.format("%s\uff08%s\uff09", oldBoEnt.getDesc(), oldBoEnt.getName()));
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty(childEntList = ent.getChildEntList())) {
            for (BoEnt childEnt : childEntList) {
                this.checkExistBoEnt(childEnt, entNames);
            }
        }
    }

    @Override
    public void checkExistBoEnt(String boDefId, BoEnt ent, Set<String> entNames, String parentEntRelId) {
        block8: {
            block9: {
                if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)ent)) || !StringUtil.isNotEmpty((String)ent.getName())) break block8;
                BoEnt oldBoEnt = this.boEntManager.getByName(ent.getName());
                if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)oldBoEnt))) break block9;
                BoEntRel boEntRel = this.bOEntRelManager.getByDefIdAndEntId(boDefId, oldBoEnt.getId());
                if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)boEntRel)) && parentEntRelId.equals(boEntRel.getParentId()) && ent.getIsExternal().equals(oldBoEnt.getIsExternal())) {
                    if (ent.isExternal()) {
                        if (!ent.getTableName().equalsIgnoreCase(oldBoEnt.getTableName())) {
                            throw new BaseException("\u5efa\u6a21\u4e2d\u5916\u90e8\u5b9e\u4f53\u3010" + ent.getName() + "\u3011\u5916\u90e8\u8868\u540d\u4e0d\u4e00\u81f4");
                        }
                        if (!ent.getDsName().equalsIgnoreCase(oldBoEnt.getDsName())) {
                            throw new BaseException("\u5efa\u6a21\u4e2d\u5916\u90e8\u5b9e\u4f53\u3010" + ent.getName() + "\u3011\u6570\u636e\u6e90\u4e0d\u4e00\u81f4");
                        }
                    }
                } else {
                    throw new BaseException("\u5efa\u6a21\u4e2d\u5b9e\u4f53\u3010" + ent.getName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728");
                }
                entNames.add(String.format("%s\uff08%s\uff09", oldBoEnt.getDesc(), oldBoEnt.getName()));
                List<BoEnt> childEntList = ent.getChildEntList();
                if (!com.hotent.base.util.BeanUtils.isNotEmpty(childEntList)) break block8;
                for (BoEnt childEnt : childEntList) {
                    this.checkExistBoEnt(boDefId, childEnt, entNames, boEntRel.getId());
                }
                break block8;
            }
            List<BoEnt> childEntList = ent.getChildEntList();
            if (com.hotent.base.util.BeanUtils.isNotEmpty(childEntList)) {
                for (BoEnt childEnt : childEntList) {
                    HashSet<String> tempEntNames = new HashSet<String>();
                    this.checkExistBoEnt(childEnt, tempEntNames);
                    if (!com.hotent.base.util.BeanUtils.isNotEmpty(tempEntNames)) continue;
                    throw new BaseException("\u5efa\u6a21\u4e2d\u5b9e\u4f53\u3010" + String.join((CharSequence)",", tempEntNames) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728");
                }
            }
        }
    }

    private void saveAttr(String entId, List<BoAttribute> attrList, BoEnt dbEnt) {
        for (BoAttribute attribute : attrList) {
            attribute.setBoEnt(dbEnt);
            attribute.setId(UniqueIdUtil.getSuid());
            attribute.setEntId(entId);
            this.boAttributeManager.create((Model)attribute);
        }
    }

    private void saveBoRel(String id, String defId, String parentId, String entId, String type) {
        BoEntRel rel = new BoEntRel();
        rel.setId(id);
        rel.setBoDefid(defId);
        rel.setParentId(parentId);
        rel.setRefEntId(entId);
        rel.setType(type);
        this.bOEntRelManager.create((Model)rel);
    }

    @Override
    @Transactional
    public void save(String json) throws Exception {
        JsonNode jsonNode = JsonUtil.toJsonNode((String)json);
        BoDef boDef = (BoDef)JsonUtil.toBean((String)json, BoDef.class);
        this.delBodefCache(boDef.getAlias());
        if (StringUtil.isEmpty((String)boDef.getId())) {
            BoDef isAlias = this.getByAlias(boDef.getAlias());
            if (isAlias != null) {
                throw new BaseException("\u522b\u540d\u5df2\u5b58\u5728");
            }
            boDef.setId(UniqueIdUtil.getSuid());
            this.create((Model)boDef);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", boDef.getId());
            map.put("rev", jsonNode.get("rev").asText());
            BoDef boDef1 = ((BoDefDao)this.baseMapper).getBoDefByRev(map);
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)boDef1)) {
                this.update(boDef);
                this.bOEntRelManager.removeByDefId(boDef.getId());
            } else {
                throw new BaseException("\u6b64\u5efa\u6a21\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            }
        }
        ArrayNode ents = (ArrayNode)jsonNode.get("ents");
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)ents)) {
            throw new BaseException("bo\u5b9a\u4e49\u4e2d\u7684\u5b9e\u4f53\u5143\u7d20(ents)\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String mainId = UniqueIdUtil.getSuid();
        this.dealEnts(boDef, ents, mainId);
    }

    @Override
    public ObjectNode getBOJson(String id) throws IOException {
        BoDef boDef = this.getByDefId(id);
        if (boDef == null) {
            return null;
        }
        BoEnt mainBo = boDef.getBoEnt();
        Assert.notNull((Object)((Object)mainBo), (String)String.format("ID\u4e3a%s\u7684BoDef\u6240\u5bf9\u5e94\u7684BoEnt\u4e3a\u7a7a", id));
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)mainBo));
        jsonNode.put("boDefId", boDef.getId());
        jsonNode.put("boDefAlias", boDef.getAlias());
        jsonNode.put("path", boDef.getAlias());
        if (com.hotent.base.util.BeanUtils.isNotEmpty(mainBo.getChildEntList())) {
            List<BoEnt> childEntList = mainBo.getChildEntList();
            ArrayNode arrayEnts = JsonUtil.getMapper().createArrayNode();
            for (BoEnt boEnt : childEntList) {
                ObjectNode objNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)boEnt));
                if (com.hotent.base.util.BeanUtils.isNotEmpty(boEnt.getChildEntList())) {
                    objNode.set("childEnts", JsonUtil.toJsonNode(boEnt.getChildEntList()));
                }
                arrayEnts.add((JsonNode)objNode);
            }
            jsonNode.set("childEnts", (JsonNode)arrayEnts);
        }
        this.handelBOJSON(jsonNode, "sub");
        jsonNode.put("nodeType", "main");
        jsonNode.put("icon", "fa fa-th-large dark");
        return jsonNode;
    }

    @Override
    public ObjectNode getBOJsonByBoDefCode(String code) throws IOException {
        BoDef boDef = this.getByAlias(code);
        BoEnt mainBo = boDef.getBoEnt();
        Assert.notNull((Object)((Object)mainBo), (String)String.format("code\u4e3a%s\u7684BoDef\u6240\u5bf9\u5e94\u7684BoEnt\u4e3a\u7a7a", code));
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)mainBo));
        jsonNode.put("boDefId", boDef.getId());
        jsonNode.put("boDefAlias", boDef.getAlias());
        jsonNode.put("path", boDef.getAlias());
        if (com.hotent.base.util.BeanUtils.isNotEmpty(mainBo.getChildEntList())) {
            jsonNode.set("childEnts", JsonUtil.toJsonNode(mainBo.getChildEntList()));
        }
        this.handelBOJSON(jsonNode, "sub");
        jsonNode.put("nodeType", "main");
        jsonNode.put("icon", "fa fa-th-large dark");
        return jsonNode;
    }

    @Override
    @Transactional
    @CacheEvict(value={"eip:form:boDefAlias"}, key="#boDef.alias")
    public void updateCategory(BoDef boDef) {
        super.update((Model)boDef);
    }

    @Override
    @Transactional
    public String saveFormData(String json) throws Exception {
        JsonNode jsonNode = JsonUtil.toJsonNode((String)json);
        BoDef boDef = (BoDef)JsonUtil.toBean((String)json, BoDef.class);
        this.delBodefCache(boDef.getAlias());
        Boolean isDeployed = jsonNode.get("deployed").asBoolean();
        String defId = null;
        if (StringUtil.isEmpty((String)boDef.getId())) {
            BoDef isAlias = this.getByAlias(boDef.getAlias());
            if (isAlias != null) {
                throw new BaseException("\u5efa\u6a21\u522b\u540d\u5df2\u5b58\u5728");
            }
            boDef.setId(UniqueIdUtil.getSuid());
            defId = boDef.getId();
            this.create((Model)boDef);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", boDef.getId());
            map.put("rev", jsonNode.get("rev").asInt());
            BoDef boDef1 = ((BoDefDao)this.baseMapper).getBoDefByRev(map);
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)boDef1)) {
                super.update((Model)boDef);
                this.bOEntRelManager.removeByDefId(boDef.getId());
            } else {
                throw new BaseException("\u6b64\u5efa\u6a21\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            }
        }
        ArrayNode ents = (ArrayNode)jsonNode.get("ents");
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)ents)) {
            throw new BaseException("bo\u5b9a\u4e49\u4e2d\u7684\u5b9e\u4f53\u5143\u7d20(ents)\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String mainId = UniqueIdUtil.getSuid();
        this.dealEnts(boDef, ents, mainId);
        if (isDeployed.booleanValue()) {
            this.deployed(defId, JsonUtil.getString((JsonNode)jsonNode, (String)"id", (String)""));
        }
        return defId;
    }

    @Override
    @Transactional
    public void deployed(String defId, String id) {
        BoDef byDefId = this.getByDefId(defId);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)byDefId)) {
            BoDef updateBo = this.getByDefId(id);
            updateBo.setDeployed(true);
            this.update(updateBo);
        } else {
            byDefId.setDeployed(true);
            this.update(byDefId);
        }
    }

    private void dealEnts(BoDef boDef, ArrayNode ents, String mainId) throws Exception {
        for (int i = 0; i < ents.size(); ++i) {
            JsonNode subJsonNode = ents.get(i);
            BoEnt ent = (BoEnt)((Object)JsonUtil.toBean((JsonNode)subJsonNode, BoEnt.class));
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)subJsonNode.get("createdTable")) && subJsonNode.get("createdTable").asBoolean()) {
                ent.setIsCreatedTable(true);
            }
            this.boEntManager.saveEnt(ent, mainId, boDef.getId(), ents);
            String entId = ent.getId();
            BoEntRel boEntRel = new BoEntRel();
            boEntRel.setBoDefid(boDef.getId());
            JsonNode relationNode = subJsonNode.get("relation");
            String relation = relationNode.asText();
            String sunMainId = UniqueIdUtil.getSuid();
            if ("main".equals(relation)) {
                boEntRel.setParentId("0");
                boEntRel.setId(mainId);
            } else {
                boEntRel.setId(sunMainId);
                boEntRel.setParentId(mainId);
            }
            boEntRel.setRefEntId(entId);
            boEntRel.setType(relation);
            this.bOEntRelManager.create((Model)boEntRel);
            if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)subJsonNode.get("children"))) continue;
            ArrayNode sunents = (ArrayNode)subJsonNode.get("children");
            this.dealEnts(boDef, sunents, sunMainId);
        }
    }

    @Override
    public Map<String, Object> getBindData(String id, String alias) throws IOException {
        List<Map<String, String>> formDifinitionData = ((BoDefDao)this.baseMapper).getFormDifinitionData(id);
        List bpmDefinitionData = this.bpmModelFeignService.bpmDefinitionData(alias);
        List<Map<String, String>> entData = ((BoDefDao)this.baseMapper).getEntData(id);
        Map<String, BoBpmShipGroup> shipMap = this.buildBoBpmShipGroup(bpmDefinitionData);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formData", formDifinitionData);
        map.put("bpmData", shipMap);
        map.put("entData", entData);
        return map;
    }

    @Override
    public List<Map<String, String>> getFormDifinitionData(String id) {
        return ((BoDefDao)this.baseMapper).getFormDifinitionData(id);
    }

    @Override
    public List<Map<String, String>> getDefinitionTemplateData(String id) {
        return ((BoDefDao)this.baseMapper).getDefinitionTemplateData(id);
    }

    private Map<String, BoBpmShipGroup> buildBoBpmShipGroup(List<Map<String, String>> definitionData) {
        HashMap<String, BoBpmShipGroup> shipMap = new HashMap<String, BoBpmShipGroup>();
        definitionData.forEach(map -> {
            String defId = (String)map.get("def_id_");
            String name = (String)map.get("name_");
            String defKey = (String)map.get("def_key_");
            String version = (String)map.get("version_");
            String main = (String)map.get("is_main_");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)defKey), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230defKey");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)name), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u540d\u79f0");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)version), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u7248\u672c\u53f7");
            BoBpmShipGroup shipGroup = null;
            if (!shipMap.containsKey(defKey)) {
                shipGroup = BoBpmShipGroup.build(defKey, name);
                shipMap.put(defKey, shipGroup);
            }
            shipGroup = (BoBpmShipGroup)shipMap.get(defKey);
            shipGroup.addShip(defId, version, "Y".equals(main));
        });
        return shipMap;
    }

    @Override
    public List<Map<String, String>> getBpmDefinitionData(String formKey) throws Exception {
        return this.bpmModelFeignService.bpmDefinitionData(formKey);
    }

    @Override
    public List getHideAttr(String tableName) throws Exception {
        List<BoEnt> boEnts = this.boEntManager.getByTableName(tableName);
        if (boEnts.size() == 0) {
            return null;
        }
        List<BoAttribute> attrList = this.boAttributeManager.getByBoEnt(boEnts.get(0));
        ArrayList<BoAttribute> list = new ArrayList<BoAttribute>();
        for (int i = 0; i < attrList.size(); ++i) {
            if (!"hide".equals(attrList.get(i).getStatus())) continue;
            list.add(attrList.get(i));
        }
        return list.size() > 0 ? list : null;
    }

    @Override
    public ObjectNode getBoDefDetailsByAlias(String alias) throws Exception {
        BoDef boDef = this.getByAlias(alias);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)boDef)) {
            return null;
        }
        return this.getBoDefDetailsByDef(boDef);
    }

    @Override
    public ObjectNode getBoDefDetails(String id) throws Exception {
        BoDef boDef = this.getByDefId(id);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)boDef)) {
            return JsonUtil.createObjectNode();
        }
        return this.getBoDefDetailsByDef(boDef);
    }

    private ObjectNode getBoDefDetailsByDef(BoDef boDef) throws Exception {
        boDef.getBoEnt().getBoAttrList().removeIf(boAttribute -> boAttribute.getName().equals("TENANT_ID_"));
        BoEnt ent = boDef.getBoEnt();
        ObjectNode boDefNode = (ObjectNode)JsonUtil.toJsonNode((Object)boDef);
        ObjectNode entNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)ent));
        ArrayNode node = JsonUtil.getMapper().createArrayNode();
        node.add((JsonNode)entNode);
        if (ent.getChildEntList() != null && ent.getChildEntList().size() > 0) {
            for (BoEnt boent : ent.getChildEntList()) {
                ObjectNode no = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)boent));
                if (com.hotent.base.util.BeanUtils.isNotEmpty(boent.getChildEntList())) {
                    no.set("children", (JsonNode)((ArrayNode)JsonUtil.toJsonNode(boent.getChildEntList())));
                }
                node.add((JsonNode)no);
            }
        }
        boDefNode.set("ents", (JsonNode)node);
        boDefNode.put("isVerify", StringUtil.isNotEmpty((String)boDef.getVerifyJson()));
        return boDefNode;
    }

    @Override
    public ObjectNode getBoTreeData(String ids) throws Exception {
        if (ids.equals("{}")) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)ids)) {
            ids = ids.replace("=", "");
        }
        String[] idsArr = ids.split(",");
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        for (String id : idsArr) {
            ObjectNode boJson = this.getBOJson(id);
            if (boJson == null) continue;
            if (boJson.hasNonNull("children")) {
                ArrayNode main = (ArrayNode)boJson.get("children");
                Iterator iterator = main.iterator();
                while (iterator.hasNext()) {
                    JsonNode jsonNode = (JsonNode)iterator.next();
                    if (jsonNode.hasNonNull("children")) {
                        ArrayNode subTab = (ArrayNode)jsonNode.get("children");
                        Iterator subIterator = subTab.iterator();
                        while (subIterator.hasNext()) {
                            JsonNode subNode = (JsonNode)subIterator.next();
                            if (!subNode.hasNonNull("name") || !"form_data_rev_".equals(subNode.get("name").asText())) continue;
                            subIterator.remove();
                        }
                        continue;
                    }
                    if ((!jsonNode.hasNonNull("name") || !"form_data_rev_".equals(jsonNode.get("name").asText())) && (!jsonNode.hasNonNull("status") || !"hide".equals(jsonNode.get("status").asText()))) continue;
                    iterator.remove();
                }
            }
            arrayNode.add((JsonNode)boJson);
        }
        ObjectNode bos = (ObjectNode)JsonUtil.toJsonNode((String)"{\"id\":\"0\",\"parentId\":\"-1\",\"desc\":\"BO\u5bf9\u8c61\u5c5e\u6027\"}");
        bos.set("children", (JsonNode)arrayNode);
        return bos;
    }

    private void handelBOJSON(ObjectNode boJson, String nodeTypeOfChild) {
        ArrayNode children = JsonUtil.getMapper().createArrayNode();
        ArrayNode attrList = (ArrayNode)boJson.get("attributeList");
        for (int i = 0; i < attrList.size(); ++i) {
            ObjectNode attr = (ObjectNode)attrList.get(i);
            attr.put("nodeType", "field");
            attr.set("entId", boJson.get("id"));
            attr.set("boDefId", boJson.get("boDefId"));
            attr.set("path", boJson.get("path"));
            String dataType = attr.get("dataType").asText();
            if ("number".equals(dataType)) {
                attr.put("icon", "ico_int green");
                continue;
            }
            if ("datetime".equals(dataType)) {
                attr.put("icon", "ico_date green");
                continue;
            }
            attr.put("icon", "ico_string dark");
        }
        children.addAll(attrList);
        boJson.remove("attributeList");
        ArrayNode childEntList = (ArrayNode)boJson.get("childEnts");
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)childEntList)) {
            for (int i = 0; i < childEntList.size(); ++i) {
                ObjectNode subTable = (ObjectNode)childEntList.get(i);
                subTable.put("nodeType", "sub");
                subTable.put("childType", nodeTypeOfChild);
                subTable.put("icon", "ico_complex blue");
                subTable.put("path", boJson.get("path").asText() + ".sub_" + subTable.get("name").asText());
                this.handelBOJSON(subTable, "sun");
            }
            attrList.addAll(childEntList);
        }
        boJson.remove("childEnts");
        boJson.set("children", (JsonNode)attrList);
    }

    @Transactional
    public boolean removeById(Serializable id) {
        Assert.notNull((Object)id, (String)"\u5220\u9664\u6570\u636e\u65f6\u4f20\u5165\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        this.boEntManager.deleteByDefId(id.toString());
        this.bOEntRelManager.removeByDefId(id.toString());
        return super.removeById(id);
    }

    @Override
    @Transactional
    public int removeByAlias(String alias) {
        return ((BoDefDao)this.baseMapper).removeByAlias(alias);
    }

    @Override
    public List<BoDef> getByFormKey(String formKey) {
        return ((BoDefDao)this.baseMapper).getByFormKey(formKey);
    }

    @Override
    public List<BoDef> getByFormId(String formId) {
        ArrayList<BoDef> buildList = new ArrayList<BoDef>();
        List<BoDef> list = ((BoDefDao)this.baseMapper).getByFormId(formId);
        if (com.hotent.base.util.BeanUtils.isNotEmpty(list)) {
            for (BoDef boDef : list) {
                buildList.add(this.getbuildBoFormCache(boDef));
            }
        }
        return buildList;
    }

    @Override
    public List<String> getFormIdByBoDefIds(List<String> boDefIds) {
        return ((BoDefDao)this.baseMapper).getFormIdByBoDefIds(boDefIds);
    }

    @Override
    public String getBoDefIdByFormId(String formId) {
        return ((BoDefDao)this.baseMapper).getBoDefIdByFormId(formId);
    }

    @Override
    public void deleteExternalEnt(String entString) throws Exception {
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)entString);
        String defId = jsonNode.get("id").asText();
        this.boEntManager.removeById((Serializable)((Object)defId));
        this.boAttributeManager.removeByEntId(defId);
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("REF_ENT_ID_", defId);
        this.bOEntRelManager.removeByMap(query);
        JsonNode childEntList = jsonNode.get("children");
        for (JsonNode boEntn : childEntList) {
            ObjectNode boEnt = (ObjectNode)boEntn;
            String id = boEnt.get("id").asText();
            this.boEntManager.removeById((Serializable)((Object)id));
            this.boAttributeManager.removeByEntId(id);
            HashMap<String, String> querys = new HashMap<String, String>();
            querys.put("REF_ENT_ID_", id);
            this.bOEntRelManager.removeByMap(querys);
        }
    }

    @Override
    public List<String> getBoDefIdsByFormKey(List<String> formKeys) {
        return ((BoDefDao)this.baseMapper).getBoDefIdsByFormKey(formKeys);
    }

    @Override
    @CacheEvict(value={"eip:form:boDefAlias"}, key="#alias")
    public void delBodefFromCache(String alias) {
    }

    public void delBodefCache(String alias) {
        this.delBodefFromCache(alias);
        this.delSimpleBoDefFromCache(alias);
    }

    public void delBodefCacheByIds(List<String> aliasList) {
        for (String alias : aliasList) {
            this.delBodefFromCache(alias);
            this.delSimpleBoDefFromCache(alias);
        }
    }

    @Override
    @Transactional
    public void saveBoCopy(BoCopyVo boCopyVo) throws Exception {
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)this.getPureByAlias(boCopyVo.getNewAlias()))) {
            throw new RuntimeException("\u5efa\u6a21\u522b\u540d\u5df2\u5b58\u5728");
        }
        HashSet newEntNames = new HashSet();
        boCopyVo.getEntsMap().forEach((key, value) -> {
            if (newEntNames.contains(value.getNewName())) {
                throw new RuntimeException("\u5b58\u5728\u91cd\u540d\u7684\u5b9e\u4f53\u540d\u79f0\uff1a" + value.getNewName());
            }
            newEntNames.add(value.getNewName());
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)this.boEntManager.getByName(value.getNewName())))) {
                throw new RuntimeException(String.format("\u5df2\u5b58\u5728\u522b\u540d\u4e3a%s\u7684bo\u5b9e\u4f53.", value.getNewName()));
            }
        });
        BoDef boDefCache = this.getPureByAlias(boCopyVo.getAlias());
        BoDef boDef = new BoDef();
        BeanUtils.copyProperties((Object)boDefCache, (Object)boDef);
        String oldBoDefId = boDef.getId();
        String newBoDefId = UniqueIdUtil.getSuid();
        boDef.setId(newBoDefId);
        boDef.setAlias(boCopyVo.getNewAlias());
        boDef.setDescription(boCopyVo.getNewDescription());
        boDef.setCategoryId(boCopyVo.getNewCategoryId());
        boDef.setCategoryName(boCopyVo.getNewCategoryName());
        boDef.setDeployed(false);
        boDef.setCreateBy(AuthenticationUtil.getCurrentUserId());
        boDef.setCreateTime(LocalDateTime.now());
        boDef.setCreateOrgId(AuthenticationUtil.getCurrentUserMainOrgId());
        this.create((Model)boDef);
        Map<String, BoCopyVo.BoEntCopyVo> newEntMap = boCopyVo.getEntsMap();
        HashMap<String, String> entIdMap = new HashMap<String, String>();
        List<BoEnt> boEnts = this.boEntManager.getByDefId(oldBoDefId);
        for (BoEnt boEnt : boEnts) {
            if (!newEntMap.containsKey(boEnt.getName())) {
                throw new RuntimeException(String.format("\u5b9e\u4f53[%s]\u7684\u65b0\u5b9e\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", boEnt.getDesc()));
            }
            String newEntId = UniqueIdUtil.getSuid();
            entIdMap.put(boEnt.getId(), newEntId);
            BoCopyVo.BoEntCopyVo newEntInfo = newEntMap.get(boEnt.getName());
            boEnt.setId(newEntId);
            boEnt.setName(newEntInfo.getNewName());
            boEnt.setDesc(newEntInfo.getNewDesc());
            boEnt.setStatus("enabled");
            boEnt.setIsCreatedTable(false);
            boEnt.setTableName(boEnt.isExternal() ? boEnt.getTableName() : null);
            this.boEntManager.create((Model)boEnt);
            for (BoAttribute boAttr : boEnt.getBoAttrList()) {
                boAttr.setEntId(newEntId);
                boAttr.setId(UniqueIdUtil.getSuid());
                this.boAttributeManager.create((Model)boAttr);
            }
        }
        List<BoEntRel> boEntRelList = this.bOEntRelManager.getByDefId(oldBoDefId);
        HashMap<String, String> relIdMap = new HashMap<String, String>();
        for (BoEntRel boEntRel : boEntRelList) {
            String newRelId = UniqueIdUtil.getSuid();
            relIdMap.put(boEntRel.getId(), newRelId);
            boEntRel.setBoDefid(newBoDefId);
            boEntRel.setId(newRelId);
        }
        for (BoEntRel boEntRel : boEntRelList) {
            boEntRel.setRefEntId((String)entIdMap.get(boEntRel.getRefEntId()));
            String newParentId = (String)relIdMap.get(boEntRel.getParentId());
            boEntRel.setParentId(StringUtil.isEmpty((String)newParentId) ? "0" : newParentId);
            this.bOEntRelManager.create((Model)boEntRel);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"eip:form:boDefAlias"}, key="#defAlias")
    public void phyRemoveAttrById(String attrId, String defAlias) throws Exception {
        String count;
        BoAttribute boAttribute = (BoAttribute)((Object)this.boAttributeManager.getById((Serializable)((Object)attrId)));
        if (boAttribute == null) {
            return;
        }
        BoEnt boEnt = (BoEnt)this.boEntManager.get((Serializable)((Object)boAttribute.getEntId()));
        if (boEnt.isExternal()) {
            throw new BaseException("\u5916\u90e8\u8868\u4e0d\u5141\u8bb8\u7269\u7406\u5220\u9664\u5217");
        }
        String checkSql = "SELECT COUNT(1) as count FROM " + boEnt.getTableName() + " where " + boAttribute.getFieldName() + " is not null ";
        Map map = this.jdbcTemplate.queryForMap(checkSql);
        if (com.hotent.base.util.BeanUtils.isNotEmpty(map.get("count")) && !"0".equals(count = map.get("count").toString())) {
            throw new MessagePassingException(String.format("\u8868\u3010%s\u3011\u4e2d\u7684\u5b57\u6bb5\u3010%s\u3011\u6570\u636e\u4e0d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u9664\u8be5\u5217", boEnt.getTableName(), boAttribute.getFieldName()));
        }
        this.boAttributeManager.remove((Serializable)((Object)attrId));
        this.tableOperator.dropColumn(boEnt.getTableName(), boAttribute.getFieldName());
        this.boAttributeManager.saveRecordLog(Collections.singletonList(boAttribute), defAlias, "\u7269\u7406\u5220\u9664");
    }

    @Override
    @Transactional
    public CommonResult<String> saveBo(String boData, String boAlias) throws Exception {
        String message = "\u4fdd\u5b58\u6210\u529f";
        JsonNode jsonNode = JsonUtil.toJsonNode((String)boData);
        BoDef boDef = this.getByAlias(boAlias);
        BoEnt boEnt = boDef.getBoEnt();
        ArrayList<BoData> datas = new ArrayList<BoData>();
        if (jsonNode.isArray()) {
            for (JsonNode node : jsonNode) {
                BoData data = BoUtil.transJSON(node);
                data.setBoEnt(boEnt);
                data.setBoDef(boDef);
                datas.add(data);
            }
        } else {
            BoData data = BoUtil.transJSON(jsonNode);
            data.setBoEnt(boEnt);
            data.setBoDef(boDef);
            datas.add(data);
        }
        BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
        ThreadMsgUtil.addMapMsg((String)"ignore_form_data_rev", (String)"true");
        for (BoData data : datas) {
            List<BoResult> resultList = handler.save(MapUtil.getStringIgnoreKey(data.getData(), (String)boEnt.getPkKey(), (String)""), "", data);
            if (!com.hotent.base.util.BeanUtils.isNotEmpty(resultList)) continue;
            ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
            for (BoResult result : resultList) {
                list.add((ObjectNode)JsonUtil.toJsonNode((Object)result));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            ArrayNode boResult = JsonUtil.listToArrayNode(list);
            params.put("boResult", boResult);
            params.put("data", data);
            ((BpmRuntimeFeignService)AppUtil.getBean(BpmRuntimeFeignService.class)).handleBoDateModify(params);
        }
        ThreadMsgUtil.clean();
        return new CommonResult(message);
    }

    @Override
    @Transactional
    public CommonResult<String> deleteBo(String ids, String boAlias) {
        String[] idList = ids.split(",");
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)idList)) {
            BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
            handler.removeBoData(boAlias, idList);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @Override
    public PageList<Map<String, Object>> listJsonByAlias(String boAlias, String boEntName, QueryFilter<BoDef> queryFilter) {
        BoDef boDef = this.getByAlias(boAlias);
        List<BoEnt> boEnts = this.boEntManager.getByDefId(boDef.getId());
        if (com.hotent.base.util.BeanUtils.isEmpty(boEnts = boEnts.stream().filter(boEnt -> boEnt.getName().equalsIgnoreCase(boEntName)).collect(Collectors.toList()))) {
            throw new BaseException(String.format("\u5f53\u524d\u5efa\u6a21\u4e0d\u5b58\u5728 %s  \u5b9e\u4f53", boEntName));
        }
        String tableName = boEnts.get(0).getTableName();
        String sql = String.format("select * from %s", tableName);
        return this.commonManager.queryByCustomSql(sql, queryFilter);
    }

    @Override
    public CommonResult<Object> queryTableExist(String querys) throws Exception {
        JsonNode jsonNode = JsonUtil.toJsonNode((String)querys);
        if (jsonNode != null && jsonNode.isArray()) {
            ArrayNode array = (ArrayNode)jsonNode;
            array.forEach(a -> {
                String dsName = JsonUtil.getString((JsonNode)a, (String)"dsName");
                String tableName = JsonUtil.getString((JsonNode)a, (String)"tableName");
                if (StringUtil.isNotEmpty((String)tableName)) {
                    ObjectNode obj = (ObjectNode)a;
                    boolean tableExist = false;
                    tableExist = StringUtil.isEmpty((String)dsName) || "LOCAL".contentEquals(dsName) ? this.tableOperator.isTableExist(tableName) : ((Boolean)this.databaseContext.switchDS(dsName, () -> this.tableOperator.isTableExist(tableName), e -> {
                        throw new BoBaseException(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    })).booleanValue();
                    obj.put("tableExists", tableExist);
                }
            });
        }
        return new CommonResult(true, "", (Object)jsonNode);
    }

    @Override
    public CommonResult<Boolean> createTableByEntId(String entId) throws Exception {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)entId), (String)"\u901a\u8fc7entId\u521b\u5efa\u7269\u7406\u8868\u65f6entId\u4e0d\u80fd\u4e3a\u7a7a");
        BoEnt boEnt = this.boEntManager.getById(entId);
        ArrayList<BoEnt> list = new ArrayList<BoEnt>();
        list.add(boEnt);
        this.createTables(list);
        return new CommonResult(true, "", (Object)true);
    }

    @Override
    public BoEnt getMainByBoCode(String boCode) {
        return this.boEntManager.getMainByBoCode(boCode);
    }

    @Override
    public PageList<BoDef> queryByPage(QueryFilter<BoDef> queryFilter) {
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)queryFilter.getSorter())) {
            queryFilter.getSorter().add(new FieldSort("createTime", Direction.DESC));
        }
        return new PageList(((BoDefDao)this.baseMapper).queryByPage((IPage<BoDef>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BoDef>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Override
    public List<String> checkExistBoEnt(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        list.forEach(alias -> {
            BoEnt boEnt = this.boEntManager.getByName((String)alias);
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)boEnt))) {
                result.add(boEnt.getName());
            }
        });
        return result;
    }

    @Override
    public Map<String, String> getEntIdMap(List<BoDef> boDefs, Map<String, String> nameMap) {
        HashMap<String, String> entIdMap = new HashMap<String, String>();
        if (com.hotent.base.util.BeanUtils.isNotEmpty(boDefs)) {
            return entIdMap;
        }
        for (BoDef def : boDefs) {
            if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)def.getBoEnt()))) continue;
            this.putEntIdMap(Collections.singletonList(def.getBoEnt()), nameMap, entIdMap);
        }
        return entIdMap;
    }

    @Override
    public void updateEntId(List<BoDef> boDefs, ObjectNode expand) {
        HashMap<String, BoEnt> boEntMap = new HashMap<String, BoEnt>();
        for (BoDef boDef : boDefs) {
            boEntMap.put(boDef.getAlias(), boDef.getBoEnt());
        }
        JsonNode list = expand.get("list");
        for (JsonNode jsonNode : list) {
            JsonNode jsonNode2 = jsonNode.get("boDefAlias");
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)jsonNode2) || StringUtil.isEmpty((String)jsonNode2.asText())) continue;
            String boDefAlias = jsonNode2.asText();
            ObjectNode objectNode = (ObjectNode)jsonNode;
            objectNode.put("entId", ((BoEnt)((Object)boEntMap.get(boDefAlias))).getId());
        }
    }

    @Override
    public PageList<BoDef> querySelectorsByPage(QueryFilter<BoDef> queryFilter) {
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)queryFilter.getSorter())) {
            queryFilter.getSorter().add(new FieldSort("createTime", Direction.DESC));
        }
        return new PageList(((BoDefDao)this.baseMapper).querySelectorsByPage((IPage<BoDef>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BoDef>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Override
    @CachePut(value={"eip:form:subDataTemp"}, key="#key", ignoreException=false, firstCache=@FirstCache(expireTime=30, timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=30, timeUnit=TimeUnit.SECONDS))
    public String saveSubDataTemp(String key, String subData) {
        return subData;
    }

    @Override
    @Cacheable(value={"eip:form:subDataTemp"}, key="#key")
    public String getSubDataTemp(String key) {
        return "";
    }

    private void putEntIdMap(List<BoEnt> ents, Map<String, String> nameMap, Map<String, String> entIdMap) {
        if (com.hotent.base.util.BeanUtils.isNotEmpty(ents)) {
            return;
        }
        for (BoEnt ent : ents) {
            if (com.hotent.base.util.BeanUtils.isNotEmpty(ent.getBoAttrList())) {
                if (com.hotent.base.util.BeanUtils.isNotEmpty(nameMap)) {
                    entIdMap.put(nameMap.get(ent.getName()), ent.getId());
                } else {
                    entIdMap.put(ent.getName(), ent.getBoAttrList().get(0).getEntId());
                }
            }
            this.putEntIdMap(ent.getChildEntList(), nameMap, entIdMap);
        }
    }
}

