/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bo.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.BooleanUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BaseContextThreadUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.exception.BoBaseException;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class BoUtil {
    private static Pattern pattern = Pattern.compile("(\\$\\{[^\\}]+})");
    public static final List<String> NUMBER_TYPE_LIST = Arrays.asList("number", "numeric");
    public static final List<String> CHAR_TYPE_LIST = Collections.singletonList("varchar");
    public static final List<String> CLOB_TYPE_LIST = Arrays.asList("clob", "text");
    public static final List<String> DATE_TYPE_LIST = Arrays.asList("datetime", "date");
    public static final List<String> ATTR_TYPE_LIST = Arrays.asList("varchar", "number", "date", "clob", "numeric", "text", "datetime");

    public static BoData transJSON(JsonNode jsonNode) {
        BoData data = new BoData();
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            ArrayNode arys;
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (jNode.isArray() && key.startsWith("sub_")) {
                arys = (ArrayNode)jNode;
                arys.forEach(t -> {
                    BoData transResult = BoUtil.transJSON(t);
                    data.addSubRow(key.replaceFirst("sub_", ""), transResult);
                });
                continue;
            }
            if (jNode.isTextual()) {
                data.set(key, jNode.asText());
                continue;
            }
            if (jNode.isInt()) {
                data.set(key, jNode.asInt());
                continue;
            }
            if (jNode.isLong()) {
                data.set(key, jNode.asLong());
                continue;
            }
            if (jNode.isArray()) {
                arys = (ArrayNode)jNode;
                data.set(key, arys.toString().replace("\"", ""));
                continue;
            }
            data.set(key, jNode);
        }
        return data;
    }

    public static JsonNode transJsonNode(JsonNode jsonNode) {
        ObjectNode data = JsonUtil.getMapper().createObjectNode();
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (jNode.isArray()) {
                boolean isCheck = false;
                if (BeanUtils.isNotEmpty((Object)jNode)) {
                    for (JsonNode fxk : jNode) {
                        if (fxk.isObject()) continue;
                        isCheck = true;
                        break;
                    }
                }
                if (!isCheck && key.contains("sub_")) {
                    String tmp = key.replaceFirst("sub_", "");
                    ObjectNode subNode = (ObjectNode)data.get("subMap");
                    if (BeanUtils.isEmpty((Object)subNode)) {
                        subNode = JsonUtil.getMapper().createObjectNode();
                    }
                    subNode.set(tmp, jNode);
                    data.set("subMap", (JsonNode)subNode);
                    continue;
                }
                data.set(key, jNode);
                continue;
            }
            data.set(key, jNode);
        }
        return data;
    }

    public static ObjectNode toJSON(BoData boData, boolean needInitData) throws IOException {
        HashMap<String, Map<String, Object>> initMap = new HashMap<String, Map<String, Object>>();
        ObjectNode json = BoUtil.toJSON(boData, initMap);
        if (needInitData) {
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            for (Map.Entry entry : initMap.entrySet()) {
                String key = (String)entry.getKey();
                ObjectNode rowJson = JsonUtil.getMapper().createObjectNode();
                for (Map.Entry row : ((Map)entry.getValue()).entrySet()) {
                    Object value = row.getValue();
                    JsonNode oNode = JsonUtil.toJsonNode(value);
                    rowJson.set((String)row.getKey(), oNode);
                }
                objectNode.set(key, (JsonNode)rowJson);
            }
            json.set("initData", (JsonNode)objectNode);
        }
        return json;
    }

    private static ObjectNode toJSON(BoData boData, Map<String, Map<String, Object>> initMap) throws IOException {
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        for (Map.Entry<String, Object> entry : boData.getData().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (BeanUtils.isNotEmpty((Object)value)) {
                BoAttribute attribute;
                objectNode.set(key, BeanUtils.isNotEmpty((Object)value) ? JsonUtil.toJsonNode((Object)value) : null);
                if (boData.getBoEnt() == null || !CollUtil.isNotEmpty(boData.getBoEnt().getBoAttrList()) || key.endsWith("[default]") || (attribute = (BoAttribute)boData.getBoEnt().getBoAttrList().stream().filter(attr -> key.equals(attr.getName())).findFirst().orElse(null)) == null || !StringUtil.isNotEmpty((String)attribute.getDefaultValue())) continue;
                objectNode.put(entry.getKey() + "[default]", attribute.getDefaultValue());
                continue;
            }
            objectNode.put(entry.getKey(), "");
        }
        Map<String, List<BoData>> subMap = boData.getSubMap();
        for (Map.Entry<String, List<BoData>> ent : subMap.entrySet()) {
            ArrayNode aNode = JsonUtil.getMapper().createArrayNode();
            for (BoData obj : ent.getValue()) {
                aNode.add((JsonNode)BoUtil.toJSON(obj, initMap));
            }
            objectNode.set("sub_" + ent.getKey(), (JsonNode)aNode);
        }
        initMap.putAll(boData.getInitDataMap());
        return objectNode;
    }

    public static ObjectNode hanlerData(List<BoData> boJsons) throws Exception {
        ObjectNode jsondata = JsonUtil.getMapper().createObjectNode();
        for (BoData boJson : boJsons) {
            ObjectNode json = BoUtil.toJSON(boJson, true);
            jsondata.set(boJson.getBoDefAlias(), (JsonNode)json);
        }
        return jsondata;
    }

    public static boolean verifyBoData(BoData curData, BoDef boDef) throws Exception {
        ArrayList<BoData> boJsons = new ArrayList<BoData>();
        boJsons.add(curData);
        String verifyJson = boDef.getVerifyJson();
        JsonNode verify = JsonUtil.toJsonNode((String)verifyJson);
        ObjectNode objectNode = BoUtil.hanlerData(boJsons);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boData", objectNode);
        params.put("alias", boDef.getAlias());
        List result = ((PortalFeignService)AppUtil.getBean(PortalFeignService.class)).getServiceList();
        HashMap microServiceMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (ObjectNode on : result) {
                microServiceMap.put(on.get("sysCode").asText(), on.get("rootAddress").asText());
            }
        }
        String url = JsonUtil.getString((JsonNode)verify, (String)"url");
        String serviceMode = JsonUtil.getString((JsonNode)verify, (String)"serviceMode");
        String host = (String)microServiceMap.get(serviceMode);
        url = host + url;
        String s = HttpUtil.doPost((String)url, (String)Base64.getBase64((String)JsonUtil.getString((JsonNode)verify, (String)"headerStr")), params);
        return !BooleanUtil.toBoolean((String)s);
    }

    public static Map<String, Object> handlerDesensitizeSettings(String desensitization, String formType) throws IOException {
        HashMap<String, Object> desensiMap = new HashMap<String, Object>();
        if (BeanUtils.isNotEmpty((Object)desensitization)) {
            if (StringUtil.isEmpty((String)formType)) {
                throw new BoBaseException("\u8131\u654f\u5904\u7406\u4e2dformType\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BaseContextThreadUtil.putCommonVars((String)"desensitization", (Object)desensitization);
            BaseContextThreadUtil.putCommonVars((String)"formType", (Object)formType);
            JsonNode desensiNode = JsonUtil.toJsonNode((String)desensitization);
            HashSet<String> desensiIds = new HashSet<String>();
            Iterator iterator = desensiNode.fields();
            HashSet entNameSet = new HashSet();
            HashSet attrNameSet = new HashSet();
            HashSet<String> desensitizationFieldPath = new HashSet<String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                JsonNode tableJson = (JsonNode)entry.getValue();
                entNameSet.add(entry.getKey());
                Iterator tableIterator = tableJson.fields();
                while (tableIterator.hasNext()) {
                    Map.Entry fieldJson = (Map.Entry)tableIterator.next();
                    JsonNode fieldJsonNode = (JsonNode)fieldJson.getValue();
                    if (!fieldJsonNode.hasNonNull(formType)) continue;
                    desensiIds.add(fieldJsonNode.get(formType).asText());
                    attrNameSet.add(fieldJson.getKey());
                    desensitizationFieldPath.add(String.format("%s.%s", entry.getKey(), fieldJson.getKey()));
                }
            }
            if (!(desensiIds.isEmpty() || entNameSet.isEmpty() || attrNameSet.isEmpty())) {
                Map<String, Object> desensiRuleMap = BoUtil.getDesensiMap(desensiIds.stream().collect(Collectors.toList()));
                HashMap<String, String> entNameMap = new HashMap<String, String>();
                HashMap<String, String> attrMap = new HashMap<String, String>();
                BoAttributeManager boAttributeManager = (BoAttributeManager)AppUtil.getBean(BoAttributeManager.class);
                List<Map<String, String>> dataBaseAttrs = boAttributeManager.getBoDatabaseAttr(new ArrayList<String>(entNameSet), new ArrayList<String>(attrNameSet));
                if (BeanUtils.isNotEmpty(dataBaseAttrs)) {
                    for (Map<String, String> map : dataBaseAttrs) {
                        String entName = map.get("entname");
                        String attrname = map.get("attrname");
                        entNameMap.put(entName, map.get("tablename"));
                        attrMap.put(String.format("%s.%s", entName, attrname), map.get("fieldname"));
                    }
                }
                Iterator desensiIterator = desensiNode.fields();
                while (desensiIterator.hasNext()) {
                    Map.Entry desensiEntry = (Map.Entry)desensiIterator.next();
                    String tname = (String)desensiEntry.getKey();
                    if (!entNameMap.containsKey(tname)) continue;
                    HashMap<String, Object> fieldDesensiMap = new HashMap<String, Object>();
                    JsonNode desensiTableJson = (JsonNode)desensiEntry.getValue();
                    Iterator desensiTableIterator = desensiTableJson.fields();
                    while (desensiTableIterator.hasNext()) {
                        Map.Entry desensiFieldJson = (Map.Entry)desensiTableIterator.next();
                        JsonNode fieldJsonNode = (JsonNode)desensiFieldJson.getValue();
                        if (!fieldJsonNode.hasNonNull(formType)) continue;
                        String tablename = (String)attrMap.get(String.format("%s.%s", tname, desensiFieldJson.getKey()));
                        Object rule = desensiRuleMap.get(fieldJsonNode.get(formType).textValue());
                        if (!StringUtil.isNotEmpty((String)tablename) || !BeanUtils.isNotEmpty((Object)rule)) continue;
                        fieldDesensiMap.put(tablename, rule);
                    }
                    if (fieldDesensiMap.isEmpty()) continue;
                    desensiMap.put((String)entNameMap.get(tname), fieldDesensiMap);
                }
                if (!desensiMap.isEmpty()) {
                    BaseContextThreadUtil.putCommonVars((String)"desensitizationMap", desensiMap);
                    BaseContextThreadUtil.putCommonVars((String)"desensitizationFieldPath", desensitizationFieldPath);
                }
            }
        }
        return desensiMap;
    }

    private static Map<String, Object> getDesensiMap(List<String> ids) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PortalFeignService feignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        List list = feignService.getDesensiRulesByIds(ids);
        if (BeanUtils.isNotEmpty((Object)list)) {
            list.forEach(item -> {
                try {
                    JsonNode node = JsonUtil.toJsonNode((Object)item);
                    map.put(node.get("id").asText(), node);
                }
                catch (IOException e) {
                    throw new WorkFlowException(e.getMessage());
                }
            });
        }
        return map;
    }

    public static List<BoEnt> boTree2List(List<BoEnt> ents, Function<BoEnt, List<BoEnt>> childSupplier) {
        ArrayList<BoEnt> result = new ArrayList<BoEnt>();
        if (BeanUtils.isEmpty(ents)) {
            return result;
        }
        for (BoEnt ent : ents) {
            BoUtil.recursionTreeChildren(ent, result, childSupplier);
            result.add(ent);
        }
        return result;
    }

    private static void recursionTreeChildren(BoEnt ent, List<BoEnt> result, Function<BoEnt, List<BoEnt>> childSupplier) {
        if (BeanUtils.isEmpty((Object)((Object)ent)) || BeanUtils.isEmpty(childSupplier.apply(ent))) {
            return;
        }
        for (BoEnt child : childSupplier.apply(ent)) {
            if (BeanUtils.isNotEmpty(childSupplier.apply(child))) {
                BoUtil.recursionTreeChildren(child, result, childSupplier);
            }
            result.add(child);
        }
    }

    public static void handlerSubMap(BoData curData, ObjectNode boData) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode subMapNode = (ObjectNode)boData.get("subMap");
        Iterator fields = subMapNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (!jNode.isArray()) continue;
            ArrayList<BoData> datas = new ArrayList<BoData>();
            for (JsonNode jsonNode : jNode) {
                Iterator subFields = jsonNode.fields();
                BoData data = new BoData();
                HashMap sunBoDataMap = new HashMap();
                while (subFields.hasNext()) {
                    Map.Entry subNext = (Map.Entry)subFields.next();
                    String subkey = (String)subNext.getKey();
                    data.set(subkey, subNext.getValue());
                    if (!subkey.startsWith("sub_") || !BeanUtils.isNotEmpty(subNext.getValue())) continue;
                    JsonNode sunNode = (JsonNode)subNext.getValue();
                    ArrayList<BoData> sunBoDatas = new ArrayList<BoData>();
                    for (JsonNode itemNode : sunNode) {
                        BoData sunData = new BoData();
                        Iterator sunFields = itemNode.fields();
                        while (sunFields.hasNext()) {
                            Map.Entry sunNext = (Map.Entry)sunFields.next();
                            String sunkey = (String)sunNext.getKey();
                            sunData.set(sunkey, sunNext.getValue());
                        }
                        BoData bb = (BoData)JsonUtil.toBean((String)JsonUtil.toJson((Object)sunData), BoData.class);
                        sunBoDatas.add(bb);
                    }
                    sunBoDataMap.put(subkey, sunBoDatas);
                }
                BoData aa = (BoData)JsonUtil.toBean((String)JsonUtil.toJson((Object)data), BoData.class);
                if (!sunBoDataMap.isEmpty()) {
                    for (String sunKey : sunBoDataMap.keySet()) {
                        aa.setSubList(sunKey, (List)sunBoDataMap.get(sunKey));
                    }
                }
                datas.add(aa);
            }
            curData.setSubList(key, datas);
        }
    }
}

