/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bo.instance.impl;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.instance.BoDataHandler;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.model.BoResult;
import com.hotent.bo.persistence.manager.BoDefManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public abstract class AbstractBoDataHandler
implements BoDataHandler {
    @Resource
    BoDefManager boDefManager;

    public void setBoDefAlias(List<BoResult> resultList, String bodefAlias) {
        for (BoResult result : resultList) {
            result.setBoAlias(bodefAlias);
        }
    }

    @Override
    public BoData getByBoDefAlias(String bodefAlias) {
        BoDef boDef = this.boDefManager.getByAlias(bodefAlias);
        if (BeanUtils.isEmpty((Object)boDef)) {
            return null;
        }
        BoData boData = new BoData();
        boData.setBoDef(boDef);
        BoEnt boEnt = boDef.getBoEnt();
        Map<String, Object> row = this.getMapByBOEnt(boEnt, false);
        boData.setData(row);
        this.getCascadeByEnt(boEnt, boData, false);
        return boData;
    }

    public Map<String, Object> getMapByBOEnt(BoEnt boEnt, Boolean getPk) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<BoAttribute> list = boEnt.getBoAttrList();
        for (BoAttribute attr : list) {
            String val = attr.getDefaultValue();
            if (StringUtil.isEmpty((String)val) || "NULL".equals(val)) {
                val = "";
            }
            map.put(attr.getName(), val);
            if (!StringUtil.isNotEmpty((String)val) || attr.getName().endsWith("[default]")) continue;
            map.put(attr.getName() + "[default]", val);
        }
        String pkKey = boEnt.getPkKey();
        if (getPk.booleanValue() && !MapUtil.containsIgnoreKey(map, (String)pkKey)) {
            map.put(pkKey, "");
        }
        return map;
    }

    private void getCascadeByEnt(BoEnt boEnt, BoData boData, Boolean getPk) {
        List<BoEnt> childEntList = boEnt.getChildEntList();
        if (BeanUtils.isEmpty(childEntList)) {
            return;
        }
        for (BoEnt childEnt : childEntList) {
            String key = childEnt.getName();
            Map<String, Object> childEntInitData = childEnt.getInitData();
            if (getPk.booleanValue() && !MapUtil.containsIgnoreKey(childEntInitData, (String)childEnt.getPkKey())) {
                childEntInitData.put(childEnt.getPkKey(), null);
            }
            if ("main".equals(boEnt.getType())) {
                boData.addInitDataMap(key, childEntInitData);
                boData.setSubList(key, new ArrayList<BoData>());
            } else {
                Map<String, Object> subInitMap = boData.getInitDataMap().get(boEnt.getName());
                Map<String, Map<String, Object>> subInitDataMap = new HashMap<String, Map<String, Object>>();
                if (BeanUtils.isNotEmpty(subInitMap) && subInitMap.containsKey("initData")) {
                    subInitDataMap = (Map)subInitMap.get("initData");
                }
                subInitDataMap.put(childEnt.getName(), childEntInitData);
                HashMap<String, Cloneable> subboEntMap = new HashMap<String, Cloneable>();
                subboEntMap.put("initData", (Cloneable)((Object)subInitDataMap));
                subboEntMap.put("sub_" + childEnt.getName(), new ArrayList());
                boData.getInitDataMap().get(boEnt.getName()).putAll(subboEntMap);
            }
            this.getCascadeByEnt(childEnt, boData, getPk);
        }
    }

    @Override
    public BoData getByBoDefCode(String bodefCode, Boolean getPk) {
        BoDef boDef = this.boDefManager.getByAlias(bodefCode);
        return this.getByBoDef(boDef, getPk);
    }

    @Override
    public BoData getByBoDef(BoDef boDef, Boolean getPk) {
        BoData boData = new BoData();
        boData.setBoDef(boDef);
        boData.setBoDefAlias(boDef.getAlias());
        BoEnt boEnt = boDef.getBoEnt();
        Map<String, Object> row = this.getMapByBOEnt(boEnt, getPk);
        boData.setData(row);
        this.getCascadeByEnt(boEnt, boData, getPk);
        return boData;
    }
}

