/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bo.instance.impl;

import cn.hutool.core.date.StopWatch;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.dto.PortalDataSensitive;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BaseContextThreadUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bo.context.FormContextThreadUtil;
import com.hotent.bo.exception.BoBaseException;
import com.hotent.bo.instance.impl.AbstractBoDataHandler;
import com.hotent.bo.model.BatchBoResult;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDataRel;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.model.BoResult;
import com.hotent.bo.model.SqlModel;
import com.hotent.bo.persistence.dao.BoDataRelDao;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.bo.util.BoUtil;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.util.MetaDataUtil;
import com.hotent.uc.api.util.IPermissionCalc;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="boDataHandler")
public class BoDbHandlerImpl
extends AbstractBoDataHandler {
    private Logger logger = LoggerFactory.getLogger(BoDbHandlerImpl.class);
    @Resource
    DatabaseContext databaseContext;
    @Resource
    BoDataRelDao boDataRelDao;
    @Resource
    CommonManager commonManager;
    @Resource
    BoEntManager boEntManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    IPermissionCalc permissionCalc;

    @Override
    public List<BoResult> save(String id, String defId, BoData curData) {
        BoEnt boEnt = curData.getBoEnt();
        Map<String, Object> row = curData.getData();
        String pk = "";
        if (boEnt != null) {
            pk = boEnt.getPkKey().toLowerCase();
            if (StringUtil.isNotEmpty((String)id)) {
                row.put(pk, id);
            }
        }
        boolean forceUpdate = "true".equals(ThreadMsgUtil.getMapMsg((String)"boSaveCreateSave"));
        ArrayList<BoResult> resultList = new ArrayList<BoResult>();
        try {
            if (row.containsKey(pk) && !forceUpdate) {
                this.update(curData, resultList);
            } else {
                BoDef boDef = this.boDefManager.getByAlias(curData.getBoDefAlias());
                if (BeanUtils.isNotEmpty((Object)boDef) && StringUtil.isNotEmpty((String)boDef.getVerifyJson()) && BoUtil.verifyBoData(curData, boDef)) {
                    throw new BaseException("\u5efa\u6a21\u6821\u9a8c\u5931\u8d25");
                }
                if (row.containsKey(BoEnt.FK_NAME.toLowerCase())) {
                    this.add(curData, resultList, String.valueOf(row.get(BoEnt.FK_NAME.toLowerCase())));
                } else {
                    this.add(curData, resultList, "0");
                }
            }
            this.batchHandleBoResult(resultList);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            String exceptionStr = ex.getMessage().substring(ex.getMessage().indexOf(":") + 1);
            throw new NumberFormatException(exceptionStr + "\u975e\u6570\u5b57\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u6570\u503c\uff01");
        }
        catch (MessagePassingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        if (curData.getBoDef() != null) {
            this.setBoDefAlias(resultList, curData.getBoDef().getAlias());
        }
        return resultList;
    }

    private void batchHandleBoResult(List<BoResult> resultList) {
        StopWatch stopWatch = StopWatch.create((String)"\u6279\u91cf\u4fdd\u5b58");
        Map<String, List<BoResult>> mapBoResult = ((List)Optional.ofNullable(resultList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(boResult -> boResult.getAction() + boResult.getTableName()));
        mapBoResult.forEach(this::batchExecute);
        stopWatch.prettyPrint();
    }

    private void batchExecute(String actionTableName, List<BoResult> boResults) {
        if (actionTableName.startsWith("add")) {
            List batchParams = boResults.stream().map(BoResult::getValuesMap).collect(Collectors.toList());
            BoResult boResult = boResults.get(0);
            BoEnt currentBoEnt = boResult.getBoEnt();
            this.batchExecuteSql(boResult, currentBoEnt, batchParams, "add");
        } else if (actionTableName.startsWith("upd")) {
            List batchParams = boResults.stream().map(BoResult::getValuesMap).collect(Collectors.toList());
            BoResult boResult = boResults.get(0);
            BoEnt currentBoEnt = boResult.getBoEnt();
            this.batchExecuteSql(boResult, currentBoEnt, batchParams, "upd");
        } else if (actionTableName.startsWith("del")) {
            List batchParams = boResults.stream().map(BoResult::getPk).collect(Collectors.toList());
            BoResult boResult = boResults.get(0);
            BoEnt currentBoEnt = boResult.getBoEnt();
            this.batchExecuteSql(boResult, currentBoEnt, batchParams, "del");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void batchExecuteSql(BoResult boResult, BoEnt boEnt, Object batchParams, String action) {
        ignoreDataVersion = "main".equals(boEnt.getType()) == false;
        update = 0;
        if (!boEnt.isExternal()) {
            try {
                if ("add".equals(action)) {
                    update = this.commonManager.batchInsert(boResult.getTableName(), (List)batchParams);
                }
                if ("upd".equals(action)) {
                    update = this.commonManager.batchUpdate(boResult.getTableName(), boEnt.getPkKey(), (List)batchParams, Boolean.valueOf(ignoreDataVersion));
                }
                if (!"del".equals(action)) ** GOTO lbl20
                update = this.commonManager.batchDelete(boResult.getTableName(), boEnt.getPkKey(), (List)batchParams);
            }
            catch (DuplicateKeyException ex) {
                this.handleExceptionMsg(boEnt, ex);
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        } else {
            update = (Integer)this.databaseContext.switchDS(boEnt.getDsName(), (Supplier<Integer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$batchExecuteSql$1(java.lang.String com.hotent.bo.model.BoResult java.lang.Object com.hotent.bo.model.BoEnt boolean ), ()Ljava/lang/Integer;)((BoDbHandlerImpl)this, (String)action, (BoResult)boResult, (Object)batchParams, (BoEnt)boEnt, (boolean)ignoreDataVersion), (Consumer<Exception>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$batchExecuteSql$2(com.hotent.bo.model.BoEnt java.lang.Exception ), (Ljava/lang/Exception;)V)((BoDbHandlerImpl)this, (BoEnt)boEnt));
        }
lbl20:
        // 6 sources

        if (!"true".equals(ThreadMsgUtil.getMapMsg((String)"ignore_form_data_rev")) && "main".equals(boEnt.getType()) && "upd".equals(action) && update != ((List)batchParams).size()) {
            throw new BaseException(ResponseErrorEnums.FORM_DATA_MODIFY);
        }
    }

    private void handleExceptionMsg(BoEnt boEnt, DuplicateKeyException ex) {
        Throwable cause = ex.getCause();
        String dsName = boEnt.getDsName();
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = "LOCAL";
        }
        if (cause instanceof SQLIntegrityConstraintViolationException) {
            List tables = (List)this.databaseContext.switchDS(dsName, dsResult -> {
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dsResult.getDbType());
                return baseTableMeta.getTablesByNameIndex(boEnt.getTableName());
            }, e -> {
                throw new BaseException(e.getMessage(), (Throwable)e);
            });
            String errMsg = cause.getMessage();
            if (StringUtils.isNotBlank((String)errMsg)) {
                String customMsg = "";
                if (BeanUtils.isNotEmpty((Object)tables)) {
                    HashSet result = new HashSet(tables);
                    for (Map table : result) {
                        String comment;
                        String keyName = table.get("keyName") == null ? "" : table.get("keyName").toString();
                        String string = comment = table.get("indexComment") == null ? "" : table.get("indexComment").toString();
                        if (StringUtil.isEmpty((String)comment)) {
                            comment = keyName;
                        }
                        if (!errMsg.contains(keyName)) continue;
                        String concatChar = StringUtil.isEmpty((String)customMsg) ? "" : ",";
                        customMsg = customMsg + concatChar + comment;
                    }
                }
                if (StringUtil.isEmpty((String)customMsg)) {
                    customMsg = "\u60a8\u586b\u5199\u7684\u5185\u5bb9\u6709\u91cd\u590d\uff0c\u8bf7\u6838\u67e5\uff01";
                }
                throw new BaseException(customMsg);
            }
        }
        throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + ex.getMessage(), ex);
    }

    private void handleExceptionMsg(BoEnt boEnt, DataIntegrityViolationException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof DataTruncation) {
            this.logger.error("\u6570\u636e\u64cd\u4f5c\u5f02\u5e38", (Throwable)ex);
            throw new BaseException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519, \u539f\u56e0\u4e3a\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff01");
        }
    }

    @Override
    public BoData getById(Object pk, String bodefCode) {
        BoDef boDef = this.boDefManager.getByAlias(bodefCode);
        return this.getByIdAndBoDef(pk, boDef);
    }

    @Override
    public BoData getByIdAndBoDef(Object pk, BoDef boDef) {
        BoData boData = new BoData();
        boData.setBoDef(boDef);
        BoEnt boEnt = boDef.getBoEnt();
        boData.setBoEnt(boEnt);
        Map<String, Object> row = this.getById(boEnt, pk);
        boData.setData(row);
        this.handleChild(pk, boEnt, boData);
        return boData;
    }

    @Override
    public BoData getDataTemplateById(Object pk, String bodefCode) {
        BoDef boDef = this.boDefManager.getByAlias(bodefCode);
        BoData boData = new BoData();
        boData.setBoDef(boDef);
        BoEnt boEnt = boDef.getBoEnt();
        boData.setBoEnt(boEnt);
        Map<Object, Object> row = Maps.newHashMap();
        try {
            row = this.getById(boEnt, pk);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        boData.setData(row);
        this.handleChild(pk, boEnt, boData);
        return boData;
    }

    private void handleChild(Object pk, BoEnt boEnt, BoData boData) {
        List<BoEnt> childEntList = boEnt.getChildEntList();
        for (BoEnt childEnt : childEntList) {
            List<Map<String, Object>> list = this.getByFk(childEnt, pk);
            String key = childEnt.getName();
            ArrayList<BoData> listData = new ArrayList<BoData>();
            List<BoEnt> sunEntList = childEnt.getChildEntList();
            Map<String, Object> initData = childEnt.getInitData();
            HashMap<String, Map<String, List<Map<String, Object>>>> allMapSunList = new HashMap<String, Map<String, List<Map<String, Object>>>>();
            if (BeanUtils.isNotEmpty(sunEntList)) {
                HashMap<String, Map<String, Object>> sunInitData = new HashMap<String, Map<String, Object>>();
                for (BoEnt sunEnt : sunEntList) {
                    initData.put("sub_" + sunEnt.getName(), new ArrayList());
                    sunInitData.put(sunEnt.getName(), sunEnt.getInitData());
                    Map<String, List<Map<String, Object>>> mapSunList = this.getSunList(childEnt, sunEnt, pk);
                    allMapSunList.put(sunEnt.getName(), mapSunList);
                }
                initData.put("initData", sunInitData);
            }
            for (Map<String, Object> rowMap : list) {
                BoData childData = new BoData();
                Map<String, Object> rtnMap = this.convertDbToData(childEnt, rowMap, false);
                childData.setData(rtnMap);
                if (BeanUtils.isNotEmpty(sunEntList)) {
                    String subPkStr = StringUtil.isNotEmpty((String)childEnt.getPk()) ? childEnt.getPk() : BoEnt.PK_NAME;
                    Object subPkVal = rowMap.get(subPkStr);
                    String subPk = subPkVal instanceof BigDecimal ? ((BigDecimal)subPkVal).toPlainString() : (String)subPkVal;
                    if (StringUtil.isEmpty((String)subPk) && StringUtil.isNotEmpty((String)subPkStr)) {
                        subPk = (String)rowMap.get(subPkStr.toLowerCase());
                    }
                    for (BoEnt sunEnt : sunEntList) {
                        if (!BeanUtils.isNotEmpty(allMapSunList) || !BeanUtils.isNotEmpty(allMapSunList.get(sunEnt.getName())) || !((Map)allMapSunList.get(sunEnt.getName())).containsKey(subPk)) continue;
                        List sunList = (List)((Map)allMapSunList.get(sunEnt.getName())).get(subPk);
                        String sunKey = sunEnt.getName();
                        ArrayList<BoData> sunListData = new ArrayList<BoData>();
                        for (Map sunRowMap : sunList) {
                            BoData sunData = new BoData();
                            Map<String, Object> sunRtnMap = this.convertDbToData(sunEnt, sunRowMap, false);
                            sunData.setData(sunRtnMap);
                            sunListData.add(sunData);
                        }
                        childData.addInitDataMap(sunKey, sunEnt.getInitData());
                        childData.setSubList(sunKey, sunListData);
                    }
                }
                listData.add(childData);
            }
            boData.addInitDataMap(key, initData);
            boData.setSubList(key, listData);
        }
    }

    private Map<String, List<Map<String, Object>>> getSunList(BoEnt childEnt, BoEnt boEnt, Object pk) {
        List<Map<String, Object>> list;
        String sql;
        ObjectNode subRowAuthJosn = null;
        if (BeanUtils.isNotEmpty((Object)FormContextThreadUtil.getCommuVar("subRowAuthJosn", ""))) {
            try {
                ObjectNode curTab = (ObjectNode)JsonUtil.toJsonNode((String)((String)FormContextThreadUtil.getCommuVar("subRowAuthJosn", "")));
                subRowAuthJosn = (ObjectNode)curTab.get(boEnt.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashSet totalAuth = new HashSet();
        HashMap varMap = new HashMap();
        String fk = boEnt.getFk();
        if (boEnt.getType().equals("manytomany")) {
            sql = "select A.* from " + boEnt.getTableName() + " A , form_bo_data_relation B where  B.SUB_BO_NAME = '" + boEnt.getName() + "' AND A." + boEnt.getPk() + "=B.FK_  AND B.PK_=?";
            list = this.executeQuery(boEnt, sql, pk);
        } else {
            if (StringUtil.isEmpty((String)fk)) {
                throw new RuntimeException("\u901a\u8fc7\u6dfb\u52a0\u5916\u90e8\u8868\u6784\u5efa\u4e1a\u52a1\u5bf9\u8c61\u65f6\u5fc5\u987b\u6307\u5b9a\u5916\u952e");
            }
            String childIds = this.getIdsByBoEnt(childEnt, pk);
            sql = StringUtil.isNotEmpty((String)childIds) ? String.format("select A.* from " + boEnt.getTableName() + " A  where A." + fk + " in (%s)", childIds) : "select * from " + boEnt.getTableName();
            list = this.executeQuery(boEnt, sql);
        }
        this.decryptResult(boEnt, list);
        Map<String, List<Map<String, Object>>> resultSunList = list.stream().collect(Collectors.groupingBy(map -> String.valueOf(MapUtil.getIgnoreCase((Map)map, (String)fk))));
        if (BeanUtils.isEmpty(list) || BeanUtils.isEmpty((Object)subRowAuthJosn) || totalAuth.contains("w") || StringUtil.isEmpty((String)JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"w.conditionString"))) {
            return resultSunList;
        }
        HashSet<Object> editKeys = new HashSet<Object>();
        String editSql = sql + " and (" + JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"w.conditionString") + ")";
        List<Map<String, Object>> editList = this.executeQuery(boEnt, editSql = StringUtil.getStrByRule((String)editSql, varMap), pk);
        if (BeanUtils.isNotEmpty(editList)) {
            for (Map<String, Object> data : editList) {
                editKeys.add(data.get(BoEnt.PK_NAME));
            }
        }
        for (Map<String, Object> data : list) {
            if (editKeys.contains(data.get(BoEnt.PK_NAME))) {
                data.put(BoEnt.SUB_ROW_READONLY, false);
                continue;
            }
            data.put(BoEnt.SUB_ROW_READONLY, true);
        }
        return resultSunList;
    }

    private String getIdsByBoEnt(BoEnt boEnt, Object pk) {
        String sql = String.format("select %s from %s where %s =?", boEnt.getPkKey(), boEnt.getTableName(), boEnt.getFk());
        List<Map<String, Object>> maps = this.executeQuery(boEnt, sql, pk);
        if (BeanUtils.isEmpty(maps)) {
            return null;
        }
        List ids = maps.stream().map(m -> MapUtil.getIgnoreCase((Map)m, (String)boEnt.getPkKey(), null)).filter(Objects::nonNull).map(pkVal -> {
            if (pkVal instanceof String) {
                return String.format("'%s'", pkVal);
            }
            return pkVal.toString();
        }).collect(Collectors.toList());
        if (BeanUtils.isEmpty(ids)) {
            return null;
        }
        return String.join((CharSequence)",", ids);
    }

    private Map<String, Object> convertDbToData(BoEnt boEnt, Map<String, Object> map) {
        return this.convertDbToData(boEnt, map, true);
    }

    private Map<String, Object> convertDbToData(BoEnt boEnt, Map<String, Object> map, boolean encrypt) {
        Object fFormDataRev;
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> ent : map.entrySet()) {
            String field = ent.getKey().toLowerCase();
            BoAttribute attribute = boEnt.getAttrByField(field);
            if (!BeanUtils.isNotEmpty((Object)((Object)attribute))) continue;
            Object val = this.handValue(attribute, ent.getValue(), encrypt);
            rtnMap.put(attribute.getName(), val);
        }
        if (MapUtil.containsIgnoreKey(map, (String)boEnt.getFieldFFormDataRevWithPrefix())) {
            fFormDataRev = MapUtil.getIgnoreCase(map, (String)boEnt.getFieldFFormDataRevWithPrefix(), (Object)"0");
            rtnMap.put(BoEnt.FORM_DATA_REV, fFormDataRev);
        } else if (MapUtil.containsIgnoreKey(map, (String)BoEnt.FORM_DATA_REV)) {
            fFormDataRev = MapUtil.getIgnoreCase(map, (String)BoEnt.FORM_DATA_REV);
            rtnMap.put(BoEnt.FORM_DATA_REV, fFormDataRev);
        }
        if (map.containsKey(BoEnt.SUB_ROW_READONLY)) {
            rtnMap.put(BoEnt.SUB_ROW_READONLY, map.get(BoEnt.SUB_ROW_READONLY));
        }
        if (!"main".equals(boEnt.getType())) {
            rtnMap.put(BoEnt.SUB_KEY, UUID.randomUUID());
        }
        String pkKey = boEnt.getPkKey();
        if (boEnt.isPkNumber() && BeanUtils.isNotEmpty(rtnMap.get(pkKey))) {
            rtnMap.put(pkKey, rtnMap.get(pkKey).toString());
        }
        return rtnMap;
    }

    private Object handValue(BoAttribute attr, Object val, boolean encrypt) {
        if (BeanUtils.isEmpty((Object)val)) {
            return val;
        }
        if ("date".equals(attr.getDataType())) {
            String format = attr.getFormat();
            if (val instanceof Timestamp) {
                Timestamp times = (Timestamp)val;
                return TimeUtil.getDateTimeString((LocalDateTime)times.toLocalDateTime(), (String)format);
            }
            if (val instanceof Date) {
                return TimeUtil.getDateTimeString((LocalDateTime)DateFormatUtil.parse((Date)((Date)val)), (String)format);
            }
            if (val instanceof LocalDateTime) {
                return TimeUtil.getDateTimeString((LocalDateTime)((LocalDateTime)val), (String)format);
            }
        } else if (("text".equals(attr.getDataType()) || "varchar".equals(attr.getDataType()) || "clob".equals(attr.getDataType())) && attr.getIsEncode() == 1 && encrypt) {
            try {
                return EncryptUtil.decrypt((String)((String)val), (String)"@$ATPW*%");
            }
            catch (Exception e) {
                return val;
            }
        }
        return val;
    }

    private Map<String, Object> getById(BoEnt boEnt, Object pk) {
        String sql = String.format("select * from %s where %s=#{pk}", boEnt.getTableName(), boEnt.getPkKey());
        Object pkVal = boEnt.isPkNumber() ? Long.valueOf(pk.toString()) : pk.toString();
        Map<String, Object> map = this.getOneById(boEnt, sql, pkVal, e -> {
            String errorMsg = "\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a";
            throw new BoBaseException(errorMsg + ExceptionUtils.getRootCauseMessage((Throwable)e));
        });
        return this.convertDbToData(boEnt, map);
    }

    private Map<String, Object> getOneById(BoEnt boEnt, String sql, Object pk, Consumer<Exception> consumer) {
        HashMap<String, Object> buildMap = new HashMap<String, Object>();
        if (BeanUtils.isNotEmpty((Object)pk)) {
            buildMap.put("pk", pk);
        }
        List result = boEnt.isExternal() ? (List)this.databaseContext.switchDS(boEnt.getDsName(), () -> this.commonManager.query(sql, buildMap), consumer) : this.commonManager.query(sql, buildMap);
        Assert.isTrue((BeanUtils.isNotEmpty((Object)result) && result.size() == 1 ? 1 : 0) != 0, (String)"\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u6570\u636e\u65f6\u7ed3\u679c\u4e3a\u7a7a\u6216\u67e5\u8be2\u5230\u8d85\u8fc7\u4e00\u6761\u8bb0\u5f55");
        return (Map)result.get(0);
    }

    private List<Map<String, Object>> getByFk(BoEnt boEnt, Object pk) {
        String pkName;
        String readSql;
        ObjectNode subRowAuthJosn = null;
        if (BeanUtils.isNotEmpty((Object)FormContextThreadUtil.getCommuVar("subRowAuthJosn", ""))) {
            try {
                ObjectNode curTab = (ObjectNode)JsonUtil.toJsonNode((String)((String)FormContextThreadUtil.getCommuVar("subRowAuthJosn", "")));
                subRowAuthJosn = (ObjectNode)curTab.get(boEnt.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String sql = "";
        HashSet<String> totalAuth = new HashSet<String>();
        Map<String, Object> varMap = this.initVarMap();
        if (BeanUtils.isNotEmpty(subRowAuthJosn)) {
            if (boEnt.getType().equals("manytomany")) {
                sql = "select A.* from " + boEnt.getTableName() + " A , form_bo_data_relation B where  B.SUB_BO_NAME = '" + boEnt.getName() + "' AND A." + boEnt.getPk() + "=B.FK_  AND B.PK_=?";
            } else {
                String fk = boEnt.getFk();
                if (StringUtil.isEmpty((String)fk)) {
                    throw new RuntimeException("\u901a\u8fc7\u6dfb\u52a0\u5916\u90e8\u8868\u6784\u5efa\u4e1a\u52a1\u5bf9\u8c61\u65f6\u5fc5\u987b\u6307\u5b9a\u5916\u952e");
                }
                sql = "select * from " + boEnt.getTableName() + " A  where A." + fk + "=?";
            }
            readSql = sql = String.format(sql, boEnt.getFieldsSql("A"));
            ArrayNode total = (ArrayNode)subRowAuthJosn.get("total");
            for (JsonNode jsonNode : total) {
                totalAuth.add(jsonNode.asText());
            }
            if (!totalAuth.contains("r") && StringUtil.isNotEmpty((String)JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"r.conditionString"))) {
                readSql = sql + " and (" + JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"r.conditionString") + ")";
                readSql = StringUtil.getStrByRule((String)readSql, varMap);
            }
        } else {
            ObjectNode objectNode;
            BpmRuntimeFeignService bpmRuntimeFeignService = (BpmRuntimeFeignService)AppUtil.getBean(BpmRuntimeFeignService.class);
            try {
                objectNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)boEnt));
                objectNode.put("selectSql", sql);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String defId = (String)FormContextThreadUtil.getCommuVar("defId", "");
            String nodeId = (String)FormContextThreadUtil.getCommuVar("nodeId", "");
            String parentDefKey = (String)FormContextThreadUtil.getCommuVar("parentDefKey", "local_");
            if (StringUtil.isEmpty((String)defId)) {
                defId = "123";
            }
            CommonResult result = bpmRuntimeFeignService.getSubDataSqlByFk(objectNode, pk, defId, nodeId, parentDefKey);
            readSql = (String)result.getValue();
        }
        List<Map<String, Object>> list = this.executeQuery(boEnt, readSql, pk);
        this.decryptResult(boEnt, list);
        if (BeanUtils.isEmpty(list) || BeanUtils.isEmpty((Object)subRowAuthJosn) || totalAuth.contains("w") || StringUtil.isEmpty((String)JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"w.conditionString"))) {
            return list;
        }
        HashSet<Object> editKeys = new HashSet<Object>();
        String editSql = sql + " and (" + JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"w.conditionString") + ")";
        editSql = StringUtil.getStrByRule((String)editSql, varMap);
        List<Map<String, Object>> editList = this.executeQuery(boEnt, editSql, pk);
        String string = pkName = StringUtil.isEmpty((String)boEnt.getPk()) ? BoEnt.PK_NAME : boEnt.getPk();
        if (BeanUtils.isNotEmpty(editList)) {
            for (Map<String, Object> data : editList) {
                if (!data.containsKey(pkName)) {
                    pkName = pkName.toLowerCase();
                }
                editKeys.add(data.get(pkName));
            }
        }
        for (Map<String, Object> data : list) {
            if (editKeys.contains(data.get(pkName))) {
                data.put(BoEnt.SUB_ROW_READONLY, false);
                continue;
            }
            data.put(BoEnt.SUB_ROW_READONLY, true);
        }
        return list;
    }

    private Map<String, Object> initVarMap() {
        HashMap<String, Object> varMap = new HashMap<String, Object>(16);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        AuthenticationUtil.setAuthentication((Authentication)authentication);
        varMap.put("curDate", DateUtil.getCurrentTime());
        varMap.put("curUserId", AuthenticationUtil.getCurrentUserId());
        varMap.put("curUserAccount", AuthenticationUtil.getCurrentUsername());
        varMap.put("curUserName", AuthenticationUtil.getCurrentUserFullname());
        varMap.put("curUserOrgIds", this.transToInsql(AuthenticationUtil.getCurrentUserOrgIds()));
        varMap.put("curUserOrgAndUnderIds", this.transToInsql(AuthenticationUtil.getCurrentUserSubOrgIds()));
        varMap.put("curUserRolesAlias", this.transToInsql(StringUtil.join((Collection)AuthenticationUtil.getCurrentUserRolesAlias(), (String)",")));
        varMap.put("flowCreaterID", this.transToInsql((String)FormContextThreadUtil.getCommuVar("flowCreaterID", "")));
        varMap.put("flowCreaterAccount", this.transToInsql((String)FormContextThreadUtil.getCommuVar("flowCreaterAccount", "")));
        varMap.put("flowCreaterName", this.transToInsql((String)FormContextThreadUtil.getCommuVar("flowCreaterName", "")));
        varMap.put("subCreaterID", this.transToInsql((String)FormContextThreadUtil.getCommuVar("subCreaterID", "")));
        varMap.put("subCreaterAccount", this.transToInsql((String)FormContextThreadUtil.getCommuVar("subCreaterAccount", "")));
        varMap.put("subCreaterName", this.transToInsql((String)FormContextThreadUtil.getCommuVar("subCreaterName", "")));
        return varMap;
    }

    private void decryptResult(BoEnt boEnt, List<Map<String, Object>> list) {
        for (Map<String, Object> data : list) {
            for (String key : data.keySet()) {
                BoAttribute attr = boEnt.getAttrByField(key);
                if (BeanUtils.isEmpty((Object)((Object)attr)) || attr.getIsEncode() != 1) continue;
                try {
                    Object val = data.get(key);
                    data.put(key, EncryptUtil.decrypt((String)((String)val), (String)"@$ATPW*%"));
                }
                catch (Exception e) {
                    this.logger.error("\u5efa\u6a21\u5b57\u6bb5\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private String transToInsql(String str) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("('");
        if (StringUtil.isNotEmpty((String)str)) {
            sBuilder.append(StringUtil.join((String[])str.split(","), (String)"','"));
        }
        sBuilder.append("')");
        return sBuilder.toString();
    }

    public List<Map<String, Object>> executeQuery(BoEnt boEnt, String sql, Object pk) {
        if (boEnt.isExternal()) {
            String errorMsg = "\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a";
            return (List)this.databaseContext.switchDS(boEnt.getDsName(), () -> {
                if (BeanUtils.isNotEmpty((Object)pk)) {
                    return this.commonManager.query(sql, new Object[]{pk});
                }
                return this.commonManager.query(sql);
            }, e -> {
                throw new BoBaseException(errorMsg + ExceptionUtils.getRootCauseMessage((Throwable)e));
            });
        }
        if (BeanUtils.isNotEmpty((Object)pk)) {
            return this.commonManager.query(sql, new Object[]{pk});
        }
        return this.commonManager.query(sql);
    }

    public List<Map<String, Object>> executeQuery(BoEnt boEnt, String sql) {
        return this.executeQuery(boEnt, sql, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void add(BoData curData, List<BoResult> resultList, String parentId) throws Exception {
        BoEnt boEnt = curData.getBoEnt();
        Map<String, Object> map = this.convertDbMap(curData);
        BoResult boResult = new BoResult();
        this.insert(boEnt, map, parentId, boResult);
        boResult.setBoAlias(curData.getBoDefAlias());
        resultList.add(boResult);
        if (BeanUtils.isEmpty((Object)((Object)boEnt))) {
            return;
        }
        Map<String, BoEnt> entMap = boEnt.getChildMap();
        if (BeanUtils.isEmpty(entMap) && StringUtil.isNotEmpty((String)parentId) && BeanUtils.isNotEmpty(curData.getData()) && !curData.getData().isEmpty()) {
            boolean hasSun = false;
            for (String key : curData.getData().keySet()) {
                if (!key.startsWith("sub_") || !BeanUtils.isNotEmpty((Object)curData.getData().get(key))) continue;
                hasSun = true;
                break;
            }
            if (!hasSun) return;
            List<BoEnt> sunEnts = boEnt.getChildEntList();
            if (BeanUtils.isEmpty(sunEnts)) {
                sunEnts = this.boEntManager.getBySubEntId(boEnt.getId());
            }
            if (!BeanUtils.isNotEmpty(sunEnts)) return;
            boEnt.setChildEntList(sunEnts);
            entMap = boEnt.getChildMap();
        }
        for (Map.Entry<String, List<BoData>> ent : curData.getSubMap().entrySet()) {
            String key;
            String tableName = key = ent.getKey();
            if (key.startsWith("sub_")) {
                tableName = key.substring(4, key.length());
            }
            BoEnt childEnt = entMap.get(tableName.toLowerCase());
            List<BoData> subDataList = ent.getValue();
            for (BoData chidData : subDataList) {
                chidData.setBoEnt(childEnt);
                this.add(chidData, resultList, boResult.getPk());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void update(BoData curData, List<BoResult> resultList) throws Exception {
        BoEnt boEnt = curData.getBoEnt();
        Map<String, Object> map = this.convertDbMap(curData);
        String modifyResult = "";
        BoResult boResult = new BoResult();
        this.update(boEnt, null, map, boResult);
        if (StringUtil.isNotEmpty((String)boResult.getModifyDetail())) {
            modifyResult = String.format("\u4e3b\u8868\u3010%s\u3011\u4fee\u6539\u660e\u7ec6\uff1a\n%s", boEnt.getDesc(), boResult.getModifyDetail());
        }
        boResult.setBoAlias(curData.getBoDefAlias());
        resultList.add(boResult);
        String pk = (String)map.get(boEnt.getPkKey());
        Map<String, BoEnt> entMap = boEnt.getChildMap();
        if (BeanUtils.isEmpty(entMap) && BeanUtils.isNotEmpty(curData.getData()) && !curData.getData().isEmpty()) {
            boolean hasSun = false;
            for (String key : curData.getData().keySet()) {
                if (!key.startsWith("sub_") || !BeanUtils.isNotEmpty((Object)curData.getData().get(key))) continue;
                hasSun = true;
                break;
            }
            if (!hasSun) return;
            List<BoEnt> sunEnts = boEnt.getChildEntList();
            if (BeanUtils.isEmpty(sunEnts)) {
                sunEnts = this.boEntManager.getBySubEntId(boEnt.getId());
            }
            if (!BeanUtils.isNotEmpty(sunEnts)) return;
            boEnt.setChildEntList(sunEnts);
            entMap = boEnt.getChildMap();
        }
        if (BeanUtils.isEmpty(curData.getSubMap())) {
            for (Map.Entry<String, BoEnt> entry : entMap.entrySet()) {
                BoEnt childEnt = entMap.get(entry.getKey());
                if (!BeanUtils.isNotEmpty((Object)((Object)childEnt))) continue;
                Map<String, Map<String, Object>> oldDatas = this.getOldSubDatas(childEnt, pk);
                HashMap<String, Map<String, List<Map<String, Object>>>> sunAliasSubIdList = new HashMap<String, Map<String, List<Map<String, Object>>>>();
                List<BoEnt> sunEnts = BeanUtils.isEmpty(childEnt.getChildEntList()) ? this.boEntManager.getBySubEntId(childEnt.getId()) : childEnt.getChildEntList();
                for (BoEnt sunEnt : sunEnts) {
                    Map<String, List<Map<String, Object>>> sunList = this.getSunList(childEnt, sunEnt, pk);
                    sunAliasSubIdList.put(sunEnt.getName(), sunList);
                }
                this.deleteSunBoData(childEnt, oldDatas, resultList, sunAliasSubIdList);
                for (String subPk : oldDatas.keySet()) {
                    BoResult result = this.delete(childEnt, subPk);
                    resultList.add(result);
                }
                modifyResult = modifyResult + String.format("\n\u5b50\u8868\u3010%s\u3011\u5220\u9664\u660e\u7ec6\uff1a%s", childEnt.getDesc(), BeanUtils.ObjectToString(oldDatas));
            }
        } else {
            for (Map.Entry<String, List<BoData>> ent : curData.getSubMap().entrySet()) {
                BoEnt childEnt;
                String key;
                String tableName = key = ent.getKey();
                if (key.startsWith("sub_")) {
                    tableName = key.substring(4, key.length());
                }
                if (BeanUtils.isEmpty((Object)((Object)(childEnt = entMap.get(tableName.toLowerCase()))))) continue;
                Map<String, Map<String, Object>> oldDatas = this.getOldSubDatas(childEnt, pk);
                HashSet<String> updSet = new HashSet<String>();
                List<BoData> subDataList = ent.getValue();
                StringJoiner curSubModifyRes = new StringJoiner("\n");
                List<BoEnt> sunEnts = BeanUtils.isEmpty(childEnt.getChildEntList()) ? this.boEntManager.getBySubEntId(childEnt.getId()) : childEnt.getChildEntList();
                HashMap<String, Map<String, List<Map<String, Object>>>> sunAliasSubIdList = new HashMap<String, Map<String, List<Map<String, Object>>>>();
                for (BoEnt sunEnt : sunEnts) {
                    Map<String, List<Map<String, Object>>> sunList = this.getSunList(childEnt, sunEnt, pk);
                    sunAliasSubIdList.put(sunEnt.getName(), sunList);
                }
                long currentTimeMillis = System.currentTimeMillis();
                int[] index = new int[]{0};
                for (BoData childData : subDataList) {
                    childData.setBoEnt(childEnt);
                    String childPkField = childEnt.getPkKey();
                    Map<String, Object> childRow = null;
                    try {
                        childRow = this.convertDbMap(childData);
                    }
                    catch (ParseException e) {
                        throw new BaseException("\u6570\u636e\u8f6c\u6362\u51fa\u9519", (Throwable)e);
                    }
                    if (childData.containKey(childPkField)) {
                        String childPk = childData.getString(childPkField);
                        updSet.add(childPk);
                        if (oldDatas.keySet().contains(childPk)) {
                            BoResult result = new BoResult();
                            this.update(childEnt, oldDatas.get(childPk), childRow, result);
                            if (BeanUtils.isNotEmpty(sunEnts)) {
                                try {
                                    this.updateSunBoData(sunEnts, childData, childPk, resultList, sunAliasSubIdList);
                                }
                                catch (Exception e) {
                                    throw new BaseException("\u66f4\u65b0\u5b59\u8868\u6570\u636e\u51fa\u9519", (Throwable)e);
                                }
                            }
                            if (StringUtil.isNotEmpty((String)result.getModifyDetail())) {
                                curSubModifyRes.add(String.format("\u7b2c\u3010%s\u3011\u884c\u4fee\u6539\u660e\u7ec6\uff1a%s", index[0] + 1, result.getModifyDetail()));
                            }
                            if (result != null) {
                                if ("0".equals(result.getParentId())) {
                                    result.setParentId(pk);
                                }
                                resultList.add(result);
                            }
                        }
                    } else {
                        BoResult result = new BoResult();
                        this.insert(childEnt, childRow, pk, result);
                        this.addSunBoData(resultList, sunEnts, childData, result.getPk());
                        curSubModifyRes.add(String.format("\u7b2c\u3010%s\u3011\u884c\u65b0\u589e\u660e\u7ec6\uff1a%s", index[0] + 1, BeanUtils.ObjectToString(childRow)));
                        resultList.add(result);
                    }
                    index[0] = index[0] + 1;
                }
                this.logger.info("\u5904\u7406\u5b50\u8868\u6570\u636e\u8017\u65f6{}", (Object)(System.currentTimeMillis() - currentTimeMillis));
                ArrayList<String> delDatas = new ArrayList<String>();
                for (String subPk : oldDatas.keySet()) {
                    if (updSet.contains(subPk)) continue;
                    delDatas.add(BeanUtils.ObjectToString(oldDatas.get(subPk)));
                    this.deleteSunBoData(resultList, sunEnts, subPk);
                    BoResult result = this.delete(childEnt, subPk);
                    resultList.add(result);
                }
                if (delDatas.size() > 0) {
                    curSubModifyRes.add(String.format("\u5220\u9664\u660e\u7ec6\u3010%s\u3011", StringUtil.join(delDatas, (String)",")));
                }
                if (!StringUtil.isNotEmpty((String)curSubModifyRes.toString())) continue;
                modifyResult = modifyResult + String.format("\n\u5b50\u8868\u3010%s\u3011\u53d8\u66f4\u660e\u7ec6\uff1a%s", childEnt.getDesc(), curSubModifyRes.toString());
            }
        }
        this.setBoDefAlias(resultList, curData.getBoDefAlias());
        if (resultList.size() <= 0) return;
        resultList.get(0).setModifyDetail(modifyResult);
    }

    private void updateSunBoData(List<BoEnt> sunEnts, BoData chidData, String childPk, List<BoResult> resultList, Map<String, Map<String, List<Map<String, Object>>>> sunAliasSubIdList) throws Exception {
        Map<String, Object> subData = chidData.getData();
        if (BeanUtils.isNotEmpty(subData)) {
            for (BoEnt sunEnt : sunEnts) {
                Map<String, Map<String, Object>> oldSunDatas = this.getSunData(sunAliasSubIdList, sunEnt, childPk);
                if (BeanUtils.isNotEmpty((Object)subData.get("sub_" + sunEnt.getName()))) {
                    JsonNode sunDatas = JsonUtil.toJsonNode((Object)subData.get("sub_" + sunEnt.getName()));
                    String sunPkField = sunEnt.getPkKey();
                    for (JsonNode sunNode : sunDatas) {
                        BoData sunData = new BoData();
                        sunData.setBoEnt(sunEnt);
                        sunData.setData(JsonUtil.toMap((String)JsonUtil.toJson((Object)sunNode)));
                        Map<String, Object> sunRow = this.convertDbMap(sunData);
                        if (sunData.containKey(sunPkField)) {
                            String sunPk = sunData.getString(sunPkField);
                            if (!oldSunDatas.containsKey(sunPk)) continue;
                            BoResult result = new BoResult();
                            this.update(sunEnt, oldSunDatas.get(sunPk), sunRow, result);
                            if ("0".equals(result.getParentId())) {
                                result.setParentId(childPk);
                            }
                            resultList.add(result);
                            oldSunDatas.remove(sunPk);
                            continue;
                        }
                        BoResult result = new BoResult();
                        this.insert(sunEnt, sunRow, childPk, result);
                        if ("0".equals(result.getParentId())) {
                            result.setParentId(childPk);
                        }
                        resultList.add(result);
                    }
                    if (!BeanUtils.isNotEmpty(oldSunDatas)) continue;
                    for (String sunPk : oldSunDatas.keySet()) {
                        BoResult result = this.delete(sunEnt, sunPk);
                        resultList.add(result);
                    }
                    continue;
                }
                if (!BeanUtils.isNotEmpty(oldSunDatas)) continue;
                for (String sunPk : oldSunDatas.keySet()) {
                    BoResult result = this.delete(sunEnt, sunPk);
                    resultList.add(result);
                }
            }
        }
    }

    private Map<String, Map<String, Object>> getSunData(Map<String, Map<String, List<Map<String, Object>>>> sunAliasSubIdList, BoEnt sunEnt, String childPk) {
        if (sunAliasSubIdList.containsKey(sunEnt.getName()) && sunAliasSubIdList.get(sunEnt.getName()).containsKey(childPk)) {
            Map<String, List<Map<String, Object>>> map = sunAliasSubIdList.get(sunEnt.getName());
            List<Map<String, Object>> list = map.get(childPk);
            return this.listToMap(sunEnt, list);
        }
        return null;
    }

    private Map<String, Map<String, Object>> listToMap(BoEnt childEnt, List<Map<String, Object>> oldList) {
        String pkField = childEnt.getPkKey().toLowerCase();
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        block0: for (Map<String, Object> row : oldList) {
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(pkField)) continue;
                map.put(entry.getValue().toString(), row);
                continue block0;
            }
        }
        return map;
    }

    private void deleteSunBoData(BoEnt childEnt, Map<String, Map<String, Object>> oldDatas, List<BoResult> resultList, Map<String, Map<String, List<Map<String, Object>>>> sunAliasSubIdList) {
        if (BeanUtils.isNotEmpty((Object)((Object)childEnt)) && BeanUtils.isNotEmpty(childEnt.getChildEntList()) && BeanUtils.isNotEmpty(oldDatas)) {
            List<BoEnt> sunEnts = childEnt.getChildEntList();
            for (BoEnt sunEnt : sunEnts) {
                for (String subPk : oldDatas.keySet()) {
                    Map<String, Map<String, Object>> oldSunDatas = this.getSunData(sunAliasSubIdList, sunEnt, subPk);
                    if (!BeanUtils.isNotEmpty(oldSunDatas)) continue;
                    for (String sunPk : oldSunDatas.keySet()) {
                        BoResult result = this.delete(sunEnt, sunPk);
                        resultList.add(result);
                    }
                }
            }
        }
    }

    private void addSunBoData(List<BoResult> resultList, List<BoEnt> sunEnts, BoData chidData, String parentId) {
        try {
            if (BeanUtils.isNotEmpty(sunEnts)) {
                boolean hasSun = false;
                HashMap<String, Object> sunDataMap = new HashMap<String, Object>();
                for (String subKey : chidData.getData().keySet()) {
                    if (!subKey.startsWith("sub_") || !BeanUtils.isNotEmpty((Object)chidData.getData().get(subKey))) continue;
                    sunDataMap.put(subKey, chidData.getData().get(subKey));
                    hasSun = true;
                }
                if (hasSun) {
                    for (BoEnt sunBoEnt : sunEnts) {
                        if (!sunDataMap.containsKey("sub_" + sunBoEnt.getName())) continue;
                        ArrayNode sunArray = (ArrayNode)JsonUtil.toJsonNode(sunDataMap.get("sub_" + sunBoEnt.getName()));
                        for (JsonNode jsonNode : sunArray) {
                            Map sunRow = JsonUtil.toMap((String)JsonUtil.toJson((Object)jsonNode));
                            BoData sunData = new BoData();
                            sunData.setBoDef(chidData.getBoDef());
                            sunData.setBoEnt(sunBoEnt);
                            sunData.setBoDefAlias(chidData.getBoDefAlias());
                            sunData.setData(sunRow);
                            Map<String, Object> row = this.convertDbMap(sunData);
                            BoResult sunresult = new BoResult();
                            this.insert(sunBoEnt, row, parentId, sunresult);
                            resultList.add(sunresult);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5904\u7406\u5b59\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void deleteSunBoData(List<BoResult> resultList, List<BoEnt> sunEnts, String subPk) {
        if (BeanUtils.isNotEmpty(sunEnts)) {
            for (BoEnt sunEnt : sunEnts) {
                Map<String, Map<String, Object>> oldSunDatas = this.getOldSubDatas(sunEnt, subPk);
                if (!BeanUtils.isNotEmpty(oldSunDatas)) continue;
                for (String sunPk : oldSunDatas.keySet()) {
                    BoResult sunResult = this.delete(sunEnt, sunPk);
                    resultList.add(sunResult);
                }
            }
        }
    }

    private Map<String, Object> convertDbMap(BoData curData) throws ParseException {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        BoEnt boEnt = curData.getBoEnt();
        if (boEnt == null) {
            return rtnMap;
        }
        List<BoAttribute> list = boEnt.getBoAttrList();
        for (BoAttribute attr : list) {
            Object obj;
            String fieldName = attr.getFieldName();
            String name = attr.getName();
            if (!curData.containKey(name)) continue;
            try {
                obj = curData.getValByKey(name);
            }
            catch (ParseException e) {
                throw new BaseException(String.format("boEnt[%s]field[%s]\u8f6c\u6362\u51fa\u9519", boEnt.getName(), attr.getDesc()), (Throwable)e);
            }
            if (BeanUtils.isNotEmpty((Object)obj) && !name.equalsIgnoreCase(BoEnt.FORM_DATA_REV) && !name.equalsIgnoreCase(boEnt.getFieldFFormDataRevWithPrefix())) {
                if (obj.toString().length() > attr.getIntLen() && "varchar".equals(attr.getDataType())) {
                    throw new MessagePassingException(attr.getDesc() + "\u5b57\u6bb5\u8d85\u8fc7\u8bbe\u7f6e\u7684\u5b57\u7b26\u957f\u5ea6\uff01");
                }
                if ("number".equals(attr.getDataType())) {
                    Integer intLength = null;
                    int decimal = 0;
                    if (obj instanceof Integer || obj instanceof Long) {
                        intLength = obj.toString().replace("-", "").length();
                    } else if (obj instanceof Double) {
                        BigDecimal dec = new BigDecimal(obj.toString());
                        String stringValue = dec.toPlainString().replace("-", "");
                        if (stringValue.contains(".")) {
                            String[] splitArr = stringValue.split("\\.");
                            intLength = splitArr[0].length();
                            decimal = splitArr[1].length();
                        } else {
                            intLength = stringValue.length();
                        }
                    }
                    if (null != intLength) {
                        if (intLength > attr.getIntLen()) {
                            throw new MessagePassingException("\u6570\u5b57\u3010" + attr.getDesc() + "\u3011\u957f\u5ea6\u8d85\u51fa\u9650\u5236");
                        }
                        if (decimal > attr.getDecimalLen()) {
                            throw new MessagePassingException("\u6570\u5b57\u3010" + attr.getDesc() + "\u3011\u7cbe\u5ea6\u8d85\u51fa\u9650\u5236");
                        }
                    }
                }
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("value", obj);
            resultMap.put("isEncode", attr.getIsEncode());
            rtnMap.put(fieldName, resultMap);
        }
        String pk = boEnt.getPkKey();
        if (curData.containKey(pk)) {
            rtnMap.put(pk, curData.getString(pk));
        }
        if (rtnMap.containsKey(BoEnt.FORM_DATA_REV) || !boEnt.isExternal()) {
            rtnMap.put(boEnt.getFieldFFormDataRevWithPrefix(), BeanUtils.isNotEmpty((Object)curData.getByKey(BoEnt.FORM_DATA_REV)) ? curData.getByKey(BoEnt.FORM_DATA_REV) : Integer.valueOf(0));
        }
        return rtnMap;
    }

    private BoResult insert(BoEnt boEnt, Map<String, Object> row, String parentId, BoResult boResult) throws Exception {
        String tableName = "";
        String pkField = "";
        Assert.isTrue((boEnt != null ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684BoEnt\u4e0d\u80fd\u4e3a\u7a7a");
        tableName = boEnt.getTableName();
        pkField = boEnt.getPkKey();
        Object id = UniqueIdUtil.getSuid();
        String rowPk = MapUtil.getString(row, (String)pkField, (String)"");
        if (StringUtil.isNotEmpty((String)rowPk)) {
            id = rowPk;
        }
        if (boEnt.isPkNumber()) {
            id = Long.valueOf(id.toString());
        }
        LinkedHashMap<String, Object> valuesMap = new LinkedHashMap<String, Object>();
        this.initField(boEnt, valuesMap);
        valuesMap.put(pkField, id);
        if (boEnt != null && !boEnt.getType().equals("manytomany") && StringUtil.isNotEmpty((String)boEnt.getFk())) {
            if (boEnt.getPkKey().toUpperCase().equals(boEnt.getFk().toUpperCase())) {
                throw new RuntimeException(String.format("\u5916\u90e8\u8868\u3010%s(%s)\u3011\u7684\u5916\u952e\u4e0d\u80fd\u548c\u4e3b\u952e\u76f8\u540c", boEnt.getDesc(), boEnt.getName()));
            }
            valuesMap.put(boEnt.getFk(), parentId);
        }
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            String key = entry.getKey();
            boolean isPkField = StringUtil.isNotEmpty((String)pkField) && pkField.equals(key);
            Object value = entry.getValue();
            if (isPkField) continue;
            if (value instanceof Map) {
                Map result = (Map)value;
                value = result.get("value");
                if (result.containsKey("isEncode") && (Integer)result.get("isEncode") == 1) {
                    String encrypted;
                    if (value == null) {
                        value = "";
                    }
                    String s = String.valueOf(value);
                    s = SQLUtil.escapeDataBaseByEqual((String)s);
                    try {
                        encrypted = EncryptUtil.encrypt((String)s, (String)"@$ATPW*%");
                    }
                    catch (Exception e) {
                        encrypted = s;
                    }
                    valuesMap.put(entry.getKey(), encrypted);
                    continue;
                }
                valuesMap.put(entry.getKey(), value);
                continue;
            }
            valuesMap.put(entry.getKey(), value);
        }
        if (!"".equals(tableName) && tableName != null) {
            boResult.setValuesMap(valuesMap);
            if (boEnt.getType().equals("manytomany")) {
                String relPk = UniqueIdUtil.getSuid();
                BoDataRel entRel = new BoDataRel(relPk, parentId, id.toString(), boEnt.getName());
                this.boDataRelDao.insert((Object)entRel);
            }
        }
        boResult.setParentId(parentId);
        boResult.setAction("add");
        boResult.setBoEnt(boEnt);
        boResult.setPk(id.toString());
        return boResult;
    }

    private void initField(BoEnt boEnt, Map<String, Object> valuesMap) {
        List<BoAttribute> boAttrList = boEnt.getBoAttrList();
        boAttrList.stream().forEach(boAttribute -> valuesMap.put(boAttribute.getFieldName(), null));
    }

    private List<Map<String, Object>> querySql(String sql, String id, BoEnt boEnt) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (boEnt == null || !boEnt.isExternal()) {
            try {
                result = this.commonManager.query(sql, new Object[]{id});
            }
            catch (DuplicateKeyException ex) {
                this.handleExceptionMsg(boEnt, ex);
            }
            catch (Exception e2) {
                throw new BaseException(e2.getMessage(), (Throwable)e2);
            }
        } else {
            return (List)this.databaseContext.switchDS(boEnt.getDsName(), () -> this.commonManager.query(sql, new Object[]{id}), e -> {
                if (!(e instanceof DuplicateKeyException)) {
                    throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                }
                this.handleExceptionMsg(boEnt, (DuplicateKeyException)((Object)e));
            });
        }
        return result;
    }

    private int executeSql(SqlModel model, BoEnt boEnt) {
        String sql = model.getSql();
        int update = -1;
        if (StringUtil.isEmpty((String)sql)) {
            return update;
        }
        Object[] obs = model.getValues();
        if (boEnt == null || !boEnt.isExternal()) {
            try {
                update = this.commonManager.execute(sql, obs);
            }
            catch (DuplicateKeyException ex) {
                this.handleExceptionMsg(boEnt, ex);
            }
            catch (Exception e2) {
                throw new BaseException(e2.getMessage(), (Throwable)e2);
            }
        } else {
            return (Integer)this.databaseContext.switchDS(boEnt.getDsName(), () -> this.commonManager.execute(sql, obs), e -> {
                if (!(e instanceof DuplicateKeyException)) {
                    throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                }
                this.handleExceptionMsg(boEnt, (DuplicateKeyException)((Object)e));
            });
        }
        return update;
    }

    private BoResult update(BoEnt boEnt, Map<String, Object> oldEntData, Map<String, Object> row, BoResult result) {
        String string;
        String modifyDetail;
        String tableName = boEnt.getTableName();
        String pkField = boEnt.getPkKey();
        Object pkValue = MapUtil.getStringIgnoreKey(row, (String)pkField, (String)"");
        if (boEnt.isPkNumber() && BeanUtils.isNotEmpty((Object)pkValue)) {
            pkValue = Long.valueOf(pkValue.toString());
        }
        String pkType = boEnt.getPkType();
        if (BeanUtils.isEmpty(oldEntData)) {
            String selectOneSql = !"number".equals(pkType) && !"int".equals(pkType) ? "select * from " + tableName + " where " + pkField + " ='" + pkValue + "'" : "select * from " + tableName + " where " + pkField + " =" + pkValue;
            oldEntData = this.getOneById(boEnt, selectOneSql, null, e -> this.logger.error("\u6839\u636eid\u67e5\u8be2\u5916\u90e8\u6570\u636e\u9519\u8bef\uff1a", (Throwable)e));
        }
        if (BeanUtils.isNotEmpty(oldEntData) && StringUtil.isNotEmpty((String)(modifyDetail = this.compareData(boEnt, row, oldEntData)))) {
            result.setModifyDetail(modifyDetail);
            result.setBoAlias(boEnt.getName());
        }
        CommonResult portalDataSensitiveResult = this.portalFeignService.getPortalDataSensitive(boEnt.getDsName(), tableName);
        PortalDataSensitive portalDataSensitive = null;
        Map currentProfiles = null;
        Object desensitizationMap = BaseContextThreadUtil.getCommuVar((String)"desensitizationMap", (Object)"");
        Map desensiMap = null;
        Object desensiRule = null;
        if (BeanUtils.isNotEmpty((Object)desensitizationMap)) {
            desensiMap = (Map)desensitizationMap;
        }
        if (portalDataSensitiveResult.getState().booleanValue() && BeanUtils.isNotEmpty((Object)portalDataSensitiveResult.getValue())) {
            portalDataSensitive = (PortalDataSensitive)portalDataSensitiveResult.getValue();
            currentProfiles = this.permissionCalc.getCurrentProfiles();
        }
        if (BeanUtils.isNotEmpty((Object)desensiMap)) {
            desensiRule = desensiMap.get(tableName);
            if (currentProfiles == null) {
                currentProfiles = this.permissionCalc.getCurrentProfiles();
            }
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        int version = 0;
        if (BeanUtils.isNotEmpty((Object)row.get(boEnt.getFieldFFormDataRevWithPrefix()))) {
            Object object = row.get(boEnt.getFieldFFormDataRevWithPrefix());
            Object ver = String.valueOf(object);
            if (StringUtil.isEmpty((String)ver)) {
                ver = "0";
            }
            version = Integer.parseInt(((String)ver).replaceAll("\\.0*$", ""));
            row.put(boEnt.getFieldFFormDataRevWithPrefix(), version + 1);
        } else {
            ThreadMsgUtil.addMapMsg((String)"ignore_form_data_rev", (String)"true");
        }
        StringBuffer set = new StringBuffer();
        for (Map.Entry entry : row.entrySet()) {
            Map desensiRuleMap;
            boolean hasRight;
            if (pkField.equals(entry.getKey()) || BoEnt.SUB_ROW_READONLY.equals(entry.getKey()) || BeanUtils.isNotEmpty((Object)portalDataSensitive) && (hasRight = this.hasFieldNameRight((String)entry.getKey(), portalDataSensitive, currentProfiles))) continue;
            if (BeanUtils.isNotEmpty(desensiRule) && BeanUtils.isNotEmpty((desensiRuleMap = (Map)desensiRule).get(entry.getKey()))) {
                JsonNode ruleNode = (JsonNode)desensiRuleMap.get(entry.getKey());
                boolean hasRight2 = true;
                try {
                    hasRight2 = this.hasRight(ruleNode.get("rights").asText(), currentProfiles);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (!hasRight2) continue;
            }
            set.append((String)entry.getKey()).append("=?,");
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map valueResult = (Map)value;
                value = valueResult.get("value");
                if (valueResult.containsKey("isEncode") && (Integer)valueResult.get("isEncode") == 1) {
                    if (value == null) {
                        value = "";
                    }
                    String s = String.valueOf(value);
                    s = SQLUtil.escapeDataBaseByEqual((String)s);
                    try {
                        value = EncryptUtil.encrypt((String)s, (String)"@$ATPW*%");
                    }
                    catch (Exception e3) {
                        value = s;
                    }
                }
            }
            valuesMap.put((String)entry.getKey(), value);
        }
        result.setAction("upd");
        result.setBoEnt(boEnt);
        result.setPk(pkValue.toString());
        valuesMap.put(pkField, pkValue);
        result.setValuesMap(valuesMap);
        String fkField = boEnt.getFk();
        if (row.containsKey(fkField) && !"0".equals(string = row.get(fkField).toString())) {
            result.setParentId(string);
        }
        return result;
    }

    private boolean hasFieldNameRight(String fieldName, PortalDataSensitive portalDataSensitive, Map<String, Set<String>> currentProfiles) {
        try {
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)portalDataSensitive.getDesensitizationRules());
            for (JsonNode jsonNode : arrayNode) {
                boolean hasRight;
                if (!fieldName.equalsIgnoreCase(jsonNode.get("fieldName").asText()) || (hasRight = this.hasRight(jsonNode.get("rights").asText(), currentProfiles))) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new BaseException(ResponseErrorEnums.DESENSITIZATION);
        }
        return false;
    }

    private boolean hasRight(String rights, Map<String, Set<String>> currentProfiles) throws IOException {
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)rights);
        Iterator iterator = arrayNode.iterator();
        if (iterator.hasNext()) {
            JsonNode jsonNode = (JsonNode)iterator.next();
            return this.permissionCalc.hasRight(JsonUtil.toJsonString((Object)jsonNode), currentProfiles);
        }
        return false;
    }

    private BoResult delete(BoEnt boEnt, Object pk) {
        if (boEnt.isPkNumber() && BeanUtils.isNotEmpty((Object)pk)) {
            pk = Long.valueOf(pk.toString());
        }
        if (boEnt.getType().equals("manytomany")) {
            String sql = "delete from form_bo_data_relation where SUB_BO_NAME='" + boEnt.getName() + "' and FK_=?";
            SqlModel sqlModel = new SqlModel(sql, new Object[]{pk});
            this.executeSql(sqlModel, null);
        }
        BoResult result = new BoResult();
        result.setAction("del");
        result.setBoEnt(boEnt);
        result.setPk(pk.toString());
        return result;
    }

    @Override
    public BoData getResById(Object id, String bodefCode) {
        BoDef boDef = this.boDefManager.getByAlias(bodefCode);
        BoData boData = new BoData();
        BoEnt boEnt = boDef.getBoEnt();
        Map<String, Object> row = this.getById(boEnt, id);
        boData.setData(row);
        this.getCascadeById(id, boEnt, boData);
        return boData;
    }

    private void getCascadeById(Object id, BoEnt boEnt, BoData boData) {
        List<BoEnt> childEntList = boEnt.getChildEntList();
        if (BeanUtils.isEmpty(childEntList)) {
            return;
        }
        for (BoEnt childEnt : childEntList) {
            List<Map<String, Object>> list = this.getByFk(childEnt, id);
            String key = childEnt.getName();
            ArrayList<BoData> listData = new ArrayList<BoData>();
            for (Map<String, Object> rowMap : list) {
                BoData childData = new BoData();
                Map<String, Object> rtnMap = this.convertDbToData(childEnt, rowMap);
                childData.setData(rtnMap);
                listData.add(childData);
                String pkKey = childEnt.getPkKey();
                String childId = (String)rowMap.get(pkKey);
                if (StringUtil.isEmpty((String)childId)) {
                    childId = (String)rowMap.get(pkKey.toUpperCase());
                }
                this.getCascadeById(childId, childEnt, childData);
            }
            String subName = key.startsWith("sub_") ? key : "sub_" + key;
            ArrayList<Map<String, Object>> subArr = new ArrayList<Map<String, Object>>();
            for (BoData listDatum : listData) {
                subArr.add(listDatum.getData());
            }
            boData.getData().put(subName, subArr);
            boData.setSubList(key, listData);
        }
    }

    @Override
    public String saveType() {
        return "database";
    }

    @Override
    public void removeBoData(String boCode, String[] aryIds) {
        BoDef boDef = this.boDefManager.getByAlias(boCode);
        BoEnt boEnt = boDef.getBoEnt();
        ArrayList<BoResult> resultList = new ArrayList<BoResult>();
        for (String id : aryIds) {
            BoResult deleteBoResult = this.delete(boEnt, id);
            resultList.add(deleteBoResult);
            this.removeByEnt(boEnt, id);
        }
        this.batchHandleBoResult(resultList);
    }

    private void removeByEnt(BoEnt boEnt, String id) {
        for (BoEnt child : boEnt.getChildEntList()) {
            String pk = StringUtil.isNotEmpty((String)child.getPk()) ? child.getPk() : "id_";
            String selectSql = "select " + pk + " from " + child.getTableName() + " where " + child.getFk() + "=?";
            List<Map<String, Object>> subList = this.querySql(selectSql, id, child);
            String sql = "delete  from " + child.getTableName() + "  where " + child.getFk() + " =? ";
            SqlModel sqlModel = new SqlModel(sql, new Object[]{id});
            this.executeSql(sqlModel, child);
            subList.stream().map(map -> {
                if (map.containsKey(pk.toLowerCase())) {
                    return map.get(pk.toLowerCase()).toString();
                }
                if (map.containsKey(pk.toUpperCase())) {
                    return map.get(pk.toUpperCase()).toString();
                }
                return null;
            }).filter(BeanUtils::isNotEmpty).forEach(subId -> this.removeByEnt(child, (String)subId));
        }
    }

    @Override
    public List<Map<String, Object>> getList(String boCode, Map<String, Object> param) {
        BoDef boDef = this.boDefManager.getByAlias(boCode);
        BoEnt boEnt = boDef.getBoEnt();
        StringBuffer sql = new StringBuffer("select * from " + boEnt.getTableName());
        ArrayList<Object> p = new ArrayList<Object>();
        if (BeanUtils.isNotEmpty(param)) {
            sql.append(" where 1=1 ");
            for (String fieldName : param.keySet()) {
                String filedName = fieldName.toLowerCase();
                if (!boEnt.getAttrFieldMap().containsKey(filedName)) continue;
                sql.append(" and " + filedName + "=? ");
                p.add(param.get(fieldName));
            }
        }
        List list = null;
        if (boEnt.isExternal()) {
            String errorMsg = "\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a";
            list = (List)this.databaseContext.switchDS(boEnt.getDsName(), () -> this.commonManager.query(sql.toString(), p.toArray()), e -> {
                throw new BoBaseException(errorMsg + ExceptionUtils.getRootCauseMessage((Throwable)e));
            });
        } else {
            list = this.commonManager.query(sql.toString(), p.toArray());
        }
        ArrayList<Map<String, Object>> returnData = new ArrayList<Map<String, Object>>();
        for (Map rowMap : list) {
            Map<String, Object> rtnMap = this.convertDbToData(boEnt, rowMap);
            returnData.add(rtnMap);
        }
        return returnData;
    }

    @Override
    public PageList<Map<String, Object>> getList(String boCode, QueryFilter queryFilter) {
        BoDef boDef = this.boDefManager.getByAlias(boCode);
        final BoEnt boEnt = boDef.getBoEnt();
        StringBuffer sb = new StringBuffer(" select * from " + boEnt.getTableName());
        PageList queryForPageList = this.commonManager.query(sb.toString(), queryFilter);
        List rows = queryForPageList.getRows();
        rows.replaceAll(new UnaryOperator<Map<String, Object>>(){

            @Override
            public Map<String, Object> apply(Map<String, Object> rowMap) {
                return BoDbHandlerImpl.this.convertDbToData(boEnt, rowMap);
            }
        });
        return queryForPageList;
    }

    private String compareData(BoEnt boEnt, Map<String, Object> newMap, Map<String, Object> oldMap) {
        HashMap<String, Object> newData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> next : newMap.entrySet()) {
            newData.put(next.getKey().toLowerCase(), next.getValue());
        }
        HashMap<String, Object> oldData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> next : oldMap.entrySet()) {
            oldData.put(next.getKey().toLowerCase(), next.getValue());
        }
        Map<String, BoAttribute> attrFieldMap = boEnt.getAttrFieldMap();
        ArrayList<String> changeList = new ArrayList<String>();
        for (Map.Entry next : newData.entrySet()) {
            String filed = (String)next.getKey();
            if ("f_form_data_rev_".equalsIgnoreCase(filed)) continue;
            Object newVal = next.getValue();
            if (newVal instanceof HashMap) {
                HashMap mapValue = (HashMap)newVal;
                newVal = mapValue.get("value");
            }
            Object oldVal = oldData.get(filed);
            if (BeanUtils.isNotEmpty(newVal) && BeanUtils.isNotEmpty(oldVal) && newVal instanceof Date) {
                if (oldVal instanceof LocalDateTime) {
                    newVal = DateUtil.asLocalDateTime((Date)((Date)newVal));
                } else if (oldVal instanceof LocalDate) {
                    newVal = DateUtil.asLocalDate((Date)((Date)newVal));
                } else if (oldVal instanceof Timestamp) {
                    oldVal = new Date(((Timestamp)oldVal).getTime());
                }
            }
            if (BeanUtils.isEquals(newVal, oldVal) || !attrFieldMap.containsKey(filed)) continue;
            changeList.add(String.format("\u3010%s\u3011\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011", attrFieldMap.get(filed).getDesc(), BeanUtils.ObjectToString(oldVal), BeanUtils.ObjectToString(newVal)));
        }
        for (Map.Entry next : oldData.entrySet()) {
            BoAttribute boAttribute;
            Object newVal = newData.get(next.getKey());
            if (newVal instanceof HashMap) {
                HashMap mapValue = (HashMap)newVal;
                newVal = mapValue.get("value");
            }
            if (!BeanUtils.isEmpty(newVal) || !BeanUtils.isNotEmpty(oldData.get(next.getKey())) || BoEnt.FK_NAME.equalsIgnoreCase((String)next.getKey()) || BeanUtils.isEmpty((Object)((Object)(boAttribute = attrFieldMap.get(next.getKey()))))) continue;
            String desc = boAttribute.getDesc();
            String objectToString = BeanUtils.ObjectToString(oldData.get(next.getKey()));
            changeList.add(String.format("\u3010%s\u3011\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010\u3011", desc, objectToString));
        }
        return StringUtil.join(changeList, (String)",");
    }

    private Map<String, Map<String, Object>> getOldSubDatas(BoEnt childEnt, String pk) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        String pkField = childEnt.getPkKey().toLowerCase();
        List<Object> oldList = new ArrayList();
        oldList = this.getByFk(childEnt, pk);
        block0: for (Map map2 : oldList) {
            for (Map.Entry entry : map2.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(pkField)) continue;
                map.put(entry.getValue().toString(), map2);
                continue block0;
            }
        }
        return map;
    }

    @Override
    public List<BatchBoResult> batchSave(String id, String defId, List<BoData> curDatas) throws IOException {
        ArrayList<BoResult> allResultList = new ArrayList<BoResult>();
        ArrayList<BatchBoResult> resultMapList = new ArrayList<BatchBoResult>();
        boolean forceUpdate = "true".equals(ThreadMsgUtil.getMapMsg((String)"boSaveCreateSave"));
        for (BoData curData : curDatas) {
            ArrayList<BoResult> resultList = new ArrayList<BoResult>();
            BoEnt boEnt = curData.getBoEnt();
            Map<String, Object> row = curData.getData();
            String pk = "";
            if (boEnt != null) {
                pk = boEnt.getPkKey().toLowerCase();
                if (StringUtil.isNotEmpty((String)id)) {
                    row.put(pk, id);
                }
            }
            try {
                if (row.containsKey(pk) && !forceUpdate) {
                    this.update(curData, resultList);
                } else if (row.containsKey("ref_id_")) {
                    this.add(curData, resultList, row.get("ref_id_") + "");
                } else {
                    this.add(curData, resultList, "0");
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                String exceptionStr = ex.getMessage().substring(ex.getMessage().indexOf(":") + 1);
                throw new NumberFormatException(exceptionStr + "\u975e\u6570\u5b57\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u6570\u503c\uff01");
            }
            catch (MessagePassingException e) {
                throw e;
            }
            catch (BaseException e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Exception ex) {
                throw new BaseException(ex.getMessage(), (Throwable)ex);
            }
            if (curData.getBoDef() != null) {
                this.setBoDefAlias(resultList, curData.getBoDef().getAlias());
            }
            resultMapList.add(new BatchBoResult(curData, resultList));
            allResultList.addAll(resultList);
        }
        this.batchHandleBoResult(allResultList);
        return resultMapList;
    }

    private /* synthetic */ void lambda$batchExecuteSql$2(BoEnt boEnt, Exception e) {
        if (e instanceof DuplicateKeyException) {
            this.handleExceptionMsg(boEnt, (DuplicateKeyException)e);
        } else if (e instanceof DataIntegrityViolationException) {
            this.handleExceptionMsg(boEnt, (DataIntegrityViolationException)e);
        } else {
            throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + e.getMessage(), e);
        }
    }

    private /* synthetic */ Integer lambda$batchExecuteSql$1(String action, BoResult boResult, Object batchParams, BoEnt boEnt, boolean ignoreDataVersion) {
        if ("add".equals(action)) {
            return this.commonManager.batchInsert(boResult.getTableName(), (List)batchParams);
        }
        if ("upd".equals(action)) {
            return this.commonManager.batchUpdate(boResult.getTableName(), boEnt.getPkKey(), (List)batchParams, Boolean.valueOf(ignoreDataVersion));
        }
        if ("del".equals(action)) {
            return this.commonManager.batchDelete(boResult.getTableName(), boEnt.getPkKey(), (List)batchParams);
        }
        return -1;
    }
}

