/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bo.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.model.BoEntRel;
import com.hotent.bo.persistence.dao.BoEntDao;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.bo.persistence.manager.BoEntRelManager;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.model.Index;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultIndex;
import com.hotent.table.operator.IIndexOperator;
import com.hotent.table.operator.ITableOperator;
import com.hotent.table.util.MetaDataUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="boEntManager")
public class BoEntManagerImpl
extends BaseManagerImpl<BoEntDao, BoEnt>
implements BoEntManager {
    @Resource
    ITableOperator tableOperator;
    @Resource
    IIndexOperator indexOperator;
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    BoEntRelManager boEntRelManager;
    @Resource
    BoDefManager boDefManager;
    @Resource
    DatabaseContext databaseContext;

    @Override
    @Transactional
    public void createTable(BoEnt boEnt) throws SQLException {
        BoAttribute colPk = new BoAttribute();
        colPk.setName(BoEnt.PK_NAME);
        colPk.setFieldName(BoEnt.PK_NAME);
        colPk.setIsPk(true);
        colPk.setAttrLength(40);
        colPk.setCharLen(40);
        colPk.setColumnType("varchar");
        colPk.setDataType("varchar");
        colPk.setComment("\u4e3b\u952e");
        BoAttribute colFk = new BoAttribute();
        colFk.setName(BoEnt.FK_NAME);
        colFk.setFieldName(BoEnt.FK_NAME);
        colFk.setIsPk(false);
        colFk.setCharLen(40);
        colFk.setAttrLength(40);
        colFk.setDataType("varchar");
        colFk.setColumnType("varchar");
        colFk.setComment("\u5916\u952e");
        colFk.setTableName(boEnt.getTableName());
        List<BoAttribute> colList = boEnt.getBoAttrList();
        boolean hasDataRev = false;
        for (BoAttribute col : colList) {
            if ("form_data_rev_".equals(col.getName())) {
                if (col.getAttrLength() == 0) {
                    col.setAttrLength(37);
                }
                hasDataRev = true;
            }
            col.setFieldName(col.getFieldName());
        }
        if (!hasDataRev) {
            BoAttribute dateRevAttr = new BoAttribute();
            dateRevAttr.setName("form_data_rev_");
            dateRevAttr.setDesc("\u8868\u5355\u6570\u636e\u7248\u672c");
            dateRevAttr.setDataType("int");
            dateRevAttr.setDefaultValue("0");
            dateRevAttr.setFieldName(dateRevAttr.getFieldName());
            dateRevAttr.setAttrLength(37);
            colList.add(dateRevAttr);
        }
        boEnt.addAttrFirst(colFk);
        boEnt.addAttrFirst(colPk);
        this.tableOperator.createTable((Table)boEnt);
        this.createIndex(colFk);
    }

    private void createIndex(BoAttribute colFk) throws SQLException {
        DefaultIndex index = new DefaultIndex();
        index.setIndexName("IDX_" + StringUtil.substring((String)colFk.getTableName(), (int)18) + "_" + colFk.getFieldName());
        index.setTableName(colFk.getTableName());
        index.setColumnList(Collections.singletonList(colFk.getFieldName()));
        this.indexOperator.createIndex((Index)index);
    }

    @Override
    @Transactional
    public String saveEnt(BoEnt boEnt, String mainId, String defId, ArrayNode ents) throws Exception {
        String entId;
        BoEnt dbBoEnt = null;
        BoEnt oldBoEnt = null;
        ArrayList<BoAttribute> oldAttrList = new ArrayList();
        List<BoAttribute> boAttrList = null;
        ArrayList<BoAttribute> newAttrList = null;
        if (StringUtil.isEmpty((String)boEnt.getId())) {
            if (((BoEntDao)this.baseMapper).getByName(boEnt.getName()) != null) {
                throw new BaseException(String.format("\u5df2\u5b58\u5728\u522b\u540d\u4e3a%s\u7684bo\u5b9e\u4f53.", boEnt.getName()));
            }
            entId = UniqueIdUtil.getSuid();
            boEnt.setId(entId);
            boEnt.setStatus(BoEnt.STATUS_ACTIVED);
            this.create((Model)boEnt);
        } else {
            entId = boEnt.getId();
            Object temp = ((BoEntDao)this.baseMapper).getByName(boEnt.getName());
            if (temp != null && !temp.getId().equals(boEnt.getId())) {
                throw new BaseException(String.format("\u5df2\u5b58\u5728\u522b\u540d\u4e3a%s\u7684bo\u5b9e\u4f53.", boEnt.getName()));
            }
            dbBoEnt = this.getById(boEnt.getId());
            oldBoEnt = (BoEnt)this.get((Serializable)((Object)boEnt.getId()));
            oldAttrList = this.boAttributeManager.getByBoEnt(boEnt);
            this.update((Model)boEnt);
            this.boAttributeManager.removeByEntId(boEnt.getId());
        }
        boAttrList = boEnt.getBoAttrList();
        newAttrList = new ArrayList<BoAttribute>();
        for (BoAttribute boAttribute : boAttrList) {
            boAttribute.setBoEnt(boEnt);
            if (StringUtil.isEmpty((String)boAttribute.getId())) {
                newAttrList.add(boAttribute);
                boAttribute.setId(UniqueIdUtil.getSuid());
                boAttribute.setEntId(boEnt.getId());
                boAttribute.setBoEnt(boEnt);
            }
            boAttribute.setTableName(boEnt.getTableName());
            this.boAttributeManager.create((Model)boAttribute);
        }
        if (!boEnt.isCreatedTable() || boEnt.isExternal()) {
            return entId;
        }
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)AppUtil.getBean(TransactionManager.class);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        int propagationBehavior = 0;
        if (StringUtil.isNotEmpty((String)boEnt.getId())) {
            propagationBehavior = 3;
        }
        def.setPropagationBehavior(propagationBehavior);
        TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)def);
        if (this.getCanEditByName(boEnt.getName()) == 0) {
            if (dbBoEnt != null) {
                this.tableOperator.dropTable(dbBoEnt.getTableName());
            }
            boEnt = this.getById(boEnt.getId());
            try {
                this.createTable(boEnt);
            }
            catch (Exception e) {
                transactionManager.rollback(status);
                if (BeanUtils.isNotEmpty((Object)((Object)oldBoEnt))) {
                    this.createTable(oldBoEnt);
                }
                throw new BaseException("\u751f\u6210\u8868\u5931\u8d25\uff1a" + ExceptionUtils.getRootCause((Throwable)e).getMessage());
            }
        }
        try {
            for (BoAttribute attr : newAttrList) {
                this.tableOperator.addColumn(boEnt.getTableName(), (Column)attr);
            }
            this.handleCompareAndOptColumn(boAttrList, oldAttrList, boEnt);
        }
        catch (BadSqlGrammarException e) {
            transactionManager.rollback(status);
            this.reductionColumn(boAttrList, oldAttrList, boEnt);
            throw new BaseException("\u4fee\u6539\u8868\u5b57\u6bb5\u957f\u5ea6\u5931\u8d25\uff1a" + ExceptionUtils.getRootCause((Throwable)e).getMessage());
        }
        transactionManager.commit(status);
        return entId;
    }

    private void handleCompareAndOptColumn(List<BoAttribute> curData, List<BoAttribute> oldData, BoEnt boEnt) throws Exception {
        for (BoAttribute cur : curData) {
            for (BoAttribute old : oldData) {
                if (!old.getId().equals(cur.getId())) continue;
                if (!cur.getDesc().equals(old.getDesc())) {
                    this.tableOperator.updateColumnComment(boEnt.getTableName(), cur.getFieldName(), (Column)cur);
                }
                if (cur.getAttrLength() == old.getAttrLength() && cur.getDecimalLen() == old.getDecimalLen()) continue;
                if (cur.getAttrLength() < old.getAttrLength() || cur.getDecimalLen() < old.getDecimalLen()) {
                    throw new IllegalArgumentException("\u65b0\u7684\u957f\u5ea6\u6216\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u65e7\u503c");
                }
                this.tableOperator.updateColumn(boEnt.getTableName(), cur.getFieldName(), (Column)cur);
            }
        }
    }

    private void reductionColumn(List<BoAttribute> curData, List<BoAttribute> oldData, BoEnt boEnt) throws Exception {
        for (BoAttribute cur : curData) {
            if (!"varchar".equals(cur.getColumnType()) && !"number".equals(cur.getColumnType())) continue;
            for (BoAttribute old : oldData) {
                if (!old.getId().equals(cur.getId()) || cur.getAttrLength() == old.getAttrLength() && cur.getDecimalLen() == old.getDecimalLen()) continue;
                this.tableOperator.updateColumn(boEnt.getTableName(), old.getFieldName(), (Column)old);
            }
        }
    }

    @Override
    @Transactional
    public void remove(String entityId) {
        List<BoEnt> byDefId = this.getByDefId(entityId);
        for (BoEnt b : byDefId) {
            BoEnt boEnt = (BoEnt)this.get((Serializable)((Object)b.getId()));
            if (BeanUtils.isEmpty((Object)((Object)boEnt))) {
                return;
            }
            String str = "";
            for (BoEntRel rel : this.boEntRelManager.getByEntId(entityId)) {
                BoDef boDef = (BoDef)this.boDefManager.get((Serializable)((Object)rel.getBoDefid()));
                if (StringUtil.isNotEmpty((String)str)) {
                    str = str + ",";
                }
                str = str + boDef.getDescription();
            }
            if (StringUtil.isNotEmpty((String)str)) {
                throw new BaseException("\u5b9e\u4f53\u201c" + boEnt.getDesc() + "\u201d\u5df2\u7ed1\u5b9a\u4e1a\u52a1\u5bf9\u8c61\u5b9a\u4e49\u201c" + str + "\u201d\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\uff01");
            }
            this.boAttributeManager.removeByEntId(entityId);
            super.remove((Serializable)((Object)entityId));
            this.boAttributeManager.removeByEntId(entityId);
            if (!boEnt.isCreatedTable() || boEnt.isExternal()) continue;
            try {
                this.tableOperator.dropTable(boEnt.getTableName());
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public BoEnt getById(String entId) {
        BoEnt boEnt = (BoEnt)this.get((Serializable)((Object)entId));
        if (boEnt == null) {
            return null;
        }
        List<BoAttribute> list = this.boAttributeManager.getByBoEnt(boEnt);
        boEnt.setBoAttrList(list);
        return boEnt;
    }

    @Override
    public BoEnt getByName(String name) {
        BoEnt boEnt = ((BoEntDao)this.baseMapper).getByName(name);
        if (BeanUtils.isNotEmpty((Object)((Object)boEnt))) {
            List<BoAttribute> list = this.boAttributeManager.getByBoEnt(boEnt);
            boEnt.setBoAttrList(list);
        }
        return boEnt;
    }

    @Override
    public int getCanEditByName(String name) {
        return 1;
    }

    void handleAttr(List<BoAttribute> removeList, List<BoAttribute> addList, List<BoAttribute> updateList) {
        for (BoAttribute attr : removeList) {
            this.boAttributeManager.remove((Serializable)((Object)attr.getId()));
        }
        for (BoAttribute attr : addList) {
            this.boAttributeManager.create((Model)attr);
        }
        for (BoAttribute attr : updateList) {
            this.boAttributeManager.update((Model)attr);
        }
    }

    private List<BoAttribute> getRemoveList(List<BoAttribute> attrList, List<Column> columnList) {
        HashSet<String> attrSet = new HashSet<String>();
        for (Column col : columnList) {
            attrSet.add(col.getFieldName());
        }
        ArrayList<BoAttribute> list = new ArrayList<BoAttribute>();
        for (BoAttribute attr : attrList) {
            if (attrSet.contains(attr.getFieldName())) continue;
            list.add(attr);
        }
        return list;
    }

    private List<BoAttribute> getAddList(List<BoAttribute> attrList, List<Column> columnList, BoEnt boEnt) {
        HashMap<String, BoAttribute> attrMap = new HashMap<String, BoAttribute>();
        for (BoAttribute attr : attrList) {
            attrMap.put(attr.getFieldName(), attr);
        }
        ArrayList<BoAttribute> list = new ArrayList<BoAttribute>();
        for (Column column : columnList) {
            String fieldName = column.getFieldName();
            if (fieldName.equalsIgnoreCase(boEnt.getPk()) || column.getIsRequired() != 1 && fieldName.equalsIgnoreCase(BoEnt.FIELD_PREFIX + BoEnt.FORM_DATA_REV) || column.getIsRequired() != 1 && fieldName.equalsIgnoreCase(BoEnt.FK_NAME) || StringUtil.isNotEmpty((String)boEnt.getFk()) && fieldName.equalsIgnoreCase(boEnt.getFk()) || attrMap.containsKey(column.getFieldName())) continue;
            BoAttribute attr = this.getByColumn(column);
            attr.setBoEnt(boEnt);
            attr.setEntId(boEnt.getId());
            list.add(attr);
        }
        return list;
    }

    private List<BoAttribute> getUpdateList(List<BoAttribute> attrList, List<Column> columnList, BoEnt boEnt) {
        HashSet<String> attrSet = new HashSet<String>();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        for (BoAttribute attr : attrList) {
            attrSet.add(attr.getFieldName());
            attrMap.put(attr.getFieldName(), attr.getId());
        }
        ArrayList<BoAttribute> list = new ArrayList<BoAttribute>();
        for (Column column : columnList) {
            if (!attrSet.contains(column.getFieldName())) continue;
            BoAttribute attrTmp = this.getByColumn(column, (String)attrMap.get(column.getFieldName()));
            attrTmp.setBoEnt(boEnt);
            attrTmp.setEntId(boEnt.getId());
            list.add(attrTmp);
        }
        return list;
    }

    private BoAttribute getByColumn(Column column) {
        return this.getByColumn(column, null);
    }

    private BoAttribute getByColumn(Column column, String id) {
        BoAttribute attr = new BoAttribute();
        attr.setId(id == null ? UniqueIdUtil.getSuid() : id);
        attr.setName(column.getFieldName());
        attr.setFieldName(column.getFieldName());
        attr.setIsPk(false);
        attr.setIsRequired(column.getIsNull() ? 0 : 1);
        String columnType = column.getColumnType();
        if (columnType.equals("varchar")) {
            attr.setAttrLength(column.getCharLen());
        } else if (columnType.equals("number")) {
            attr.setAttrLength(column.getIntLen());
            attr.setDecimalLen(column.getDecimalLen());
        }
        attr.setFormat("");
        this.updateDateFormat(column.getFcolumnType(), attr);
        attr.setDataType(columnType);
        attr.setDesc(column.getComment());
        attr.setDefaultValue(column.getDefaultValue());
        attr.setIsRequired(column.getIsRequired());
        return attr;
    }

    private void updateDateFormat(String fcolumnType, BoAttribute attr) {
        if ("datetime".equals(fcolumnType) || "timestamp".equals(fcolumnType)) {
            attr.setFormat("yyyy-MM-dd HH:mm:ss");
        }
        if ("time".equals(fcolumnType)) {
            attr.setFormat("HH:mm:ss");
        }
        if ("date".equals(fcolumnType)) {
            attr.setFormat("yyyy-MM-dd");
        }
    }

    @Override
    public List<BoEnt> getByDefId(String defId) {
        List<BoEnt> list = ((BoEntDao)this.baseMapper).getByDefId(defId);
        for (BoEnt boEnt : list) {
            List<BoAttribute> attributes = this.boAttributeManager.getByBoEnt(boEnt);
            boEnt.setBoAttrList(attributes);
        }
        return list;
    }

    @Override
    public List<BoEnt> getByTableName(String tableName) {
        return ((BoEntDao)this.baseMapper).getByTableName(tableName);
    }

    @Override
    @Cacheable(value={"eip:form:childBoEnt"}, key="#entId")
    public List<BoEnt> getBySubEntId(String entId) {
        List<BoEnt> list = ((BoEntDao)this.baseMapper).getBySubEntId(entId);
        if (BeanUtils.isNotEmpty(list)) {
            for (BoEnt boEnt : list) {
                List<BoAttribute> attributes = this.boAttributeManager.getByBoEnt(boEnt);
                boEnt.setBoAttrList(attributes);
            }
        }
        return list;
    }

    @Override
    @CacheEvict(value={"eip:form:childBoEnt"}, key="#entId")
    public void delBoEntsByEntId(String entId) {
    }

    @Override
    public void deleteByDefId(String defId) {
        ((BoEntDao)this.baseMapper).deleteByDefId(defId);
    }

    @Override
    @Transactional
    public ObjectNode resetByEntId(String entId, String json) throws Exception {
        JsonNode jsonNode = JsonUtil.toJsonNode((String)json);
        BoEnt boEnt = (BoEnt)this.get((Serializable)((Object)entId));
        if (!boEnt.isCreatedTable() && !boEnt.isExternal()) {
            throw new BaseException("\u8bf7\u53d1\u5e03\u540e\u518d\u8fdb\u884c\u91cd\u7f6e\u64cd\u4f5c");
        }
        ArrayNode ents = (ArrayNode)jsonNode.get("ents");
        String dsAlias = boEnt.getDsName();
        String tableName = boEnt.getTableName();
        Table table = null;
        if (boEnt.isExternal()) {
            table = (Table)this.databaseContext.switchDS(dsAlias, databaseSwitchResult -> {
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)databaseSwitchResult.getDbType());
                return baseTableMeta.getTableByName(tableName);
            }, e -> {
                if (e instanceof EmptyResultDataAccessException) {
                    throw new BaseException("\u627e\u4e0d\u5230\u540d\u4e3a" + tableName + "\u7684\u7269\u7406\u8868\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
                }
                throw new BaseException(e.getMessage(), (Throwable)e);
            });
        } else {
            BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)this.databaseContext.getDbType());
            table = baseTableMeta.getTableByName(tableName);
        }
        Map<String, BoAttribute> oldAttrFieldList = null;
        if (!boEnt.isExternal()) {
            List<BoAttribute> attributeList = this.boAttributeManager.getByBoEnt(boEnt);
            oldAttrFieldList = attributeList.stream().filter(item -> BeanUtils.isNotEmpty((Object)item) && StringUtil.isNotEmpty((String)item.getFieldName())).collect(Collectors.toMap(item -> item.getFieldName().toLowerCase(), item -> item));
        }
        for (JsonNode ent : ents) {
            if (!entId.equals(JsonUtil.getString((JsonNode)ent, (String)"id"))) continue;
            ArrayNode attributeList = (ArrayNode)ent.get("attributeList");
            attributeList.removeAll();
            for (Column column : table.getColumnList()) {
                String fieldName = column.getFieldName();
                if ("TENANT_ID_".equalsIgnoreCase(fieldName) || fieldName.equalsIgnoreCase(boEnt.getPk()) || column.getIsRequired() != 1 && fieldName.equalsIgnoreCase(BoEnt.FIELD_PREFIX + BoEnt.FORM_DATA_REV) || column.getIsRequired() != 1 && fieldName.equalsIgnoreCase(boEnt.getFk()) || StringUtil.isNotEmpty((String)boEnt.getFk()) && fieldName.equalsIgnoreCase(boEnt.getFk()) || !boEnt.isExternal() && column.getIsPk()) continue;
                BoAttribute attr = this.getByColumn(column);
                attr.setBoEnt(boEnt);
                attr.setEntId(boEnt.getId());
                attr.setFormatField(false);
                if (!boEnt.isExternal()) {
                    if (BeanUtils.isNotEmpty(oldAttrFieldList) && oldAttrFieldList.containsKey(column.getFieldName().toLowerCase())) {
                        BoAttribute oldAttr = oldAttrFieldList.get(column.getFieldName().toLowerCase());
                        attr.setFieldName(oldAttr.getFieldName());
                        attr.setName(oldAttr.getName());
                    } else if (column.getFieldName().toUpperCase().startsWith(BoEnt.FIELD_PREFIX) && BoEnt.FIELD_PREFIX.length() < column.getFieldName().length()) {
                        attr.setName(attr.getName().substring(BoEnt.FIELD_PREFIX.length()));
                    }
                }
                attributeList.add(JsonUtil.toJsonNode((Object)((Object)attr)));
            }
        }
        return (ObjectNode)jsonNode;
    }

    @Override
    public ObjectNode reloadByEntId(String entId, String json) throws Exception {
        JsonNode jsonNode = JsonUtil.toJsonNode((String)json);
        BoEnt boEnt = (BoEnt)this.get((Serializable)((Object)entId));
        ArrayNode ents = (ArrayNode)jsonNode.get("ents");
        String tableName = boEnt.getTableName();
        Table table = null;
        if (boEnt.isExternal()) {
            String dsAlias = boEnt.getDsName();
            table = (Table)this.databaseContext.switchDS(dsAlias, dResult -> {
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                return baseTableMeta.getTableByName(tableName);
            }, e -> {
                throw new BaseException(e.getMessage(), (Throwable)e);
            });
        } else {
            BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)this.databaseContext.getDbType());
            table = baseTableMeta.getTableByName(tableName);
        }
        this.handleReloadList(ents, table.getColumnList(), entId, boEnt);
        return (ObjectNode)jsonNode;
    }

    private void handleReloadList(ArrayNode ents, List<Column> columnList, String entId, BoEnt boEnt) throws Exception {
        for (JsonNode ent : ents) {
            ArrayNode attributeList;
            if (!entId.equals(JsonUtil.getString((JsonNode)ent, (String)"id")) || !BeanUtils.isNotEmpty((Object)(attributeList = (ArrayNode)ent.get("attributeList")))) continue;
            HashMap attributeListMap = new HashMap();
            attributeList.forEach(attribute -> attributeListMap.put(JsonUtil.getString((JsonNode)attribute, (String)"fieldName").toLowerCase(), attribute));
            for (Column column : columnList) {
                String fieldName;
                if (attributeListMap.containsKey(column.getFieldName().toLowerCase()) || "TENANT_ID_".equalsIgnoreCase(fieldName = column.getFieldName()) || fieldName.equalsIgnoreCase(boEnt.getPk()) || column.getIsRequired() != 1 && fieldName.equalsIgnoreCase(BoEnt.FIELD_PREFIX + BoEnt.FORM_DATA_REV) || column.getIsRequired() != 1 && fieldName.equalsIgnoreCase(BoEnt.FK_NAME) || StringUtil.isNotEmpty((String)boEnt.getFk()) && fieldName.equalsIgnoreCase(boEnt.getFk())) continue;
                BoAttribute attr = this.getByColumn(column);
                attr.setBoEnt(boEnt);
                attr.setEntId(boEnt.getId());
                attributeList.add(JsonUtil.toJsonNode((Object)((Object)attr)));
            }
        }
    }

    private void removePKFKColumnList(Table table, BoEnt boEnt) {
        List columnList = table.getColumnList();
        ArrayList<Column> newColumnList = new ArrayList<Column>();
        for (Column column : columnList) {
            String fieldName = column.getFieldName();
            if (fieldName.equalsIgnoreCase(boEnt.getPk()) || StringUtil.isNotEmpty((String)boEnt.getFk()) && fieldName.equalsIgnoreCase(boEnt.getFk())) continue;
            newColumnList.add(column);
        }
        table.setColumnList(newColumnList);
    }

    @Override
    public BoEnt getMainByBoCode(String boCode) {
        return ((BoEntDao)this.baseMapper).getMainByBoCode(boCode);
    }

    @Override
    public List<BoEnt> getExternalEnts(String defId) {
        return ((BoEntDao)this.baseMapper).getExternalEnts(defId);
    }

    @Override
    public List<String> getExtLocalEnts(String boDefId) {
        List localEnts;
        List<String> boDefIds = new ArrayList<String>();
        if (StringUtil.isEmpty((String)boDefId)) {
            return boDefIds;
        }
        List<BoEnt> list = ((BoEntDao)this.baseMapper).getByDefId(boDefId);
        if (CollUtil.isNotEmpty(list) && CollUtil.isNotEmpty(localEnts = list.stream().filter(item -> item.getIsExternal() == 0).collect(Collectors.toList()))) {
            ArrayList perhapsTableNames = new ArrayList();
            List tableNames = localEnts.stream().map(ent -> {
                if (StringUtil.isNotEmpty((String)ent.getTableName())) {
                    perhapsTableNames.add(ent.getTableName().toLowerCase());
                    return ent.getTableName().toUpperCase();
                }
                return ent.getTableName();
            }).collect(Collectors.toList());
            tableNames.addAll(perhapsTableNames);
            List externalEnts = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoEnt::getIsExternal, (Object)1)).eq(BoEnt::getDsName, (Object)"LOCAL")).in(BoEnt::getTableName, tableNames));
            if (CollUtil.isNotEmpty((Collection)externalEnts)) {
                List entRels = this.boEntRelManager.list((Wrapper)Wrappers.lambdaQuery().in(BoEntRel::getRefEntId, (Collection)externalEnts.stream().map(BoEnt::getId).collect(Collectors.toList())));
                boDefIds = entRels.stream().map(BoEntRel::getBoDefid).collect(Collectors.toList());
                boDefIds.removeIf(boDefId::equals);
            }
        }
        return boDefIds;
    }
}

