/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.service;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.StrUtil;
import com.hotent.sdk.commom.SDKResult;
import com.hotent.sdk.exception.SDKException;
import com.hotent.sdk.properties.AppProperty;
import com.hotent.sdk.utils.HttpClientResult;
import com.hotent.sdk.utils.HttpClientUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class AuthService {
    private AppProperty appProperty;
    TimedCache<String, String> tokenCache;

    public AuthService(AppProperty appProperty) {
        this.appProperty = appProperty;
        this.tokenCache = CacheUtil.newTimedCache((long)(appProperty.getTokenTimeout() * 1000L));
    }

    public String getTokenByAccount(String account) throws Exception {
        if (this.tokenCache.containsKey((Object)account)) {
            return (String)this.tokenCache.get((Object)account);
        }
        String url = this.appProperty.getAuthAddress() + "/apiManager/getToken" + "?" + "sysCode=" + this.appProperty.getSysCode() + "&" + "secretKey=" + this.appProperty.getSecretKey() + "&" + "account=" + account;
        HttpClientResult result = HttpClientUtils.doGet(url);
        Assert.isTrue((result.getCode() == 200 ? 1 : 0) != 0, (String)StrUtil.format((CharSequence)"\u6839\u636e\u7528\u6237\u83b7\u53d6token\u5931\u8d25\uff0chttp\u54cd\u5e94\u72b6\u6001\u7801{},\u54cd\u5e94\u4fe1\u606f\uff1a{}", (Object[])new Object[]{result.getCode(), result.getContent()}));
        SDKResult<String> sdkResult = SDKResult.trans(result.getContent());
        if (!sdkResult.getState().booleanValue()) {
            throw new SDKException(StrUtil.format((CharSequence)"\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25!{}", (Object[])new Object[]{sdkResult.getMessage()}));
        }
        this.tokenCache.put((Object)account, (Object)sdkResult.getValue());
        return sdkResult.getValue();
    }

    public Map<String, String> createAuthHeader(String account) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.getTokenByAccount(account));
        return headers;
    }
}

