/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.json.JSONUtil;
import com.hotent.sdk.commom.SDKResult;
import com.hotent.sdk.exception.SDKException;
import com.hotent.sdk.param.AssignParamObject;
import com.hotent.sdk.param.DoEndParamObject;
import com.hotent.sdk.param.DoNextParamObject;
import com.hotent.sdk.param.ForbiddenParamObject;
import com.hotent.sdk.param.StartFlowParamObject;
import com.hotent.sdk.properties.AppProperty;
import com.hotent.sdk.service.AuthService;
import com.hotent.sdk.service.BpmHttpService;
import com.hotent.sdk.utils.HttpClientResult;
import com.hotent.sdk.utils.HttpClientUtils;
import java.util.HashMap;
import java.util.Map;

public class BpmHttpServiceImpl
implements BpmHttpService {
    private AuthService authService;
    private AppProperty appProperty;

    public BpmHttpServiceImpl(AuthService authService, AppProperty appProperty) {
        this.authService = authService;
        this.appProperty = appProperty;
    }

    @Override
    public SDKResult<String> start(String account, StartFlowParamObject startFlowParamObject) {
        return this.apiPost(account, startFlowParamObject, this.appProperty.getRequestUrl("/runtime/instance/v1/start"));
    }

    @Override
    public SDKResult<String> saveDraft(String account, StartFlowParamObject startFlowParamObject) {
        return this.apiPost(account, startFlowParamObject, this.appProperty.getRequestUrl("/runtime/instance/v1/saveDraft"));
    }

    @Override
    public SDKResult<String> agree(String account, DoNextParamObject doNextParamObject) {
        doNextParamObject.setActionName("agree");
        return this.apiPost(account, doNextParamObject, this.appProperty.getRequestUrl("/runtime/task/v1/complete"));
    }

    @Override
    public SDKResult<String> back(String account, DoNextParamObject doNextParamObject) {
        doNextParamObject.setActionName("back");
        return this.apiPost(account, doNextParamObject, this.appProperty.getRequestUrl("/runtime/task/v1/complete"));
    }

    @Override
    public SDKResult<String> forbiddenInstance(String account, ForbiddenParamObject forbiddenParamObject) {
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            Map beanToMap = BeanUtil.beanToMap((Object)forbiddenParamObject, (String[])new String[0]);
            for (Map.Entry entry : beanToMap.entrySet()) {
                param.put((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
            Map<String, String> authHeader = this.authService.createAuthHeader(account);
            HttpClientResult result = HttpClientUtils.doGet(this.appProperty.getRequestUrl("/runtime/instance/v1/forbiddenInstance"), authHeader, param);
            return SDKResult.trans(result.getContent());
        }
        catch (Exception e) {
            throw new SDKException(ExceptionUtil.getRootCauseMessage((Throwable)e));
        }
    }

    @Override
    public SDKResult<String> unForbiddenInstance(String account, ForbiddenParamObject forbiddenParamObject) {
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            Map beanToMap = BeanUtil.beanToMap((Object)forbiddenParamObject, (String[])new String[0]);
            for (Map.Entry entry : beanToMap.entrySet()) {
                param.put((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
            Map<String, String> authHeader = this.authService.createAuthHeader(account);
            HttpClientResult result = HttpClientUtils.doGet(this.appProperty.getRequestUrl("/runtime/instance/v1/unForbiddenInstance"), authHeader, param);
            return SDKResult.trans(result.getContent());
        }
        catch (Exception e) {
            throw new SDKException(ExceptionUtil.getRootCauseMessage((Throwable)e));
        }
    }

    @Override
    public SDKResult<String> oppose(String account, DoNextParamObject doNextParamObject) {
        doNextParamObject.setActionName("oppose");
        return this.apiPost(account, doNextParamObject, this.appProperty.getRequestUrl("/runtime/task/v1/complete"));
    }

    @Override
    public SDKResult<String> doEndProcess(String account, DoEndParamObject doEndParamObject) {
        return this.apiPost(account, doEndParamObject, this.appProperty.getRequestUrl("/runtime/instance/v1/doEndProcess"));
    }

    @Override
    public SDKResult<String> delegate(String account, AssignParamObject assignParamObject) {
        return this.apiPost(account, assignParamObject, this.appProperty.getRequestUrl("/runtime/task/v1/delegate"));
    }

    private SDKResult<String> apiPost(String account, Object param, String url) {
        try {
            Map<String, String> authHeader = this.authService.createAuthHeader(account);
            HttpClientResult result = HttpClientUtils.doPost(url, authHeader, JSONUtil.toJsonStr((Object)param));
            return SDKResult.trans(result.getContent());
        }
        catch (Exception e) {
            throw new SDKException(ExceptionUtil.getRootCauseMessage((Throwable)e));
        }
    }
}

