/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sdk.utils;

import cn.hutool.core.util.StrUtil;
import com.hotent.sdk.utils.HttpClientResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static final String ENCODING = "UTF-8";
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int SOCKET_TIMEOUT = 6000;
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_TYPE_JSON = "application/json;charset=utf-8";

    public static HttpClientResult doGet(String url) throws Exception {
        return HttpClientUtils.doGet(url, null, null);
    }

    public static HttpClientResult doGet(String url, Map<String, String> params) throws Exception {
        return HttpClientUtils.doGet(url, null, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult doGet(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        URIBuilder uriBuilder = new URIBuilder(url);
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpGet.setConfig(requestConfig);
        HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpGet);
        try {
            HttpClientResult httpClientResult = HttpClientUtils.getHttpClientResult(httpClient, (HttpRequestBase)httpGet);
            return httpClientResult;
        }
        finally {
            HttpClientUtils.close(httpClient);
        }
    }

    public static HttpClientResult doPost(String url) throws Exception {
        return HttpClientUtils.doPost(url, null, null);
    }

    public static HttpClientResult doPost(String url, String paramStr) throws Exception {
        return HttpClientUtils.doPost(url, null, paramStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResult doPost(String url, Map<String, String> headers, String paramStr) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpPost.setConfig(requestConfig);
        if (!headers.containsKey(CONTENT_TYPE)) {
            headers.put(CONTENT_TYPE, CONTENT_TYPE_JSON);
        }
        HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpPost);
        HttpClientUtils.packageParam(null, paramStr, (HttpEntityEnclosingRequestBase)httpPost);
        try {
            HttpClientResult httpClientResult = HttpClientUtils.getHttpClientResult(httpClient, (HttpRequestBase)httpPost);
            return httpClientResult;
        }
        finally {
            HttpClientUtils.close(httpClient);
        }
    }

    public static void packageHeader(Map<String, String> params, HttpRequestBase httpMethod) {
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void packageParam(Map<String, String> params, String paramStr, HttpEntityEnclosingRequestBase httpMethod) throws UnsupportedEncodingException {
        if (params != null) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, ENCODING));
        }
        if (StrUtil.isNotEmpty((CharSequence)paramStr)) {
            httpMethod.setEntity((HttpEntity)new StringEntity(paramStr, ENCODING));
        }
    }

    public static HttpClientResult getHttpClientResult(CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws IOException {
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpMethod);){
            if (httpResponse != null && httpResponse.getStatusLine() != null) {
                String content = "";
                if (httpResponse.getEntity() != null) {
                    content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)ENCODING);
                }
                HttpClientResult httpClientResult = new HttpClientResult(httpResponse.getStatusLine().getStatusCode(), content);
                return httpClientResult;
            }
        }
        return new HttpClientResult(500, null);
    }

    public static void close(CloseableHttpClient httpClient) throws IOException {
        if (httpClient != null) {
            httpClient.close();
        }
    }
}

