/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.AvoidRepeatableCommit;
import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.engine.def.ButtonDTO;
import com.hotent.bpm.engine.def.impl.handler.ButtonsBpmDefXmlHandler;
import com.hotent.bpm.model.def.BpmDefXmlList;
import com.hotent.bpm.params.SearchDefNodeVO;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpmModel.manager.BpmDefService;
import com.hotent.bpmModel.manager.BpmDefTransform;
import com.hotent.bpmModel.manager.BpmOftenFlowManager;
import com.hotent.bpmModel.params.CopyFlow;
import com.hotent.bpmModel.params.DefBoSetVo;
import com.hotent.bpmModel.params.DefBtnsSaveVo;
import com.hotent.bpmModel.params.DefPropSaveVo;
import com.hotent.bpmModel.params.DefaultBpmDefinitionVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/flow/def/v1/"})
@Api(tags={"\u6d41\u7a0b\u5b9a\u4e49"})
@ApiGroup(group={"group_bpm"})
public class DefController
extends BaseController<BpmDefinitionManager, DefaultBpmDefinition> {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmDefTransform bpmDefTransform;
    @Resource
    ButtonsBpmDefXmlHandler buttonsBpmDefXmlHandler;
    @Resource
    private BpmOftenFlowManager bpmOftenFlowManager;
    @Resource
    private BpmDefService bpmDefService;

    @GetMapping(value={"bpmnXml"}, produces={"application/xml; charset=UTF-8"})
    @ApiOperation(value="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u751f\u6210\u7684BPMNxml", httpMethod="GET", notes="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u751f\u6210\u7684BPMNxml")
    public Object bpmnXml(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam @Valid @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u80fd\u4e3a\u7a7a") @Valid @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u80fd\u4e3a\u7a7a") String defId) {
        DefaultBpmDefinition po = this.bpmDefinitionManager.getById(defId);
        return po.getBpmnXml();
    }

    @GetMapping(value={"designXml"}, produces={"application/xml; charset=UTF-8"})
    @ApiOperation(value="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml", httpMethod="GET", notes="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml")
    public Object designXml(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam @Valid @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u80fd\u4e3a\u7a7a") @Valid @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u80fd\u4e3a\u7a7a") String defId) {
        DefaultBpmDefinition po = this.bpmDefinitionManager.getById(defId);
        return po.getDefXml();
    }

    @GetMapping(value={"getJson"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61")
    public DefaultBpmDefinition getJson(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49Key", required=true) @RequestParam String defKey) {
        DefaultBpmDefinition po = this.bpmDefinitionManager.getMainByDefKey(defKey);
        if (po != null) {
            po.setBpmnXml("");
        }
        return po;
    }

    @GetMapping(value={"webDefDesign"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml", httpMethod="GET", notes="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml")
    public Object webDefDesign(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        return this.bpmDefinitionManager.webDefDesign(defId);
    }

    @PostMapping(value={"webDefSave"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="web\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fdd\u5b58", httpMethod="POST", notes="web\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fdd\u5b58")
    public CommonResult<String> webDefSave(@ApiParam(name="bpmDefinitionVo", value="\u4fdd\u5b58\u6d41\u7a0b\u5bf9\u8c61", required=true) @RequestBody DefaultBpmDefinitionVo bpmDefinitionVo) throws Exception {
        int length;
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("oracle") && StringUtils.isNotEmpty((String)bpmDefinitionVo.getDefaultBpmDefinition().getName()) && (length = bpmDefinitionVo.getDefaultBpmDefinition().getName().length()) > 21) {
            return new CommonResult(false, "\u6d41\u7a0b\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc721\uff01", (Object)"");
        }
        return this.bpmOftenFlowManager.webDefAndConfSave(bpmDefinitionVo);
    }

    @PostMapping(value={"flexDefSave"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="flex\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fdd\u5b58", httpMethod="POST", notes="flex\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fdd\u5b58")
    public CommonResult<String> flexDefSave(@ApiParam(name="bpmDefinitionVo", value="\u4fdd\u5b58\u6d41\u7a0b\u5bf9\u8c61", required=true) @RequestBody DefaultBpmDefinitionVo bpmDefinitionVo) {
        return this.bpmDefService.flexDefSave(bpmDefinitionVo);
    }

    @PostMapping(value={"listJson"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<DefaultBpmDefinition> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmDefinition> queryFilter) throws Exception {
        return this.bpmDefinitionManager.queryList(queryFilter);
    }

    @PostMapping(value={"formDeflist"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ed1\u5b9a\u6307\u5b9a\u8868\u5355\u7684\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<DefaultBpmDefinition> formDefList(@ApiParam(name="boCode", value="boCode", required=true) @RequestParam String boCode, @ApiParam(name="formKey", value="formKey", required=true) @RequestParam String formKey, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmDefinition> queryFilter) throws Exception {
        return this.bpmDefService.formDeflist(boCode, formKey, queryFilter);
    }

    @GetMapping(value={"getByTypeId"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5206\u7c7bid\u67e5\u8be2\u6570\u636e", httpMethod="GET", notes="\u6d41\u7a0b\u5b9a\u4e49\u5206\u7c7bid\u67e5\u8be2\u6570\u636e")
    public PageList<DefaultBpmDefinition> getByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bid") @RequestParam String typeId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL);
        queryFilter.addFilter("type_id_", (Object)typeId, QueryOP.EQUAL);
        return this.bpmDefinitionManager.queryList(queryFilter);
    }

    @GetMapping(value={"defGet"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f")
    public DefaultBpmDefinition defGet(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        DefaultBpmDefinition bpmDefinition = null;
        if (StringUtil.isNotEmpty((String)defId)) {
            bpmDefinition = this.bpmDefinitionManager.getById(defId);
        }
        return bpmDefinition;
    }

    @GetMapping(value={"getDefDesignByDefId"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u7684\u6700\u57fa\u672c\u4fe1\u606f\uff0c\u8fd4\u56de\u7684\u5185\u5bb9\u4e0d\u542bxml", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f")
    public CommonResult getDefDesignByDefId(@RequestParam(value="defId") String defId) {
        DefaultBpmDefinition definition = this.bpmDefService.getDefDesignByDefId(defId);
        if (definition != null) {
            return CommonResult.ok().value((Object)definition);
        }
        return CommonResult.error().message("\u8be5\u6d41\u7a0b\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"image"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u56fe", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u56fe")
    public void image(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="bpmnInstId", value="bpmn\u5b9e\u4f8bid") @RequestParam String bpmnInstId, @ApiParam(name="taskId", value="\u4efb\u52a1id") @RequestParam String taskId, HttpServletResponse response) throws Exception {
        this.bpmDefinitionManager.image(defId, bpmnInstId, taskId, response);
    }

    @PostMapping(value={"save"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49\u3002")
    public Object save(@ApiParam(name="bpmVo", value="\u6d41\u7a0b\u4fdd\u5b58\u5bf9\u8c61", required=true) @RequestParam DefaultBpmDefinitionVo bpmVo) throws Exception {
        return this.bpmDefService.save(bpmVo);
    }

    @DeleteMapping(value={"removeByDefIds"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49")
    public CommonResult<String> removeByDefIds(@ApiParam(name="ids", value="\u6d41\u7a0b\u5b9a\u4e49id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids, @ApiParam(name="cascade", value="\u662f\u5426\u7ea7\u8054\u5220\u9664\u8be5\u6d41\u7a0b\u6240\u6709\u7248\u672c", required=true) @RequestParam Optional<Boolean> cascade, @ApiParam(name="isVersion", value="\u662f\u5426\u662f\u4ece\u7248\u672c\u7ba1\u7406\u5220\u9664", required=true) @RequestParam Optional<Boolean> isVersion) {
        try {
            String[] aryIds = ids.split(",");
            this.bpmDefinitionManager.removeDefIds(cascade.orElse(false).booleanValue(), isVersion.orElse(false), aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new CommonResult(false, "\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25:" + rootCauseMessage, (Object)"");
        }
    }

    @DeleteMapping(value={"physicsRemoveAllVersionByIds"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\uff0c\u7269\u7406\u5220\u9664\u6240\u6709\u7248\u672c\u7684\u6d41\u7a0b\u76f8\u5173\u6570\u636e", httpMethod="DELETE", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\uff0c\u7269\u7406\u5220\u9664\u6240\u6709\u7248\u672c\u7684\u6d41\u7a0b\u76f8\u5173\u6570\u636e")
    public CommonResult<String> physicsRemoveAllVersionByIds(@ApiParam(name="ids", value="\u6d41\u7a0b\u5b9a\u4e49id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) {
        try {
            this.bpmDefinitionManager.physicsRemoveAllVersionByIds(ids);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new CommonResult(false, "\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25:" + rootCauseMessage, (Object)"");
        }
    }

    @PostMapping(value={"saveSetBos"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u8bbe\u7f6e\u7684BO\u8bbe\u7f6e", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u7a0b\u8bbe\u7f6e\u7684BO\u8bbe\u7f6e")
    public CommonResult<String> saveSetBos(@ApiParam(name="defBoSetVo", value="\u6d41\u7a0bbo\u8bbe\u7f6e\u5bf9\u8c61", required=true) @RequestBody DefBoSetVo defBoSetVo) throws Exception {
        return this.bpmDefService.saveSetBos(defBoSetVo);
    }

    @GetMapping(value={"getFlowListByTypeId"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4ee3\u7406\u4fe1\u606f", httpMethod="GET", notes="\u4fdd\u5b58\u4ee3\u7406\u4fe1\u606f")
    public void getFlowListByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestParam String typeId, @ApiParam(name="word", value="\u67e5\u8be2\u5173\u952e\u5b57", required=true) @RequestParam String word, HttpServletResponse response) throws Exception {
        this.bpmDefService.getFlowListByTypeId(typeId, word, response);
    }

    @GetMapping(value={"flexGet"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5728\u7ebf\u8bbe\u8ba1\uff0c\u6839\u636edefId\u83b7\u53d6\u6d41\u7a0b\u5bf9\u5e94\u7684\u8be6\u7ec6\u4fe1\u606f", httpMethod="GET", notes="\u6d41\u7a0b\u5728\u7ebf\u8bbe\u8ba1\uff0c\u6839\u636edefId\u83b7\u53d6\u6d41\u7a0b\u5bf9\u5e94\u7684\u8be6\u7ec6\u4fe1\u606f")
    public void flexGet(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, HttpServletResponse response) throws Exception {
        this.bpmDefService.flexGet(defId, response);
    }

    @GetMapping(value={"getOtherParam"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570")
    public Map<String, Object> getOtherParam(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) {
        return this.bpmDefService.getOtherParam(defId);
    }

    @PostMapping(value={"saveProp"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570", httpMethod="POST", notes="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570")
    public CommonResult<String> saveProp(@ApiParam(name="defPropVo", value="\u6d41\u7a0b\u5176\u4ed6\u53c2\u6570\u4fdd\u5b58\u5bf9\u8c61", required=true) @RequestBody DefPropSaveVo defPropVo) {
        return this.bpmDefService.saveProp(defPropVo);
    }

    @GetMapping(value={"nodeBos"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5c55\u793a\u6d41\u7a0b\u8282\u70b9BO\u8bbe\u7f6e", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570")
    public Object nodeBos(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="topDefKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String topDefKey) throws Exception {
        return this.bpmDefService.nodeBos(defId, topDefKey);
    }

    @GetMapping(value={"exportXml"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml", httpMethod="GET", notes="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="bpmDefId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String bpmDefId) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)bpmDefId)) {
            String zipName;
            String[] bpmDefIds = bpmDefId.split(",");
            List defList = this.bpmDefinitionService.getExternalSubprocess(Arrays.asList(bpmDefIds));
            String fullname = ContextUtil.getCurrentUser().getFullname();
            if (defList.size() == 1) {
                DefaultBpmDefinition bpmDefinition = (DefaultBpmDefinition)((BpmDefinitionManager)this.baseService).get((Serializable)defList.get(0));
                zipName = String.format("\u6d41\u7a0b\u5bfc\u51fa_%s(%s)_%s%s", bpmDefinition.getName(), bpmDefinition.getDefKey(), fullname, DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
                if (zipName.length() > 123) {
                    zipName = zipName.substring(0, 120) + "...";
                }
            } else {
                zipName = String.format("\u6279\u91cf\u6d41\u7a0b\u5bfc\u51fa\u6587\u4ef6_%s%s", fullname, DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
            }
            Map<String, String> strXml = this.bpmDefTransform.exportDef(defList);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @GetMapping(value={"exportData"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml", httpMethod="GET", notes="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml")
    public Map<String, String> exportData(String ... ids) throws Exception {
        List defList = this.bpmDefinitionService.getExternalSubprocess(Arrays.asList(ids));
        return this.bpmDefTransform.exportDef(defList);
    }

    @PostMapping(value={"importData"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml", httpMethod="POST", notes="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml")
    public CommonResult<Map<String, String>> importData(@RequestBody Map<String, Object> param, @RequestParam(value="typeId", required=false) Optional<String> typeId) throws JAXBException, UnsupportedEncodingException {
        String bpmdefsXml = param.getOrDefault("bpmdefs.flow.xml", "").toString();
        String formXmlStr = param.getOrDefault("form.xml", "").toString();
        String boXmlStr = param.getOrDefault("bo.xml", "").toString();
        String formRightsXml = param.getOrDefault("formrights.xml", "").toString();
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("bpmdefsXml", bpmdefsXml);
        obj.put("formXmlStr", formXmlStr);
        obj.put("boXmlStr", boXmlStr);
        obj.put("formRightsXml", formRightsXml);
        ThreadMsgUtil.addMapMsg((String)"notNeedTransaction", (String)"true");
        CommonResult<String> result = this.bpmDefTransform.importDef(obj, typeId.orElse("6"), true, true);
        if (!result.getState().booleanValue()) {
            return new CommonResult(false, result.getMessage());
        }
        Map<Object, Object> map = new HashMap();
        BpmDefXmlList defList = (BpmDefXmlList)JAXBUtil.unmarshall((String)bpmdefsXml, BpmDefXmlList.class);
        if (BeanUtils.isNotEmpty((Object)defList.getBpmList())) {
            List alias = defList.getBpmList().stream().map(item -> item.getBpmDefinition().getDefKey()).collect(Collectors.toList());
            map = this.bpmDefinitionManager.list((Wrapper)Wrappers.lambdaQuery().in(DefaultBpmDefinition::getDefKey, alias)).stream().collect(Collectors.toMap(DefaultBpmDefinition::getDefKey, DefaultBpmDefinition::getId, (k1, k2) -> k1));
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f", map);
    }

    @PostMapping(value={"importCheck1"})
    List<ImportCheckResult> importFlowCheck(@RequestBody Map<String, Object> param) throws Exception {
        return this.bpmDefService.importFlowCheck(param);
    }

    @PostMapping(value={"importSave"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5bfc\u5165\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165") @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6") @RequestParam Optional<String> typeId, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6d41\u7a0b\u6587\u4ef6id") @RequestParam Optional<String> cacheFileId, @ApiParam(name="toMain", value="\u662f\u5426\u5c06\u5bfc\u5165\u7248\u672c\u8bbe\u7f6e\u4e3a\u4e3b\u7248\u672c") @RequestParam(required=false) Boolean toMain) throws Exception {
        CommonResult<String> message = null;
        try {
            if (confirmImport.orElse(false).booleanValue()) {
                String byKey = ((BpmDefinitionManager)this.baseService).getImportFileFromCache(cacheFileId.get());
                if (StringUtil.isEmpty((String)byKey)) {
                    return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:\u4e0a\u4f20\u7684\u6587\u4ef6\u5df2\u4ece\u7f13\u5b58\u4e2d\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
                }
                ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)byKey);
                message = this.bpmDefTransform.importDef(objectNode, typeId.orElse(""), toMain);
            }
            ((BpmDefinitionManager)this.baseService).delImportFileFromCache(cacheFileId.orElse(""));
        }
        catch (Exception e) {
            message = new CommonResult<String>(false, "\u5bfc\u5165\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return message;
    }

    @PostMapping(value={"importCheck"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c,\u901a\u8fc7\u6821\u9a8c\u5219\u76f4\u63a5\u5bfc\u5165\uff0c\u5982\u6709\u91cd\u590d\u6d41\u7a0b\uff0c\u5219\u8fd4\u56de\u6d41\u7a0bxml\u7684\u7f13\u5b58key\uff0c\u5f85\u7528\u6237\u786e\u8ba4\u8986\u76d6\u540e\u518d\u6b21\u5bfc\u5165", httpMethod="POST", notes="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c")
    public Object importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6") @RequestParam Optional<String> typeId, @ApiParam(name="toMain", value="\u662f\u5426\u5c06\u5bfc\u5165\u7248\u672c\u8bbe\u7f6e\u4e3a\u4e3b\u7248\u672c") @RequestParam(required=false) Boolean toMain) throws Exception {
        return this.bpmDefService.importCheck(request, response, typeId, toMain);
    }

    @RequestMapping(value={"versions"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5386\u53f2\u7248\u672c", httpMethod="POST", notes="\u6d41\u7a0b\u5b9a\u4e49\u5386\u53f2\u7248\u672c")
    public PageList<DefaultBpmDefinition> versions(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key") @RequestParam String defKey, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmDefinition> queryFilter) {
        return this.bpmDefinitionManager.versions(defId, defKey, queryFilter);
    }

    @RequestMapping(value={"isLatestVersion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5386\u53f2\u7248\u672c", httpMethod="GET", notes="\u6d41\u7a0b\u5b9a\u4e49\u5386\u53f2\u7248\u672c")
    public CommonResult<String> isLatestVersion(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId) {
        return this.bpmDefinitionManager.isLatestVersion(defId);
    }

    @RequestMapping(value={"switchMainVersion"})
    @ApiOperation(value="\u8bbe\u7f6e\u5386\u53f2\u7248\u672c\u7684\u6d41\u7a0b\u5b9a\u4e49\u4e3a\u4e3b\u7248\u672c", httpMethod="GET", notes="\u8bbe\u7f6e\u5386\u53f2\u7248\u672c\u7684\u6d41\u7a0b\u5b9a\u4e49\u4e3a\u4e3b\u7248\u672c")
    public CommonResult<String> switchMainVersion(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId) {
        try {
            this.bpmDefinitionService.switchMainVersion(defId);
            return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u8bbe\u7f6e\u5931\u8d25:" + e.getMessage(), (Object)"");
        }
    }

    @GetMapping(value={"subFlowDetail"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u5916\u90e8\u5b50\u6d41\u7a0b", httpMethod="GET", notes="\u8bbe\u7f6e\u5916\u90e8\u5b50\u6d41\u7a0b")
    public Map<String, Object> subFlowDetail(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId) throws Exception {
        return this.bpmDefinitionManager.subFlowDetail(defId, nodeId);
    }

    @PostMapping(value={"getNodeBtns"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u4ee3\u7406\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u4ee3\u7406\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<BpmNodeDef> getNodeBtns(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestBody String defId) throws Exception {
        return this.bpmDefinitionManager.getNodeBtns(defId);
    }

    @PostMapping(value={"getNodeSet"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f97\u5230\u67d0\u4e2a\u8282\u70b9\u81ea\u5b9a\u4e49\u6309\u94ae", httpMethod="POST", notes="\u5f97\u5230\u67d0\u4e2a\u8282\u70b9\u81ea\u5b9a\u4e49\u6309\u94ae")
    public DefBtnsSaveVo getNodeSet(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId, @ApiParam(name="action", value="0:\u83b7\u53d6\u9ed8\u8ba4\u521d\u59cb\u5316\u7684\u6309\u94ae,1:\u83b7\u53d6\u914d\u7f6e\u7684\u6309\u94ae,2:\u83b7\u53d6\u9ed8\u8ba4\u4e0d\u521d\u59cb\u5316\u7684\u6309\u94ae") @RequestParam int action) throws Exception {
        return this.bpmDefService.getNodeSet(defId, nodeId, action);
    }

    @PostMapping(value={"saveNodeBtns"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8282\u70b9\u7684\u6309\u94ae", httpMethod="POST", notes="\u4fdd\u5b58\u8282\u70b9\u7684\u6309\u94ae")
    public CommonResult<DefBtnsSaveVo> saveNodeBtns(@ApiParam(name="btnsVo", value="\u6d41\u7a0b\u8282\u70b9\u6309\u94ae\u5bf9\u8c61") @RequestBody DefBtnsSaveVo btnsVo) throws Exception {
        try {
            String defId = btnsVo.getDefId();
            String nodeId = btnsVo.getNodeId();
            ButtonDTO buttonDTO = new ButtonDTO();
            buttonDTO.setButtons(btnsVo.getBtns());
            buttonDTO.setTopButtons(btnsVo.getTopButtons());
            this.buttonsBpmDefXmlHandler.saveNodeXml(defId, nodeId, (Object)buttonDTO);
            return new CommonResult(true, "\u6309\u94ae\u8bbe\u7f6e\u6210\u529f", (Object)btnsVo);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6309\u94ae\u8bbe\u7f6e\u5931\u8d25", null);
        }
    }

    @PostMapping(value={"cleanData"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6e05\u9664\u6d4b\u8bd5\u72b6\u6001\u6d41\u7a0b\u7684\u6d4b\u8bd5\u6570\u636e", httpMethod="POST", notes="\u6e05\u9664\u6d4b\u8bd5\u72b6\u6001\u6d41\u7a0b\u7684\u6d4b\u8bd5\u6570\u636e")
    public CommonResult<String> cleanData(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId) {
        try {
            this.bpmDefinitionService.cleanData(defId);
            return new CommonResult(true, "\u6e05\u9664\u6570\u636e\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u6e05\u9664\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @PostMapping(value={"deploy"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49", httpMethod="POST", notes="\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49")
    public CommonResult<String> deploy(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId) {
        try {
            BpmDefinition def = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
            this.bpmDefinitionService.deploy(def);
            return new CommonResult(true, "\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @GetMapping(value={"goRunOrTest"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4e0a\u7ebf\u6216\u8005\u6d4b\u8bd5", httpMethod="GET", notes="\u6279\u91cf\u4e0a\u7ebf\u6216\u8005\u6d4b\u8bd5")
    public CommonResult<String> goLive(@ApiParam(name="defIds", value="\u6d41\u7a0b\u5b9a\u4e49ids(\u591a\u4e2a\u4f7f\u7528\uff0c\u9694\u5f00)") @RequestParam String defIds, @ApiParam(name="isRun", value="\u662f\u5426\u4e0a\u7ebf\uff0ctrue\u662f\u4e0a\u7ebf\uff0cfalse\u662f\u6d4b\u8bd5") @RequestParam Boolean isRun) throws Exception {
        return this.bpmDefinitionService.goRunOrTest(defIds, isRun);
    }

    @GetMapping(value={"getBindRelation"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u7ed1\u5b9a\u5173\u7cfb\u3002", httpMethod="GET", notes="\u6839\u636e\u7ec4\u4ef6\u522b\u540d\u83b7\u53d6\u6240\u6709\u5b50\u5b9e\u4f53\u3002")
    public Map<String, Object> getBindRelation(@ApiParam(name="defId", value="\u8868\u5355defId") @RequestParam String defId) throws Exception {
        return this.bpmDefinitionManager.getBindRelation(defId);
    }

    @GetMapping(value={"initNodeBtn"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u521d\u59cb\u5316\u6240\u6709\u6309\u94ae", httpMethod="GET", notes="\u521d\u59cb\u5316\u6240\u6709\u6309\u94ae")
    public CommonResult<String> initNodeBtn(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId) throws Exception {
        return this.bpmDefService.initNodeBtn(defId, nodeId);
    }

    @PostMapping(value={"copy"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u6d41\u7a0b", httpMethod="POST", notes="\u590d\u5236\u6d41\u7a0b")
    @AvoidRepeatableCommit
    public CommonResult<String> copyDef(@ApiParam(name="flowInfo", value="\u6d41\u7a0b\u4fe1\u606f", required=true) @RequestBody CopyFlow flow) throws IOException {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(flow.getDefKey(), false);
        if (bpmDefinition != null) {
            return new CommonResult(false, "\u6d41\u7a0bkey\u5df2\u7ecf\u5b58\u5728", (Object)"");
        }
        try {
            this.bpmDefinitionManager.copyDef(flow.getDefId(), flow.getName(), flow.getDefKey(), flow.getTypeId(), flow.getTypeName());
        }
        catch (Exception ex) {
            return new CommonResult(false, ex.getMessage(), (Object)"");
        }
        return new CommonResult(true, "\u590d\u5236\u6210\u529f", (Object)"");
    }

    @GetMapping(value={"getBpmDefId"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6\u6700\u65b0\u7684\u6d41\u7a0b\u5b9a\u4e49id", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6\u6700\u65b0\u7684\u6d41\u7a0b\u5b9a\u4e49id")
    public String getBpmDefId(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String defKey) {
        List defs = this.bpmDefinitionManager.queryByDefKey(defKey);
        String defId = "";
        if (defs.size() > 0 && BeanUtils.isNotEmpty(defs.get(defs.size() - 1))) {
            defId = ((DefaultBpmDefinition)defs.get(defs.size() - 1)).getDefId();
        }
        return defId;
    }

    @GetMapping(value={"isBoBindFlowCheck"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u6d4bbo\u662f\u5426\u5df2\u7ed1\u5b9a\u6d41\u7a0b", httpMethod="GET", notes="\u68c0\u6d4bbo\u662f\u5426\u5df2\u7ed1\u5b9a\u6d41\u7a0b")
    public CommonResult<Boolean> isBoBindFlowCheck(@ApiParam(name="boCode", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String boCode, @ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey) throws Exception {
        return this.bpmDefService.isBoBindFlowCheck(boCode, formKey);
    }

    @GetMapping(value={"getBpmdefByDefId"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49")
    public DefaultBpmDefinition getBpmdefByDefId(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        return this.bpmDefinitionManager.getById(defId);
    }

    @PostMapping(value={"defSetCategory"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u6d41\u7a0b\u5206\u7c7b", httpMethod="POST", notes="\u8bbe\u7f6e\u6d41\u7a0b\u5206\u7c7b")
    public CommonResult<String> defSetCategory(@ApiParam(name="jNode", value="\u8bbe\u7f6e\u5206\u7c7b\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody ObjectNode jNode) {
        List<String> defIds = Arrays.asList(jNode.get("defIds").asText().split(","));
        String typeName = jNode.get("typeName").asText();
        String typeId = jNode.get("typeId").asText();
        return this.bpmDefinitionManager.setDefType(typeName, typeId, defIds);
    }

    @GetMapping(value={"bpmDefinitionData"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b")
    public List<Map<String, Object>> bpmDefinitionData(String alias) {
        return this.bpmDefinitionManager.bpmDefinitionData(alias);
    }

    @GetMapping(value={"flowHasStartRights"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u542f\u52a8\u6d41\u7a0b\u6743\u9650", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u542f\u52a8\u6d41\u7a0b\u6743\u9650")
    public CommonResult<Boolean> flowHasStartRights(@ApiParam(name="defKey", value="defKey") @RequestParam String defKey) throws IOException {
        ObjectNode reslt = this.bpmDefAuthorizeManager.getRight(defKey, "start");
        return new CommonResult(true, "", (Object)BeanUtils.isNotEmpty((Object)reslt));
    }

    @GetMapping(value={"getAllowSignet"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49\u83b7\u53d6\u662f\u5426\u5141\u8bb8\u5957\u6253\u5370\u7ae0", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49\u83b7\u53d6\u662f\u5426\u5141\u8bb8\u5957\u6253\u5370\u7ae0")
    public CommonResult<Boolean> getAllowSignet(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        BpmProcessDef procDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmDefExtProperties prop = procDef.getProcessDefExt().getExtProperties();
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\u3002", (Object)"true".equals(prop.getAllowSignet()));
    }

    @PostMapping(value={"getDefNodeUserByTeam"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1\u8282\u70b9key\uff0c\uff08\u7528\u6237\u8d26\u53f7/\u540d\u79f0\uff0c\u7ec4\u7ec7\u3001\u89d2\u8272\u3001\u5c97\u4f4d\u7f16\u7801/\u540d\u79f0\uff09\u83b7\u53d6\u6d41\u8f6c\u914d\u7f6e\u4efb\u52a1\u8282\u70b9\u3001\u5ba1\u6279\u4eba\u4fe1\u606f")
    public CommonResult<ObjectNode> getDefNodeUserByTeam(@ApiParam(name="map", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody SearchDefNodeVO searchDefNodeVO) throws Exception {
        return ((BpmDefinitionManager)this.baseService).getAllDefNodeUserByTeam(searchDefNodeVO);
    }

    @PostMapping(value={"exportDefNodeUserByTeam"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5206\u7ba1\u6388\u6743\u660e\u7ec6\u5217\u8868", httpMethod="POST", notes="\u5bfc\u51fa\u5206\u7ba1\u6388\u6743\u660e\u7ec6\u5217\u8868")
    public void exportDefNodeUserByTeam(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody SearchDefNodeVO searchDefNodeVO, HttpServletResponse httpServletResponse) throws Exception {
        ((BpmDefinitionManager)this.baseService).exportDefNodeUserByTeam(searchDefNodeVO, httpServletResponse);
    }

    @PostMapping(value={"operatingDefSetting"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8f6c\u79fb\u3001\u590d\u5236\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u914d\u7f6e\u4fe1\u606f\u7ed9\uff08\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u89d2\u8272\u3001\u5c97\u4f4d\uff09")
    public CommonResult<String> operatingDefSetting(@ApiParam(name="map", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody Map<String, Object> map) throws Exception {
        return ((BpmDefinitionManager)this.baseService).operatingDefSetting(map);
    }

    @PostMapping(value={"saveDefTags"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49\u6807\u7b7e")
    public CommonResult<String> saveDefTags(@RequestBody ObjectNode params) {
        ((BpmDefinitionManager)this.baseService).saveDefTags(params);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"getMainByDefIdOrKey"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u6216\u8005\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u4e3b\u7248\u672c\u5bf9\u8c61", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u6216\u8005\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u4e3b\u7248\u672c\u5bf9\u8c61")
    public DefaultBpmDefinition getMainByDefIdOrKey(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam Optional<String> defId, @ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam Optional<String> defKey) {
        DefaultBpmDefinition po;
        String definitionKey = defKey.orElse("");
        if (StringUtil.isEmpty((String)definitionKey)) {
            if (StringUtil.isNotEmpty((String)defId.orElse(""))) {
                DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)defId.get()));
                if (BeanUtils.isEmpty((Object)defaultBpmDefinition)) {
                    throw new BaseException(String.format("\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id[%s]\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49", defId));
                }
                definitionKey = defaultBpmDefinition.getDefKey();
            } else {
                throw new BaseException(String.format("\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key\u548c\u6d41\u7a0b\u5b9a\u4e49id[%s]\u4e0d\u80fd\u90fd\u4e3a\u7a7a", defId));
            }
        }
        if (BeanUtils.isEmpty((Object)(po = this.bpmDefinitionManager.getMainByDefKey(definitionKey)))) {
            throw new BaseException(String.format("\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key[%s]\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49", definitionKey));
        }
        po.setBpmnXml("");
        return po;
    }

    @GetMapping(value={"getFlowKeyByDefId"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bdefId\u83b7\u53d6\u6d41\u7a0bflowKey", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0bdefId\u83b7\u53d6\u6d41\u7a0bflowKey")
    public CommonResult<String> getFlowKeyByDefId(@RequestParam(value="defId") String defId) {
        DefaultBpmDefinition definition = this.bpmDefService.getDefDesignByDefId(defId);
        if (definition != null) {
            return CommonResult.ok().value((Object)definition.getDefKey());
        }
        return CommonResult.error().message("\u8be5\u6d41\u7a0b\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"batchDeleteNode"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u6d41\u7a0b\u7684\u67d0\u4e00\u4e2a\u8282\u70b9", httpMethod="GET", notes="\u5220\u9664\u6307\u5b9a\u6d41\u7a0b\u7684\u67d0\u4e00\u4e2a\u8282\u70b9")
    public HashMap<String, Object> batchDeleteNode(@RequestParam(value="nodeName") String nodeName, @RequestParam(value="defIds") String defIds) throws Exception {
        return ((BpmDefinitionManager)this.baseService).batchDeleteNode(nodeName, defIds);
    }

    @PostMapping(value={"batchAddNode"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u8282\u70b9", httpMethod="POST", notes="\u6279\u91cf\u6dfb\u52a0\u8282\u70b9")
    public HashMap<String, Object> batchAddNode(@RequestBody HashMap<String, Object> parmter) throws Exception {
        return ((BpmDefinitionManager)this.baseService).batchAddNode(parmter);
    }

    @GetMapping(value={"webDefDesignByDefKey"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636edefkey\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml", httpMethod="GET", notes="\u6839\u636edefkey\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml")
    public Object webDefDesignByDefKey(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String defKey) {
        return this.bpmDefinitionManager.webDefDesignByDefKey(defKey);
    }

    @PostMapping(value={"physicsRemoveAllVersionByKey"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key\uff0c\u7269\u7406\u5220\u9664\u6240\u6709\u7248\u672c\u7684\u6d41\u7a0b\u76f8\u5173\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key\uff0c\u7269\u7406\u5220\u9664\u6240\u6709\u7248\u672c\u7684\u6d41\u7a0b\u76f8\u5173\u6570\u636e")
    public CommonResult<String> physicsRemoveAllVersionByKey(@RequestBody List<String> keys) {
        try {
            this.bpmDefinitionManager.physicsRemoveAllVersionByKey(keys);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new CommonResult(false, "\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25:" + rootCauseMessage, (Object)"");
        }
    }

    @GetMapping(value={"checkDefKey"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6821\u9a8c\u6d41\u7a0b\u5b9a\u4e49\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u6821\u9a8c\u6d41\u7a0b\u5b9a\u4e49\u662f\u5426\u5b58\u5728")
    public CommonResult<Boolean> checkDefKey(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String defKey) {
        List definitions = this.bpmDefinitionManager.queryByDefKeyUppercase(defKey);
        return CommonResult.success((Object)BeanUtils.isNotEmpty((Object)definitions));
    }
}

