/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.NewVersion;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.helper.identity.UserQueryPluginHelper;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmSubTableRight;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.AutoTaskDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.DefaultJumpRule;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.PrivilegeItem;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.SignRule;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.engine.def.impl.handler.ServiceNodeBpmDefXmlHandler;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.plugin.core.util.UserAssignRuleParser;
import com.hotent.bpmModel.manager.BpmNodeService;
import com.hotent.bpmModel.params.DefConfSaveVo;
import com.hotent.bpmModel.params.NodeConfCopyVo;
import com.hotent.bpmModel.params.NodeConfSaveVo;
import com.hotent.bpmModel.params.VarTreeGetVo;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/flow/node/v1/"})
@Api(tags={"\u6d41\u7a0b\u8282\u70b9\u8bbe\u7f6e"})
@ApiGroup(group={"group_bpm"})
@NewVersion
public class NodeController {
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    private UserQueryPluginHelper userQueryPluginHelper;
    @Autowired
    FormFeignService formFeignService;
    @Autowired
    private BpmNodeService nodeService;

    @RequestMapping(value={"saveSub"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u6743\u9650\u914d\u7f6e", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public CommonResult<String> saveSub(@ApiParam(name="nodeId", value="\u8282\u70b9ID") @RequestParam String nodeId, @ApiParam(name="defId", value="\u6743\u9650\u7c7b\u578b ") @RequestParam String defId, @ApiParam(name="parentDefKey", value="\u7236\u6d41\u7a0b\u5b9a\u4e49") @RequestParam String parentDefKey, HttpServletRequest request) throws Exception {
        CommonResult<String> res = this.nodeService.saveSub(nodeId, defId, parentDefKey, request);
        return res;
    }

    @RequestMapping(value={"initSub"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u663e\u793a\u8868\u5355\u6743\u9650\u914d\u7f6e", httpMethod="GET", notes="\u663e\u793a\u8868\u5355\u6743\u9650\u914d\u7f6e")
    public Object initSub(@ApiParam(name="nodeId", value="\u8282\u70b9ID") @RequestParam String nodeId, @ApiParam(name="defId", value="\u6743\u9650\u7c7b\u578b ") @RequestParam String defId, @ApiParam(name="parentDefKey", value="\u7236\u6d41\u7a0b\u5b9a\u4e49") @RequestParam String parentDefKey) throws Exception {
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        UserTaskNodeDef utnd = (UserTaskNodeDef)nodeDef;
        for (BpmSubTableRight bsr : utnd.getBpmSubTableRightByParentDefKey(parentDefKey)) {
            map.put(bsr.getTableName(), JsonUtil.toJsonNode((Object)bsr));
        }
        return map;
    }

    @RequestMapping(value={"ruleEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u8282\u70b9\u89c4\u5219\u9875\u9762\u521d\u59cb\u5316\u6570\u636e", httpMethod="GET", notes="\u7f16\u8f91\u8282\u70b9\u89c4\u5219\u9875\u9762\u521d\u59cb\u5316\u6570\u636e")
    public Map<String, Object> ruleEdit(@ApiParam(name="definitionId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String definitionId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId) throws Exception {
        Map<String, Object> res = this.nodeService.ruleEdit(definitionId, nodeId);
        return res;
    }

    @RequestMapping(value={"ruleListJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8282\u70b9\u89c4\u5219\u5217\u8868", httpMethod="POST", notes="\u8282\u70b9\u89c4\u5219\u5217\u8868")
    public PageList<DefaultJumpRule> ruleListJson(@ApiParam(name="definitionId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String definitionId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId) throws Exception {
        UserTaskNodeDef nodeDef = (UserTaskNodeDef)this.bpmDefinitionService.getBpmNodeDefByDefIdNodeId(definitionId, nodeId);
        List rules = nodeDef.getJumpRuleList();
        if (rules == null) {
            rules = Collections.EMPTY_LIST;
        }
        return new PageList(rules);
    }

    @RequestMapping(value={"isSubFirstNode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u662f\u5426\u662f\u5b50\u6d41\u7a0b\u4e2d\u975e\u7b2c\u4e00\u8282\u70b9", httpMethod="GET", notes="\u8282\u70b9\u89c4\u5219\u5217\u8868")
    public CommonResult<Boolean> isSubFirstNode(@ApiParam(name="definitionId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String definitionId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId, @ApiParam(name="parentKey", value="\u7236\u6d41\u7a0bKey") @RequestParam String parentKey) throws Exception {
        return this.nodeService.isSubFirstNode(definitionId, nodeId, parentKey);
    }

    @RequestMapping(value={"ruleSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8282\u70b9\u7684\u8df3\u8f6c\u89c4\u5219", httpMethod="POST", notes="\u4fdd\u5b58\u8282\u70b9\u7684\u8df3\u8f6c\u89c4\u5219")
    public CommonResult<String> ruleSave(@ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId, @ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeList", value="\u8282\u70b9\u89c4\u5219json", required=true) @RequestBody List<JsonNode> nodeList) throws Exception {
        CommonResult<String> res = this.nodeService.ruleSave(nodeId, defId, nodeList);
        return res;
    }

    @RequestMapping(value={"nodeUserConditionSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8282\u70b9json \u914d\u7f6e", httpMethod="POST", notes="\u4fdd\u5b58\u8282\u70b9json \u914d\u7f6e")
    public CommonResult<String> nodeUserConditionSave(@ApiParam(name="vo", value="\u8282\u70b9\u4fdd\u5b58\u5bf9\u8c61") @RequestBody NodeConfSaveVo vo) throws Exception {
        CommonResult<String> res = this.nodeService.nodeUserConditionSave(vo);
        return res;
    }

    @RequestMapping(value={"eventScriptEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8282\u70b9\u89c4\u5219\u811a\u672c\u8bbe\u7f6e", httpMethod="GET", notes="\u8282\u70b9\u89c4\u5219\u811a\u672c\u8bbe\u7f6e")
    public Map<String, Object> eventScriptEdit(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId) throws Exception {
        return this.nodeService.eventScriptEdit(defId, nodeId);
    }

    @RequestMapping(value={"eventScriptSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8282\u70b9\u4e8b\u4ef6\u811a\u672c\u4fdd\u5b58", httpMethod="POST", notes="\u8282\u70b9\u4e8b\u4ef6\u811a\u672c\u4fdd\u5b58")
    public CommonResult<String> eventScriptSave(@ApiParam(name="vo", value="\u8282\u70b9\u914d\u7f6e\u4fdd\u5b58\u5bf9\u8c61") @RequestBody NodeConfSaveVo vo) throws Exception {
        CommonResult<String> res = this.nodeService.eventScriptSave(vo);
        return res;
    }

    @RequestMapping(value={"branchConditionEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u652f\u8bbe\u7f6e\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u5206\u652f\u8bbe\u7f6e\u4fe1\u606f")
    public Map<String, Object> branchConditionEdit(@ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId, @ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        Map<String, Object> res = this.nodeService.branchConditionEdit(nodeId, defId);
        return res;
    }

    @RequestMapping(value={"branchConditionSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u652f\u8282\u70b9\u89c4\u5219\u811a\u672c\u4fdd\u5b58", httpMethod="POST", notes="\u5206\u652f\u8282\u70b9\u89c4\u5219\u811a\u672c\u4fdd\u5b58")
    public CommonResult<String> branchConditionSave(@ApiParam(name="vo", value="\u8282\u70b9\u914d\u7f6e\u4fdd\u5b58\u5bf9\u8c61") @RequestBody NodeConfSaveVo vo) throws Exception {
        CommonResult<String> res = this.nodeService.branchConditionSave(vo);
        return res;
    }

    @RequestMapping(value={"autoTaskManager"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u52a8\u4efb\u52a1\u7ba1\u7406", httpMethod="GET", notes="\u81ea\u52a8\u4efb\u52a1\u7ba1\u7406")
    public Map<String, Object> autoTaskManager(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        AutoTaskDef autoTaskDef = (AutoTaskDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        BpmPluginContext bpmPluginContext = autoTaskDef.getAutoTaskBpmPluginContext();
        data.put("bpmPluginContext", bpmPluginContext);
        return data;
    }

    @RequestMapping(value={"autoTaskPluginGet"})
    public Map<String, Object> autoTaskPluginGet(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId, @ApiParam(name="pluginType", value="\u63d2\u4ef6\u7c7b\u578b") @RequestParam String pluginType) throws Exception {
        Map<String, Object> res = this.nodeService.autoTaskPluginGet(defId, nodeId, pluginType);
        return res;
    }

    @RequestMapping(value={"autoTaskPluginSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u52a8\u8282\u70b9\u4fdd\u5b58json \u914d\u7f6e", httpMethod="POST", notes="\u81ea\u52a8\u8282\u70b9\u4fdd\u5b58json \u914d\u7f6e")
    public CommonResult<String> autoTaskPluginSave(@ApiParam(name="vo", value="\u8282\u70b9\u914d\u7f6e\u4fdd\u5b58\u5bf9\u8c61") @RequestBody NodeConfSaveVo vo) throws Exception {
        String defId = vo.getDefId();
        String nodeId = vo.getNodeId();
        String jsonStr = vo.getJsonStr();
        try {
            if (StringUtil.isNotEmpty((String)nodeId)) {
                ServiceNodeBpmDefXmlHandler serviceNodeDefXmlHandler = (ServiceNodeBpmDefXmlHandler)AppUtil.getBean(ServiceNodeBpmDefXmlHandler.class);
                serviceNodeDefXmlHandler.saveNodeXml(defId, nodeId, (Object)jsonStr);
            }
            return new CommonResult("\u66f4\u65b0\u8282\u70b9\u914d\u7f6e\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u66f4\u65b0\u8282\u70b9\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"getSignConfig"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4f1a\u7b7e\u89c4\u5219\u7279\u6743\u914d\u7f6e", httpMethod="GET", notes="\u83b7\u53d6\u4f1a\u7b7e\u89c4\u5219\u7279\u6743\u914d\u7f6e")
    public Object getSignConfig(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId) throws Exception {
        SignNodeDef signNodeDef = (SignNodeDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List privilegeList = signNodeDef.getPrivilegeList();
        SignRule signRule = signNodeDef.getSignRule();
        HashMap<String, ObjectNode> map = new HashMap<String, ObjectNode>();
        map.put("privilegeList", this.getPrivilegeListJson(privilegeList));
        map.put("signRule", SignRule.toJson((SignRule)signRule));
        return map;
    }

    private ObjectNode getPrivilegeListJson(List<PrivilegeItem> privilegeList) throws IOException {
        ObjectNode ObjectNode2 = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isEmpty(privilegeList)) {
            return ObjectNode2;
        }
        for (PrivilegeItem privilege : privilegeList) {
            ArrayNode config = JsonUtil.getMapper().createArrayNode();
            UserAssignRuleParser.handJsonConfig((ArrayNode)config, (List)privilege.getUserRuleList());
            ObjectNode2.set(privilege.getPrivilegeMode().getKey(), (JsonNode)config);
        }
        String json = ObjectNode2.toString().replaceAll("null,", "\"\",");
        return (ObjectNode)JsonUtil.toJsonNode((String)json);
    }

    @RequestMapping(value={"signConfigSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f1a\u7b7e\u89c4\u5219\u7279\u6743\u914d\u7f6e", httpMethod="POST", notes="\u83b7\u53d6\u4f1a\u7b7e\u89c4\u5219\u7279\u6743\u914d\u7f6e")
    public Object signConfigSave(@ApiParam(name="vo", value="\u8282\u70b9\u914d\u7f6e\u4fdd\u5b58\u5bf9\u8c61") @RequestBody NodeConfSaveVo vo) throws Exception {
        Object res = this.nodeService.signConfigSave(vo);
        return res;
    }

    @RequestMapping(value={"previewCondition"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9884\u89c8\u4eba\u5458\u6761\u4ef6", httpMethod="GET", notes="\u6dfb\u52a0bo\u5b9a\u4e49")
    public PageList<IUser> previewCondition(@ApiParam(name="conditionArray", value="\u4eba\u5458\u6761\u4ef6\u6570\u7ec4", required=true) @RequestParam String conditionArray, @ApiParam(name="variables", value="\u53d8\u91cf", required=true) @RequestParam String variables) throws Exception {
        ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)variables);
        Map map = (Map)obj;
        List users = this.userQueryPluginHelper.queryUsersByConditions(conditionArray, map);
        return (PageList)users;
    }

    private List<BpmVariableDef> getAllBpmVariableDef(String defId, String nodeId) throws Exception {
        ArrayList<BpmVariableDef> bpmVariableList = new ArrayList<BpmVariableDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (defExt.getVariableList() != null) {
            bpmVariableList.addAll(defExt.getVariableList());
        }
        List list = bpmProcessDefExt.getBpmnNodeDefs();
        for (BpmNodeDef node : list) {
            UserTaskNodeDef targetNodeDef;
            if (!node.getNodeId().equals(nodeId) || !node.getType().toString().equalsIgnoreCase("usertask") || (targetNodeDef = (UserTaskNodeDef)node).getVariableList() == null) continue;
            bpmVariableList.addAll(targetNodeDef.getVariableList());
        }
        return bpmVariableList;
    }

    @RequestMapping(value={"userAssignConditionDialog"})
    public ModelAndView userAssignConditionDialog(HttpServletRequest request, HttpServletResponse response, String defId, String nodeId) throws Exception {
        return new ModelAndView("/flow/def/userAssignConditionDialog.jsp").addObject("defId", (Object)defId).addObject("nodeId", (Object)nodeId);
    }

    @RequestMapping(value={"validHandler"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1handler\u3002 \u8f93\u5165\u683c\u5f0f\u4e3a serviceId +.\u6cd5\u540d", httpMethod="GET", notes="\u9a8c\u8bc1handler\u3002 \u8f93\u5165\u683c\u5f0f\u4e3a serviceId +.\u6cd5\u540d")
    public Object validHandler(@ApiParam(name="handler", value="handler\u5b57\u7b26\u4e32", required=true) @RequestParam String handler) throws IOException {
        Object res = this.nodeService.validHandler(handler);
        return res;
    }

    @RequestMapping(value={"varTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u53d8\u91cf\u5bf9\u8bdd\u6846\u7684\u6811 \u5176\u4e2d\u5305\u542b\uff1abodef\u7684\u5b57\u6bb5\uff0c\u6d41\u7a0b\u53d8\u91cf\uff0c\u6d41\u7a0b\u5e38\u91cf\uff08\u53d1\u8d77\u4eba,\u5f53\u524d\u7528\u6237,...\uff09", httpMethod="POST", notes="\u6d41\u7a0b\u53d8\u91cf\u5bf9\u8bdd\u6846\u7684\u6811 \u5176\u4e2d\u5305\u542b\uff1abodef\u7684\u5b57\u6bb5\uff0c\u6d41\u7a0b\u53d8\u91cf\uff0c\u6d41\u7a0b\u5e38\u91cf\uff08\u53d1\u8d77\u4eba,\u5f53\u524d\u7528\u6237,...\uff09")
    public Object varTree(@ApiParam(name="vo", value="\u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf\u53c2\u6570", required=true) @RequestBody VarTreeGetVo vo) throws Exception {
        Object res = this.nodeService.varTree(vo);
        return res;
    }

    @RequestMapping(value={"getNodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u7684\u5217\u8868 \u4e00\u4e9b\u57fa\u672c\u4fe1\u606f\u800c\u5df2", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u7684\u5217\u8868 \u4e00\u4e9b\u57fa\u672c\u4fe1\u606f\u800c\u5df2")
    public Object getNodes(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        Object res = this.nodeService.getNodes(defId);
        return res;
    }

    @RequestMapping(value={"getDefSetting"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u914d\u7f6e\u9875\u9762json\u6570\u636e", httpMethod="GET", notes="\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u914d\u7f6e\u9875\u9762json\u6570\u636e")
    public Map<String, Object> nodeDefSetting(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="topDefKey", value="\u7236\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String topDefKey) throws Exception {
        Map<String, Object> res = this.nodeService.nodeDefSetting(defId, topDefKey);
        return res;
    }

    @RequestMapping(value={"saveDefConf"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u914d\u7f6e", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u7a0b\u914d\u7f6e")
    public CommonResult<String> saveDefConf(@ApiParam(name="vo", value="\u6d41\u7a0b\u8bbe\u7f6e\u4fdd\u5b58\u5bf9\u8c61") @RequestBody DefConfSaveVo vo) throws Exception {
        return this.nodeService.saveDefConf(vo);
    }

    @RequestMapping(value={"getNodeOutcomes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u5f53\u524d\u8282\u70b9\u7684\u6240\u6709\u51fa\u53e3\u8282\u70b9\u96c6\u5408", httpMethod="GET", notes="\u53d6\u5f97\u5f53\u524d\u8282\u70b9\u7684\u6240\u6709\u51fa\u53e3\u8282\u70b9\u96c6\u5408")
    public Map<String, Object> getNodeOutcomes(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId) throws Exception {
        Map<String, Object> res = this.nodeService.getNodeOutcomes(defId, nodeId);
        return res;
    }

    @RequestMapping(value={"getNodeAutoTask"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u52a8\u4efb\u52a1\u4fe1\u606f\u660e\u7ec6", httpMethod="GET", notes="\u81ea\u52a8\u4efb\u52a1\u4fe1\u606f\u660e\u7ec6")
    public Object getNodeAutoTask(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId) throws Exception {
        Object res = this.nodeService.getNodeAutoTask(defId, nodeId);
        return res;
    }

    @RequestMapping(value={"getGlobalForm"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u83b7\u53d6\u5168\u5c40\u8868\u5355", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u83b7\u53d6\u5168\u5c40\u8868\u5355")
    public ObjectNode getGlobalForm(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49ID") @RequestParam String defId, @ApiParam(name="type", value="\u8868\u5355\u7c7b\u578b(PC\u6216\u8005mobile)") @RequestParam String type) throws Exception {
        try {
            return this.nodeService.getGlobalForm(defId, type);
        }
        catch (BaseException e) {
            e.setMessage("url\u8868\u5355\u914d\u7f6e\u9664\u5916");
            throw e;
        }
    }

    @RequestMapping(value={"copyNodeConf"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8282\u70b9\u914d\u7f6e\u590d\u5236", httpMethod="POST", notes="\u8282\u70b9\u914d\u7f6e\u590d\u5236")
    public CommonResult<String> copyNodeConf(@ApiParam(name="vo", value="\u8282\u70b9\u590d\u5236\u5bf9\u8c61") @RequestBody NodeConfCopyVo vo) throws Exception {
        CommonResult<String> res = this.nodeService.copyNodeConf(vo);
        return res;
    }

    @RequestMapping(value={"getDefSettingByDefKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u914d\u7f6e\u9875\u9762json\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u914d\u7f6e\u9875\u9762json\u6570\u636e")
    public Map<String, Object> getDefSettingByDefKey(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String defKey, @ApiParam(name="topDefKey", value="\u7236\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String topDefKey) throws Exception {
        Map<String, Object> res = this.nodeService.getDefSettingByDefKey(defKey, topDefKey);
        return res;
    }
}

