/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.controller;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.NewVersion;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.bpm.api.model.process.def.BpmWordPrintDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpmModel.manager.BpmWordPrintService;
import com.hotent.bpmModel.params.BpmWordPrintDefVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flow/wordPrint/v1/"})
@Api(tags={"\u6d41\u7a0b\u5957\u6253\u6a21\u677f"})
@ApiGroup(group={"group_bpm"})
@NewVersion
public class WordPrintController {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    FormFeignService formFeignService;
    @Autowired
    private BpmWordPrintService wordPrintService;

    @RequestMapping(value={"listJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5957\u6253\u6a21\u677f\u5217\u8868\u6570\u636e", httpMethod="GET", notes="\u6d41\u7a0b\u5957\u6253\u6a21\u677f\u5217\u8868\u6570\u636e")
    public List<BpmWordPrintDef> listJson(@ApiParam(name="defId", value="\u5e38\u7528\u8bedid") @RequestParam String defId) throws Exception {
        List<BpmWordPrintDef> res = this.wordPrintService.listJson(defId);
        return res;
    }

    @RequestMapping(value={"wordPrintEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u8282\u70b9\u5957\u6253\u6a21\u677f", httpMethod="GET", notes="\u7f16\u8f91\u8282\u70b9\u5957\u6253\u6a21\u677f")
    public BpmWordPrintDef wordPrintEdit(@ApiParam(name="defId", value="\u5e38\u7528\u8bedid") @RequestParam String defId, @ApiParam(name="alias", value="\u5957\u6253\u6a21\u677f\u522b\u540d") @RequestParam String alias) throws Exception {
        BpmWordPrintDef res = this.wordPrintService.wordPrintEdit(defId, alias);
        return res;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u8282\u70b9\u5957\u6253\u6a21\u677f", httpMethod="DELETE", notes="\u5220\u9664\u8282\u70b9\u5957\u6253\u6a21\u677f")
    public CommonResult<String> remove(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="alias", value="\u5957\u6253\u6a21\u677fkey", required=true) @RequestParam String alias) throws Exception {
        CommonResult<String> res = this.wordPrintService.remove(defId, alias);
        return res;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8282\u70b9\u89c4\u5219", httpMethod="POST", notes="\u4fdd\u5b58\u8282\u70b9\u89c4\u5219")
    public CommonResult<String> save(@ApiParam(name="variableDefVo", value="\u4fdd\u5b58\u8282\u70b9\u89c4\u5219", required=true) @RequestBody BpmWordPrintDefVo wordPrintDefVo) throws Exception {
        CommonResult<String> res = this.wordPrintService.save(wordPrintDefVo);
        return res;
    }

    @RequestMapping(value={"getAllFormPrintTemplateByDefId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u914d\u7f6e\u9875\u9762json\u6570\u636e", httpMethod="GET", notes="\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u914d\u7f6e\u9875\u9762json\u6570\u636e")
    public List<ObjectNode> getAllFormPrintTemplateByDefId(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="topDefKey", value="\u7236\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String topDefKey) throws Exception {
        List<ObjectNode> res = this.wordPrintService.getAllFormPrintTemplateByDefId(defId, topDefKey);
        return res;
    }

    @RequestMapping(value={"getFormPrintTemplates"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u914d\u7f6e\u9875\u9762json\u6570\u636e", httpMethod="GET", notes="\u6d41\u7a0b\u5b9a\u4e49\u8282\u70b9\u914d\u7f6e\u9875\u9762json\u6570\u636e")
    public List<ObjectNode> getFormPrintTemplates(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="instId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String instId, @ApiParam(name="topDefKey", value="\u7236\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String topDefKey, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam Optional<String> nodeId, @ApiParam(name="formKey", value="\u8868\u5355key\uff08\u7528\u4e8e\u517c\u5bb9\u65e7\u6570\u636e\uff0c\u53d6\u65e7\u6570\u636e\u6a21\u677f\uff09", required=true) @RequestParam Optional<String> formKey) throws Exception {
        List<ObjectNode> res = this.wordPrintService.getFormPrintTemplates(defId, instId, topDefKey, nodeId, formKey);
        return res;
    }

    @RequestMapping(value={"getGlobalPrintTemplate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5168\u5c40\u5957\u6253\u6a21\u677f", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u5168\u5c40\u5957\u6253\u6a21\u677f")
    public CommonResult<List> getGlobalPrintTemplate(@ApiParam(name="defId", value="\u5b9a\u4e49ID", required=true) @RequestParam String defId) throws Exception {
        return new CommonResult(true, "", (Object)this.wordPrintService.getGlobalPrintTemplate(defId));
    }
}

