/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.bpm.api.constant.DesignerType;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.process.def.BpmBoDef;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmDefSetting;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmFormInit;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.engine.def.BpmDefUtil;
import com.hotent.bpm.engine.def.ButtonDTO;
import com.hotent.bpm.engine.def.impl.handler.BoBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.BpmDefSettingBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.BpmFormInitBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.ButtonsBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.PropertiesBpmDefXmlHandler;
import com.hotent.bpm.engine.task.skip.SkipConditionUtil;
import com.hotent.bpm.model.def.BpmDefXml;
import com.hotent.bpm.model.def.BpmDefXmlList;
import com.hotent.bpm.persistence.dao.BpmDefinitionDao;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProBoManager;
import com.hotent.bpm.persistence.model.BpmProBo;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.bpmModel.manager.BpmDefService;
import com.hotent.bpmModel.manager.BpmDefTransform;
import com.hotent.bpmModel.params.DefBoSetVo;
import com.hotent.bpmModel.params.DefBtnsSaveVo;
import com.hotent.bpmModel.params.DefPropSaveVo;
import com.hotent.bpmModel.params.DefaultBpmDefinitionVo;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class DefServiceImpl
implements BpmDefService {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmProBoManager bpmProBoManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmFormInitBpmDefXmlHandler bpmFormInitBpmDefXmlHandler;
    @Resource
    BoBpmDefXmlHandler boBpmDefXmlHandler;
    @Resource
    PortalFeignService PortalFeignService;
    @Resource
    PropertiesBpmDefXmlHandler propertiesBpmDefXmlHandler;
    @Resource
    BpmDefTransform bpmDefTransform;
    @Autowired
    BpmDefinitionManager bpmDefinitionManagerImpl;
    @Resource
    ButtonsBpmDefXmlHandler buttonsBpmDefXmlHandler;
    @Autowired
    BpmDefinitionDao bpmDefinitionDao;
    @Resource
    FormFeignService formFeignService;

    @Override
    public CommonResult<String> flexDefSave(DefaultBpmDefinitionVo bpmDefinitionVo) {
        Boolean isDeploy = bpmDefinitionVo.getIsdeploy();
        DefaultBpmDefinition bpmDefinition = null;
        try {
            bpmDefinition = this.getFromRequest(bpmDefinitionVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String resultMsg = "";
        try {
            List oldDefs;
            if (StringUtils.isEmpty((String)bpmDefinition.getDefId()) && BeanUtils.isNotEmpty((Object)(oldDefs = this.bpmDefinitionManager.queryByDefKey(bpmDefinition.getDefKey())))) {
                resultMsg = "\u6d41\u7a0b\u5b9a\u4e49KEY\u201c" + bpmDefinition.getDefKey() + "\u201d \u5df2\u7ecf\u5b58\u5728\u4e8e\uff1a" + ((DefaultBpmDefinition)oldDefs.get(0)).getName();
                return new CommonResult(false, resultMsg, (Object)"");
            }
            if (isDeploy.booleanValue()) {
                this.bpmDefinitionService.deploy((BpmDefinition)bpmDefinition);
            } else if (StringUtils.isNotEmpty((String)bpmDefinition.getDefId())) {
                this.bpmDefinitionService.updateBpmDefinition((BpmDefinition)bpmDefinition);
            } else {
                this.bpmDefinitionService.saveDraft((BpmDefinition)bpmDefinition);
            }
            return new CommonResult(true, "\u6d41\u7a0b\u53d1\u5e03\u6210\u529f", (Object)"");
        }
        catch (Exception ex) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            return new CommonResult(false, "\u6d41\u7a0b\u53d1\u5e03\u5931\u8d25\uff1a" + rootCauseMessage, (Object)"");
        }
    }

    @Override
    public PageList<DefaultBpmDefinition> formDeflist(String boCode, String formKey, QueryFilter<DefaultBpmDefinition> queryFilter) {
        List proBos = this.bpmProBoManager.getByBoCode(boCode);
        if (BeanUtils.isNotEmpty((Object)proBos)) {
            HashSet<String> defIds = new HashSet<String>();
            HashSet<String> defKeys = new HashSet<String>();
            for (BpmProBo proBo : proBos) {
                if (StringUtil.isNotEmpty((String)proBo.getProcessId())) {
                    defIds.add(proBo.getProcessId());
                }
                if (!StringUtil.isNotEmpty((String)proBo.getProcessKey())) continue;
                defKeys.add(proBo.getProcessKey());
            }
            if (BeanUtils.isNotEmpty(defIds)) {
                queryFilter.addFilter("defId", (Object)defIds.toArray(new String[defIds.size()]), QueryOP.IN, FieldRelation.OR, "def");
            }
            if (BeanUtils.isNotEmpty(defKeys)) {
                queryFilter.addFilter("def_key_", (Object)defKeys.toArray(new String[defKeys.size()]), QueryOP.IN, FieldRelation.OR, "def");
            }
            queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "isMain");
            PageList bpmDefinitionList = null;
            try {
                bpmDefinitionList = this.bpmDefinitionManager.queryList(queryFilter);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (String str : defIds) {
                boolean form;
                DefaultBpmDefinition result = this.bpmDefinitionManager.getById(str);
                if (BeanUtils.isEmpty((Object)result)) continue;
                BpmProcessDef bpmProcessDef = null;
                try {
                    bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(str);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!BeanUtils.isNotEmpty((Object)bpmProcessDef)) continue;
                DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
                FormExt globalForm = defExt.getGlobalForm();
                FormExt globalMobileForm = defExt.getGlobalMobileForm();
                boolean bl = globalForm != null ? !formKey.equals(globalForm.getFormValue()) : (form = true);
                boolean mobile = globalMobileForm != null ? !formKey.equals(globalMobileForm.getFormValue()) : true;
                int i = 0;
                ArrayList<Integer> list = null;
                for (DefaultBpmDefinition def : bpmDefinitionList.getRows()) {
                    if (def.getDefId().equals(bpmProcessDef.getProcessDefinitionId()) && form && mobile) {
                        list = new ArrayList<Integer>();
                        list.add(i);
                    }
                    ++i;
                }
                if (list == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int j = (Integer)iterator.next();
                    bpmDefinitionList.getRows().remove(j);
                    bpmDefinitionList.setTotal(bpmDefinitionList.getTotal() - 1L);
                }
            }
            return bpmDefinitionList;
        }
        return new PageList((IPage)new Page(1L, (long)queryFilter.getPageBean().getPageSize().intValue()));
    }

    @Override
    public Object save(DefaultBpmDefinitionVo bpmVo) {
        String resultMsg = null;
        String isDeploy = String.valueOf(bpmVo.getIsdeploy());
        String isSave = String.valueOf(bpmVo.getIsSave());
        String defXml = bpmVo.getDefXml();
        DefaultBpmDefinition bpmDefinition = bpmVo.getDefaultBpmDefinition();
        MultipartFile fileLoad = bpmVo.getFile();
        if (fileLoad == null) {
            bpmDefinition.setDefXml(defXml);
        } else {
            try {
                bpmDefinition.setDefXml(FileUtil.inputStream2String((InputStream)fileLoad.getInputStream()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        bpmDefinition.setDesigner(DesignerType.ECLIPSE.name());
        try {
            if ("true".equals(isDeploy)) {
                if (StringUtils.isNotEmpty((String)bpmDefinition.getDefId())) {
                    DefaultBpmDefinition oldBpmDefinition = this.bpmDefinitionManager.getById(bpmDefinition.getDefId());
                    BeanUtils.copyNotNullProperties((Object)oldBpmDefinition, (Object)bpmDefinition);
                    this.bpmDefinitionService.deploy((BpmDefinition)oldBpmDefinition);
                    resultMsg = "\u6210\u529f\u53d1\u5e03\u65b0\u7248\u672c\u6d41\u7a0b\u5b9a\u4e49\uff01";
                } else {
                    this.bpmDefinitionService.deploy((BpmDefinition)bpmDefinition);
                    resultMsg = "\u6210\u529f\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49\uff01";
                }
            } else if ("true".equals(isSave) && StringUtils.isNotEmpty((String)bpmDefinition.getDefId())) {
                DefaultBpmDefinition oldBpmDefinition = this.bpmDefinitionManager.getById(bpmDefinition.getDefId());
                BeanUtils.copyNotNullProperties((Object)oldBpmDefinition, (Object)bpmDefinition);
                this.bpmDefinitionService.updateBpmDefinition((BpmDefinition)oldBpmDefinition);
                resultMsg = "\u6210\u529f\u66f4\u65b0\u6d41\u7a0b\u5b9a\u4e49\uff01";
            } else {
                this.bpmDefinitionService.saveDraft((BpmDefinition)bpmDefinition);
                resultMsg = "\u6210\u529f\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49\u8349\u7a3f\uff01";
            }
            return new CommonResult(true, resultMsg, (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, " \u64cd\u4f5c\u51fa\u9519\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @Override
    public CommonResult<String> saveSetBos(DefBoSetVo defBoSetVo) throws Exception {
        CommonResult msg = new CommonResult(false, "BO\u8bbe\u7f6e\u5185\u5bb9\u4e3a\u7a7a!", (Object)"\u5185\u5bb9\u4e3a\u7a7a!");
        String userId = ContextUtil.getCurrentUser().getUserId();
        String json = defBoSetVo.getJson();
        String topDefKey = defBoSetVo.getTopDefKey();
        String flowId = defBoSetVo.getFlowId();
        Boolean isClearForm = defBoSetVo.getIsClearForm();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(flowId);
        ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((String)json);
        BpmFormInit formInit = new BpmFormInit();
        if (jsonObj.findValue("formInitItems") != null) {
            formInit = (BpmFormInit)JsonUtil.toBean((String)json, BpmFormInit.class);
            formInit.setParentDefKey(topDefKey);
        }
        this.bpmFormInitBpmDefXmlHandler.saveNodeXml(flowId, "", (Object)formInit);
        ObjectNode bodefJson = (ObjectNode)jsonObj.get("bodef");
        BpmBoDef bpmBoDef = new BpmBoDef();
        if (bodefJson != null) {
            bpmBoDef = (BpmBoDef)JsonUtil.toBean((JsonNode)bodefJson, BpmBoDef.class);
            this.saveBpmProBoList(userId, flowId, def.getDefKey(), topDefKey, bpmBoDef, isClearForm);
        }
        this.boBpmDefXmlHandler.saveNodeXml(flowId, "", (Object)bpmBoDef);
        msg.setState(Boolean.valueOf(true));
        msg.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
        msg.setValue((Object)"\u5185\u5bb9\u5b8c\u6574\uff01");
        return msg;
    }

    @Override
    public void getFlowListByTypeId(String typeId, String word, HttpServletResponse response) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)typeId)) {
            params.put("typeId", typeId);
        }
        if (StringUtil.isNotEmpty((String)word)) {
            word = "%" + word + "%";
            params.put(typeId, typeId);
        }
        List list = this.bpmDefinitionManager.queryListByMap(params);
        StringBuffer msg = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Result>");
        for (DefaultBpmDefinition bpmDefinition : list) {
            msg.append("<item name=\"" + bpmDefinition.getName() + "\" key=\"" + bpmDefinition.getDefKey() + "\" type=\"" + bpmDefinition.getTypeId() + "\"></item>");
        }
        msg.append("</Result>");
        PrintWriter out = response.getWriter();
        out.println(msg.toString());
    }

    @Override
    public void flexGet(String defId, HttpServletResponse response) throws IOException {
        DefaultBpmDefinition bpmDefinition = null;
        bpmDefinition = StringUtil.isNotEmpty((String)defId) ? this.bpmDefinitionManager.getById(defId) : new DefaultBpmDefinition();
        StringBuffer msg = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Result>");
        msg.append("<defId>" + bpmDefinition.getDefId() + "</defId>");
        msg.append("<defXml>" + bpmDefinition.getDefXml() + "</defXml>");
        if (bpmDefinition.getTypeId() != null) {
            ObjectNode proType = this.PortalFeignService.getSysTypeById(bpmDefinition.getTypeId());
            msg.append("<typeName>" + proType.get("name").asText() + "</typeName>");
            msg.append("<typeId>" + proType.get("id").asText() + "</typeId>");
        }
        msg.append("<subject>" + bpmDefinition.getName() + "</subject>");
        msg.append("<defKey>" + bpmDefinition.getDefKey() + "</defKey>");
        msg.append("<descp>" + bpmDefinition.getDesc() + "</descp>");
        msg.append("<versionNo>" + bpmDefinition.getVersion() + "</versionNo>");
        msg.append("</Result>");
        PrintWriter out = response.getWriter();
        out.println(msg.toString());
    }

    @Override
    public Map<String, Object> getOtherParam(String defId) {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(defId);
        BpmProcessDef procDef = null;
        try {
            procDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        BpmDefExtProperties prop = procDef.getProcessDefExt().getExtProperties();
        Map handlerTypes = MessageUtil.getHandlerTypes();
        List skipConditionList = SkipConditionUtil.getSkipConditions();
        if (StringUtil.isEmpty((String)prop.getDescription())) {
            prop.setDescription(bpmDefinition.getDesc());
        }
        prop.setTestStatus(bpmDefinition.getTestStatus());
        prop.setStatus(bpmDefinition.getStatus());
        prop.setShowUrgentState(bpmDefinition.getShowUrgentState() == 1);
        prop.setShowModifyRecord(bpmDefinition.getShowModifyRecord() == 1);
        prop.setReadRevoke(bpmDefinition.getIsReadRevoke().equals("true"));
        prop.setUrgentMailTel(bpmDefinition.getUrgentMailTel());
        prop.setUrgentSmsTel(bpmDefinition.getUrgentSmsTel());
        prop.setUseMainForm(BeanUtils.isNotEmpty((Object)prop.getUseMainForm()) ? prop.getUseMainForm() : "instUseMainForm");
        prop.setDoneDataVersion(BeanUtils.isNotEmpty((Object)prop.getDoneDataVersion()) ? prop.getDoneDataVersion() : "history");
        prop.setFlowType(bpmDefinition.getFlowType());
        resMap.put("prop", prop);
        resMap.put("handlerTypes", handlerTypes);
        resMap.put("skipConditionList", skipConditionList);
        return resMap;
    }

    @Override
    @Transactional
    public CommonResult<String> saveProp(DefPropSaveVo defPropVo) {
        try {
            String defId = defPropVo.getDefId();
            String description = defPropVo.getDescription();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", defId);
            map.put("rev", defPropVo.getRev());
            DefaultBpmDefinition defaultBpmDefinition1 = this.bpmDefinitionManager.getBpmDefinitionByRev(map);
            if (BeanUtils.isNotEmpty((Object)defaultBpmDefinition1)) {
                String urgentSms;
                BpmDefExtProperties prop = defPropVo.getBpmProp();
                String defKey = defaultBpmDefinition1.getDefKey();
                if (StringUtil.isNotEmpty((String)defKey)) {
                    prop.setSubjectRule(I18nUtil.handleI18nMessage((String)String.format("flow.rule.%s", defKey), (String)prop.getSubjectRule()));
                }
                String status = prop.getStatus();
                this.propertiesBpmDefXmlHandler.saveNodeXml(defId, "", (Object)prop);
                DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(defId);
                String oldStatus = bpmDefinition.getStatus();
                bpmDefinition.setTestStatus(prop.getTestStatus());
                bpmDefinition.setStatus(status);
                bpmDefinition.setDesc(description);
                bpmDefinition.setShowUrgentState(prop.isShowUrgentState() ? 1 : 0);
                bpmDefinition.setShowModifyRecord(prop.isShowModifyRecord() ? 1 : 0);
                bpmDefinition.setIsReadRevoke(prop.isReadRevoke() ? "true" : "false");
                bpmDefinition.setFlowType(prop.getFlowType());
                String urgentMail = prop.getUrgentMailTel();
                if (StringUtil.isNotEmpty((String)urgentMail)) {
                    urgentMail = urgentMail.replace("<p>", "");
                    urgentMail = urgentMail.replace("</p>", "");
                }
                if (StringUtil.isNotEmpty((String)(urgentSms = prop.getUrgentSmsTel()))) {
                    urgentSms = urgentSms.replace("<p>", "");
                    urgentSms = urgentSms.replace("</p>", "");
                }
                bpmDefinition.setUrgentMailTel(urgentMail);
                bpmDefinition.setUrgentSmsTel(urgentSms);
                this.bpmDefinitionManager.update((Model)bpmDefinition);
                this.bpmDefinitionAccessor.clean(defId);
                return new CommonResult(true, "\u4fdd\u5b58\u6d41\u7a0b\u53c2\u6570\u6210\u529f!", (Object)"");
            }
            return new CommonResult(false, "\u6b64\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u6d41\u7a0b\u53c2\u6570\u5931\u8d25!", (Object)"");
        }
    }

    @Override
    public Object nodeBos(String defId, String topDefKey) throws Exception {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(defId);
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmBoDef boDef = null;
        if (StringUtil.isNotEmpty((String)topDefKey)) {
            DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getMainByDefKey(topDefKey, false);
            BpmProcessDef topProcessExt = this.bpmDefinitionAccessor.getBpmProcessDef(bpmDef.getDefId());
            boDef = BpmDefUtil.getBpmBoDef((BpmProcessDef)topProcessExt);
        } else {
            boDef = BpmDefUtil.getBpmBoDef((BpmProcessDef)bpmProcessDefExt);
        }
        List nodeDefList = BpmUtil.getSubProcessNodes((List)bpmProcessDefExt.getBpmnNodeDefs(), (boolean)true);
        BpmFormInit formInit = BpmDefUtil.getBpmFormInit((BpmProcessDef)bpmProcessDefExt, (String)topDefKey);
        ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((Object)formInit);
        ObjectNode boDefJson = (ObjectNode)JsonUtil.toJsonNode((Object)boDef);
        jsonObj.set("bodef", (JsonNode)boDefJson);
        ArrayNode jry = JsonUtil.getMapper().createArrayNode();
        for (BpmNodeDef def : nodeDefList) {
            ObjectNode jo = JsonUtil.getMapper().createObjectNode();
            jo.put("nodeId", def.getNodeId());
            jo.put("name", def.getName());
            jry.add((JsonNode)jo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bpmDefinition", bpmDefinition);
        map.put("json", jsonObj);
        map.put("nodeDefList", jry);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object importCheck(MultipartHttpServletRequest request, HttpServletResponse response, Optional<String> typeId, Boolean toMain) throws Exception {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String bpmdefsXml = FileUtil.readFile((String)(unZipFilePath + "/bpmdefs.flow.xml"));
            String formXmlStr = FileUtil.readFile((String)(unZipFilePath + "/form.xml"));
            String boXmlStr = FileUtil.readFile((String)(unZipFilePath + "/bo.xml"));
            String formRightsXml = FileUtil.readFile((String)(unZipFilePath + "/formrights.xml"));
            if (StringUtils.isEmpty((String)bpmdefsXml)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            DefServiceImpl.checkXmlFormat(bpmdefsXml);
            BpmDefXmlList defList = (BpmDefXmlList)JAXBUtil.unmarshall((String)bpmdefsXml, BpmDefXmlList.class);
            List list = defList.getBpmList();
            ArrayList<String> names = new ArrayList<String>();
            for (BpmDefXml defXml : list) {
                DefaultBpmDefinition odef;
                DefaultBpmDefinition def = defXml.getBpmDefinition();
                if (!BeanUtils.isNotEmpty((Object)def) || (odef = this.bpmDefinitionManager.getMainByDefKey(def.getDefKey())) == null) continue;
                names.add(def.getName() + "\uff08" + def.getDefKey() + "\uff09");
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("bpmdefsXml", bpmdefsXml);
            obj.put("formXmlStr", formXmlStr);
            obj.put("boXmlStr", boXmlStr);
            obj.put("formRightsXml", formRightsXml);
            if (BeanUtils.isEmpty(names)) {
                message = this.bpmDefTransform.importDef(obj, typeId.orElse(""), toMain);
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                this.bpmDefinitionManagerImpl.putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u6d41\u7a0b\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u4e3a\u5176\u65b0\u589e\u7248\u672c\uff1f", (Object)cacheFileId);
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        finally {
            File boDir = new File(unZipFilePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
        return message;
    }

    @Override
    public DefBtnsSaveVo getNodeSet(String defId, String nodeId, int action) throws Exception {
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List nodeBtns = nodeDef.getButtons();
        List defaultBtns = nodeDef.getButtonsByType(true);
        DefBtnsSaveVo defBtnsSaveVo = new DefBtnsSaveVo();
        defBtnsSaveVo.setDefId(defId);
        defBtnsSaveVo.setNodeId(nodeId);
        defBtnsSaveVo.setBtns(nodeBtns);
        if (!NodeType.START.equals((Object)nodeDef.getType())) {
            defBtnsSaveVo.setTopButtons(nodeDef.getTopButtons());
        }
        if (action == 0) {
            defBtnsSaveVo.setBtns(defaultBtns);
            return defBtnsSaveVo;
        }
        if (action == 2) {
            List notInitBtns = nodeDef.getButtonsByType(false);
            defBtnsSaveVo.setBtns(notInitBtns);
            return defBtnsSaveVo;
        }
        for (Button btn : nodeBtns) {
            btn.setSupportScript(Boolean.valueOf(true));
            for (Button b : defaultBtns) {
                if (!btn.getAlias().equals(b.getAlias()) || b.getSupportScript().booleanValue()) continue;
                btn.setSupportScript(Boolean.valueOf(false));
            }
        }
        return defBtnsSaveVo;
    }

    @Override
    public CommonResult<String> initNodeBtn(String defId, String nodeId) {
        String resultMsg = "";
        try {
            List nodeDefs = this.bpmDefinitionAccessor.getSignUserNode(defId);
            if (BeanUtils.isNotEmpty((Object)nodeDefs)) {
                if (StringUtil.isEmpty((String)nodeId)) {
                    for (BpmNodeDef bnd : nodeDefs) {
                        String key = bnd.getType().getKey();
                        if (!key.equals("signTask") && !key.equals("userTask") && !key.equals("start")) continue;
                        ButtonDTO buttonDTO = new ButtonDTO();
                        buttonDTO.setButtons(bnd.getButtonsByType(true));
                        buttonDTO.setTopButtons(bnd.getTopButtons());
                        this.buttonsBpmDefXmlHandler.saveNodeXml(defId, bnd.getNodeId(), (Object)buttonDTO);
                    }
                } else {
                    for (BpmNodeDef bnd : nodeDefs) {
                        if (!nodeId.equals(bnd.getNodeId())) continue;
                        ButtonDTO buttonDTO = new ButtonDTO();
                        buttonDTO.setButtons(bnd.getButtonsByType(true));
                        buttonDTO.setTopButtons(bnd.getTopButtons());
                        this.buttonsBpmDefXmlHandler.saveNodeXml(defId, nodeId, (Object)buttonDTO);
                    }
                }
            }
            resultMsg = "\u521d\u59cb\u5316\u6210\u529f";
            return new CommonResult(true, resultMsg, (Object)"");
        }
        catch (Exception e) {
            resultMsg = "\u521d\u59cb\u5316\u5931\u8d25";
            return new CommonResult(false, resultMsg + ":" + e.getMessage(), (Object)"");
        }
    }

    @Override
    public CommonResult<Boolean> isBoBindFlowCheck(String boCode, String formKey) {
        List bpmProBos = this.bpmProBoManager.getByBoCode(boCode);
        for (BpmProBo bpmProBo : bpmProBos) {
            DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(bpmProBo.getProcessId());
            if (BeanUtils.isEmpty((Object)bpmDef)) continue;
            String defId = bpmDef.getDefId();
            boolean isFormExist = false;
            try {
                isFormExist = this.isFormExists(defId, formKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isFormExist) continue;
            return new CommonResult(true, "\u5df2\u7ed1\u5b9a\u6d41\u7a0b\u3010" + bpmDef.getName() + "\u3011", (Object)true);
        }
        return new CommonResult(true, "\u68c0\u6d4b\u6210\u529f\uff01", (Object)false);
    }

    @Override
    public DefaultBpmDefinition getDefDesignByDefId(String defId) {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionDao.getDefDesignByDefId(defId);
        return bpmDefinition;
    }

    @Override
    public List<ImportCheckResult> importFlowCheck(Map<String, Object> param) throws Exception {
        String bpmdefsXml = param.getOrDefault("bpmdefs.flow.xml", "").toString();
        String formXmlStr = param.getOrDefault("form.xml", "").toString();
        String boXmlStr = param.getOrDefault("bo.xml", "").toString();
        String formRightsXml = param.getOrDefault("formrights.xml", "").toString();
        if (StringUtils.isEmpty((String)bpmdefsXml)) {
            throw new BaseException("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
        }
        DefServiceImpl.checkXmlFormat(bpmdefsXml);
        BpmDefXmlList defList = (BpmDefXmlList)JAXBUtil.unmarshall((String)bpmdefsXml, BpmDefXmlList.class);
        List list = defList.getBpmList();
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        for (BpmDefXml defXml : list) {
            DefaultBpmDefinition odef;
            DefaultBpmDefinition def = defXml.getBpmDefinition();
            if (!BeanUtils.isNotEmpty((Object)def) || !BeanUtils.isNotEmpty((Object)(odef = this.bpmDefinitionManager.getMainByDefKey(def.getDefKey())))) continue;
            results.add(new ImportCheckResult(true, "\u6d41\u7a0b", odef.getName()));
        }
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("bpmdefsXml", bpmdefsXml);
        obj.put("formXmlStr", formXmlStr);
        obj.put("boXmlStr", boXmlStr);
        obj.put("formRightsXml", formRightsXml);
        List importCheckResults = this.formFeignService.importFormCheck(param);
        if (BeanUtils.isNotEmpty((Object)importCheckResults)) {
            results.addAll(importCheckResults);
        }
        return results;
    }

    private DefaultBpmDefinition getFromRequest(DefaultBpmDefinitionVo vo) throws Exception {
        DefaultBpmDefinition defaultBpmDef = vo.getDefaultBpmDefinition();
        String typeId = defaultBpmDef.getTypeId();
        String subject = defaultBpmDef.getName();
        String defKey = defaultBpmDef.getDefKey();
        String descp = defaultBpmDef.getDesc();
        String defXml = defaultBpmDef.getDefXml();
        String defJson = defaultBpmDef.getDefJson();
        Boolean isDeploy = vo.getIsdeploy();
        defXml = defXml.replace("''", "'");
        String reason = defaultBpmDef.getReason();
        String defId = defaultBpmDef.getDefId();
        DefaultBpmDefinition bpmDefinition = null;
        if (StringUtils.isNotEmpty((String)defId)) {
            bpmDefinition = isDeploy != false ? this.bpmDefinitionManager.getById(defId) : this.bpmDefinitionManager.getById(defId);
        }
        if (bpmDefinition == null) {
            bpmDefinition = new DefaultBpmDefinition();
            if (StringUtils.isNotEmpty((String)defKey)) {
                bpmDefinition.setDefKey(defKey);
            }
        }
        if (StringUtils.isNotEmpty((String)typeId)) {
            bpmDefinition.setTypeId(typeId);
        }
        if (StringUtils.isNotEmpty((String)subject)) {
            bpmDefinition.setName(subject);
        }
        if (StringUtils.isNotEmpty((String)descp)) {
            bpmDefinition.setDesc(descp);
        } else {
            bpmDefinition.setDesc(subject);
        }
        if (StringUtils.isNotEmpty((String)defXml)) {
            bpmDefinition.setDefXml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + defXml);
            bpmDefinition.setDesigner(DesignerType.FLASH.name());
        }
        if (StringUtils.isNotEmpty((String)defJson)) {
            bpmDefinition.setDefJson(defJson);
            bpmDefinition.setDesigner(DesignerType.WEB.name());
        }
        bpmDefinition.setReason(reason);
        return bpmDefinition;
    }

    private void saveBpmProBoList(String userId, String flowId, String flowKey, String parentFlowKey, BpmBoDef bpmBoDef, Boolean isClearForm) throws Exception {
        List dbProBos = this.bpmProBoManager.getByProcessId(flowId);
        ArrayList<BpmProBo> bpmProBoList = new ArrayList<BpmProBo>();
        List boDefs = bpmBoDef.getBoDefs();
        for (ProcBoDef procBoDef : boDefs) {
            BpmProBo bpmProBo = new BpmProBo();
            bpmProBo.setProcessId(flowId);
            bpmProBo.setProcessKey(flowKey);
            bpmProBo.setBoCode(procBoDef.getKey());
            bpmProBo.setBoName(procBoDef.getName());
            bpmProBo.setCreatorId(userId);
            bpmProBoList.add(bpmProBo);
        }
        this.bpmProBoManager.createByBpmProBoList(bpmProBoList, flowId, flowKey);
        if (BeanUtils.isNotEmpty((Object)boDefs) && dbProBos.containsAll(bpmProBoList)) {
            return;
        }
        if (isClearForm.booleanValue()) {
            FormFeignService formService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            formService.removeFormRights(flowKey, parentFlowKey);
            BpmDefSetting bpmDefSetting = new BpmDefSetting();
            BpmDefSettingBpmDefXmlHandler bpmDefSettingBpmDefXmlHandler = (BpmDefSettingBpmDefXmlHandler)AppUtil.getBean(BpmDefSettingBpmDefXmlHandler.class);
            bpmDefSettingBpmDefXmlHandler.saveNodeXml(flowId, null, (Object)bpmDefSetting);
        }
    }

    public static void checkXmlFormat(String xml) throws Exception {
        String firstName = "bpmlist";
        String nextName = "bpmDef";
        Document doc = Dom4jUtil.loadXml((String)xml);
        Element root = doc.getRootElement();
        String msg = "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9";
        if (!root.getName().equals(firstName)) {
            throw new Exception(msg);
        }
        List itemLists = root.elements();
        for (Element elm : itemLists) {
            if (elm.getName().equals(nextName)) continue;
            throw new Exception(msg);
        }
    }

    private boolean isFormExists(String defId, String formKey) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        FormExt frm = defExt.getGlobalForm();
        FormExt mobileFrm = defExt.getGlobalMobileForm();
        FormExt instFrm = defExt.getInstForm();
        FormExt instMobileFrm = defExt.getInstMobileForm();
        if (frm != null && frm.getFormValue().equals(formKey) || mobileFrm != null && mobileFrm.getFormValue().equals(formKey) || instFrm != null && instFrm.getFormValue().equals(formKey) || instMobileFrm != null && instMobileFrm.getFormValue().equals(formKey)) {
            return true;
        }
        List nodeList = this.bpmDefinitionAccessor.getSignUserNode(defId);
        for (BpmNodeDef bpmNodeDef : nodeList) {
            frm = bpmNodeDef.getForm();
            if (frm != null && frm.getFormValue().equals(formKey)) {
                return true;
            }
            frm = bpmNodeDef.getMobileForm();
            if (frm == null || !frm.getFormValue().equals(formKey)) continue;
            return true;
        }
        return false;
    }
}

