/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.defxml.DefXmlUtil;
import com.hotent.bpm.defxml.entity.ext.BoDef;
import com.hotent.bpm.defxml.entity.ext.ExtDefinitions;
import com.hotent.bpm.defxml.entity.ext.ExtProcess;
import com.hotent.bpm.model.BpmNodeSetting;
import com.hotent.bpm.model.def.BpmDefXml;
import com.hotent.bpm.model.def.BpmDefXmlList;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.natapi.def.NatProDefinitionService;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmNodeSettingManager;
import com.hotent.bpm.persistence.manager.BpmProBoManager;
import com.hotent.bpm.persistence.model.BpmProBo;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpmModel.manager.BpmDefTransform;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmDefTransform
implements BpmDefTransform {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    NatProDefinitionService natProDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmProBoManager bpmProBoManager;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    BpmNodeSettingManager bpmNodeSettingManager;

    @Override
    public Map<String, String> exportDef(List<String> defList) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        BpmDefXmlList list = new BpmDefXmlList();
        HashSet<String> formKeys = new HashSet<String>();
        HashSet<String> bocodes = new HashSet<String>();
        HashSet<String> defKeys = new HashSet<String>();
        for (String defId : defList) {
            this.handelFormBo(defId, formKeys, bocodes, defKeys);
            BpmDefXml defXml = this.getByDefId(defId);
            list.addBpmDefXml(defXml);
        }
        try {
            String xml = JAXBUtil.marshall((Object)list, BpmDefXmlList.class);
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formKeys", StringUtil.join(new ArrayList<String>(formKeys), (String)","));
            obj.put("boCodes", StringUtil.join(new ArrayList<String>(bocodes), (String)","));
            obj.put("defKeys", StringUtil.join(new ArrayList<String>(defKeys), (String)","));
            Map formRightXml = this.formRestfulService.getFormAndBoExportXml(obj);
            map.put("bpmdefs.flow.xml", xml);
            if (BeanUtils.isNotEmpty((Object)formRightXml)) {
                map.putAll(formRightXml);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    private List<BpmNodeSetting> branchConditionXml(String defId) throws JAXBException {
        BpmNodeSettingManager bpmNodeSettingManager = (BpmNodeSettingManager)AppUtil.getBean(BpmNodeSettingManager.class);
        return bpmNodeSettingManager.list((Wrapper)Wrappers.lambdaQuery().eq(BpmNodeSetting::getDefId, (Object)defId));
    }

    private void handelFormBo(String defId, Set<String> form, Set<String> bocode, Set<String> defKeys) throws Exception {
        FormExt globalMobileForm;
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        defKeys.add(bpmProcessDefExt.getDefKey());
        FormExt globalForm = defExt.getGlobalForm();
        if (globalForm != null && FormCategory.INNER == globalForm.getType() && StringUtil.isNotEmpty((String)globalForm.getFormValue())) {
            form.add(globalForm.getFormValue());
        }
        if ((globalMobileForm = defExt.getGlobalMobileForm()) != null && FormCategory.INNER == globalMobileForm.getType() && StringUtil.isNotEmpty((String)globalMobileForm.getFormValue())) {
            form.add(globalMobileForm.getFormValue());
        }
        List nodeList = this.bpmDefinitionAccessor.getSignUserNode(defId);
        for (Object bpmNodeDef : nodeList) {
            Form mobileNodeForm;
            Form nodeForm = bpmNodeDef.getForm();
            if (nodeForm != null && FormCategory.INNER == nodeForm.getType() && StringUtil.isNotEmpty((String)nodeForm.getFormValue())) {
                form.add(nodeForm.getFormValue());
            }
            if ((mobileNodeForm = bpmNodeDef.getMobileForm()) == null || FormCategory.INNER != mobileNodeForm.getType() || !StringUtil.isNotEmpty((String)mobileNodeForm.getFormValue())) continue;
            form.add(mobileNodeForm.getFormValue());
        }
        List list = this.bpmDefinitionAccessor.getNodeDefs(defId);
        for (BpmNodeDef nodeDef : list) {
            CallActivityNodeDef callActivityNode;
            DefaultBpmDefinition subProcessDef;
            if (!NodeType.CALLACTIVITY.equals((Object)nodeDef.getType()) || !BeanUtils.isNotEmpty((Object)(subProcessDef = this.bpmDefinitionManager.getMainByDefKey((callActivityNode = (CallActivityNodeDef)nodeDef).getFlowKey())))) continue;
            this.handelSubFormBo(subProcessDef.getDefId(), form, bocode, defKeys, bpmProcessDefExt.getDefKey());
        }
        List boDefList = defExt.getBoDefList();
        for (ProcBoDef procBoDef : boDefList) {
            bocode.add(procBoDef.getKey());
        }
    }

    private void handelSubFormBo(String defId, Set<String> form, Set<String> bocode, Set<String> defKeys, String parentFlowKey) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        if (BeanUtils.isEmpty((Object)bpmProcessDefExt)) {
            return;
        }
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        defKeys.add(bpmProcessDefExt.getDefKey());
        List allGlobalForm = defExt.getAllGlobalForm();
        if (BeanUtils.isNotEmpty((Object)allGlobalForm)) {
            for (FormExt formExt : defExt.getAllGlobalForm()) {
                if (!formExt.getParentFlowKey().equals(parentFlowKey)) continue;
                form.add(formExt.getFormValue());
            }
        }
        List list = this.bpmDefinitionAccessor.getNodeDefs(defId);
        for (BpmNodeDef nodeDef : list) {
            Form pcForm = nodeDef.getSubForm(parentFlowKey, FormType.PC);
            Form mobileForm = nodeDef.getSubForm(parentFlowKey, FormType.MOBILE);
            if (pcForm != null) {
                form.add(pcForm.getFormValue());
            }
            if (mobileForm == null) continue;
            form.add(mobileForm.getFormValue());
        }
        List boDefList = defExt.getBoDefList();
        for (ProcBoDef procBoDef : boDefList) {
            bocode.add(procBoDef.getKey());
        }
    }

    @Override
    public CommonResult<String> importDef(ObjectNode objectNode, String typeId, Boolean toMain) {
        return this.importDef(objectNode, typeId, false, toMain);
    }

    @Override
    public CommonResult<String> importDef(ObjectNode objectNode, String typeId, boolean isSkip, Boolean toMain) {
        try {
            String flowXml = objectNode.get("bpmdefsXml").asText();
            String formXmlStr = objectNode.get("formXmlStr").asText();
            String boXmlStr = objectNode.get("boXmlStr").asText();
            String formRightsXml = objectNode.get("formRightsXml").asText();
            BpmDefXmlList defList = (BpmDefXmlList)JAXBUtil.unmarshall((String)flowXml, BpmDefXmlList.class);
            List list = defList.getBpmList();
            for (BpmDefXml defXml : list) {
                this.importDef(defXml, typeId, toMain);
            }
            if (isSkip) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("form.xml", formXmlStr);
                param.put("bo.xml", boXmlStr);
                param.put("formrights.xml", formRightsXml);
                this.formRestfulService.importForms(param, "cover", null);
                return CommonResult.ok();
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formXmlStr", formXmlStr);
            obj.put("boXmlStr", boXmlStr);
            obj.put("formRightsXml", formRightsXml);
            return this.formRestfulService.importFormAndBo(obj);
        }
        catch (Exception e) {
            if (e.getMessage().contains("\u8d85\u51faMySQL\u5efa\u8868\u5b57\u6bb5\u603b\u957f\u5ea665535")) {
                return CommonResult.error((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u8d85\u51faMySQL\u5efa\u8868\u5b57\u6bb5\u603b\u957f\u5ea665535");
            }
            throw new RuntimeException("XML\u8f6c\u6362\u4e3aPOJO\u7c7b\u578b\u9519\u8bef" + e.getMessage(), e);
        }
    }

    private BpmDefXml getByDefId(String defId) throws JAXBException {
        DefaultBpmDefinition definition = this.bpmDefinitionManager.getById(defId);
        BpmDefXml defXml = new BpmDefXml();
        defXml.setBpmDefinition(definition);
        defXml.setBpmNodeSettingList(this.branchConditionXml(defId));
        return defXml;
    }

    private void importDef(BpmDefXml defXml, String typeId, Boolean toMain) throws Exception {
        this.importDefinition(defXml, typeId, toMain);
    }

    private DefaultBpmDefinition importDefinition(BpmDefXml defXml, String typeId, Boolean toMain) throws Exception {
        String defId = UniqueIdUtil.getSuid();
        DefaultBpmDefinition def = defXml.getBpmDefinition();
        String defKey = def.getDefKey();
        def.setDefId(defId);
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        ObjectNode sysType = portalFeignService.getSysTypeById(typeId);
        String typeName = "";
        if (BeanUtils.isNotEmpty((Object)sysType)) {
            typeName = sysType.get("name").asText();
        }
        if (StringUtil.isNotEmpty((String)typeId)) {
            def.setTypeId(typeId);
            def.setTypeName(typeName);
        }
        String bpmnXml = def.getBpmnXml();
        String defJson = def.getDefJson();
        if (StringUtil.isNotEmpty((String)defJson)) {
            def.getBpmDefData().setDefJson(null);
        }
        IUser user = ContextUtil.getCurrentUser();
        String createBy = null;
        if (user != null) {
            createBy = user.getUserId();
        }
        def.setCreateBy(createBy);
        this.handleBpmProBo(bpmnXml, defId, defKey, createBy);
        String deployId = "";
        try {
            deployId = this.natProDefinitionService.deploy("", def.getName(), bpmnXml);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String bpmnDefId = this.natProDefinitionService.getProcessDefinitionIdByDeployId(deployId);
        def.setIsMain("N");
        def.setBpmnDefId(bpmnDefId);
        def.setBpmnDeployId(deployId);
        Integer version = this.bpmDefinitionManager.getMaxVersion(defKey);
        def.setVersion(version);
        def.setCreateTime(LocalDateTime.now());
        this.bpmDefinitionManager.create((Model)def);
        if (toMain.booleanValue()) {
            this.bpmDefinitionManager.updMainVersion(defId, false);
        }
        List bpmNodeSettingList = Optional.ofNullable(defXml.getBpmNodeSettingList()).orElse(new ArrayList());
        bpmNodeSettingList.forEach(item -> item.setDefId(defId));
        this.bpmNodeSettingManager.saveOrUpdateByDefId(bpmNodeSettingList);
        return def;
    }

    private void handleBpmProBo(String bpmnXml, String defId, String defKey, String createBy) throws Exception {
        ExtDefinitions definitions = DefXmlUtil.getDefinitionsByXml((String)bpmnXml);
        ExtProcess extProcess = definitions.getExtProcess();
        ExtProcess.BoList boList = extProcess.getBoList();
        if (BeanUtils.isEmpty((Object)boList)) {
            return;
        }
        List boDefs = boList.getBoDef();
        if (BeanUtils.isEmpty((Object)boDefs)) {
            return;
        }
        ArrayList<BpmProBo> bpmProBos = new ArrayList<BpmProBo>();
        for (BoDef boDef : boDefs) {
            BpmProBo bpmProBo = new BpmProBo();
            bpmProBo.setId(UniqueIdUtil.getSuid());
            bpmProBo.setProcessId(defId);
            bpmProBo.setBoCode(boDef.getKey());
            bpmProBo.setBoName(boDef.getName());
            bpmProBo.setCreatorId(createBy);
            bpmProBos.add(bpmProBo);
        }
        this.bpmProBoManager.createByBpmProBoList(bpmProBos, defId, defKey);
    }
}

