/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.BpmDefAuthorize;
import com.hotent.bpm.persistence.model.dto.BpmDefAuthorizeDetailDTO;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flow/defAuthorize/v1/"})
@Api(tags={"\u6d41\u7a0b\u5206\u7ba1\u6388\u6743"})
@ApiGroup(group={"group_bpm"})
public class DefAuthorizeController
extends BaseController<BpmDefAuthorizeManager, BpmDefAuthorize> {
    @Resource
    private BpmDefinitionManager bpmDefinitionManager;
    @Autowired
    BpmDefAuthorizeManager bpmDefAuthorizeManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u6d41\u7a0b\u5b9a\u4e49\u6743\u9650\u5217\u8868", httpMethod="POST", notes="\u53d6\u5f97\u6d41\u7a0b\u5b9a\u4e49\u6743\u9650\u5217\u8868")
    public PageList<BpmDefAuthorize> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BpmDefAuthorize> queryFilter) throws Exception {
        PageList pageList = ((BpmDefAuthorizeManager)this.baseService).getAuthorizeListByFilter(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u65b0\u589e\u6216\u4fee\u6539\u6388\u6743\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u65b0\u589e\u6216\u4fee\u6539\u6388\u6743\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="author", value="\u6388\u6743\u4fe1\u606f", required=true) @RequestBody BpmDefAuthorize author) throws Exception {
        CommonResult res = this.bpmDefAuthorizeManager.saveBpmDefAuthorize(author);
        return res;
    }

    @RequestMapping(value={"del"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5206\u7ba1\u6388\u6743\u4fe1\u606f", httpMethod="DELETE", notes="\u5220\u9664\u6d41\u7a0b\u5206\u7ba1\u6388\u6743\u4fe1\u606f")
    public CommonResult<String> del(@ApiParam(name="ids", value="\u6388\u6743\u4fe1\u606fid\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = ids.split(",");
            ((BpmDefAuthorizeManager)this.baseService).deleteAuthorizeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6388\u6743\u4fe1\u606f\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u5220\u9664\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01", (Object)"");
        }
    }

    @RequestMapping(value={"defAuthorizeGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u6d41\u7a0b\u5206\u7ba1\u6388\u6743\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u5f97\u6d41\u7a0b\u5206\u7ba1\u6388\u6743\u8be6\u60c5")
    public Object defAuthorizeGet(@ApiParam(name="id", value="\u5206\u7ba1\u6388\u6743id", required=true) @RequestParam String id) throws Exception {
        Object res = this.bpmDefAuthorizeManager.defAuthorizeGet(id);
        return res;
    }

    @RequestMapping(value={"getPermissionList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u9ed8\u8ba4\u6743\u9650\u7c7b\u578b", httpMethod="GET", notes="\u83b7\u5f97\u9ed8\u8ba4\u6743\u9650\u7c7b\u578b")
    public Object getPermissionList() throws Exception {
        return AppUtil.getBean((String)"defaultObjectRightType");
    }

    @RequestMapping(value={"startRight"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u548c\u6d41\u7a0bID\u5224\u65ad\u662f\u5426\u6709\u542f\u52a8\u6743\u9650", httpMethod="GET", notes="\u6839\u636e\u7528\u6237ID\u548c\u6d41\u7a0bID\u5224\u65ad\u662f\u5426\u6709\u6d41\u7a0b\u542f\u52a8\u6743\u9650")
    public CommonResult<Boolean> startRight(@ApiParam(required=true, name="userId", value="\u7528\u6237ID") String userId, @ApiParam(required=true, name="defId", value="\u6d41\u7a0b\u5b9a\u4e49ID") String defId, @ApiParam(required=true, name="leadId", value="\u9886\u5bfcid") String leadId, @ApiParam(required=true, name="instId", value="\u5b9e\u4f8bid") Optional<String> instId) throws Exception {
        if (ContextUtil.getCurrentUser().isAdmin()) {
            return new CommonResult(true, "\u7ba1\u7406\u5458", (Object)true);
        }
        Boolean hasRight = ((BpmDefAuthorizeManager)this.baseService).getStartRightByUserIdAndDefId(userId, defId, leadId, (String)instId.orElse(null));
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)hasRight);
    }

    @RequestMapping(value={"getAuthDetailPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u7ba1\u6388\u6743\u660e\u7ec6\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u5206\u7ba1\u6388\u6743\u660e\u7ec6\u5217\u8868")
    public PageList<BpmDefAuthorizeDetailDTO> getUserOrgPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter filter) throws Exception {
        IPage p = ((BpmDefAuthorizeManager)this.baseService).getAuthDetailPage(filter);
        return new PageList(p);
    }

    @RequestMapping(value={"exportAuthDetail"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5206\u7ba1\u6388\u6743\u660e\u7ec6\u5217\u8868", httpMethod="POST", notes="\u5bfc\u51fa\u5206\u7ba1\u6388\u6743\u660e\u7ec6\u5217\u8868")
    public void exportAuthDetail(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter filter, HttpServletResponse httpServletResponse) throws Exception {
        ((BpmDefAuthorizeManager)this.baseService).exportAuthDetail(filter, httpServletResponse);
    }
}

