/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.aop;

import com.hotent.base.context.BaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.runtime.annotation.PermissionCheck;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionCheckAspect {
    @Resource
    IFlowManager iFlowManager;
    @Resource
    BaseContext baseContext;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Around(value="execution(* *..*Controller.*(..)) && @annotation(com.hotent.runtime.annotation.PermissionCheck)")
    public Object permissionCheck(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> targetClass = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Method[] methods = targetClass.getMethods();
        Object[] args = joinPoint.getArgs();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        PermissionCheck permissionCheck = method.getAnnotation(PermissionCheck.class);
        LocalVariableTableParameterNameDiscoverer localVariableTable = new LocalVariableTableParameterNameDiscoverer();
        String[] paraNameArr = localVariableTable.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < paraNameArr.length; ++i) {
            context.setVariable(paraNameArr[i], args[i]);
        }
        String instanceId = permissionCheck.instanceId();
        String taskId = permissionCheck.taskId();
        String isDefAuthorize = permissionCheck.isDefAuthorize();
        if (instanceId.matches("^#.*.$")) {
            instanceId = (String)parser.parseExpression(instanceId).getValue((EvaluationContext)context, String.class);
        }
        if (taskId.matches("^#.*.$")) {
            taskId = (String)parser.parseExpression(taskId).getValue((EvaluationContext)context, String.class);
        }
        if (isDefAuthorize.matches("^#.*.$")) {
            isDefAuthorize = (String)parser.parseExpression(isDefAuthorize).getValue((EvaluationContext)context, String.class);
        }
        String currentUserAccount = this.baseContext.getCurrentUserAccout();
        String currentUserId = this.baseContext.getCurrentUserId();
        boolean isPermissions = true;
        if ("true".equals(isDefAuthorize)) {
            if (ContextUtil.getCurrentUser().isAdmin()) {
                return joinPoint.proceed();
            }
            Map actRight = this.bpmDefAuthorizeManager.getActRightByUserId(currentUserId, "instance", true, false);
            DefaultBpmProcessInstance processInstance = new DefaultBpmProcessInstance();
            String procDefKey = "";
            if (StringUtil.isNotEmpty((String)instanceId)) {
                processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instanceId));
                procDefKey = processInstance.getProcDefKey();
            }
            if (StringUtil.isNotEmpty((String)taskId)) {
                DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
                procDefKey = defaultBpmTask.getProcDefKey();
            }
            if (actRight.containsKey("defKeys") && !Arrays.asList(actRight.get("defKeys").toString().split(",")).contains("'" + procDefKey + "'")) {
                isPermissions = false;
            }
        } else {
            if (StringUtil.isNotEmpty((String)instanceId)) {
                isPermissions = this.isInstancePermission(instanceId);
            }
            if (StringUtil.isNotEmpty((String)taskId)) {
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("bt.id_", (Object)taskId, QueryOP.EQUAL, FieldRelation.AND);
                long todoTotal = this.iFlowManager.getTodoList(currentUserAccount, (QueryFilter<DefaultBpmTask>)queryFilter).get().getTotal();
                long leaderTotal = 0L;
                try {
                    leaderTotal = this.iFlowManager.getLeaderTodoList(currentUserAccount, this.getQueryFilter("task_id_", taskId)).getTotal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = isPermissions = todoTotal != 0L || leaderTotal != 0L;
            }
        }
        if (!isPermissions) {
            throw new BaseException(ResponseErrorEnums.USER_PERMISSION);
        }
        return joinPoint.proceed();
    }

    private Boolean isInstancePermission(String instanceId) throws Throwable {
        String currentUserAccount = this.baseContext.getCurrentUserAccout();
        if (this.iFlowManager.getDoneInstList(currentUserAccount, this.getQueryFilter("wfInst.id_", instanceId), null).get().getTotal() > 0L) {
            return true;
        }
        if (this.iFlowManager.getNoticeDoneReadList(currentUserAccount, this.getQueryFilter("bpm_task_notice_done.proc_inst_id_", instanceId)).getTotal() > 0L) {
            return true;
        }
        if (this.iFlowManager.myRequest(currentUserAccount, this.getQueryFilter("bpm_pro_inst.id_", instanceId)).getTotal() > 0L) {
            return true;
        }
        if (this.iFlowManager.getNoticeTodoReadList(currentUserAccount, this.getQueryFilter("bpm_task_notice.proc_inst_id_", instanceId)).getTotal() > 0L) {
            return true;
        }
        if (this.iFlowManager.getMyNoticeReadList(currentUserAccount, this.getQueryFilter("bpm_task_notice.proc_inst_id_", instanceId)).getTotal() > 0L) {
            return true;
        }
        return this.iFlowManager.getDelegate(currentUserAccount, this.getQueryFilter("a.proc_inst_id_", instanceId)).getTotal() > 0L;
    }

    private QueryFilter getQueryFilter(String property, String value) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(1), Boolean.valueOf(true)));
        queryFilter.addFilter(property, (Object)value, QueryOP.EQUAL, FieldRelation.AND, "permissionCheck");
        return queryFilter;
    }
}

