/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.runtime.manager.BpmFlowCollectManager;
import com.hotent.runtime.model.BpmFlowCollect;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bpmFlowCollect/v1/"})
@Api(tags={"\u6d41\u7a0b\u6536\u85cf"})
@ApiGroup(group={"group_bpm"})
public class BpmFlowCollectController
extends BaseController<BpmFlowCollectManager, BpmFlowCollect> {
    @GetMapping(value={"/getDetail"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6d41\u7a0b\u6536\u85cf\u8bb0\u5f55\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u6d41\u7a0b\u6536\u85cf\u8bb0\u5f55\u6570\u636e\u8be6\u60c5")
    public CommonResult<BpmFlowCollect> getDetail(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam(required=true) String id) throws Exception {
        return CommonResult.ok().value((Object)((BpmFlowCollectManager)this.baseService).getDetail(id));
    }

    @PostMapping(value={"/save"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u6d41\u7a0b\u6536\u85cf\u8bb0\u5f55\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u6d41\u7a0b\u6536\u85cf\u8bb0\u5f55\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="BpmFlowCollect", value="\u6d41\u7a0b\u6536\u85cf\u8bb0\u5f55\u5bf9\u8c61", required=true) @RequestBody BpmFlowCollect bpmFlowCollect) throws Exception {
        String msg = StringUtil.isEmpty((String)bpmFlowCollect.getId()) ? "\u6dfb\u52a0\u6d41\u7a0b\u6536\u85cf\u8bb0\u5f55\u6210\u529f" : "\u66f4\u65b0\u6d41\u7a0b\u6536\u85cf\u8bb0\u5f55\u6210\u529f";
        ((BpmFlowCollectManager)this.baseService).createOrUpdate(bpmFlowCollect);
        return CommonResult.ok().message(msg);
    }

    @PostMapping(value={"bookmark"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6536\u85cf\u6d41\u7a0b", httpMethod="POST", notes="\u6536\u85cf\u6d41\u7a0b")
    public CommonResult<String> bookmark(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestBody String defKey) {
        ((BpmFlowCollectManager)this.baseService).bookmark(defKey);
        return new CommonResult(true, "\u6536\u85cf\u6210\u529f");
    }

    @PostMapping(value={"cancel"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u6d88\u6536\u85cf\u6d41\u7a0b", httpMethod="POST", notes="\u53d6\u6d88\u6536\u85cf\u6d41\u7a0b")
    public CommonResult<String> cancel(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestBody String defKey) {
        ((BpmFlowCollectManager)this.baseService).cancel(defKey);
        return new CommonResult(true, "\u53d6\u6d88\u6536\u85cf\u6210\u529f");
    }

    @PostMapping(value={"myCollect"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u6536\u85cf\u7684\u6d41\u7a0b", httpMethod="POST", notes="\u83b7\u53d6\u6211\u6536\u85cf\u7684\u6d41\u7a0b")
    public CommonResult<PageList<DefaultBpmDefinition>> myCollection(@ApiParam(name="queryFilter", required=true, value="\u901a\u7528\u67e5\u8be2\u6761\u4ef6") @RequestBody QueryFilter<DefaultBpmDefinition> queryFilter) throws Exception {
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", ((BpmFlowCollectManager)this.baseService).myCollectFlow(queryFilter));
    }

    @GetMapping(value={"myCollectShowButton"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u6536\u85cf\u7684\u6d41\u7a0b\u65f6\uff0c\u662f\u5426\u6709\u672a\u914d\u7f6e\u79fb\u52a8\u8868\u5355", httpMethod="GET", notes="\u83b7\u53d6\u6211\u6536\u85cf\u7684\u6d41\u7a0b\u65f6\uff0c\u662f\u5426\u6709\u672a\u914d\u7f6e\u79fb\u52a8\u8868\u5355")
    public CommonResult<Boolean> myCollectShowButton() throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addQueryField(new QueryField("SUPPORT_MOBILE_", (Object)0));
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(0)));
        PageList<DefaultBpmDefinition> queryList = ((BpmFlowCollectManager)this.baseService).myCollectFlow((QueryFilter<DefaultBpmDefinition>)queryFilter);
        return CommonResult.success((Object)(queryList.getTotal() > Long.valueOf("0") ? 1 : 0));
    }

    @PostMapping(value={"myCollectCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u7684\u6536\u85cf\u5206\u7c7b\u6570\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u6211\u7684\u6536\u85cf\u5206\u7c7b\u6570\u91cf")
    public List<Map<String, Object>> myCollectCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) {
        return ((BpmFlowCollectManager)this.baseService).getCollectCountByUserId(queryFilter, ContextUtil.getCurrentUserId());
    }

    @GetMapping(value={"myCollectDefKeys"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u6536\u85cf\u7684\u6d41\u7a0bkey\u96c6\u5408", httpMethod="GET", notes="\u83b7\u53d6\u6211\u6536\u85cf\u7684\u6d41\u7a0bkey\u96c6\u5408")
    public CommonResult<List<String>> myCollectDefKeys() {
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", ((BpmFlowCollectManager)this.baseService).getMyCollectDefKeys());
    }
}

