/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.hotent.bpm.persistence.model.BpmTaskDueTime;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/bpmTaskDueTime/v1/"})
@Api(tags={"\u4efb\u52a1\u671f\u9650\u7edf\u8ba1"})
@ApiGroup(group={"group_bpm"})
public class BpmTaskDueTimeController
extends BaseController<BpmTaskDueTimeManager, BpmTaskDueTime> {
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;
    @Resource
    PortalFeignService PortalFeignService;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<BpmTaskDueTime> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmTaskDueTimeManager.query(queryFilter);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u660e\u7ec6")
    public BpmTaskDueTime get(@ApiParam(name="id", value="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1id", required=true) @RequestParam String id) throws Exception {
        return (BpmTaskDueTime)this.bpmTaskDueTimeManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id \u83b7\u53d6\u6700\u65b0\u7684\u5ef6\u671f\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id \u83b7\u53d6\u6700\u65b0\u7684\u5ef6\u671f\u4fe1\u606f")
    public BpmTaskDueTime getByTaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        BpmTaskDueTime bpmTaskDueTime = this.bpmTaskDueTimeManager.getByTaskId(taskId);
        if (BeanUtils.isEmpty((Object)bpmTaskDueTime)) {
            return new BpmTaskDueTime();
        }
        int remainingTime = 0;
        try {
            remainingTime = this.getRemainingTime(bpmTaskDueTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bpmTaskDueTime.setRemainingTime(remainingTime);
        return bpmTaskDueTime;
    }

    @RequestMapping(value={"getExpirationDate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5230\u671f\u65f6\u95f4", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u5230\u671f\u65f6\u95f4")
    public Object getExpirationDate(@ApiParam(name="id", value="\u4efb\u52a1id", required=true) @RequestParam String id, @ApiParam(name="addDueTime", value="\u4efb\u52a1id", required=true) @RequestParam Integer addDueTime) throws Exception {
        Object res = this.bpmTaskDueTimeManager.getExpirationDate(id, addDueTime);
        return res;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u4fe1\u606f", httpMethod="POST", notes="\u6dfb\u52a0\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="bpmTaskDueTime", value="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u4fe1\u606f", required=true) @RequestBody BpmTaskDueTime bpmTaskDueTime) throws Exception {
        CommonResult res = this.bpmTaskDueTimeManager.saveBpmTaskDueTime(bpmTaskDueTime);
        return res;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="aryIds", value="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String aryIds) throws Exception {
        String[] ids = null;
        if (!StringUtil.isEmpty((String)aryIds)) {
            ids = aryIds.split(",");
        }
        this.bpmTaskDueTimeManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u50ac\u529e\u5386\u53f2\u6210\u529f", (Object)"");
    }

    private int getRemainingTime(BpmTaskDueTime bpmTaskDueTime) throws Exception {
        int remainingTime = 0;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            remainingTime = TimeUtil.getSecondDiff((LocalDateTime)LocalDateTime.now(), (LocalDateTime)bpmTaskDueTime.getStartTime()) / 60;
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getStartTime()));
            params.put("endTime", DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()));
            remainingTime = (int)(this.PortalFeignService.getWorkTimeByUser(params) / 60000L);
        }
        remainingTime = bpmTaskDueTime.getDueTime() - remainingTime;
        if (remainingTime <= 0) {
            remainingTime = 0;
        }
        return remainingTime;
    }
}

