/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.groovy.IScript;
import com.hotent.base.groovy.IUserScript;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExtendClassLoader;
import com.hotent.base.util.StringUtil;
import com.hotent.runtime.dao.BpmExtendJarDao;
import com.hotent.runtime.manager.BpmExtendClassManager;
import com.hotent.runtime.manager.BpmExtendJarManager;
import com.hotent.runtime.manager.ConditionScriptManager;
import com.hotent.runtime.model.BpmExtendClass;
import com.hotent.runtime.model.BpmExtendJar;
import com.hotent.runtime.model.ConditionScript;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BpmExtendJarManagerImpl
extends BaseManagerImpl<BpmExtendJarDao, BpmExtendJar>
implements BpmExtendJarManager {
    @Resource
    BpmExtendClassManager BpmExtendClassManager;
    @Resource
    ConditionScriptManager conditionScriptManager;
    @Resource
    JmsProducer jmsProducer;

    public void remove(Serializable id) {
        super.removeById(id);
        BpmExtendJarManager manageManager = (BpmExtendJarManager)AppUtil.getBean(BpmExtendJarManager.class);
        manageManager.removeFormCache((String)((Object)id));
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("JAR_ID_", (Object)id, QueryOP.EQUAL);
        List classList = this.BpmExtendClassManager.queryNoPage(queryFilter);
        if (BeanUtils.isNotEmpty((Object)classList)) {
            HashSet<String> exitClassIds = new HashSet<String>();
            HashSet<String> exitClassNames = new HashSet<String>();
            for (BpmExtendClass extendClass : classList) {
                exitClassIds.add(extendClass.getId());
                this.BpmExtendClassManager.removeFormCacheBySimpleName(extendClass.getSimpleName());
                exitClassNames.add(extendClass.getSimpleName());
            }
            QueryFilter sFilter = QueryFilter.build();
            sFilter.addFilter("CLASS_INS_NAME_", (Object)StringUtil.join(exitClassNames), QueryOP.IN);
            sFilter.withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
            List liScripts = this.conditionScriptManager.queryNoPage(sFilter);
            if (BeanUtils.isNotEmpty((Object)liScripts)) {
                HashSet<String> scriptIds = new HashSet<String>();
                for (ConditionScript conditionScript : liScripts) {
                    scriptIds.add(conditionScript.getId());
                }
                this.conditionScriptManager.removeByIds(scriptIds);
            }
            this.BpmExtendClassManager.removeByIds(exitClassIds);
            this.jmsProducer.sendToTopic((Object)StringUtil.join(exitClassNames), "bpmRemoveExtendClass");
        }
    }

    @Override
    public CommonResult<String> saveJar(BpmExtendJar jar) {
        jar.setCreateBy(AuthenticationUtil.getCurrentUserId());
        jar.setCreateName(AuthenticationUtil.getCurrentUserFullname());
        jar.setCreateTime(LocalDateTime.now());
        super.saveOrUpdate((Object)jar);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", null);
    }

    @Override
    @Cacheable(value={"bpm:extendJarId"}, key="#id")
    public BpmExtendJar getFormCache(String id) {
        return (BpmExtendJar)super.get((Serializable)((Object)id));
    }

    @Override
    @CacheEvict(value={"bpm:extendJarId"}, key="#id")
    public void removeFormCache(String id) {
    }

    @Override
    public List<Map<String, Object>> getAllJarIds() {
        return ((BpmExtendJarDao)this.baseMapper).getAllJarIds();
    }

    @Override
    public CommonResult<String> publishJar(String jarId, Boolean iscover) throws Exception {
        ArrayList<BpmExtendClass> addClassList;
        BpmExtendJar jar = (BpmExtendJar)((Object)super.getById((Serializable)((Object)jarId)));
        Map resolutionJarClass = ExtendClassLoader.resolutionJarClass((byte[])jar.getJarBytes(), (Integer)jar.getType());
        if (BeanUtils.isNotEmpty((Object)resolutionJarClass)) {
            HashSet<String> simpleNmaes = new HashSet<String>();
            addClassList = new ArrayList<BpmExtendClass>();
            for (Map.Entry next : resolutionJarClass.entrySet()) {
                Class cls = (Class)next.getValue();
                BpmExtendClass extendClass = new BpmExtendClass();
                extendClass.setJarId(jar.getId());
                extendClass.setPath(cls.getName());
                extendClass.setSimpleName(ExtendClassLoader.getSimpleName((String)cls.getName()));
                simpleNmaes.add(extendClass.getSimpleName());
                extendClass.setMd5((String)next.getKey());
                if (IUserScript.class.isAssignableFrom(cls)) {
                    extendClass.setType("2");
                } else if (IScript.class.isAssignableFrom(cls)) {
                    extendClass.setType("1");
                }
                addClassList.add(extendClass);
            }
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("SIMPLE_NAME_", (Object)StringUtil.join(simpleNmaes), QueryOP.IN);
            List list = this.BpmExtendClassManager.queryNoPage(queryFilter);
            HashSet<String> exitClassIds = new HashSet<String>();
            if (BeanUtils.isNotEmpty((Object)list)) {
                boolean isSameJar = true;
                HashSet<String> exitClass = new HashSet<String>();
                for (BpmExtendClass extendClass : list) {
                    exitClass.add(extendClass.getSimpleName());
                    exitClassIds.add(extendClass.getId());
                    if (jarId.equals(extendClass.getJarId())) continue;
                    isSameJar = false;
                }
                if (!iscover.booleanValue() && !isSameJar) {
                    return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)StringUtil.join(exitClass));
                }
            }
            if (BeanUtils.isNotEmpty(exitClassIds)) {
                this.BpmExtendClassManager.removeByIds(exitClassIds);
            }
            for (String simpleName : simpleNmaes) {
                this.BpmExtendClassManager.removeFormCacheBySimpleName(simpleName);
            }
        } else {
            return new CommonResult(false, "\u672a\u89e3\u6790\u5230\u7b26\u5408\u6761\u4ef6\u7684\u811a\u672c\u7c7b", null);
        }
        jar.setUpdateBy(AuthenticationUtil.getCurrentUserId());
        jar.setUpdateName(AuthenticationUtil.getCurrentUserFullname());
        jar.setUpdateTime(LocalDateTime.now());
        this.BpmExtendClassManager.saveBatch(addClassList);
        jar.setStatus(2);
        super.updateById((Object)jar);
        this.jmsProducer.sendToTopic((Object)jarId, "bpmPublishExtendJar");
        return new CommonResult(true, "\u53d1\u5e03\u6210\u529f", null);
    }

    @Override
    public List<BpmExtendJar> getJarByType(Integer type) {
        List jarList = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmExtendJar::getType, (Object)type)).eq(BpmExtendJar::getStatus, (Object)2));
        if (CollectionUtils.isNotEmpty((Collection)jarList)) {
            for (BpmExtendJar jar : jarList) {
                if (jar.getJarBytes() == null) continue;
                try {
                    jar.setJarData(new String(jar.getJarBytes(), StandardCharsets.ISO_8859_1));
                }
                catch (Exception exception) {}
            }
        }
        return jarList;
    }
}

