/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import cn.hutool.core.collection.ListUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.UserQueryPluginHelper;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.exception.ApproveTaskException;
import com.hotent.bpm.exception.BusinessException;
import com.hotent.bpm.model.BpmNodeSetting;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.params.PreviewProcessVo;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmNodeSettingManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProStatus;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.hotent.bpm.plugin.execution.message.def.HtmlSetting;
import com.hotent.bpm.plugin.execution.message.def.MessagePluginDef;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.runtime.manager.PreviewProcessManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PreviewProcessManagerImpl
implements PreviewProcessManager {
    private static final ThreadLocal<String> CUR_NODE_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<List<Map<String, Set<String>>>> ANNULAR_THREAD_LOCAL = new ThreadLocal();
    private final Logger logger = LoggerFactory.getLogger(PreviewProcessManagerImpl.class);
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmNodeSettingManager bpmNodeSettingManager;
    @Resource
    IFlowManager iFlowService;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    UCFeignService ucFeignService;
    public static Set<String> hiddenTaskType = new HashSet<String>(){
        {
            this.add(TaskType.TRANSFORMING.name());
            this.add(TaskType.COPYTO.name());
            this.add(TaskType.APPROVELINEING.name());
            this.add(TaskType.SIGNSEQUENCEING.name());
            this.add(TaskType.SIGNLINEING.name());
            this.add("manualend");
            this.add("adminmanualend");
        }
    };

    @Override
    public Map<String, Object> previewProcess(PreviewProcessVo previewProcessVo) throws Exception {
        List startNodes;
        Map startNodeMap;
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)previewProcessVo.getInstId()));
        List<ObjectNode> boDatas = this.initBpmContext(previewProcessVo, processInstance);
        List allNodeDef = this.bpmDefinitionAccessor.getAllNodeDef(processInstance.getProcDefId());
        HashMap<String, Object> pathMap = new HashMap<String, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String startNodeId = this.getPreviewProcessStartNodeId(processInstance);
        map.put("nextNodeId", ListUtil.list((boolean)false, (Object[])new String[]{startNodeId}));
        Map<String, Object> variables = this.initVariables(processInstance);
        Map<String, DefaultBpmTask> curTaskMap = this.initCurTaskMap(previewProcessVo);
        this.calcNextNode(allNodeDef, startNodeId, boDatas, variables, pathMap, "startNode", curTaskMap, !curTaskMap.containsKey(startNodeId), processInstance);
        boolean isSkipFirstNode = BpmUtil.getSkipFirstNode((String)processInstance.getProcDefId());
        if (isSkipFirstNode && (startNodeMap = (Map)pathMap.get(startNodeId)) != null) {
            startNodeMap.put("isSkipFirst", true);
        }
        List<String> nodeSort = this.nodeSort(pathMap, startNodeId, new ArrayList<String>());
        this.preHandleExcutorList(processInstance, pathMap, nodeSort, allNodeDef, curTaskMap);
        String continueNodeAuditor = "";
        for (String key : nodeSort) {
            String auditor;
            List data;
            Map nodeOpinionMap;
            Map parentNodeMap;
            Iterator<Object> parentNodeOpinion;
            Map nodeMap = (Map)pathMap.get(key);
            HashMap<String, Object> variablesFormNode = new HashMap<String, Object>(variables);
            Object parentNodeId = nodeMap.get("parentNodeId");
            if (StringUtil.isNotEmpty((String)continueNodeAuditor)) {
                variablesFormNode.put("parentNodeAuditor", continueNodeAuditor);
            } else if (BeanUtils.isNotEmpty(parentNodeId) && pathMap.get(parentNodeId) != null && BeanUtils.isNotEmpty(parentNodeOpinion = (parentNodeMap = (Map)pathMap.get(parentNodeId)).get("nodeOpinion")) && (nodeOpinionMap = (Map)((Object)parentNodeOpinion)).getOrDefault("hasOpinion", false).booleanValue() && BeanUtils.isNotEmpty((Object)(data = (List)nodeOpinionMap.getOrDefault("data", new ArrayList()))) && StringUtil.isNotEmpty((String)(auditor = ((DefaultBpmCheckOpinion)data.get(0)).getAuditor()))) {
                variablesFormNode.put("parentNodeAuditor", auditor);
                continueNodeAuditor = auditor;
            }
            try {
                BpmNodeDef bpmNodeDef = null;
                parentNodeOpinion = allNodeDef.iterator();
                while (parentNodeOpinion.hasNext()) {
                    BpmNodeDef nodeDef = (BpmNodeDef)parentNodeOpinion.next();
                    if (!nodeDef.getNodeId().equals(nodeMap.get("nodeId").toString())) continue;
                    bpmNodeDef = nodeDef;
                    break;
                }
                if (bpmNodeDef == null) continue;
                ContextThreadUtil.setNewVars((String)("currentNode_" + processInstance.getId()), (String)bpmNodeDef.getNodeId());
                ContextThreadUtil.setNewVars((String)("currentNodeName_" + processInstance.getId()), (String)bpmNodeDef.getName());
                ContextThreadUtil.setNewVars((String)("currentNodeType_" + processInstance.getId()), (String)bpmNodeDef.getType().getKey());
                UserQueryPluginHelper userQueryPluginHelper = (UserQueryPluginHelper)AppUtil.getBean(UserQueryPluginHelper.class);
                List bpmPluginContexts = bpmNodeDef.getBpmPluginContexts();
                List bpmIdentities = null;
                if (nodeMap.containsKey("excutorList")) continue;
                if (NodeType.SERVICETASK.equals((Object)bpmNodeDef.getType())) {
                    if (bpmPluginContexts.size() > 0) {
                        MessagePluginDef bpmPluginDef = (MessagePluginDef)((BpmPluginContext)bpmPluginContexts.get(0)).getBpmPluginDef();
                        HtmlSetting htmlSetting = bpmPluginDef.getHtmlSetting();
                        BpmPluginSessionFactory bpmPluginSessionFactory = (BpmPluginSessionFactory)AppUtil.getBean(BpmPluginSessionFactory.class);
                        BpmUserCalcPluginSession bpmUserCalcPluginSession = bpmPluginSessionFactory.buildBpmUserCalcPluginSession(variablesFormNode);
                        bpmIdentities = UserAssignRuleQueryHelper.queryExtract((List)htmlSetting.getRuleList(), (BpmUserCalcPluginSession)bpmUserCalcPluginSession);
                    }
                } else {
                    variablesFormNode.put("nodeId", bpmNodeDef.getNodeId());
                    variablesFormNode.put("nodeName", bpmNodeDef.getName());
                    bpmIdentities = userQueryPluginHelper.query(bpmPluginContexts, variablesFormNode, "user");
                    if (BeanUtils.isNotEmpty((Object)bpmIdentities) && bpmIdentities.size() == 1) {
                        if (!continueNodeAuditor.equals(((BpmIdentity)bpmIdentities.get(0)).getId())) {
                            continueNodeAuditor = "";
                        }
                    } else {
                        continueNodeAuditor = "";
                    }
                }
                nodeMap.put("excutorList", bpmIdentities);
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u5ba1\u6279\u8def\u5f84\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        if (BeanUtils.isNotEmpty(pathMap)) {
            pathMap = Optional.ofNullable(this.ucFeignService.calculateNodeUsersByOne(pathMap)).orElse(new HashMap());
        }
        returnData.put("proInststatus", processInstance.getStatus());
        boolean deduceFromStart = true;
        if (!ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(processInstance.getStatus()) && BeanUtils.isNotEmpty((Object)(startNodes = this.bpmDefinitionAccessor.getStartNodes(processInstance.getProcDefId()))) && !startNodeId.equals(((BpmNodeDef)startNodes.get(0)).getNodeId())) {
            deduceFromStart = false;
        }
        map.put("nodeName", "\u5f00\u59cb");
        map.put("nodeType", "start");
        map.put("nodeId", "startNode");
        map.put("excutorList", this.getExecutors(processInstance));
        map.put("isOld", deduceFromStart);
        pathMap.put("startNode", map);
        returnData.put("pathMap", pathMap);
        returnData.put("deduceFromStart", deduceFromStart);
        this.clearThreadLocal();
        return returnData;
    }

    private Map<String, DefaultBpmTask> initCurTaskMap(PreviewProcessVo previewProcessVo) throws Exception {
        List byInstId = this.bpmTaskManager.list((Wrapper)Wrappers.lambdaQuery().eq(DefaultBpmTask::getProcInstId, (Object)previewProcessVo.getInstId()));
        HashMap<String, DefaultBpmTask> curTaskMap = new HashMap<String, DefaultBpmTask>();
        for (DefaultBpmTask defaultBpmTask : byInstId) {
            BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defaultBpmTask.getProcDefId(), defaultBpmTask.getNodeId());
            if (BeanUtils.isEmpty((Object)bpmNodeDef)) continue;
            BpmNodeDef parentBpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
            if (BeanUtils.isNotEmpty((Object)parentBpmNodeDef) && (NodeType.SUBPROCESS.getKey().equals(parentBpmNodeDef.getType().getKey()) || NodeType.CALLACTIVITY.getKey().equals(parentBpmNodeDef.getType().getKey()))) {
                curTaskMap.put(parentBpmNodeDef.getNodeId(), defaultBpmTask);
                continue;
            }
            curTaskMap.put(defaultBpmTask.getNodeId(), defaultBpmTask);
        }
        if (BeanUtils.isEmpty(curTaskMap)) {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DefaultBpmProStatus::getProcInstId, (Object)previewProcessVo.getInstId())).eq(DefaultBpmProStatus::getStatus, (Object)NodeStatus.PENDING.getKey())).select(new SFunction[]{DefaultBpmProStatus::getNodeId});
            List bpmProStatusList = this.bpmProStatusManager.list((Wrapper)wrapper);
            bpmProStatusList.forEach(item -> {
                if (StringUtil.isNotEmpty((String)item.getNodeId())) {
                    curTaskMap.put(item.getNodeId(), null);
                }
            });
        }
        return curTaskMap;
    }

    private List<ObjectNode> initBpmContext(PreviewProcessVo previewProcessVo, DefaultBpmProcessInstance processInstance) throws Exception {
        List<ObjectNode> boDatas = this.getFormDataObjectNodes(previewProcessVo.getFormData(), processInstance);
        BpmContextUtil.setBoToContext(boDatas);
        BpmContextUtil.setBoToThreadContext(boDatas);
        return boDatas;
    }

    private List<Map<String, String>> getExecutors(DefaultBpmProcessInstance processInstance) {
        ArrayList<Map<String, String>> executorList = new ArrayList<Map<String, String>>();
        HashMap<String, String> executorMap = new HashMap<String, String>();
        executorMap.put("type", "user");
        executorMap.put("id", processInstance.getCreateBy());
        executorMap.put("name", processInstance.getCreator());
        executorList.add(executorMap);
        return executorList;
    }

    private Map<String, Object> initVariables(DefaultBpmProcessInstance processInstance) {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Map variables = Optional.ofNullable(cmd).map(ActionCmd::getVariables).orElse(new HashMap());
        String startUserId = StringUtil.isEmpty((String)processInstance.getCreateBy()) ? ContextUtil.getCurrentUserId() : processInstance.getCreateBy();
        String creator = "";
        String createAccount = "";
        if (ContextUtil.getCurrentUser() != null) {
            creator = ContextUtil.getCurrentUser().getFullname();
            createAccount = ContextUtil.getCurrentUser().getAccount();
        }
        if (StringUtil.isNotEmpty((String)processInstance.getCreator())) {
            creator = processInstance.getCreator();
        }
        if (StringUtil.isNotEmpty((String)processInstance.getCreateAccount())) {
            createAccount = processInstance.getCreateAccount();
        }
        variables.put("startorName", creator);
        variables.put("startUserAccount", createAccount);
        variables.put("businessKey_", processInstance.getBizKey());
        variables.put("processDefId_", processInstance.getProcDefId());
        variables.put("flowKey_", processInstance.getProcDefKey());
        variables.put("subject_", processInstance.getSubject());
        variables.put("instanceId_", processInstance.getId());
        variables.put("processInstance", processInstance);
        variables.put("startUser", startUserId);
        JsonNode jsonNode = this.ucFeignService.getMainOrgByUserIdAndCurOrgId(startUserId, processInstance.getCreateOrgId());
        variables.put("startUserOrgId", JsonUtil.getStrByPath((JsonNode)jsonNode, (String)"startUserOrgId"));
        variables.put("startUserOrgCode", JsonUtil.getStrByPath((JsonNode)jsonNode, (String)"startUserOrgCode"));
        variables.put("startUserOrgName", JsonUtil.getStrByPath((JsonNode)jsonNode, (String)"startUserOrgName"));
        variables.put("not_request_uc", "true");
        variables.put("processInstance", processInstance);
        List byInstId = this.bpmTaskManager.list((Wrapper)Wrappers.lambdaQuery().eq(DefaultBpmTask::getProcInstId, (Object)processInstance.getId()));
        if (BeanUtils.isNotEmpty((Object)byInstId)) {
            String taskId = ((DefaultBpmTask)byInstId.get(0)).getTaskId();
            if (BeanUtils.isNotEmpty((Object)((DefaultBpmTask)byInstId.get(0)).getParentId()) && !"0".equals(((DefaultBpmTask)byInstId.get(0)).getParentId())) {
                taskId = ((DefaultBpmTask)byInstId.get(0)).getParentId();
            }
            Map variables2 = this.natTaskService.getVariables(taskId);
            variables.putAll(variables2);
        }
        return variables;
    }

    private void clearThreadLocal() {
        CUR_NODE_THREAD_LOCAL.remove();
        ANNULAR_THREAD_LOCAL.remove();
        BpmContextUtil.clearBoInThreadContext();
        ContextThreadUtil.clearCmdDataThreadLocal();
    }

    private void preHandleExcutorList(DefaultBpmProcessInstance processInstance, HashMap<String, Object> pathMap, List<String> nodeSort, List<BpmNodeDef> allNodeDef, Map<String, DefaultBpmTask> curTaskMap) throws Exception {
        Map<String, List<BpmNodeDef>> nodeDefListMap = allNodeDef.stream().filter(item -> StringUtil.isNotEmpty((String)item.getNodeId())).collect(Collectors.groupingBy(BpmNodeDef::getNodeId));
        for (String key : pathMap.keySet()) {
            List<Object> bpmIdentities;
            Map nodeMap;
            Object nodeOpinion;
            JsonNode jsonNode;
            boolean hasOpinion;
            if (!nodeSort.contains(key)) {
                nodeSort.add(key);
            }
            if (!(hasOpinion = (jsonNode = JsonUtil.toJsonNode((Object)(nodeOpinion = this.iFlowService.nodeOpinion("", processInstance, (String)(nodeMap = (Map)pathMap.get(key)).get("nodeId"), true)))).get("hasOpinion").asBoolean())) continue;
            nodeMap.put("nodeOpinion", nodeOpinion);
            JsonNode data = jsonNode.get("data");
            if (!BeanUtils.isNotEmpty((Object)data) || !(data instanceof ArrayNode)) continue;
            ArrayNode arrayData = (ArrayNode)data;
            String status = JsonUtil.getString((JsonNode)arrayData.get(0), (String)"status", (String)"");
            HashSet allStatus = Sets.newHashSet();
            for (JsonNode arrayDatum : arrayData) {
                allStatus.add(JsonUtil.getString((JsonNode)arrayDatum, (String)"status", (String)""));
            }
            if (NodeType.SIGNTASK.getKey().equals(nodeMap.get("nodeType"))) {
                bpmIdentities = PreviewProcessManagerImpl.getBpmIdentitiesByOpinion(arrayData);
                if (!BeanUtils.isNotEmpty(bpmIdentities)) continue;
                nodeMap.put("excutorList", bpmIdentities);
                continue;
            }
            if (arrayData.size() > 1 && allStatus.contains(OpinionStatus.DELIVERTO.getKey())) {
                List collect;
                bpmIdentities = Lists.newArrayList();
                List todoByNodeIdList = this.bpmTaskManager.getByInstIdAndNodeId(processInstance.getId(), key);
                if (BeanUtils.isNotEmpty((Object)todoByNodeIdList) && (collect = todoByNodeIdList.stream().filter(bpmTask -> !TaskType.TRANSFORMING.getKey().equals(bpmTask.getStatus()) && !TaskType.COPYTO.getKey().equals(bpmTask.getStatus()) && !TaskType.APPROVELINEING.getKey().equals(bpmTask.getStatus()) && !TaskType.SIGNSEQUENCEING.getKey().equals(bpmTask.getStatus()) && !TaskType.SIGNLINEING.getKey().equals(bpmTask.getStatus())).collect(Collectors.toList())).size() > 0) {
                    for (DefaultBpmTask defaultBpmTask : collect) {
                        String account;
                        String assigneeId = defaultBpmTask.getAssigneeId();
                        CommonResult commonResult = this.ucFeignService.getUserById(assigneeId);
                        if (!commonResult.getState().booleanValue() || !BeanUtils.isNotEmpty((Object)commonResult.getValue()) || (account = JsonUtil.getString((JsonNode)((JsonNode)commonResult.getValue()), (String)"account", (String)"")) == "") continue;
                        BpmIdentity bpmIdentity = DefaultBpmIdentity.getIdentityByUserId((String)assigneeId, (String)account);
                        bpmIdentities.add(bpmIdentity);
                    }
                }
                if (BeanUtils.isEmpty((Object)bpmIdentities)) {
                    bpmIdentities = PreviewProcessManagerImpl.getBpmIdentitiesByOpinion(arrayData);
                }
                if (!BeanUtils.isNotEmpty((Object)bpmIdentities)) continue;
                nodeMap.put("excutorList", bpmIdentities);
                continue;
            }
            if (OpinionStatus.SIGN_PASS_CANCEL.getKey().equals(status) || OpinionStatus.TRANS_OPPOSE.getKey().equals(status) || OpinionStatus.TRANS_AGREE.getKey().equals(status)) {
                if (!StringUtil.isNotEmpty((String)CUR_NODE_THREAD_LOCAL.get()) || !this.isAfterNowNode(key, nodeSort)) continue;
                nodeMap.put("transStatus", OpinionStatus.TRANS_AGREE.getKey());
                nodeMap.put("transStatusVal", "\u6d41\u8f6c\u901a\u8fc7");
                continue;
            }
            if (!curTaskMap.containsKey(key) || !BeanUtils.isNotEmpty((Object)(bpmIdentities = PreviewProcessManagerImpl.getBpmIdentitiesByOpinion(arrayData)))) continue;
            nodeMap.put("excutorList", bpmIdentities);
        }
    }

    private static List<BpmIdentity> getBpmIdentitiesByOpinion(ArrayNode arrayData) throws IOException {
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        HashSet existIds = Sets.newHashSet();
        for (JsonNode opinionRow : arrayData) {
            JsonNode qualfieds;
            String rowStatus = JsonUtil.getString((JsonNode)opinionRow, (String)"status", (String)"");
            if (!OpinionStatus.AWAITING_CHECK.getKey().equals(rowStatus) || !BeanUtils.isNotEmpty((Object)(qualfieds = JsonUtil.toJsonNode((String)JsonUtil.getString((JsonNode)opinionRow, (String)"qualfieds")))) || !(qualfieds instanceof ArrayNode)) continue;
            for (JsonNode qualfied : qualfieds) {
                String id = JsonUtil.getString((JsonNode)qualfied, (String)"id", (String)"");
                String name = JsonUtil.getString((JsonNode)qualfied, (String)"name", (String)"");
                String type = JsonUtil.getString((JsonNode)qualfied, (String)"type", null);
                String groupType = JsonUtil.getString((JsonNode)qualfied, (String)"groupType", null);
                if (existIds.contains(id)) continue;
                DefaultBpmIdentity identityByUserId = new DefaultBpmIdentity();
                identityByUserId.setId(id);
                identityByUserId.setName(name);
                identityByUserId.setType(type);
                identityByUserId.setGroupType(groupType);
                bpmIdentities.add((BpmIdentity)identityByUserId);
                existIds.add(id);
            }
        }
        return bpmIdentities;
    }

    private String getPreviewProcessStartNodeId(DefaultBpmProcessInstance processInstance) {
        try {
            List startNodes = this.bpmDefinitionAccessor.getStartNodes(processInstance.getProcDefId());
            if (BeanUtils.isNotEmpty((Object)startNodes)) {
                return ((BpmNodeDef)startNodes.get(0)).getNodeId();
            }
            if (!ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(processInstance.getStatus())) {
                List taskList = this.bpmTaskManager.getByInstId(processInstance.getId());
                for (DefaultBpmTask task : taskList) {
                    if (hiddenTaskType.contains(task.getStatus()) || !StringUtil.isNotEmpty((String)task.getNodeId())) continue;
                    return task.getNodeId();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f00\u59cb\u8282\u70b9\u5931\u8d25", (Throwable)e);
            throw new ApproveTaskException("\u83b7\u53d6\u5f00\u59cb\u8282\u70b9\u5931\u8d25");
        }
        return null;
    }

    private void calcNextNode(List<BpmNodeDef> allNodeDef, String nodeId, List<ObjectNode> boDatas, Map<String, Object> vars, Map<String, Object> pathMap, String parentNodeId, Map<String, DefaultBpmTask> curTaskMap, boolean isOld, DefaultBpmProcessInstance processInstance) throws Exception {
        boolean lastIsOld = isOld;
        if (StringUtil.isEmpty((String)nodeId)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parentNodeId", parentNodeId);
        ArrayList<String> nextNodeArr = new ArrayList<String>();
        for (BpmNodeDef bpmNodeDef : allNodeDef) {
            List byInstNodeId;
            if (!nodeId.equals(bpmNodeDef.getNodeId())) continue;
            if (this.checkAnnular(nodeId, parentNodeId)) {
                map.put("nodeName", "cannot");
                map.put("nodeId", "cannot");
                map.put("nodeType", "cannot");
                map.put("excutorList", new ArrayList());
                map.put("emptySkip", false);
                map.put("canSkip", true);
                map.put("isOld", false);
                map.put("nextNodeId", Lists.newArrayList());
                HashMap lastNode = (HashMap)pathMap.get(parentNodeId);
                if (lastNode != null && (lastNode = (HashMap)pathMap.get(lastNode.get("parentNodeId"))) != null) {
                    nextNodeArr.add("cannot");
                    map.put("parentNodeId", lastNode.get("nodeId"));
                }
                pathMap.put("cannot", map);
                break;
            }
            if (pathMap.containsKey(nodeId)) {
                HashMap m = (HashMap)pathMap.get(nodeId);
                if (!((Boolean)m.get("isOld")).booleanValue() || isOld) break;
                m.put("isOld", isOld);
            }
            nodeId = null;
            if (curTaskMap.containsKey(bpmNodeDef.getNodeId())) {
                CUR_NODE_THREAD_LOCAL.set(bpmNodeDef.getNodeId());
                map.put("isNow", true);
                isOld = false;
                lastIsOld = false;
            }
            map.put("isOld", isOld);
            List outcomeNodes = bpmNodeDef.getOutcomeNodes();
            if (NodeType.INCLUSIVEGATEWAY.getKey().equals(bpmNodeDef.getType().getKey())) {
                Object nextNodeIds;
                Map conditions = bpmNodeDef.getConditions();
                for (BpmNodeDef bpmNodeD : outcomeNodes) {
                    nextNodeArr.add(bpmNodeD.getNodeId());
                }
                List<String> evaluateAll = this.evaluateAll(conditions, boDatas, vars, bpmNodeDef.getNodeId(), isOld, processInstance, parentNodeId);
                nextNodeArr.removeAll(evaluateAll);
                map.put("nodeName", bpmNodeDef.getName());
                map.put("nodeId", bpmNodeDef.getNodeId());
                map.put("nodeType", bpmNodeDef.getType().getKey());
                map.put("emptySkip", false);
                map.put("nextNodeId", nextNodeArr);
                if (outcomeNodes.size() == 1) {
                    map.put("isEndGateway", true);
                }
                pathMap.put(bpmNodeDef.getNodeId(), map);
                if (nextNodeArr.size() > 0 && !(nextNodeIds = nextNodeArr.stream().map(obj -> (String)obj).filter(nextNodeId -> {
                    if (BeanUtils.isEmpty((Object)bpmNodeDef.getDefaultOutcome())) {
                        return true;
                    }
                    return !nextNodeId.equals(bpmNodeDef.getDefaultOutcome().getNodeId());
                }).collect(Collectors.toList())).isEmpty()) {
                    nextNodeArr.clear();
                    nextNodeArr.addAll((Collection<String>)nextNodeIds);
                }
                for (BpmNodeDef bpmNodeDe : outcomeNodes) {
                    if (!nextNodeArr.contains(bpmNodeDe.getNodeId())) continue;
                    this.calcNextNode(allNodeDef, bpmNodeDe.getNodeId(), boDatas, vars, pathMap, bpmNodeDef.getNodeId(), curTaskMap, isOld, processInstance);
                }
                break;
            }
            if (NodeType.EXCLUSIVEGATEWAY.getKey().equals(bpmNodeDef.getType().getKey())) {
                Map conditions = bpmNodeDef.getConditions();
                for (BpmNodeDef bpmNodeD : outcomeNodes) {
                    nextNodeArr.add(bpmNodeD.getNodeId());
                }
                List<String> evaluateAll = this.evaluateAll(conditions, boDatas, vars, bpmNodeDef.getNodeId(), isOld, processInstance, parentNodeId);
                nextNodeArr.removeAll(evaluateAll);
                if (nextNodeArr.size() > 0) {
                    ArrayList suitableList = new ArrayList();
                    ArrayList emptyList = new ArrayList();
                    nextNodeArr.stream().map(obj -> (String)obj).forEach(nextNodeId -> {
                        if (StringUtil.isNotEmpty((String)((String)conditions.get(nextNodeId)))) {
                            suitableList.add(nextNodeId);
                        } else {
                            emptyList.add(nextNodeId);
                        }
                    });
                    if (!suitableList.isEmpty()) {
                        nodeId = (String)suitableList.get(0);
                    }
                    if (StringUtil.isEmpty((String)nodeId) && emptyList.size() == 1) {
                        nodeId = (String)emptyList.get(0);
                    }
                    if (StringUtil.isNotEmpty((String)nodeId)) {
                        nextNodeArr.clear();
                        nextNodeArr.add(nodeId);
                    }
                }
                map.put("nodeName", bpmNodeDef.getName());
                map.put("nodeId", bpmNodeDef.getNodeId());
                map.put("nodeType", bpmNodeDef.getType().getKey());
                map.put("emptySkip", false);
                map.put("nextNodeId", nextNodeArr);
                pathMap.put(bpmNodeDef.getNodeId(), map);
                this.calcNextNode(allNodeDef, nodeId, boDatas, vars, pathMap, bpmNodeDef.getNodeId(), curTaskMap, isOld, processInstance);
                break;
            }
            if (NodeType.PARALLELGATEWAY.getKey().equals(bpmNodeDef.getType().getKey())) {
                map.put("nodeName", bpmNodeDef.getName());
                map.put("nodeId", bpmNodeDef.getNodeId());
                map.put("nodeType", bpmNodeDef.getType().getKey());
                map.put("emptySkip", false);
                map.put("nextNodeId", nextNodeArr);
                if (outcomeNodes.size() == 1) {
                    map.put("isEndGateway", true);
                }
                pathMap.put(bpmNodeDef.getNodeId(), map);
                for (BpmNodeDef bpmNodeDe : outcomeNodes) {
                    nextNodeArr.add(bpmNodeDe.getNodeId());
                    this.calcNextNode(allNodeDef, bpmNodeDe.getNodeId(), boDatas, vars, pathMap, bpmNodeDef.getNodeId(), curTaskMap, isOld, processInstance);
                }
                break;
            }
            map.put("nodeName", bpmNodeDef.getName());
            if (NodeType.END.getKey().equals(bpmNodeDef.getType().getKey())) {
                map.put("nodeName", "\u7ed3\u675f");
            } else {
                nextNodeArr.add(((BpmNodeDef)outcomeNodes.get(0)).getNodeId());
                nodeId = ((BpmNodeDef)outcomeNodes.get(0)).getNodeId();
            }
            if (NodeType.SIGNTASK.getKey().equals(bpmNodeDef.getType().getKey())) {
                SignNodeDef signNodeDef = (SignNodeDef)bpmNodeDef;
                String extraProp = signNodeDef.isParallel() ? "parallel" : "sequential";
                map.put("extraProp", extraProp);
            }
            map.put("nodeId", bpmNodeDef.getNodeId());
            map.put("nodeType", bpmNodeDef.getType().getKey());
            boolean canSkip = true;
            boolean emptySkip = false;
            List nodeProperties = bpmNodeDef.getNodeProperties();
            if (BeanUtils.isNotEmpty((Object)nodeProperties)) {
                NodeProperties nodeProperties2 = (NodeProperties)nodeProperties.get(0);
                emptySkip = nodeProperties2.isSkipExecutorEmpty();
                canSkip = nodeProperties2.isPopWin();
            }
            if (isOld && (byInstNodeId = this.bpmCheckOpinionManager.getByInstNodeId(processInstance.getId(), bpmNodeDef.getNodeId())).size() == 0) {
                isOld = false;
            }
            map.put("isOld", isOld);
            if (lastIsOld && (NodeType.CALLACTIVITY.equals((Object)bpmNodeDef.getType()) || NodeType.SUBPROCESS.equals((Object)bpmNodeDef.getType()))) {
                isOld = true;
            }
            map.put("canSkip", canSkip);
            map.put("emptySkip", emptySkip);
            map.put("nextNodeId", nextNodeArr);
            pathMap.put(bpmNodeDef.getNodeId(), map);
            this.calcNextNode(allNodeDef, nodeId, boDatas, vars, pathMap, bpmNodeDef.getNodeId(), curTaskMap, isOld, processInstance);
            break;
        }
    }

    private boolean checkAnnular(String nodeId, String parentNodeId) {
        List<Map<String, Set<String>>> maps = Optional.ofNullable(ANNULAR_THREAD_LOCAL.get()).orElse(Lists.newArrayList());
        Map<String, Set<Object>> cur = new HashMap<String, HashSet>();
        boolean check = false;
        for (Map<String, Set<String>> map : maps) {
            if (!map.containsKey(parentNodeId)) continue;
            cur = map;
            Set<String> nextSet = map.get(parentNodeId);
            if (nextSet.contains(nodeId)) {
                check = this.checkAnnular(nodeId, maps, Sets.newHashSet((Object[])new String[]{parentNodeId}));
                if (!check) continue;
                break;
            }
            nextSet.add(nodeId);
        }
        if (BeanUtils.isEmpty(cur)) {
            cur.put(parentNodeId, Sets.newHashSet((Object[])new String[]{nodeId}));
            maps.add(cur);
            HashSet alreadyNodeSet = Sets.newHashSet((Object[])new String[]{parentNodeId});
            check = this.checkAnnular(nodeId, maps, alreadyNodeSet);
        }
        ANNULAR_THREAD_LOCAL.set(maps);
        return check;
    }

    private boolean checkAnnular(String nodeId, List<Map<String, Set<String>>> maps, Set<String> alreadyNodeSet) {
        for (Map<String, Set<String>> map : maps) {
            if (!map.containsKey(nodeId)) continue;
            for (String next : map.get(nodeId)) {
                if (alreadyNodeSet.contains(nodeId)) {
                    return true;
                }
                alreadyNodeSet.add(nodeId);
                if (!this.checkAnnular(next, maps, alreadyNodeSet)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ObjectNode> getFormDataObjectNodes(String formData, DefaultBpmProcessInstance processInstance) throws Exception {
        String formDataDecode;
        if (StringUtil.isNotEmpty((String)formData) && (formDataDecode = Base64.getFromBase64((String)formData)).contains("initData")) {
            return BoDataUtil.converFormData((String)formDataDecode);
        }
        return this.boDataService.getDataByInst((BpmProcessInstance)processInstance);
    }

    private List<String> evaluateAll(Map<String, String> conditions, List<ObjectNode> boDatas, Map<String, Object> vars, String curnodeId, boolean isOld, DefaultBpmProcessInstance processInstance, String parentNodeId) throws Exception {
        Map boMap;
        List byInstNodeId;
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<Object, Object> maps = new HashMap();
        if (BeanUtils.isNotEmpty(vars)) {
            maps = vars;
        }
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        vars.put("cmd", cmd);
        vars.put("taskCmd", cmd);
        DefaultBpmCheckOpinion defaultBpmCheckOpinion = null;
        if (isOld && (byInstNodeId = this.bpmCheckOpinionManager.getByInstNodeId(processInstance.getId(), parentNodeId)).size() > 0) {
            defaultBpmCheckOpinion = (DefaultBpmCheckOpinion)byInstNodeId.get(byInstNodeId.size() - 1);
            List<ObjectNode> oldBoDatas = this.getFormDataObjectNodes(defaultBpmCheckOpinion.getFormData(), processInstance);
            BpmContextUtil.setBoToContext(oldBoDatas);
            BpmContextUtil.setBoToThreadContext(oldBoDatas);
            if ("oppose".equals(defaultBpmCheckOpinion.getStatus())) {
                cmd.setActionName("oppose");
            } else {
                cmd.setActionName("agree");
            }
            String vars2 = defaultBpmCheckOpinion.getVars();
            if (StringUtil.isNotEmpty((String)vars2)) {
                String fromBase64 = Base64.getFromBase64((String)vars2);
                Map bean = (Map)JsonUtil.toBean((String)fromBase64, Map.class);
                maps.putAll(bean);
            }
        }
        if (BeanUtils.isEmpty(defaultBpmCheckOpinion)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"NODE_ID_", (Object)curnodeId);
            queryWrapper.eq((Object)"DEF_ID", vars.get("processDefId_"));
            BpmNodeSetting one = (BpmNodeSetting)this.bpmNodeSettingManager.getOne((Wrapper)queryWrapper);
            if (BeanUtils.isEmpty((Object)one)) {
                cmd.setActionName("agree");
            } else {
                Integer forecast = one.getForecast();
                if (forecast == 2) {
                    cmd.setActionName("oppose");
                } else {
                    cmd.setActionName("agree");
                }
            }
        }
        if (BeanUtils.isNotEmpty((Object)(boMap = BpmContextUtil.getBoFromThreadContext()))) {
            HashMap newMap = new HashMap();
            for (Map.Entry next : boMap.entrySet()) {
                newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)next.getValue()));
            }
            maps.putAll(newMap);
        }
        GroovyScriptEngine engine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        Set<Map.Entry<String, String>> entrySet = conditions.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String nodeId = entry.getKey();
            String script = this.replaceSpecialChar(entry.getValue());
            try {
                if (StringUtil.isEmpty((String)script)) continue;
                BaseActionCmd taskCmd = (BaseActionCmd)vars.get("taskCmd");
                taskCmd.setNodeId(parentNodeId);
                boolean flag = engine.executeBoolean(script, maps);
                if (flag) continue;
                arrayList.add(nodeId);
            }
            catch (BusinessException e) {
                this.logger.error("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfbIT\u62a5\u4e8b\u3002", (Throwable)e);
                throw new ApproveTaskException(e.getMessage());
            }
            catch (Exception e) {
                this.logger.error("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfbIT\u62a5\u4e8b\u3002", (Throwable)e);
                e.printStackTrace();
                StringBuilder message = new StringBuilder("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfbIT\u62a5\u4e8b\u3002");
                message.append("<br/><br/>\u8282\u70b9\uff1a" + nodeId);
                message.append("<br/><br/>\u811a\u672c\uff1a" + script);
                message.append("<br/><br/>\u6d41\u7a0b\u53d8\u91cf\uff1a" + maps);
                throw new ApproveTaskException(message.toString());
            }
        }
        if (isOld) {
            BpmContextUtil.setBoToContext(boDatas);
            BpmContextUtil.setBoToThreadContext(boDatas);
        }
        return arrayList;
    }

    private String replaceSpecialChar(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        if ((str = str.trim()).startsWith("${")) {
            return str.substring(2, str.length() - 1);
        }
        return str;
    }

    private List<String> nodeSort(Map<String, Object> pathMap, String nextId, List<String> result) {
        if (pathMap.get(nextId) == null) {
            return result;
        }
        Map nextNodeMap = (Map)pathMap.get(nextId);
        Object nextNodeId = nextNodeMap.get("nextNodeId");
        result.add(nextNodeMap.get("nodeId").toString());
        if (BeanUtils.isNotEmpty(nextNodeId)) {
            List list = (List)nextNodeId;
            for (Object o : list) {
                String nodeId;
                if (!BeanUtils.isNotEmpty(o) || result.contains(nextId) && !this.checkAnnular(nextId, o.toString()) || !pathMap.containsKey(nodeId = o.toString())) continue;
                this.nodeSort(pathMap, nodeId, result);
            }
        }
        return result;
    }

    private boolean isAfterNowNode(String nodeId, List<String> nodeList) {
        if (CUR_NODE_THREAD_LOCAL.get().equals(nodeId)) {
            return false;
        }
        for (String s : nodeList) {
            if (CUR_NODE_THREAD_LOCAL.get().equals(s)) {
                return false;
            }
            if (!nodeId.equals(s)) continue;
            return true;
        }
        return false;
    }
}

