/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.script;

import cn.hutool.core.util.BooleanUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.activiti.ext.model.BpmDelegateTaskImpl;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.IUserScript;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityConverter;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmDefUserManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.runtime.manager.MeetingRoomAppointmentManager;
import com.hotent.runtime.manager.MeetingRoomManager;
import com.hotent.runtime.model.MeetingRoom;
import com.hotent.runtime.model.MeetingRoomAppointment;
import com.hotent.runtime.params.InstFormAndBoVo;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.impl.model.Org;
import com.hotent.uc.api.impl.model.UserFacade;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IParamService;
import com.hotent.uc.api.service.IUserGroupService;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UserScript
implements IUserScript {
    @Resource
    IUserService userService;
    @Resource
    BpmDefUserManager bpmDefUserManager;
    @Resource
    MeetingRoomManager meetingroomManager;
    @Resource
    MeetingRoomAppointmentManager meetingRoomAppointmentManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    UCFeignService uCFeignService;
    @Resource
    IUserGroupService userGroupService;
    @Resource
    IParamService paramService;
    @Resource
    BpmIdentityConverter bpmIdentityConverter;
    @Resource
    IFlowManager iFlowService;

    private Set<BpmIdentity> convertUserList(List<IUser> list) {
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        for (IUser iUser : list) {
            if (!BeanUtils.isNotEmpty((Object)iUser) || iUser.getStatus() != 1) continue;
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setId(iUser.getUserId());
            bpmIdentity.setName(iUser.getFullname());
            bpmIdentity.setType("user");
            identitys.add((BpmIdentity)bpmIdentity);
        }
        return identitys;
    }

    public Set<BpmIdentity> getUser() {
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId("1234");
        bpmIdentity.setName("demoUser");
        set.add((BpmIdentity)bpmIdentity);
        bpmIdentity.setId("5678");
        bpmIdentity.setName("demoUser2");
        set.add((BpmIdentity)bpmIdentity);
        return set;
    }

    public void updateAppointMent(String hysId, BpmDelegateTaskImpl task, String meetingName, String hostessName, String appointBenTime, String appointEndTime, String status) {
        MeetingRoomAppointment meetingAppoint = null;
        String meetingId = (String)task.getVariable("instanceId_");
        try {
            if (status.equals("0")) {
                meetingAppoint = new MeetingRoomAppointment();
                meetingAppoint.setId(UniqueIdUtil.getSuid());
                meetingAppoint.setMeetingroomId(hysId);
                meetingAppoint.setMeetingId(meetingId);
                meetingAppoint.setMeetingName(meetingName);
                meetingAppoint.setHostessName(hostessName);
                meetingAppoint.setAppointmentBegTime(TimeUtil.convertString((String)appointBenTime));
                meetingAppoint.setAppointmentEndTime(TimeUtil.convertString((String)appointBenTime));
                meetingAppoint.setAppointmentStatus(0);
                this.meetingRoomAppointmentManager.create((Model)meetingAppoint);
            } else {
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("MEETING_ID_", (Object)meetingId, QueryOP.EQUAL);
                List list = this.meetingRoomAppointmentManager.query(queryFilter).getRows();
                meetingAppoint = (MeetingRoomAppointment)((Object)list.get(0));
                meetingAppoint.setMeetingroomId(hysId);
                meetingAppoint.setMeetingId(meetingId);
                meetingAppoint.setMeetingName(meetingName);
                meetingAppoint.setHostessName(hostessName);
                meetingAppoint.setAppointmentBegTime(TimeUtil.convertString((String)appointBenTime));
                meetingAppoint.setAppointmentEndTime(TimeUtil.convertString((String)appointBenTime));
                meetingAppoint.setAppointmentStatus(1);
                this.meetingRoomAppointmentManager.update((Model)meetingAppoint);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set<BpmIdentity> getPendingUsersByMeetingId(String id) {
        MeetingRoom meetingroom = (MeetingRoom)this.meetingroomManager.get((Serializable)((Object)id));
        String ids = meetingroom.getPendingUserId();
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet();
        List iUsers = this.userService.getUserByAccounts(ids);
        set = this.convertUserList(iUsers);
        return set;
    }

    public Set<BpmIdentity> getUsersByAccount(String ids) {
        Set<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        if (StringUtil.isEmpty((String)ids)) {
            return set;
        }
        List iUsers = this.userService.getUserByAccounts(ids);
        set = this.convertUserList(iUsers);
        return set;
    }

    public String getHasRightObjs(String objType) {
        List idsList = this.bpmDefUserManager.getAuthorizeIdsByUserMap(objType);
        return StringUtil.join((String[])idsList.toArray(new String[0]), (String)",");
    }

    public Set<BpmIdentity> getOrgById(String ids) {
        String[] idsArr;
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        if (StringUtil.isEmpty((String)ids)) {
            return set;
        }
        for (String id : idsArr = ids.split(",")) {
            ObjectNode org = this.uCFeignService.getOrgByIdOrCode(id);
            DefaultBpmIdentity identity = new DefaultBpmIdentity(org.get("id").asText(), org.get("name").asText(), "group");
            identity.setGroupType("org");
            identity.setExtractType(ExtractType.EXACT_NOEXACT);
            set.add((BpmIdentity)identity);
        }
        return set;
    }

    public Set<BpmIdentity> getUserById(String mainKey) {
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        if (BeanUtils.isNotEmpty((Object)mainKey)) {
            String[] idsArr;
            for (String userId : idsArr = mainKey.split(",")) {
                UserFacade user = (UserFacade)this.userService.getUserById(userId);
                if (!BeanUtils.isNotEmpty((Object)user) || user.getStatus() != 1) continue;
                DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
                bpmIdentity.setType("user");
                bpmIdentity.setId(user.getId());
                bpmIdentity.setName(user.getFullname());
                set.add((BpmIdentity)bpmIdentity);
            }
        }
        return set;
    }

    public Set<BpmIdentity> getLeanderByOrgId(String orgId, String alias) {
        if (StringUtil.isEmpty((String)orgId) || StringUtil.isEmpty((String)alias)) {
            return new LinkedHashSet<BpmIdentity>();
        }
        IGroup group = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.ORG.key(), orgId);
        if (BeanUtils.isEmpty((Object)group) || !(group instanceof Org)) {
            return new LinkedHashSet<BpmIdentity>();
        }
        String value = this.paramService.getParamByGroup(group.getGroupId(), alias) + "";
        ArrayList<IUser> list = new ArrayList<IUser>();
        IUser iUser = this.userService.getUserById(value);
        list.add(iUser);
        List listIdentity = this.bpmIdentityConverter.convertUserList(list);
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>(listIdentity);
        return set;
    }

    public Set<BpmIdentity> getUpLeanderByOrgId(String orgId, String alias) {
        if (StringUtil.isEmpty((String)orgId) || StringUtil.isEmpty((String)alias)) {
            return new LinkedHashSet<BpmIdentity>();
        }
        IGroup group = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.ORG.key(), orgId);
        if (BeanUtils.isEmpty((Object)group) || !(group instanceof Org)) {
            return new LinkedHashSet<BpmIdentity>();
        }
        Org org = (Org)group;
        IGroup upGroup = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.ORG.key(), org.getParentId());
        if (BeanUtils.isEmpty((Object)upGroup) || !(upGroup instanceof Org)) {
            return new LinkedHashSet<BpmIdentity>();
        }
        String value = this.paramService.getParamByGroup(upGroup.getGroupId(), alias) + "";
        ArrayList<IUser> list = new ArrayList<IUser>();
        IUser iUser = this.userService.getUserById(value);
        list.add(iUser);
        List listIdentity = this.bpmIdentityConverter.convertUserList(list);
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>(listIdentity);
        return set;
    }

    public Set<BpmIdentity> getMainByOrgId(String orgId) {
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        if (StringUtil.isEmpty((String)orgId)) {
            return set;
        }
        String[] aryOrgIds = orgId.split(",");
        ArrayList<String> userIds = new ArrayList<String>();
        for (String tmp : aryOrgIds) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("org.ID_", (Object)tmp, QueryOP.EQUAL);
            List list = this.uCFeignService.queryOrgUserRel(queryFilter);
            if (!BeanUtils.isNotEmpty((Object)list)) continue;
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                if (!map.get("isMaster").toString().equals("1") || !map.get("orgId").toString().equals(tmp)) continue;
                userIds.add(map.get("userId").toString());
            }
        }
        ArrayNode userByIds = this.uCFeignService.getUserByIdsOrAccounts(StringUtil.join(userIds, (String)","));
        if (BeanUtils.isEmpty((Object)userByIds)) {
            return set;
        }
        for (JsonNode jsonNode : userByIds) {
            DefaultBpmIdentity identity = new DefaultBpmIdentity();
            identity.setId(jsonNode.get("id").asText());
            identity.setName(jsonNode.get("fullname").asText());
            identity.setType("user");
            set.add((BpmIdentity)identity);
        }
        return set;
    }

    public Set<BpmIdentity> getLeanderByPreNode(String alias, String demId) {
        if (StringUtil.isEmpty((String)alias)) {
            return new LinkedHashSet<BpmIdentity>();
        }
        ObjectNode orgNode = this.uCFeignService.getMainGroup(ContextUtil.getCurrentUser().getUserId(), demId);
        if (BeanUtils.isEmpty((Object)orgNode)) {
            return new LinkedHashSet<BpmIdentity>();
        }
        String value = this.paramService.getParamByGroup(orgNode.get("id").asText(), alias) + "";
        ArrayList<IUser> list = new ArrayList<IUser>();
        IUser iUser = this.userService.getUserById(value);
        list.add(iUser);
        Set<BpmIdentity> set = this.convertUserList(list);
        return set;
    }

    public Set<BpmIdentity> getRoleByAlias(String alias) {
        String[] aryAlias;
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        if (StringUtil.isEmpty((String)alias)) {
            return set;
        }
        for (String tmp : aryAlias = alias.split(",")) {
            IGroup group = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.ROLE.key(), tmp);
            DefaultBpmIdentity identity = new DefaultBpmIdentity(group);
            identity.setType("group");
            identity.setExtractType(ExtractType.EXACT_NOEXACT);
            identity.setGroupType(GroupTypeConstant.ROLE.key());
            set.add((BpmIdentity)identity);
        }
        return set;
    }

    public Set<BpmIdentity> getByPostAlias(String alias) {
        String[] aryAlias;
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        if (StringUtil.isEmpty((String)alias)) {
            return set;
        }
        for (String tmp : aryAlias = alias.split(",")) {
            IGroup group = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.POSITION.key(), tmp);
            DefaultBpmIdentity identity = new DefaultBpmIdentity(group.getGroupId(), group.getName(), "group");
            identity.setType("group");
            identity.setExtractType(ExtractType.EXACT_NOEXACT);
            identity.setGroupType(GroupTypeConstant.POSITION.key());
            set.add((BpmIdentity)identity);
        }
        return set;
    }

    public Set<BpmIdentity> getUserFromSubData(String boDefAlias, String subTableName, String subAccountField, String subNameFiled) throws Exception {
        return this.getUserFromSubData(boDefAlias, subTableName, subAccountField);
    }

    public Set<BpmIdentity> getUserFromSubData(String boDefAlias, String subTableName, String subAccountField) throws Exception {
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isEmpty((Object)cmd.getBusData())) {
            InstFormAndBoVo instFormAndBoVo = this.iFlowService.getInstFormAndBO(cmd.getVariables().get("instanceId_").toString(), "", null, FormType.PC, true, true, false);
            jsonObject = instFormAndBoVo.getData();
        } else {
            jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)cmd.getBusData());
        }
        if (BeanUtils.isNotEmpty((Object)jsonObject) && BeanUtils.isNotEmpty((Object)jsonObject.get(boDefAlias).get(subTableName)) && jsonObject.get(boDefAlias).get(subTableName).size() > 0) {
            HashSet<String> userAccounts = new HashSet<String>();
            for (int i = 0; i < jsonObject.get(boDefAlias).get(subTableName).size(); ++i) {
                if (!BeanUtils.isNotEmpty((Object)jsonObject.get(boDefAlias).get(subTableName).get(i).get(subAccountField))) continue;
                userAccounts.add(jsonObject.get(boDefAlias).get(subTableName).get(i).get(subAccountField).asText());
            }
            if (BeanUtils.isNotEmpty(userAccounts)) {
                ArrayNode iUsers = this.uCFeignService.getUserByIdsOrAccounts(StringUtil.join(userAccounts));
                Assert.notNull((Object)iUsers, (String)String.format("\u6839\u636e\u5b50\u8868\u6240\u4f20\u8d26\u53f7\u3010%s\u3011\u672a\u67e5\u627e\u5230\u7528\u6237", StringUtil.join(userAccounts)));
                for (JsonNode userNode : iUsers) {
                    DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
                    bpmIdentity.setId(userNode.get("id").asText());
                    bpmIdentity.setName(userNode.get("fullname").asText());
                    bpmIdentity.setType("user");
                    set.add((BpmIdentity)bpmIdentity);
                }
            }
        }
        return set;
    }

    public Set<BpmIdentity> getUserFromSubDataGroupUser(String boDefAlias, String subTableName, String subAccountField, String subGroupField) throws Exception {
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isEmpty((Object)cmd.getBusData())) {
            InstFormAndBoVo instFormAndBoVo = this.iFlowService.getInstFormAndBO(cmd.getVariables().get("instanceId_").toString(), "", null, FormType.PC, true, true, false);
            jsonObject = instFormAndBoVo.getData();
        } else {
            jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)cmd.getBusData());
        }
        if (BeanUtils.isNotEmpty((Object)jsonObject) && BeanUtils.isNotEmpty((Object)jsonObject.get(boDefAlias).get(subTableName)) && jsonObject.get(boDefAlias).get(subTableName).size() > 0) {
            HashMap groupMap = new HashMap();
            for (int i = 0; i < jsonObject.get(boDefAlias).get(subTableName).size(); ++i) {
                Set<String> userAccounts = new HashSet();
                if (BeanUtils.isNotEmpty((Object)jsonObject.get(boDefAlias).get(subTableName).get(i).get(subGroupField))) {
                    String key = jsonObject.get(boDefAlias).get(subTableName).get(i).get(subGroupField).asText();
                    if (groupMap.containsKey(key)) {
                        userAccounts = (Set)groupMap.get(key);
                    } else {
                        groupMap.put(key, userAccounts);
                    }
                } else {
                    throw new BaseException("\u5b50\u8868\u5206\u7ec4\u5b57\u6bb5\u5fc5\u586b");
                }
                if (!BeanUtils.isNotEmpty((Object)jsonObject.get(boDefAlias).get(subTableName).get(i).get(subAccountField))) continue;
                userAccounts.add(jsonObject.get(boDefAlias).get(subTableName).get(i).get(subAccountField).asText());
            }
            if (BeanUtils.isNotEmpty(groupMap)) {
                Set keySet = groupMap.keySet();
                for (String key : keySet) {
                    ArrayNode iUsers = this.uCFeignService.getUserByIdsOrAccounts(StringUtil.join((Collection)((Collection)groupMap.get(key))));
                    Assert.notNull((Object)iUsers, (String)String.format("\u6839\u636e\u5b50\u8868\u6240\u4f20\u8d26\u53f7\u3010%s\u3011\u672a\u67e5\u627e\u5230\u7528\u6237", StringUtil.join((Collection)((Collection)groupMap.get(key)))));
                    HashSet<String> ids = new HashSet<String>();
                    HashSet<String> names = new HashSet<String>();
                    for (JsonNode userNode : iUsers) {
                        ids.add(userNode.get("id").asText());
                        names.add(userNode.get("fullname").asText());
                    }
                    DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
                    bpmIdentity.setId(StringUtil.join(ids));
                    bpmIdentity.setName(StringUtil.join(names));
                    bpmIdentity.setType("groupUser");
                    set.add((BpmIdentity)bpmIdentity);
                }
            }
        }
        return set;
    }

    public Set<BpmIdentity> getByCompanyRole(String company, String role) {
        List list = this.uCFeignService.getByCompanyRole(company, role);
        Set<BpmIdentity> set = this.getBpmIdentities(list);
        return set;
    }

    private Set<BpmIdentity> getBpmIdentities(List<ObjectNode> list) {
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        if (BeanUtils.isEmpty(list)) {
            return set;
        }
        list.forEach(item -> {
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setType("user");
            bpmIdentity.setName(item.get("fullname").asText());
            bpmIdentity.setId(item.get("id").asText());
            bpmIdentity.setCode(item.get("account").asText());
            set.add((BpmIdentity)bpmIdentity);
        });
        return set;
    }

    public Set<BpmIdentity> getLeaderStep(Object gradeParam, Object resParam) {
        Integer grade = Integer.parseInt(String.valueOf(gradeParam));
        Boolean res = BooleanUtil.toBooleanObject((String)String.valueOf(resParam));
        List list = this.uCFeignService.getLeaderStep(ContextUtil.getCurrentUserId(), grade, res.booleanValue());
        Set<BpmIdentity> set = this.getBpmIdentities(list);
        return set;
    }

    public Set<BpmIdentity> getFgUsers(String orgId, String orgParam, String userParam) {
        List list = this.uCFeignService.getFgUsers(orgId, orgParam, userParam);
        Set<BpmIdentity> set = new HashSet<BpmIdentity>();
        if (BeanUtils.isNotEmpty((Object)list)) {
            set = this.getBpmIdentities(list);
        }
        return set;
    }

    public Set<BpmIdentity> getLeaderStepByOrgId(String orgId, Object gradeParam) {
        Integer grade = Integer.parseInt(String.valueOf(gradeParam));
        List list = this.uCFeignService.getLeaderStepByOrgId(orgId, grade);
        Set<BpmIdentity> set = this.getBpmIdentities(list);
        return set;
    }
}

