/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.service.impl;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.persistence.manager.BpmCustomSignDataManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmReadRecordManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmCustomSignData;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.runtime.params.CustomSignRevokeParam;
import com.hotent.runtime.service.RevokeService;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParallelRevokeService
implements RevokeService {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;
    @Resource
    BpmReadRecordManager bpmReadRecordManager;

    @Override
    public void canRevoke(Map<String, Object> map, List<DefaultBpmCheckOpinion> list, String isReadRevoke) {
        String taskId = MapUtil.getString(map, (String)"taskId");
        if (StringUtil.isEmpty((String)taskId)) {
            return;
        }
        List parallelAllSonByTaskId = this.bpmCustomSignDataManager.getParallelAllSonByTaskId(taskId);
        if (parallelAllSonByTaskId == null) {
            return;
        }
        if (BeanUtils.isNotEmpty((Object)parallelAllSonByTaskId)) {
            ArrayList<String> signDataStatusList = new ArrayList<String>();
            signDataStatusList.add("approval");
            signDataStatusList.add("withdrawApproval");
            if (this.hasSignDataWithStatus(parallelAllSonByTaskId, signDataStatusList).booleanValue()) {
                map.put("revoke", true);
                map.put("needGetRevokeTasks", true);
            }
        } else {
            List<DefaultBpmCheckOpinion> afterSignOpinions = this.getOpinionBySignType(list, "AfterSign");
            if (afterSignOpinions.size() > 0) {
                ArrayList<String> opinionStatusList = new ArrayList<String>();
                opinionStatusList.add(OpinionStatus.AWAITING_CHECK.getKey());
                opinionStatusList.add(OpinionStatus.REJECT.getKey());
                opinionStatusList.add(OpinionStatus.SIGN_RECOVER_CANCEL.getKey());
                opinionStatusList.add(OpinionStatus.RETRACTED.getKey());
                opinionStatusList.add(OpinionStatus.REVOKER.getKey());
                if (this.hasOpinionWithStatus(afterSignOpinions, opinionStatusList).booleanValue()) {
                    DefaultBpmCheckOpinion toTaskOpinion;
                    List tasks;
                    String toTaskId = this.bpmExeStackManager.getToTaskIdByFromTaskId(taskId);
                    if (toTaskId == null && BeanUtils.isNotEmpty((Object)(tasks = this.bpmTaskManager.getByInstId(afterSignOpinions.get(0).getProcInstId())))) {
                        List withDrawApproval;
                        DefaultBpmTask bpmTask = (DefaultBpmTask)tasks.get(0);
                        String fromNodeId = this.bpmExeStackManager.getCurrentTaskFromNodeId(bpmTask.getId());
                        if (StringUtil.isNotEmpty((String)fromNodeId) && fromNodeId.equals(String.valueOf(map.get("taskKey")))) {
                            toTaskId = ((DefaultBpmTask)tasks.get(0)).getId();
                        }
                        if (toTaskId == null && BeanUtils.isNotEmpty((Object)(withDrawApproval = this.bpmCustomSignDataManager.getByInstIdAndStatus(bpmTask.getProcInstId(), Arrays.asList("withdrawApproval"))))) {
                            map.put("revoke", true);
                            return;
                        }
                    }
                    if ((toTaskOpinion = this.getOpinionByTaskId(afterSignOpinions, toTaskId)) != null) {
                        ArrayList<DefaultBpmCheckOpinion> toTaskOpinionList = new ArrayList<DefaultBpmCheckOpinion>();
                        toTaskOpinionList.add(toTaskOpinion);
                        if (this.hasOpinionWithStatus(toTaskOpinionList, opinionStatusList).booleanValue()) {
                            this.setRevoke(map, toTaskId, isReadRevoke, this.bpmReadRecordManager);
                        }
                    }
                }
            } else {
                map.put("revoke", true);
            }
        }
    }

    private Boolean hasSignDataWithStatus(List<BpmCustomSignData> list, List<String> signDataStatusList) {
        Boolean result = false;
        if (BeanUtils.isEmpty(list) || BeanUtils.isEmpty(signDataStatusList)) {
            return result;
        }
        for (BpmCustomSignData signData : list) {
            if (!signDataStatusList.contains(signData.getStatus())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void doRevoke(CustomSignRevokeParam revokeParamObject) throws Exception {
        List tasks = this.bpmTaskManager.getByInstId(revokeParamObject.getInstanceId());
        if (BeanUtils.isEmpty((Object)tasks)) {
            throw new BaseException("\u5df2\u6ca1\u6709\u4efb\u52a1\u53ef\u4ee5\u64a4\u56de");
        }
        DefaultBpmTask runningBpmTask = (DefaultBpmTask)tasks.get(0);
        List anSignDatas = this.bpmCustomSignDataManager.getParallelAllSonByTaskId(revokeParamObject.getTargetTaskId());
        boolean sameNodeId = revokeParamObject.getTargetNodeId().equals(runningBpmTask.getNodeId());
        if (BeanUtils.isEmpty((Object)anSignDatas)) {
            if (sameNodeId) {
                this.bpmTaskManager.addCustomSignTask(runningBpmTask.getId(), new String[]{ContextUtil.getCurrentUserId()}, false);
                String newCreateTaskId = this.getNewCreateTaskId();
                this.bpmCustomSignDataManager.updateStatusByTaskId(revokeParamObject.getTargetTaskId(), "complete", "withdrawApproval", newCreateTaskId);
                BpmCheckOpinionUtil.updateCheckRevoker((String)revokeParamObject.getTargetTaskId());
            } else {
                this.bpmTaskManager.taskAnRevoke(revokeParamObject.getInstanceId(), runningBpmTask.getId(), revokeParamObject.getTargetNodeId(), revokeParamObject.getTargetTaskId());
            }
        } else if (sameNodeId) {
            this.bpmTaskManager.parallelRevoke(revokeParamObject.getCurrentTaskIds(), revokeParamObject.getTargetTaskId());
        }
    }
}

