/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.service.impl;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.persistence.manager.BpmCustomSignDataManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmReadRecordManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmCustomSignData;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.runtime.params.CustomSignRevokeParam;
import com.hotent.runtime.service.RevokeService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SequentialRevokeService
implements RevokeService {
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;
    @Resource
    BpmReadRecordManager bpmReadRecordManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    public void canRevoke(Map<String, Object> map, List<DefaultBpmCheckOpinion> list, String isReadRevoke) {
        String taskId = MapUtil.getString(map, (String)"taskId");
        if (StringUtil.isEmpty((String)taskId)) {
            return;
        }
        BpmCustomSignData bpmCustomSignData = this.bpmCustomSignDataManager.getSequentialSonByTaskId(taskId);
        if (bpmCustomSignData != null) {
            String status = bpmCustomSignData.getStatus();
            if ("approval".equals(status)) {
                this.setRevoke(map, bpmCustomSignData.getTaskId(), isReadRevoke, this.bpmReadRecordManager);
            }
        } else {
            List<DefaultBpmCheckOpinion> afterSignOpinions = this.getOpinionBySignType(list, "AfterSign");
            if (afterSignOpinions.size() > 0) {
                String toTaskId;
                DefaultBpmCheckOpinion toTaskOpinion;
                ArrayList<String> opinionStatusList = new ArrayList<String>();
                opinionStatusList.add(OpinionStatus.AWAITING_CHECK.getKey());
                opinionStatusList.add(OpinionStatus.REJECT.getKey());
                opinionStatusList.add(OpinionStatus.REVOKER.getKey());
                if (this.hasOpinionWithStatus(afterSignOpinions, opinionStatusList).booleanValue() && (toTaskOpinion = this.getOpinionByTaskId(afterSignOpinions, toTaskId = this.bpmExeStackManager.getToTaskIdByFromTaskId(taskId))) != null) {
                    ArrayList<DefaultBpmCheckOpinion> toTaskOpinionList = new ArrayList<DefaultBpmCheckOpinion>();
                    toTaskOpinionList.add(toTaskOpinion);
                    if (this.hasOpinionWithStatus(toTaskOpinionList, opinionStatusList).booleanValue()) {
                        this.setRevoke(map, toTaskId, isReadRevoke, this.bpmReadRecordManager);
                    }
                }
            }
        }
    }

    @Override
    public void doRevoke(CustomSignRevokeParam revokeParamObject) throws Exception {
        String targetNodeId = revokeParamObject.getTargetNodeId();
        List tasks = this.bpmTaskManager.getByInstId(revokeParamObject.getInstanceId());
        if (BeanUtils.isEmpty((Object)tasks)) {
            throw new BaseException("\u5df2\u6ca1\u6709\u4efb\u52a1\u53ef\u4ee5\u64a4\u56de");
        }
        DefaultBpmTask currentTask = (DefaultBpmTask)tasks.get(0);
        if (targetNodeId.equals(currentTask.getNodeId())) {
            this.bpmTaskManager.sequentialTaskRevoke(currentTask.getId(), revokeParamObject.getTargetTaskId());
        } else {
            this.bpmTaskManager.taskAnRevoke(revokeParamObject.getInstanceId(), currentTask.getId(), targetNodeId, revokeParamObject.getTargetTaskId());
        }
    }
}

