/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmFormService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.api.service.BpmTaskService;
import com.hotent.bpm.defxml.entity.ext.DecideType;
import com.hotent.bpm.engine.form.BpmFormFactory;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefActManager;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefUserManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmInstFormManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmServiceLogManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmDefAct;
import com.hotent.bpm.persistence.model.BpmDefUser;
import com.hotent.bpm.persistence.model.BpmLeaderTask;
import com.hotent.bpm.persistence.model.BpmServiceLog;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.runtime.params.AssignParamObject;
import com.hotent.runtime.params.DoNextParamObject;
import com.hotent.runtime.params.TaskDetailVo;
import com.hotent.runtime.service.TaskService;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImp
implements TaskService {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BaseContext baseContext;
    @Resource
    IFlowManager iFlowService;
    @Resource
    BpmDefUserManager bpmDefUserManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmDefActManager bpmDefActManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmInstFormManager bpmInstFormManager;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmServiceLogManager bpmServiceLogManager;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;

    @Override
    public PageList<DefaultBpmTask> getLeaderTodoList(QueryFilter queryFilter) throws Exception {
        this.handleTodoQueryFilter((QueryFilter<DefaultBpmTask>)queryFilter);
        PageList<DefaultBpmTask> pageList = this.iFlowService.getLeaderTodoList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @Override
    public Map<String, BpmLeaderTask> getLeaderTodoCard(QueryFilter queryFilter, Integer size) throws Exception {
        this.handleTodoQueryFilter((QueryFilter<DefaultBpmTask>)queryFilter);
        return this.iFlowService.getLeaderTodoCard(this.baseContext.getCurrentUserAccout(), queryFilter, size);
    }

    @Override
    public PageList<DefaultBpmTask> getTodoList(QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        this.handleTodoQueryFilter(queryFilter);
        PageList<DefaultBpmTask> pageList = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), queryFilter).get();
        return pageList;
    }

    private void handleTodoQueryFilter(QueryFilter<DefaultBpmTask> queryFilter) {
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            ArrayList<QueryField> fields = new ArrayList<QueryField>();
            for (QueryField field : queryFilter.getQuerys()) {
                if ("urgentStateValue".equals(field.getProperty())) {
                    field.setGroup("groupUrgent");
                    field.setRelation(FieldRelation.AND);
                    QueryFilter defFilter = QueryFilter.build();
                    defFilter.addFilter("IS_MAIN_", (Object)"Y", QueryOP.EQUAL);
                    defFilter.addFilter("SHOW_URGENT_STATE_", (Object)"1", QueryOP.EQUAL);
                    PageList query = this.bpmDefinitionManager.query(defFilter);
                    ArrayList<String> defKeys = new ArrayList<String>();
                    defKeys.add("-1");
                    if (BeanUtils.isNotEmpty((Object)query.getRows())) {
                        for (DefaultBpmDefinition def : query.getRows()) {
                            defKeys.add(def.getDefKey());
                        }
                    }
                    fields.add(new QueryField("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent"));
                    continue;
                }
                fields.add(field);
            }
            queryFilter.setQuerys(fields);
        }
        queryFilter.setGroupRelation(FieldRelation.AND);
    }

    @Override
    public PageList<DefaultBpmTask> listJson(QueryFilter queryFilter) throws Exception {
        Map actRightMap;
        IUser user = ContextUtil.getCurrentUser();
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin && !this.setNoAuthFilter(queryFilter)) {
            return new PageList((IPage)new Page());
        }
        queryFilter.addFilter("task.status_", (Object)"COPYTO", QueryOP.NOT_EQUAL, FieldRelation.AND);
        queryFilter.addFilter("task.status_", (Object)"COMMU", QueryOP.NOT_EQUAL, FieldRelation.AND);
        PageList query = this.bpmTaskManager.query(queryFilter);
        if (BeanUtils.isEmpty((Object)query) || BeanUtils.isEmpty((Object)query.getRows())) {
            return query;
        }
        if (!user.isAdmin() && (actRightMap = this.bpmDefAuthorizeManager.getActRightByUserId(user.getUserId(), "management", true, true)).containsKey("authorizeRightMap")) {
            Map authorizeRightMap = (Map)actRightMap.get("authorizeRightMap");
            for (DefaultBpmTask task : query.getRows()) {
                ObjectNode authorRight;
                if (authorizeRightMap.containsKey(task.getProcDefKey()) && BeanUtils.isNotEmpty((Object)(authorRight = (ObjectNode)authorizeRightMap.get(task.getProcDefKey()))) && JsonUtil.getBoolean((ObjectNode)authorRight, (String)"m_edit")) continue;
                task.setCanJumpInstance(Boolean.valueOf(false));
            }
        }
        HashMap cMap = new HashMap();
        for (DefaultBpmTask task : query.getRows()) {
            if (!StringUtil.isEmpty((String)task.getAssigneeName())) continue;
            cMap.put(task.getTaskId(), new ArrayList());
        }
        Set keySet = cMap.keySet();
        if (BeanUtils.isNotEmpty(keySet)) {
            QueryFilter cQueryFilter = QueryFilter.build();
            cQueryFilter.addFilter("task_id_", (Object)StringUtil.join(keySet, (String)","), QueryOP.IN);
            BpmTaskCandidateManager candidateManager = (BpmTaskCandidateManager)AppUtil.getBean(BpmTaskCandidateManager.class);
            PageList candidateQuery = candidateManager.query(cQueryFilter);
            if (BeanUtils.isEmpty((Object)candidateQuery) || BeanUtils.isEmpty((Object)candidateQuery.getRows())) {
                return query;
            }
            for (DefaultBpmTaskCandidate candidate : candidateQuery.getRows()) {
                ((List)cMap.get(candidate.getTaskId())).add(candidate);
            }
            for (DefaultBpmTask task : query.getRows()) {
                if (!cMap.containsKey(task.getTaskId()) || !BeanUtils.isNotEmpty(cMap.get(task.getTaskId()))) continue;
                List list = (List)cMap.get(task.getTaskId());
                ArrayList<DefaultBpmIdentity> identityList = new ArrayList<DefaultBpmIdentity>();
                for (DefaultBpmTaskCandidate candidate : list) {
                    identityList.add(new DefaultBpmIdentity(candidate.getExecutor(), "", candidate.getType()));
                }
                task.setIdentityList(identityList);
            }
        }
        return query;
    }

    @Override
    public ArrayNode getCandidatesListByTaskId(String taskId) throws Exception {
        BpmTaskService bpmTaskService = (BpmTaskService)AppUtil.getBean(BpmTaskService.class);
        List bpmIdentities = bpmTaskService.getTaskCandidates(taskId);
        ArrayNode bpmIdentitiesArray = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isEmpty((Object)bpmIdentities)) {
            return bpmIdentitiesArray;
        }
        BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
        for (BpmIdentity identity : bpmIdentities) {
            ObjectNode identityObj = (ObjectNode)JsonUtil.toJsonNode((Object)((DefaultBpmIdentity)identity));
            bpmIdentitiesArray.add((JsonNode)identityObj);
            if ("user".equals(identity.getType())) continue;
            ArrayList<BpmIdentity> tempList = new ArrayList<BpmIdentity>();
            tempList.add(identity);
            List extractUser = bpmIdentityExtractService.extractUser(tempList);
            if (!BeanUtils.isNotEmpty((Object)extractUser)) continue;
            ArrayList<String> userNames = new ArrayList<String>();
            ArrayList<String> userIds = new ArrayList<String>();
            for (IUser iUser : extractUser) {
                userNames.add(iUser.getFullname());
                userIds.add(iUser.getUserId());
            }
            identityObj.put("userNames", StringUtil.join(userNames, (String)","));
            identityObj.put("userIds", StringUtil.join(userIds, (String)","));
        }
        return bpmIdentitiesArray;
    }

    @Override
    public CommonResult<HashMap<String, Object>> batchHandle(Map<String, Object> requestMap) throws Exception {
        String taskIds = (String)requestMap.get("taskIds");
        String action = (String)requestMap.get("action");
        String opinion = (String)requestMap.get("opinion");
        Map vars = (Map)requestMap.get("vars");
        String[] listIds = taskIds.split(",");
        String account = ContextUtil.getCurrentUser().getAccount();
        ArrayList<DefaultBpmTask> unHandleList = new ArrayList<DefaultBpmTask>();
        ArrayList<DefaultBpmTask> completeList = new ArrayList<DefaultBpmTask>();
        ArrayList unAuthList = new ArrayList();
        ArrayList<DefaultBpmTask> failedList = new ArrayList<DefaultBpmTask>();
        HashMap<String, String> failedMsgMap = new HashMap<String, String>();
        for (String taskId : listIds) {
            BpmNodeDef curNodeProperties = this.iFlowService.getCurNodeProperties(taskId, "", "");
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
            BpmProcessInstance processInstance = this.bpmInstService.getProcessInstance(defaultBpmTask.getProcInstId());
            NodeProperties properties = curNodeProperties.getLocalProperties();
            if (BeanUtils.isNotEmpty((Object)curNodeProperties.getNodeProperties())) {
                properties = (NodeProperties)curNodeProperties.getNodeProperties().get(0);
            }
            if (!properties.isBatchHandleRevoke()) {
                unHandleList.add(defaultBpmTask);
                continue;
            }
            String procInstId = defaultBpmTask.getProcInstId();
            String formCategory = this.bpmInstFormManager.getInstFormCategory(defaultBpmTask.getProcInstId(), defaultBpmTask.getNodeId());
            DoNextParamObject doNextParamObject = new DoNextParamObject();
            doNextParamObject.setVars(vars);
            doNextParamObject.setAccount(account);
            doNextParamObject.setTaskId(taskId);
            doNextParamObject.setOpinion(opinion);
            doNextParamObject.setActionName(action);
            doNextParamObject.setAgentLeaderId("0");
            doNextParamObject.setJumpType(properties.getJumpType());
            if (action.equals(DecideType.AGREE.value())) {
                BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)FormType.PC);
                FormModel formModel = bpmFormService.getByDefId(defaultBpmTask.getProcDefId(), defaultBpmTask.getTaskId(), processInstance, true);
                if (BeanUtils.isNotEmpty((Object)formModel)) {
                    doNextParamObject.setFormKey(formModel.getFormKey());
                }
            } else {
                doNextParamObject.setBackHandMode((String)requestMap.get("backHandMode"));
            }
            doNextParamObject.setNodeUsers("[]");
            doNextParamObject.setDestination("");
            doNextParamObject.setFormType(formCategory);
            doNextParamObject.setFiles("");
            doNextParamObject.setZfiles("");
            if (StringUtil.isNotEmpty((String)properties.getOpinionField())) {
                String boData = this.handleSetOpinionText(properties.getOpinionField(), defaultBpmTask, opinion, properties.isAppendOpinion());
                doNextParamObject.setData(Base64.getBase64((String)boData));
            }
            try {
                CommonResult<String> result = this.iFlowService.complete(doNextParamObject).get();
                if (result.getState().booleanValue()) {
                    completeList.add(defaultBpmTask);
                    continue;
                }
                failedList.add(defaultBpmTask);
                failedMsgMap.put(defaultBpmTask.getTaskId(), result.getMessage());
            }
            catch (Exception e) {
                failedList.add(defaultBpmTask);
                failedMsgMap.put(defaultBpmTask.getTaskId(), e.getMessage());
            }
        }
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        result.put("notAuth", unAuthList);
        result.put("complete", completeList);
        result.put("unHandleList", unHandleList);
        result.put("failedList", failedList);
        result.put("failedMsg", failedMsgMap);
        return new CommonResult(true, "\u5904\u7406\u5b8c\u6210", result);
    }

    private String handleSetOpinionText(String opinionField, DefaultBpmTask bpmTask, String opinion, boolean appendOpinion) throws Exception {
        String opinionVal;
        String[] split = opinionField.split("\\.");
        if (split.length != 2) {
            throw new BaseException("\u610f\u89c1\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef");
        }
        BoDataService bean = (BoDataService)AppUtil.getBean(BoDataService.class);
        DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)bpmTask.getProcInstId()));
        List dataByInst = bean.getDataByInst((BpmProcessInstance)inst);
        ObjectNode boData = (ObjectNode)BoDataUtil.hanlerData((List)dataByInst);
        String boDefAlias = split[0];
        String field = split[1];
        ObjectNode mainData = (ObjectNode)boData.get(boDefAlias);
        String userName = ContextUtil.getCurrentUser().getFullname();
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String tail = String.format("\u5ba1\u6838\u4eba\uff1a%s  \u5ba1\u6838\u65e5\u671f\uff1a%s", userName, now);
        if (appendOpinion) {
            opinionVal = String.format("\u5ba1\u6838\u610f\u89c1\uff1a %s %s\n", opinion, tail);
        } else {
            String preVal = "";
            String oldVal = JsonUtil.getString((JsonNode)mainData, (String)field, (String)"");
            if (StringUtil.isNotEmpty((String)oldVal) && !"<p><br/></p>".equals(oldVal.trim())) {
                preVal = oldVal;
            }
            opinionVal = StringUtil.isNotEmpty((String)preVal) && !preVal.contains("\n") ? String.format("\u5ba1\u6838\u610f\u89c1\uff1a %s %s %s\n", preVal, opinion, tail) : String.format("%s\u5ba1\u6838\u610f\u89c1\uff1a %s %s\n", preVal, opinion, tail);
        }
        mainData.put(field, opinionVal);
        return JsonUtil.toJson((Object)boData);
    }

    @Override
    public CommonResult<DefaultBpmTask> nextTask(String defId, String defKey, Boolean mobile) throws Exception {
        if (StringUtil.isEmpty((String)defKey)) {
            DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)defId));
            if (BeanUtils.isEmpty((Object)defaultBpmDefinition)) {
                throw new BaseException("\u4e0b\u4e00\u4e2a\u4efb\u52a1\u83b7\u53d6\u5931\u8d25\uff1a\u8282\u70b9\u4e3a\u7a7a");
            }
            defKey = defaultBpmDefinition.getDefKey();
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("bt.PROC_DEF_KEY_", (Object)defKey, QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.getSorter().add(new FieldSort("bt.PRIORITY_", Direction.ASC));
        if (mobile != null && mobile.booleanValue()) {
            queryFilter.addParams("isMobile", (Object)true);
        }
        PageBean bean = new PageBean(Integer.valueOf(1), Integer.valueOf(1));
        queryFilter.setPageBean(bean);
        PageList<DefaultBpmTask> byDefKey = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), (QueryFilter<DefaultBpmTask>)queryFilter).get();
        if (!byDefKey.getRows().isEmpty()) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", byDefKey.getRows().get(0));
        }
        return new CommonResult(true, "\u672a\u83b7\u53d6\u5230\u4efb\u4f55\u5f85\u529e", null);
    }

    @Override
    public CommonResult<String> delegate(AssignParamObject assignParamObject, HttpServletResponse response, Optional<String> leaderId, Optional<String> assignee) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)assignParamObject.getTaskId());
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)assignParamObject.getTaskId()));
        if (BeanUtils.isEmpty((Object)defaultBpmTask) || BpmUtil.isCompletedByTaskStatus((String)defaultBpmTask.getStatus())) {
            throw new BaseException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BaseActionCmd cmd = new BaseActionCmd();
        cmd.setFormKey(assignParamObject.getFormKey());
        ContextThreadUtil.setActionCmd((ActionCmd)cmd);
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            if (leaderId.get().equals(assignParamObject.getUserId())) {
                throw new RuntimeException("\u4ee3\u9886\u5bfc\u8f6c\u529e\u65f6\u4e0d\u80fd\u518d\u8f6c\u529e\u7ed9\u9886\u5bfc\uff01");
            }
        }
        if (StringUtil.isNotZeroEmpty((String)assignee.orElse(""))) {
            IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
            IUser user = userServiceImpl.getUserByAccount(assignee.get());
            ContextUtil.switchCurrentUser((IUser)user);
        }
        return this.iFlowService.delegate(assignParamObject);
    }

    @Override
    public Object nodeOpinion(Optional<String> defId, Optional<String> instId, String nodeId, boolean isDerive) throws Exception {
        String[] split;
        boolean notSimplifiedChinese;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (BeanUtils.isEmpty((Object)nodeId)) {
            return map;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String defKey = "";
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId.orElse("")));
        boolean bl = notSimplifiedChinese = !Locale.SIMPLIFIED_CHINESE.equals(locale);
        if (notSimplifiedChinese) {
            defKey = defaultBpmProcessInstance.getProcDefKey();
        }
        for (String id : split = nodeId.split(",")) {
            Map nodeOpinionMap;
            Object nodeOpinion = this.iFlowService.nodeOpinion(defId.orElse(""), defaultBpmProcessInstance, id, isDerive);
            if (notSimplifiedChinese && ((Boolean)(nodeOpinionMap = (Map)nodeOpinion).get("hasOpinion")).booleanValue()) {
                List data = (List)nodeOpinionMap.get("data");
                for (DefaultBpmCheckOpinion bpmTaskOpinion : data) {
                    String mes;
                    String taskKey = bpmTaskOpinion.getTaskKey();
                    String key = "flow." + defKey + "." + taskKey;
                    if (key.equals(mes = I18nUtil.getMessage((String)key, (Locale)locale))) continue;
                    bpmTaskOpinion.setTaskName(mes);
                }
            }
            if (split.length == 1) {
                return nodeOpinion;
            }
            map.put(id, nodeOpinion);
        }
        return map;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public Object nodeOpinionFromPreview(Optional<String> defId, Optional<String> instId, String nodeId, boolean isDerive) throws Exception {
        Object result = this.nodeOpinion(defId, instId, nodeId, isDerive);
        DefaultBpmProcessInstance defaultBpmProcessInstance = null;
        String defIdStr = defId.orElse("");
        if (instId.isPresent()) {
            defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId.orElse("")));
            if (BeanUtils.isEmpty((Object)defaultBpmProcessInstance)) {
                return result;
            }
            defIdStr = defaultBpmProcessInstance.getProcDefId();
        }
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defIdStr);
        List bpmnNodeDefs = bpmProcessDefExt.getBpmnNodeDefs();
        Set nodeIds = Arrays.stream(nodeId.split(",")).collect(Collectors.toSet());
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((Object)result);
        for (BpmNodeDef bpmnNodeDef : bpmnNodeDefs) {
            if (nodeIds.contains(bpmnNodeDef.getNodeId()) && bpmnNodeDef instanceof SignNodeDef) {
                SignNodeDef signNodeDef = (SignNodeDef)bpmnNodeDef;
                ObjectNode nodeOption = null;
                JsonNode nodeOptionList = null;
                if (nodeIds.size() == 1) {
                    nodeOption = jsonNode;
                    nodeOptionList = jsonNode.get("data");
                } else {
                    nodeOption = (ObjectNode)jsonNode.get(bpmnNodeDef.getNodeId());
                    if (nodeOption != null) {
                        nodeOptionList = nodeOption.get("data");
                    }
                }
                if (!BeanUtils.isNotEmpty((Object)nodeOptionList)) continue;
                HashMap map = new HashMap();
                ArrayList<DefaultBpmCheckOpinion> list = new ArrayList<DefaultBpmCheckOpinion>();
                if (nodeOptionList instanceof ArrayNode) {
                    Object parentTaskId;
                    Object node2;
                    boolean referOpinion = true;
                    boolean isNodeHandle = false;
                    for (Object node2 : nodeOptionList) {
                        String status = JsonUtil.getString((JsonNode)node2, (String)"status");
                        if (!"awaiting_check".equals(status)) continue;
                        isNodeHandle = true;
                        break;
                    }
                    if (isNodeHandle && bpmnNodeDef.getLocalProperties() != null) {
                        referOpinion = bpmnNodeDef.getLocalProperties().isReferOpinion();
                    }
                    ArrayList<String> myOpinionIds = new ArrayList<String>();
                    node2 = nodeOptionList.iterator();
                    while (node2.hasNext()) {
                        JsonNode node3 = (JsonNode)node2.next();
                        DefaultBpmCheckOpinion checkOpinion = (DefaultBpmCheckOpinion)JsonUtil.toBean((JsonNode)node3, DefaultBpmCheckOpinion.class);
                        if (StringUtil.isNotEmpty((String)checkOpinion.getQualfieds())) {
                            ArrayNode qualfiedsObj = (ArrayNode)JsonUtil.toJsonNode((String)checkOpinion.getQualfieds());
                            for (JsonNode qualfied : qualfiedsObj) {
                                DefaultBpmIdentity identity = (DefaultBpmIdentity)JsonUtil.toBean((JsonNode)qualfied, DefaultBpmIdentity.class);
                                if (!StringUtil.isNotEmpty((String)ContextUtil.getCurrentUserId()) || !ContextUtil.getCurrentUserId().equals(identity.getId())) continue;
                                myOpinionIds.add(checkOpinion.getId());
                                break;
                            }
                        }
                        list.add(checkOpinion);
                    }
                    if (!referOpinion && CollUtil.isNotEmpty(myOpinionIds)) {
                        list.removeIf(option -> !myOpinionIds.contains(option.getId()));
                    }
                    HashMap<String, List<DefaultBpmCheckOpinion>> collect = new HashMap<String, List<DefaultBpmCheckOpinion>>();
                    Map<String, List<DefaultBpmCheckOpinion>> kv = list.stream().filter(r -> StringUtil.isNotEmpty((String)r.getTaskId()) && StringUtil.isNotEmpty((String)r.getParentTaskId())).collect(Collectors.groupingBy(DefaultBpmCheckOpinion::getTaskId));
                    for (DefaultBpmCheckOpinion item : list) {
                        parentTaskId = item.getParentTaskId();
                        if (StringUtil.isNotEmpty((String)parentTaskId) && kv.containsKey(parentTaskId)) {
                            DefaultBpmCheckOpinion parent = kv.get(parentTaskId).get(0);
                            while (StringUtil.isNotEmpty((String)parent.getParentTaskId()) && kv.containsKey(parent.getParentTaskId())) {
                                parent = kv.get(parent.getParentTaskId()).get(0);
                            }
                            parentTaskId = Optional.ofNullable(parent.getParentTaskId()).orElse(parent.getTaskId());
                        }
                        if (StringUtil.isEmpty((String)parentTaskId) && kv.containsKey(item.getTaskId())) {
                            parentTaskId = kv.get(item.getTaskId()).get(0).getParentTaskId();
                        }
                        if (!collect.containsKey(parentTaskId)) {
                            collect.put((String)parentTaskId, Lists.newArrayList());
                        }
                        ((List)collect.get(parentTaskId)).add(item);
                    }
                    if (!signNodeDef.isParallel()) {
                        Set taskIdSet = list.stream().filter(r -> r.getTaskId() != null).map(DefaultBpmCheckOpinion::getTaskId).collect(Collectors.toSet());
                        Set parentTaskIdSet = list.stream().filter(r -> r.getParentTaskId() != null && !taskIdSet.contains(r.getParentTaskId())).map(DefaultBpmCheckOpinion::getParentTaskId).collect(Collectors.toSet());
                        for (Map.Entry entry : collect.entrySet()) {
                            if (!parentTaskIdSet.contains(entry.getKey())) continue;
                            this.handleNext((List)entry.getValue(), (String)entry.getKey(), collect);
                        }
                        parentTaskId = taskIdSet.iterator();
                        while (parentTaskId.hasNext()) {
                            String taskId = (String)parentTaskId.next();
                            if (parentTaskIdSet.contains(taskId)) continue;
                            collect.remove(taskId);
                        }
                    }
                    for (Map.Entry entry : collect.entrySet()) {
                        List sort = ((List)entry.getValue()).stream().sorted((o1, o2) -> {
                            LocalDateTime o1time = Optional.ofNullable(o1.getCompleteTime()).orElse(o1.getCreateTime());
                            LocalDateTime o2time = Optional.ofNullable(o2.getCompleteTime()).orElse(o2.getCreateTime());
                            return o2time == null ? -1 : o2time.compareTo(o1time);
                        }).collect(Collectors.toList());
                        entry.setValue(sort);
                        long minute = Long.valueOf(((DefaultBpmCheckOpinion)sort.get(0)).getId());
                        map.put(minute, sort);
                    }
                }
                List collect = map.entrySet().stream().collect(Collectors.toList());
                if (map.entrySet().size() > 1) {
                    collect = map.entrySet().stream().sorted((o1, o2) -> Long.compare((Long)o2.getKey(), (Long)o1.getKey())).collect(Collectors.toList());
                }
                ArrayList<ObjectNode> groupNode = new ArrayList<ObjectNode>();
                for (Map.Entry entry : collect) {
                    ObjectNode objectNode = JsonUtil.createObjectNode();
                    int allOpinionStatus = 1;
                    for (DefaultBpmCheckOpinion bpmTaskOpinion : (List)entry.getValue()) {
                        if (OpinionStatus.AWAITING_CHECK.getKey().equals(bpmTaskOpinion.getStatus())) {
                            allOpinionStatus = 2;
                            continue;
                        }
                        if (OpinionStatus.REJECT.getKey().equals(bpmTaskOpinion.getStatus()) || OpinionStatus.BACK_TO_START.getKey().equals(bpmTaskOpinion.getStatus())) {
                            if (bpmTaskOpinion.getInterpose() == 2) {
                                allOpinionStatus = 3;
                                break;
                            }
                            allOpinionStatus = 0;
                            break;
                        }
                        if (!OpinionStatus.REVOKER.getKey().equals(bpmTaskOpinion.getStatus()) && !OpinionStatus.REVOKER_TO_START.getKey().equals(bpmTaskOpinion.getStatus()) && !OpinionStatus.SIGN_RECOVER_CANCEL.getKey().equals(bpmTaskOpinion.getStatus()) && !OpinionStatus.RETRACTED.getKey().equals(bpmTaskOpinion.getStatus()) && !OpinionStatus.SIGN_LINE_RETRACTED.getKey().equals(bpmTaskOpinion.getStatus())) continue;
                        allOpinionStatus = 4;
                        break;
                    }
                    if (((List)entry.getValue()).stream().filter(r -> StringUtil.isNotEmpty((String)r.getStatus())).count() == 0L) {
                        allOpinionStatus = 5;
                    }
                    objectNode.put("allOpinionStatus", allOpinionStatus);
                    objectNode.put("sorterOpinion", JsonUtil.toJsonNode(entry.getValue()));
                    groupNode.add(objectNode);
                }
                nodeOption.put("groupNode", JsonUtil.toJsonNode(groupNode));
                if (nodeIds.size() == 1) {
                    return nodeOption;
                }
                jsonNode.put(bpmnNodeDef.getNodeId(), (JsonNode)nodeOption);
                continue;
            }
            if (!NodeType.SERVICETASK.equals((Object)bpmnNodeDef.getType())) continue;
            ObjectNode serviceTaskNode = JsonUtil.createObjectNode();
            List list = this.bpmServiceLogManager.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmServiceLog::getProcInstId, (Object)instId.get())).eq(BpmServiceLog::getNodeId, (Object)bpmnNodeDef.getNodeId())).orderByDesc(BpmServiceLog::getCreateTime));
            if (BeanUtils.isNotEmpty((Object)list)) {
                serviceTaskNode.put("nodeType", NodeType.SERVICETASK.getKey());
                serviceTaskNode.put("serviceStatus", ((BpmServiceLog)list.get(0)).getStatus());
            } else {
                serviceTaskNode.put("nodeType", NodeType.SERVICETASK.getKey());
                serviceTaskNode.put("serviceStatus", -1);
            }
            jsonNode.put(bpmnNodeDef.getNodeId(), (JsonNode)serviceTaskNode);
        }
        return jsonNode;
    }

    @Override
    public List<IUser> getAssignersByTaskId(String taskId) {
        List<DefaultBpmIdentity> bpmIdentities;
        BpmTaskService bpmTaskService = (BpmTaskService)AppUtil.getBean(BpmTaskService.class);
        BpmTask task = bpmTaskService.getByTaskId(taskId);
        if (BeanUtils.isNotEmpty((Object)task) && StringUtil.isNotZeroEmpty((String)task.getAssigneeId())) {
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setId(task.getAssigneeId());
            bpmIdentity.setName(task.getAssigneeName());
            bpmIdentity.setType("user");
            bpmIdentities = Collections.singletonList(bpmIdentity);
        } else {
            bpmIdentities = bpmTaskService.getTaskCandidates(taskId);
        }
        if (BeanUtils.isEmpty((Object)bpmIdentities)) {
            return new ArrayList<IUser>();
        }
        BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
        return bpmIdentityExtractService.extractUser((List)bpmIdentities);
    }

    private void handleNext(List<DefaultBpmCheckOpinion> list, String parentTaskId, Map<String, List<DefaultBpmCheckOpinion>> collect) {
        List<DefaultBpmCheckOpinion> opinions = collect.get(parentTaskId);
        if (BeanUtils.isNotEmpty(opinions)) {
            for (DefaultBpmCheckOpinion opinion : opinions) {
                if (list.contains(opinion)) continue;
                list.add(opinion);
            }
            this.handleNext(list, opinions.get(opinions.size() - 1).getTaskId(), collect);
        }
    }

    @Override
    public TaskDetailVo getButtonsBytaskId(String taskId, Optional<String> leaderId) throws Exception {
        TaskDetailVo buttonsBytaskId = this.iFlowService.getButtonsBytaskId(taskId);
        if (BeanUtils.isNotEmpty(buttonsBytaskId.getButtons())) {
            Iterator<Button> iterator = buttonsBytaskId.getButtons().iterator();
            while (iterator.hasNext()) {
                Button button = iterator.next();
                String btnName = button.getAlias();
                if (!StringUtil.isNotZeroEmpty((String)leaderId.orElse("")) || btnName.equals("agree") || btnName.equals("reject") || btnName.equals("lockUnlock")) continue;
                iterator.remove();
            }
            return buttonsBytaskId;
        }
        return new TaskDetailVo();
    }

    @Override
    public CommonResult<List<String>> filterUnBatchable(String taskIds) {
        if (StringUtil.isEmpty((String)taskIds)) {
            return new CommonResult(true, "", new ArrayList());
        }
        ArrayList<String> filterResult = new ArrayList<String>();
        for (String taskId : taskIds.split(",")) {
            try {
                BpmNodeDef curNodeProperties = this.iFlowService.getCurNodeProperties(taskId, "", "");
                NodeProperties localProperties = curNodeProperties.getLocalProperties();
                if (!localProperties.isBatchHandleRevoke()) continue;
                filterResult.add(taskId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new CommonResult(true, "", filterResult);
    }

    private boolean setNoAuthFilter(QueryFilter queryFilter) {
        List list = this.bpmDefUserManager.getByUserMap("bpmDef", "task");
        IGroup ugroup = ContextUtil.getCurrentGroup();
        HashMap<String, String> userRightMap = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty((Object)list)) {
            for (BpmDefUser bpmDefUser : list) {
                String type;
                List bpmDefAct;
                if (StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg())) {
                    bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                    if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                    for (BpmDefAct bpm : bpmDefAct) {
                        type = bpm.getType();
                        if ("1".equals(type)) {
                            userRightMap.put(bpm.getDefKey(), StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg()) ? StringUtil.convertListToSingleQuotesString(new HashSet<String>(Arrays.asList(bpmDefUser.getAuthOrg().split(",")))) : null);
                        }
                        if (!"2".equals(type)) continue;
                        List defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                        for (String defKey : defKeys) {
                            userRightMap.put(defKey, StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg()) ? StringUtil.convertListToSingleQuotesString(new HashSet<String>(Arrays.asList(bpmDefUser.getAuthOrg().split(",")))) : null);
                        }
                    }
                    continue;
                }
                bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                for (BpmDefAct bpm : bpmDefAct) {
                    type = bpm.getType();
                    String orgId = null;
                    if (StringUtil.isNotEmpty((String)bpm.getRightContent())) {
                        try {
                            ObjectNode rightJson = (ObjectNode)JsonUtil.toJsonNode((String)bpm.getRightContent());
                            if (JsonUtil.getBoolean((ObjectNode)rightJson, (String)"i_org", (boolean)false)) {
                                orgId = BeanUtils.isNotEmpty((Object)ugroup) ? ugroup.getGroupId() : "-1";
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if ("1".equals(type)) {
                        userRightMap.put(bpm.getDefKey(), StringUtil.isNotEmpty(orgId) ? "'" + orgId + "'" : null);
                    }
                    if (!"2".equals(type)) continue;
                    List defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                    for (String defKey : defKeys) {
                        userRightMap.put(defKey, StringUtil.isNotEmpty((String)orgId) ? "'" + orgId + "'" : null);
                    }
                }
            }
        }
        queryFilter.addParams("userRightMap", userRightMap);
        return CollUtil.isNotEmpty(userRightMap);
    }

    @Override
    public Object taskBackOpinion(String instId) {
        if (StringUtil.isEmpty((String)instId)) {
            return null;
        }
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        if ("backToStart".equals(defaultBpmProcessInstance.getStatus()) || "back".equals(defaultBpmProcessInstance.getStatus())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"PROC_INST_ID_", (Object)defaultBpmProcessInstance.getId());
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"STATUS_", (Object)"backToStart")).or(wrapper1 -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)wrapper1.eq((Object)"STATUS_", (Object)"back");
                })).or(wrapper1 -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)wrapper1.eq((Object)"STATUS_", (Object)"reject");
                });
            });
            List list = this.bpmCheckOpinionManager.list((Wrapper)queryWrapper);
            if (BeanUtils.isEmpty((Object)list)) {
                return null;
            }
            return list.get(list.size() - 1);
        }
        return null;
    }
}

